 /*
 *  file      : cd_cddb.h
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef cd_cddb_h
#define cd_cddb_h 1

typedef enum {
	SERVER_CDDB_LOCAL = 0,
	// SERVER_CDDB_AT,
	// SERVER_CDDB_CA,
	// SERVER_CDDB_DE,
	// SERVER_CDDB_FI,
	// SERVER_CDDB_FR,
	// SERVER_CDDB_NO,
	// SERVER_CDDB_UK,
	// SERVER_CDDB_US,
	SERVER_CDDB_PARAM,
	SERVER_CDDB_NONE
} SERVER_CDDB;

typedef enum {
	CONNECT_IS_FALSE,
	CONNECT_IS_TRUE,
	CONNECT_IS_NO_MATCH_FOUND
} ETAT_CONNECT;

typedef enum {
	_CDDB_BUFFER_NONE_ = 0,
	_CDDB_BUFFER_TITLE_,
	_CDDB_BUFFER_TITLE_TIME_,
	_CDDB_BUFFER_ARTIST_TITLE_TIME_
} TYPE_CDDB_BUFFER;

gboolean	CdCddb_read_toc (void);
void		CdCddb_set_bool_cancel_cddb (gboolean FLAG);
gboolean	CdCddb_get_bool_cancel_cddb (void);
gboolean	CdCddb_test_access_web (void);
void		CdCddb_set_combobox_choice( gint p_activate );
gchar		*CdCddb_get_title_cd( void );
void		CdCddb_reffresh_list_cd( gint p_Choice );

#endif

