 /*
 * file      : split_spectre.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2011 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <math.h>
#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "get_info.h"
#include "tags.h"
#include "split.h"




#define	SAMPLE_SHADES	3

extern VAR_SPLIT VarSplit;


typedef enum {
	_CRAYON_BLANC_ = 0,
	_CRAYON_BLEU_,
	_CRAYON_NOIR_,
	_CRAYON_BLEU_CLAIR_,
	_CRAYON_GRIS_,
	_CRAYON_BLEU_CLAIR_PLUS_,
	_CRAYON_GRIS_CLAIR_
} SPLIT_PEN;


// 
// 
gint SplitSpectre_get_with_scrollwindow (void)
{
	GtkWidget		*Wid = GTK_WIDGET(GLADE_GET_OBJECT("scrolledwindow_splitspectre"));
	if (NULL != Wid) {
		if (0 == VarSplit.NbrZoom) {
			VarSplit.InitwidthZoom = Wid->allocation.width;
			// g_print ("VarSplit.InitwidthZoom = %d\n", VarSplit.InitwidthZoom);
		}
		return (Wid->allocation.width);
	}
	return ( -1 );
}
// AFFICHAGE IMAGE CHRONO
// 
void SplitSpectre_draw_chrono (void)
{
	GdkColor		gdk_color;
	GdkColormap		*colormap;
	GdkGC			*gc;
	GdkPoint		points [ 10 ];
	PangoContext		*p_context = NULL;
	PangoLayout		*layout = NULL;
	PangoFontDescription	*fontdesc;
	gint			layoutX = 0;
	gint			layoutY = 0;
	gint			CursorX, CursorY;
	GdkModifierType		state;
	gint			ChronoX;
	
	gint			sec;
	gdouble			dsec;
	gdouble			TimeSongSec;
	gdouble			Percent;
	gint			H, M, S, C;
	gchar			*Str = NULL;
	gint			hundr;
	
	GtkScrolledWindow	*scrolled_window = NULL;
	GtkAdjustment		*Adj = NULL;
	
	if (NULL == VarSplit.AdrWidgetSpectreChrono) return;

	scrolled_window = GTK_SCROLLED_WINDOW (GLADE_GET_OBJECT("scrolledwindow_splitspectre"));
	Adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (scrolled_window));
	colormap = gdk_drawable_get_colormap (VarSplit.AdrWidgetSpectreChrono->window);
	gc = gdk_gc_new (VarSplit.AdrWidgetSpectreChrono->window);
	
	// CLEAR
	points [ 0 ] . x = VarSplit.ChronoX;
	points [ 0 ] . y = VarSplit.ChronoY;
	points [ 1 ] . x = VarSplit.ChronoX + VarSplit.ChronoW +1;
	points [ 1 ] . y = VarSplit.ChronoY;
	points [ 2 ] . x = VarSplit.ChronoX + VarSplit.ChronoW +1;
	points [ 2 ] . y = VarSplit.ChronoY + VarSplit.ChronoH +1;
	points [ 3 ] . x = VarSplit.ChronoY;
	points [ 3 ] . y = VarSplit.ChronoY + VarSplit.ChronoH +1;
	points [ 4 ] . x = VarSplit.ChronoX;
	points [ 4 ] . y = VarSplit.ChronoY;
	CRAYON_GRIS
	gdk_draw_polygon (
		VarSplit.AdrWidgetSpectreChrono->window,
		gc,
		TRUE,
		points,
		4
		);
#define  TIME_CHRONO   160
	// ECRITURE BARRE CHRONOLOGIQUE
	CRAYON_BLANC
	for (ChronoX = 2; ChronoX +60 < VarSplit.ChronoW; ChronoX += TIME_CHRONO) {
		if (ChronoX > 2) {
			gdk_draw_line (
				VarSplit.AdrWidgetSpectreChrono->window,
				gc,
				ChronoX -2,
				VarSplit.ChronoY,
				ChronoX -2,
				VarSplit.ChronoY + VarSplit.ChronoH
				);
		}
		p_context = gtk_widget_get_pango_context (VarSplit.AdrWidgetSpectreChrono);
		layout = pango_layout_new (p_context);
		fontdesc = pango_font_description_from_string ("Times New Roman 9");
		pango_layout_set_font_description (layout, fontdesc);
		layoutX = ChronoX;
		layoutY = VarSplit.ChronoY + 3;

		CursorX = (gint)Adj->value;
		CursorX += ChronoX;
		CursorX -= 2;
		
		if (NULL != VarSplit.Tags) {
			TimeSongSec = VarSplit.Tags->SecTime;
		}
		else {
			TimeSongSec = 300;
		}
		Percent = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
		sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
		dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
		hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
		H = (sec / 60) / 60;
		M = (sec / 60) % 60;
		S = sec % 60;
		C = hundr;
		// Str = g_strdup_printf ("%02d:%02d:%02d.%02d", H, M, S, C);
		Str = g_strdup_printf ("%02d:%02d:%02d", H, M, S);

		pango_layout_set_markup (layout, Str, -1);
		gdk_draw_layout (
			VarSplit.AdrWidgetSpectreChrono->window,
			gc,
			layoutX,
			layoutY,
			layout
			);
		g_object_unref (layout);
		g_free (Str);
		Str = NULL;
	}
	
	gdk_window_get_pointer (VarSplit.AdrWidgetSpectreChrono->window, &CursorX, &CursorY, &state);
	if (CursorX < VarSplit.ChronoX)
		CursorX = VarSplit.ChronoX;
	else if (CursorX > (VarSplit.ChronoX + VarSplit.ChronoW) -1)
		CursorX = VarSplit.ChronoX + VarSplit.ChronoW;
	
	if (CursorY < VarSplit.ChronoY)
		CursorY = VarSplit.ChronoY;
	else if (CursorY > (VarSplit.ChronoY + VarSplit.ChronoH) -1)
		CursorY = VarSplit.ChronoY + VarSplit.ChronoH;

	// REPAIR VERTICAL PARTIE HAUTE
	if (VarSplit.NbrSelecteurs > 0) {
		CRAYON_ROUGE
		gdk_draw_line (
			VarSplit.AdrWidgetSpectreChrono->window,
			gc,
			CursorX,
			VarSplit.ChronoY,
			CursorX,
			VarSplit.ChronoY + VarSplit.ChronoH
			);
	}
	gdk_gc_destroy (gc);
	
	// POSITION DU CURSEUR DANS LA FORME D ONDE
	/*
	if (NULL != VarSplit.Tags) {
		TimeSongSec = VarSplit.Tags->SecTime;
	}
	else {
		TimeSongSec = 300;
	}
	CursorX += (gint)Adj->value;
	Percent = ((gdouble)CursorX / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.0;
	sec = (gint) (((gdouble)TimeSongSec * (gdouble)Percent) / 100.0);
	dsec  = ((gdouble)TimeSongSec *(gdouble)Percent) / 100.0;
	hundr = ((gdouble)dsec - (gdouble)sec) * 100.0;
	H = (sec / 60) / 60;
	M = (sec / 60) % 60;
	S = sec % 60;
	C = hundr;
	gtk_label_set_use_markup (GTK_LABEL(GLADE_GET_OBJECT("label_temps_actuel_curseur_split")), TRUE);
	if (VarSplit.NbrSelecteurs > 0) {
		// Str = g_strdup_printf ("<b>Codage en cours ...</b>\n%02d:%02d:%02d.%02d", H, M, S, C);
		Str = g_strdup_printf ("<b>Codage en cours ...</b>\n%02d:%02d:%02d", H, M, S);
	}
	else {
		// Str = g_strdup ("<b>Codage en cours ...</b>\n00:00:00.00");
		Str = g_strdup ("<b>Codage en cours ...</b>\n00:00:00");
	}
	gtk_label_set_markup (GTK_LABEL(GLADE_GET_OBJECT("label_temps_actuel_curseur_split")), Str);
	// g_print("%s\n", Str);
	g_free (Str);
	Str = NULL;
	*/
}
// AFFICHAGE IMAGE TOP
// 
void SplitSpectre_draw_top (void)
{
	GdkColor		gdk_color;
	GdkColormap		*colormap;
	GdkGC			*gc;
	GdkPoint		points [ 10 ];
	GtkScrolledWindow	*scrolled_window = NULL;
	GtkAdjustment		*Adj = NULL;
	gint			begin = 0;
	gint			Len;
	
	scrolled_window = GTK_SCROLLED_WINDOW (GLADE_GET_OBJECT("scrolledwindow_splitspectre"));
	Adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (scrolled_window));
	begin = (gint)Adj->value;
	Len = SplitSpectre_get_with_scrollwindow () + begin;
	
	colormap = gdk_drawable_get_colormap (VarSplit.AdrWidgetSpectre->window);
	gc = gdk_gc_new (VarSplit.AdrWidgetSpectre->window);
	
	// CLEAR 
	CRAYON_GRIS_CLAIR
	gdk_draw_rectangle (
		VarSplit.AdrWidgetSpectre->window,
		gc,
		TRUE,
		VarSplit.SpectreTopX + begin,
		VarSplit.SpectreTopY,
		SplitSpectre_get_with_scrollwindow (),
		VarSplit.SpectreTopH
		);
				
	if (VarSplit.NbrSelecteurs > 0) {
		
		gint			SelBegin;
		gint			SelEnd;
		gint			Cpt;
		gint			i;
		PangoContext		*p_context = NULL;
		PangoLayout		*layout = NULL;
		PangoFontDescription 	*fontdesc;
		gint			layoutX = 0;
		gint			layoutY = 0;
		gchar			*Str = NULL;
		
		// DRAW ALL SELECTEURS
		for (Cpt = 0; Cpt < MAX_SELECTEURS_SPLIT; Cpt ++) {
								
			// if (Cpt == VarSplit.SelecteurActif) continue;
			if (VarSplit.Selecteur [ Cpt ] . Nmr == -1) break;
			
			// FLECHE LIGNE DEBUT
			SelBegin = SplitSelector_get_pos_begin (Cpt);
			// if (SelBegin > Len) continue;
			if (SelBegin >= begin && SelBegin <= Len) {
			
				points [ 0 ] . x = SelBegin;
				CRAYON_NOIR
				for (i = 0; i < 9; i++) {
					gdk_draw_line (VarSplit.AdrWidgetSpectre->window,
							gc,
							SelBegin + i,
							(VarSplit.SpectreTopY + 1) + i,
							SelBegin + i,
							(VarSplit.SpectreTopY + 16) - i
							);
				}
				
				p_context = gtk_widget_get_pango_context (VarSplit.AdrWidgetSpectre);
				layout = pango_layout_new (p_context);
				fontdesc = pango_font_description_from_string ("Times New Roman 9");
				pango_layout_set_font_description (layout, fontdesc);
				Str = g_strdup_printf("%d", Cpt +1);
				layoutX = points [ 0 ] . x + 10;
				layoutY = VarSplit.SpectreTopY +2;
				pango_layout_set_markup (layout, Str, -1);
				CRAYON_NOIR
				gdk_draw_layout (
					VarSplit.AdrWidgetSpectre->window,
					gc,
					layoutX,
					layoutY,
					layout
					);
				g_free (Str);
				Str = NULL;
				g_object_unref (layout);
			}
			
			
			// FLECHE LIGNE FIN
			SelEnd = SplitSelector_get_pos_end (Cpt);
			if (SelEnd > SelBegin && SelEnd > begin && SelEnd < Len) {
				
				points [ 0 ] . x = SelEnd;
				CRAYON_NOIR
				for (i = 0; i < 9; i++) {
					gdk_draw_line (VarSplit.AdrWidgetSpectre->window,
							gc,
							SelEnd - i,
							(VarSplit.SpectreTopY + 1) + i,
							SelEnd - i,
							(VarSplit.SpectreTopY + 16) - i
							);
				}
				
				p_context = gtk_widget_get_pango_context (VarSplit.AdrWidgetSpectre);
				layout = pango_layout_new (p_context);
				fontdesc = pango_font_description_from_string ("Times New Roman 9");
				pango_layout_set_font_description (layout, fontdesc);
				Str = g_strdup_printf("%d", Cpt +1);
				if (Cpt +1 < 10)
					layoutX = points [ 0 ] . x - 16;
				else	layoutX = points [ 0 ] . x - 21;
				layoutY = VarSplit.SpectreTopY +2;
				pango_layout_set_markup (layout, Str, -1);
				CRAYON_NOIR
				gdk_draw_layout (
					VarSplit.AdrWidgetSpectre->window,
					gc,
					layoutX,
					layoutY,
					layout
					);
				g_free (Str);
				Str = NULL;
				g_object_unref (layout);
			}
		}
		
		// DRAW SELECTEUR ACTIF
		// FLECHE LIGNE DEBUT
		SelBegin = SplitSelector_get_pos_begin (VarSplit.SelecteurActif);
		if (SelBegin >= begin && SelBegin < Len) {
			points [ 0 ] . x = SelBegin;
			// 
			CRAYON_ORANGE
			for (i = 0; i < 9; i++) {
				gdk_draw_line (VarSplit.AdrWidgetSpectre->window,
						gc,
						SelBegin + i,
						(VarSplit.SpectreTopY + 1) + i,
						SelBegin + i,
						(VarSplit.SpectreTopY + 16) - i
						);
			}
			p_context = gtk_widget_get_pango_context (VarSplit.AdrWidgetSpectre);
			layout = pango_layout_new (p_context);
			fontdesc = pango_font_description_from_string ("Times New Roman 9");
			pango_layout_set_font_description (layout, fontdesc);
			Str = g_strdup_printf("%d", VarSplit.SelecteurActif +1);
			layoutX = points [ 0 ] . x + 10;
			layoutY = VarSplit.SpectreTopY +2;
			pango_layout_set_markup (layout, Str, -1);
			CRAYON_BLANC
			gdk_draw_layout (
				VarSplit.AdrWidgetSpectre->window,
				gc,
				layoutX,
				layoutY,
				layout
				);
			g_free (Str);
			Str = NULL;
			g_object_unref (layout);
		}
		
		
		// FLECHE LIGNE FIN
		SelEnd = SplitSelector_get_pos_end (VarSplit.SelecteurActif);	
		if (SelEnd >= begin && SelEnd < Len) {
			if (VarSplit.SelecteurActif == VarSplit.NbrSelecteurs -1) SelEnd --;
			points [ 0 ] . x = SelEnd;
			// 
			CRAYON_VERT
			for (i = 0; i < 9; i++) {
				gdk_draw_line (VarSplit.AdrWidgetSpectre->window,
						gc,
						SelEnd - i,
						(VarSplit.SpectreTopY + 1) + i,
						SelEnd - i,
						(VarSplit.SpectreTopY + 16) - i
						);
				}
			p_context = gtk_widget_get_pango_context (VarSplit.AdrWidgetSpectre);
			layout = pango_layout_new (p_context);
			fontdesc = pango_font_description_from_string ("Times New Roman 9");
			pango_layout_set_font_description (layout, fontdesc);
			Str = g_strdup_printf("%d", VarSplit.SelecteurActif +1);
			if (VarSplit.SelecteurActif +1 < 10)
				layoutX = points [ 0 ] . x - 16;
			else	layoutX = points [ 0 ] . x - 21;
			layoutY = VarSplit.SpectreTopY +2;
			pango_layout_set_markup (layout, Str, -1);
			CRAYON_BLANC
			gdk_draw_layout (
				VarSplit.AdrWidgetSpectre->window,
				gc,
				layoutX,
				layoutY,
				layout
				);
			g_free (Str);
			Str = NULL;
			g_object_unref (layout);
		}
	}
	gdk_gc_destroy (gc);
}
// 
//
void SplitSpectre_get_pos_widget (void)
{
	VarSplit.ImgX = VarSplit.AdrWidgetSpectre->allocation.x;
	VarSplit.ImgY = VarSplit.AdrWidgetSpectre->allocation.y;
	VarSplit.ImgW = VarSplit.AdrWidgetSpectre->allocation.width;
	VarSplit.ImgH = VarSplit.AdrWidgetSpectre->allocation.height;

	VarSplit.ChronoX = VarSplit.AdrWidgetSpectreChrono->allocation.x;
	VarSplit.ChronoY = VarSplit.AdrWidgetSpectreChrono->allocation.y;
	VarSplit.ChronoW = VarSplit.AdrWidgetSpectreChrono->allocation.width - 1;
	VarSplit.ChronoH = 17;
	
	VarSplit.SpectreTopX = VarSplit.ImgX;
	VarSplit.SpectreTopY = VarSplit.ImgY;
	VarSplit.SpectreTopW = VarSplit.ImgW -1;
	VarSplit.SpectreTopH = 24;
	
	VarSplit.SpectreX = VarSplit.ImgX;
	VarSplit.SpectreY = VarSplit.ImgY +25;
	VarSplit.SpectreW = VarSplit.ImgW -1;
	VarSplit.SpectreH = VarSplit.ImgH -25;
}
// 
// 
void SplitSpectre_remove_draw (void)
{
	if (NULL != VarSplit.MaxScale_0) {	g_free (VarSplit.MaxScale_0);		VarSplit.MaxScale_0 = NULL; }
	if (NULL != VarSplit.MinScale_0) {	g_free (VarSplit.MinScale_0);		VarSplit.MinScale_0 = NULL; }
	if (NULL != VarSplit.MaxScale_1) {	g_free (VarSplit.MaxScale_1);		VarSplit.MaxScale_1 = NULL; }
	if (NULL != VarSplit.MinScale_1) {	g_free (VarSplit.MinScale_1);		VarSplit.MinScale_1 = NULL; }
	if (NULL != VarSplit.MaxScale_2) {	g_free (VarSplit.MaxScale_2);		VarSplit.MaxScale_2 = NULL; }
	if (NULL != VarSplit.MinScale_2) {	g_free (VarSplit.MinScale_2);		VarSplit.MinScale_2 = NULL; }
}
// 
// 
void SplitSpectre_remove (void)
{
	if (NULL != VarSplit.Tab) {	g_free (VarSplit.Tab);	VarSplit.Tab = NULL; }
	SplitSpectre_remove_draw ();
	VarSplit.Tags = tagswav_remove_info (VarSplit.Tags);
}
// 
// PERCENT = ( VALUE_X / LONGUEUR_TOTALE ) * 100.0
// VALUE_X = ( LONGUEUR_TOTALE * PERCENT ) / 100.0
// 
// xavier a écrit : 
// Le marqueur de début doit coller le début de la forme d'onde. Celui de fin à la fin de la forme d'onde
// 
// From @Dzef:
// Sinon, Claude, pour le soucis de not'
// Christophe-coupeur-d'album-en-rondelles-sans-cue, la parade existe en partie
// dans le cas où les plages sont séparées par des "blancs" (ce qui n'est pas
// le cas des albums "live" par exemple) : il suffit de détecter le niveau
// audio et en dessous d'un seuil fixé (typiquement < ~-50 dB), hop, 1 plage !
// C'est peut être une option (un bouton) à cogiter pour une future mouture,
// non ? M'est avis qu'not' Christophe serait pas contre...					
// 
void SplitSpectre_search_blank_pass (void)
{
	gint		IndicePoints = -1;
	gint		PointBegin = -1;
	gint		PointEnd = -1;
	gint		Indice;
	gdouble		PercentBegin;
	gdouble		PercentEnd;
	gint		ValueBegin;
	gint		ValueEnd;
	// gint	MaxPoints = VarSplit.nTotalChunckSize / BLOCK_SIZE;
	gint		MaxPoints = VarSplit.MaxPointsInTab;
	gboolean	BoolErr = FALSE;
	
	if (TRUE == VarSplit.BoolBlankWithCue) {
		PRINT("TRUE == VarSplit.BoolBlankWithCue");
		return;
	}
	
	PRINT_FUNC_LF();
	
	Indice = 0;
	do {
		if (VarSplit.Tab [ Indice ].Min == 0 && VarSplit.Tab [ Indice ].Max == 0) {
			
			if (-1 == PointBegin) {
				while (Indice < MaxPoints && VarSplit.Tab [ Indice ].Min == 0 && VarSplit.Tab [ Indice ].Max == 0) Indice ++;
				PointBegin = Indice;
				while (Indice < MaxPoints && (VarSplit.Tab [ Indice ].Min != 0 || VarSplit.Tab [ Indice ].Max != 0)) Indice ++;
				PointEnd = Indice;
				if (PointBegin > -1 && PointEnd - PointBegin > 13) {
					
					IndicePoints ++;
					g_print ("PointBegin = %6d   PointEnd = %6d   Diff = %6d\n", PointBegin, PointEnd, PointEnd - PointBegin);
					
					PercentBegin = ((gdouble)PointBegin / (gdouble)MaxPoints) * 100.0;
					ValueBegin = ((gdouble)VarSplit.AdrWidgetSpectre->allocation.width * (gdouble)PercentBegin) / 100.0;
					
					PercentEnd = ((gdouble)PointEnd / (gdouble)MaxPoints) * 100.0;
					ValueEnd = ((gdouble)VarSplit.AdrWidgetSpectre->allocation.width * (gdouble)PercentEnd) / 100.0;
										
					VarSplit.Selecteur [ IndicePoints ] . Nmr          = IndicePoints;
					VarSplit.Selecteur [ IndicePoints ] . Begin        = ValueBegin;
					VarSplit.Selecteur [ IndicePoints ] . PercentBegin = PercentBegin;
					VarSplit.Selecteur [ IndicePoints ] . End          = ValueEnd;
					VarSplit.Selecteur [ IndicePoints ] . PercentEnd   = PercentEnd;
				}
				PointBegin = -1;
				PointEnd = -1;
			}
		}
		Indice ++;
	} while (Indice < MaxPoints);
	
	if (-1 == IndicePoints) {
		IndicePoints = 0;
		VarSplit.Selecteur [ IndicePoints ] . Nmr          = IndicePoints;
		PercentEnd = ((gdouble)(MaxPoints - 1) / (gdouble)MaxPoints) * 100.0;
		ValueEnd = ((gdouble)VarSplit.AdrWidgetSpectre->allocation.width * (gdouble)PercentEnd) / 100.0;
		VarSplit.Selecteur [ 0 ] . PercentEnd = PercentEnd;
		VarSplit.Selecteur [ 0 ] . End        = ValueEnd;
	}
	
	g_print ("\n");
	g_print ("IndicePoints = [ 0 .. %d ]\n", IndicePoints);
	g_print ("\n");
	
	// DEBUT
	Indice = 0;
	while (Indice < MaxPoints && VarSplit.Tab [ Indice ].Min == 0 && VarSplit.Tab [ Indice ].Max == 0) Indice ++;
	PercentBegin = ((gdouble)Indice / (gdouble)MaxPoints) * 100.0;
	ValueBegin = ((gdouble)VarSplit.AdrWidgetSpectre->allocation.width * (gdouble)PercentBegin) / 100.0;
	VarSplit.Selecteur [ 0 ] . PercentBegin = PercentBegin;
	VarSplit.Selecteur [ 0 ] . Begin        = ValueBegin;
	
	// VERIFIE QUE LES POINTS NE SE CHEVAUCHENT PAS
	BoolErr = FALSE;
	for (IndicePoints = 0; VarSplit.Selecteur [ IndicePoints ] . Nmr != -1; IndicePoints ++) {
		if (IndicePoints > 0) {
			// if ((gint)VarSplit.Selecteur [ IndicePoints -1 ] . End >= (gint)VarSplit.Selecteur [ IndicePoints ] . Begin) {
				// g_print ("[ %02d ] ERREUR entre End %d et Begin %d  -->  RECTIFICATION\n", IndicePoints, IndicePoints -1, IndicePoints);
				// BoolErr = TRUE;
				// break;
			// }
			if ((gint)VarSplit.Selecteur [ IndicePoints ] . Begin >= (gint)VarSplit.Selecteur [ IndicePoints ] . End) {
				g_print ("[ %02d ]ERREUR entre Begin %d et End %d  -->  RECTIFICATION\n", IndicePoints, IndicePoints, IndicePoints);
				BoolErr = TRUE;
				break;
			}
		}
	}
	
	// VERIFICATION DE LA COHERENCE DU TEMPS ENTRE DEUX POINTS BEGIN et END
	if (FALSE == BoolErr) {
		for (IndicePoints = 0; VarSplit.Selecteur [ IndicePoints ] . Nmr != -1; IndicePoints ++) {
			if (SplitSelector_get_diff_sec (VarSplit.Selecteur [ IndicePoints ] . PercentBegin, VarSplit.Selecteur [ IndicePoints ] . PercentEnd) <= 5) {
				g_print ("ERREUR Temps < a 5 secondes entre BEGIN %d et END %d  -->  RECTIFICATION\n", IndicePoints, IndicePoints);
				BoolErr = TRUE;
				break;
			}
		}
	}
	
	if (TRUE == BoolErr) {
		for (IndicePoints = 1; IndicePoints < MAX_SELECTEURS_SPLIT; IndicePoints ++) {
			VarSplit.Selecteur [ IndicePoints ] . Nmr = -1;
			VarSplit.Selecteur [ IndicePoints ] . Begin = -1;
			VarSplit.Selecteur [ IndicePoints ] . End = -1;
			VarSplit.Selecteur [ IndicePoints ] . PercentBegin =
			VarSplit.Selecteur [ IndicePoints ] . PercentEnd = 0.0;
		}
		IndicePoints = 0;
		VarSplit.Selecteur [ IndicePoints ] . Nmr          = IndicePoints;
		PercentEnd = ((gdouble)(MaxPoints - 1) / (gdouble)MaxPoints) * 100.0;
		ValueEnd = ((gdouble)VarSplit.AdrWidgetSpectre->allocation.width * (gdouble)PercentEnd) / 100.0;
		VarSplit.Selecteur [ 0 ] . PercentEnd = PercentEnd;
		VarSplit.Selecteur [ 0 ] . End        = ValueEnd;
	}
	
	// PRINT CONSLE
	for (IndicePoints = 0; VarSplit.Selecteur [ IndicePoints ] . Nmr != -1; IndicePoints ++) {
		g_print ("[ %2d ]   BEGIN = %5d  END = %5d  PERCENTBEGIN = %f  PERCENTEND = %f\n",
			VarSplit.Selecteur [ IndicePoints ] . Nmr,
			(gint)VarSplit.Selecteur [ IndicePoints ] . Begin,
			(gint)VarSplit.Selecteur [ IndicePoints ] . End,
			VarSplit.Selecteur [ IndicePoints ] . PercentBegin,
			VarSplit.Selecteur [ IndicePoints ] . PercentEnd
			);
	}
	g_print ("\n");
}
// LECTURE FICHIER
//
gboolean SplitSpectre_read_file_spectre (gchar *PathNameFile)
{
	FILE		*pFile = NULL;
	gboolean	found = FALSE;
	gint		Ret;
	gint		Indice;
	gint		ChannelNext;
	gint		min, max;
	gint		tmp = 0;
	gint		points;
	unsigned char	devbuf[ BLOCK_SIZE +10 ];
	WAVE		son;
	TYPE_FILE_IS	TypeFileIs = FILE_IS_NONE;

	PRINT_FUNC_LF();
	g_print("\t%s\n\n", PathNameFile);
	
	VarSplit.MaxPointsInTab = 0;
	VarSplit.TypeFileIs = FILE_IS_NONE;
	if (FILE_IS_WAV != (TypeFileIs = GetInfo_file_is (PathNameFile))) {
		
		// 
		SplitSpectre_remove_draw ();
		
		// DEL ALLOC MEMORY
		if (NULL != VarSplit.Tab) {
			g_free (VarSplit.Tab);	VarSplit.Tab = NULL;
			return (TRUE);
		}
	}
	
	if (FALSE == tagswav_read_file (PathNameFile, &son)) {
		tagswav_close_file (&son);
		printf ("\nImpossible d'ouvrir le fichier : \"%s\"\n\n", PathNameFile);
		return FALSE;
	}
	pFile = son.file;
	son.file = NULL;
	
	if (pFile == NULL) {
		PRINT_FUNC_LF();
		g_print ("\nImpossible d'ouvrir le fichier : \"%s\"\n\n", PathNameFile);
		return FALSE;
	}
	VarSplit.nBitsPerSample = son.FMT.BitsPerSample;
	
	switch (son.FMT.BitsPerSample) {
	case 8 :
	case 16 :
	case 24 :
	case 32 :
		break;
	default :
		{
		fclose (pFile);
		
		PRINT_FUNC_LF();
		g_print("Seuls ces formats de bitrates : 8 16 24 et 32 sont pris en charge pour la lecture\n"
			"Format de bitrate [ %d ] non prit en charge\n", 
			son.FMT.BitsPerSample);
			
		// DEL ALLOC MEMORY
		if (NULL != VarSplit.Tab) {
			g_free (VarSplit.Tab);	VarSplit.Tab = NULL;
		}
		return FALSE;
		}
	}
	VarSplit.nTotalChunckSize = son.DATA.Subchunk2Size;
	found = TRUE;
		
	// DEL ALLOC MEMORY
	if (NULL != VarSplit.Tab) {
		g_free (VarSplit.Tab);	VarSplit.Tab = NULL;
	}

	
	if (found == TRUE) {
			
		VarSplit.TotalAllocation = sizeof(POINTS_FILE) * ((son.DATA.Subchunk2Size / BLOCK_SIZE) +10);
		VarSplit.Tab = (POINTS_FILE *)g_malloc0 (VarSplit.TotalAllocation + 10);
		
		points = 0;
		if (son.FMT.BitsPerSample <= 0) son.FMT.BitsPerSample = 8;

		// TRAITEMENT UNIQUES: 8, 16, 24 et 32 bits
		switch (son.FMT.BitsPerSample) {
			case 8 :
			case 16 :
			case 24 :
			case 32 :
				// PRE - CALCUL

				ChannelNext = (son.FMT.NumChannels -1) * (son.FMT.BitsPerSample / 8);

				// LECTURE DES DATAS

				while ((Ret = fread (devbuf, 1, BLOCK_SIZE, pFile)) > 0) {

					min = max = 0;

					for (Indice = 0; Indice < Ret; Indice++) {

						if (son.FMT.BitsPerSample == 8) {
							
							tmp = devbuf [ Indice ];
							tmp -= 128;
						}
						else if (son.FMT.BitsPerSample == 16) {
							
							tmp = (gchar)devbuf [ Indice +1 ] << 8 | (gchar)devbuf [ Indice ];
							Indice ++;
						}
						else if (son.FMT.BitsPerSample == 24) {
							
							tmp  = (gchar)devbuf [ Indice +0 ] >> 16;
							tmp += (gchar)devbuf [ Indice +1 ] >> 8;
							tmp += (gchar)devbuf [ Indice +2 ];
														
							Indice += 2;
						}
						else if (son.FMT.BitsPerSample == 32) {
							
							tmp  = (gchar)devbuf [ Indice +0 ] >> 24;
							tmp += (gchar)devbuf [ Indice +1 ] >> 16;
							tmp += (gchar)devbuf [ Indice +2 ] >> 8;
							tmp += (gchar)devbuf [ Indice +3 ];
							
							Indice += 2;
						}
						
						if (tmp > max) {
							
							max = tmp;
						} else if (tmp <= min) {
							
							min = tmp;
						}

						// skip over any extra channels
						Indice += ChannelNext;
					}
					VarSplit.Tab [ points ].Min = min;
					VarSplit.Tab [ points ].Max = max;
					
					points ++;
				}
				break;
			default :
				PRINT("Ne doit pas arriver ici  !!!!");
				g_print ("Ce format n'est pas pris en charge : %d\n", son.FMT.BitsPerSample);
				fclose (pFile);
				return FALSE;
		}
	}
	fclose (pFile);
	
	VarSplit.MaxPointsInTab = points;
	
	// TODO: MARQUAGE DES PASSAGES BLANC SOIT < ~-50 dB
	for (Indice = 0; Indice < points; Indice ++) {
		if (VarSplit.Tab [ Indice ].Min >= -1. && VarSplit.Tab [ Indice ].Max <= 1.) {
			VarSplit.Tab [ Indice ].Min =
				VarSplit.Tab [ Indice ].Max = 0.0;
		}
	}
	
	// gtk_widget_queue_draw (VarSplit.AdrWidgetSpectre);
	
	VarSplit.Tags = tagswav_remove_info (VarSplit.Tags);
	VarSplit.Tags = (INFO_WAV *)tagswav_get_info (PathNameFile);
	
	// RECHEFCHE DES PLAGES SELON L IDEE DE @Dzef  ;-)
	SplitSpectre_search_blank_pass ();

	VarSplit.BoolReadFileSpectre = TRUE;
	VarSplit.TypeFileIs = TypeFileIs;

	return (TRUE);
}
// AFFICHAGE DU SPECTRE
// RAPIDITE DE REAFFICHAGE DE L'AMPLITUDE ACCRUE AVEC LES FONCTIONS gdk_draw_ (...)
// 13 juillet 2009
// 12 mars 2010
// 
void SplitSpectre_draw_lines (void)
{
	GdkColor		gdk_color;
	GdkColormap		*colormap;
	GdkGC			*gc;
	gint			y_min;
	gint			y_max;
	gint			xaxis;
	gint			scale;
	gint			points = 0;
	gint			k;
	gdouble			Percent;
	GtkScrolledWindow	*scrolled_window = NULL;
	GtkAdjustment		*Adj = NULL;
	gint			AdjValue;
	gint			begin = 0;
	gint			end = 0;
	gint			save_begin = 0;
	gboolean		BoolAllocateMemory = FALSE;
	gint			SelBegin = 0;
	gint			SelEnd = 0;
	gint			Len;
				
	// PRINT_FUNC_LF();

	SplitSpectre_draw_top ();
	
	// WAV if bitrate == 8 16 24 32
	if (VarSplit.Tab != NULL && VarSplit.TypeFileIs == FILE_IS_WAV && VarSplit.MaxPointsInTab > 0) {
			
		// OPEN DRAW
		colormap = gdk_window_get_colormap (VarSplit.AdrWidgetSpectre->window);
		gc = gdk_gc_new (VarSplit.AdrWidgetSpectre->window);
	
		// 
		// NE PAS REALLOUER A CHAQUE FOIS !!!
		// 
		if (NULL == VarSplit.MaxScale_0) {
			BoolAllocateMemory = TRUE;
		}
		if (VarSplit.TotalAllocationTabScreen != (sizeof(GdkPoint) * (SplitSpectre_get_with_scrollwindow () + 20))) {
			BoolAllocateMemory = TRUE;
		}
		if (TRUE == BoolAllocateMemory) {
			
			SplitSpectre_remove_draw ();

			VarSplit.TotalAllocationTabScreen = sizeof(GdkPoint) * (SplitSpectre_get_with_scrollwindow () + 20);
			
			VarSplit.MaxScale_0 = (GdkPoint *)g_malloc0 (VarSplit.TotalAllocationTabScreen);
			VarSplit.MinScale_0 = (GdkPoint *)g_malloc0 (VarSplit.TotalAllocationTabScreen);
			VarSplit.MaxScale_1 = (GdkPoint *)g_malloc0 (VarSplit.TotalAllocationTabScreen);
			VarSplit.MinScale_1 = (GdkPoint *)g_malloc0 (VarSplit.TotalAllocationTabScreen);
			VarSplit.MaxScale_2 = (GdkPoint *)g_malloc0 (VarSplit.TotalAllocationTabScreen);
			VarSplit.MinScale_2 = (GdkPoint *)g_malloc0 (VarSplit.TotalAllocationTabScreen);
		}
		
		scrolled_window = GTK_SCROLLED_WINDOW (GLADE_GET_OBJECT("scrolledwindow_splitspectre"));
		Adj = gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW (scrolled_window));
		begin = (gint)Adj->value;
		AdjValue   = (gint)Adj->value;
		Len = SplitSpectre_get_with_scrollwindow () + begin;
			
		
		// LA LIGNE MEDIANE DU GRAPHE
		// xaxis = HAUTEUR_WIDGET / 2;
		// xaxis = (VarSplit.SpectreH) / 2;
		xaxis = (VarSplit.SpectreH -18) / 2;
		// xaxis += 18;

		if (xaxis != 0) {
			if (VarSplit.nBitsPerSample == 16)
				scale = SHRT_MAX  / (xaxis -1);
			else	scale = UCHAR_MAX / (xaxis -1);
			if (scale == 0) {
				scale = 1;
			}
		} else {
			scale = 1;
		}
		
		// 
		end = begin + SplitSpectre_get_with_scrollwindow ();
		save_begin = begin;
		
		// Thu, 23 Sep 2010 21:32:41 +0200
		for (points = 0; begin < end; begin ++, points ++) {
			
			Percent = ((gdouble)begin / (gdouble)VarSplit.AdrWidgetSpectre->allocation.width) * 100.;
			k = (Percent * (gdouble)VarSplit.MaxPointsInTab) / 100.;
							
			y_max = xaxis - VarSplit.Tab[ k ].Max / scale;
			y_min = xaxis + fabs(VarSplit.Tab[ k ].Min) / scale;
			
			// shade = 0;
			VarSplit.MaxScale_0 [ points ] . x = begin;
			VarSplit.MaxScale_0 [ points ] . y = y_max - (y_max - xaxis) * 0 / SAMPLE_SHADES;
			VarSplit.MinScale_0 [ points ] . x = begin;
			VarSplit.MinScale_0 [ points ] . y = y_min + (xaxis - y_min) * 0 / SAMPLE_SHADES;
			VarSplit.MaxScale_0 [ points ] . y += 36;
			VarSplit.MinScale_0 [ points ] . y += 36;
			// shade = 1;
			VarSplit.MaxScale_1 [ points ] . x = begin;
			VarSplit.MaxScale_1 [ points ] . y = y_max - (y_max - xaxis) * 1 / SAMPLE_SHADES;
			VarSplit.MinScale_1 [ points ] . x = begin;
			VarSplit.MinScale_1 [ points ] . y = y_min + (xaxis - y_min) * 1 / SAMPLE_SHADES;
			VarSplit.MaxScale_1 [ points ] . y += 36;
			VarSplit.MinScale_1 [ points ] . y += 36;
			// shade = 2;
			VarSplit.MaxScale_2 [ points ] . x = begin;
			VarSplit.MaxScale_2 [ points ] . y = y_max - (y_max - xaxis) * 2 / SAMPLE_SHADES;
			VarSplit.MinScale_2 [ points ] . x = begin;
			VarSplit.MinScale_2 [ points ] . y = y_min + (xaxis - y_min) * 2 / SAMPLE_SHADES;
			VarSplit.MaxScale_2 [ points ] . y += 36;
			VarSplit.MinScale_2 [ points ] . y += 36;
			
			// RECTIF HAUT
			if (VarSplit.MaxScale_0 [ points ] . y < VarSplit.SpectreY) {
				VarSplit.MaxScale_0 [ points ] . y = VarSplit.SpectreY;
			}
			// RECTIF BAS
			if (VarSplit.MinScale_0 [ points ] . y > VarSplit.ImgH) {
				VarSplit.MinScale_0 [ points ] . y = VarSplit.ImgH -1;
			}
			
			// RECTIF HAUT
			if (VarSplit.MaxScale_1 [ points ] . y < VarSplit.SpectreY) {
				VarSplit.MaxScale_1 [ points ] . y = VarSplit.SpectreY;
			}
			// RECTIF BAS
			if (VarSplit.MinScale_1 [ points ] . y > VarSplit.ImgH) {
				VarSplit.MinScale_1 [ points ] . y = VarSplit.ImgH -1;
			}
			
			// RECTIF HAUT
			if (VarSplit.MaxScale_2 [ points ] . y < VarSplit.SpectreY) {
				VarSplit.MaxScale_2 [ points ] . y = VarSplit.SpectreY;
			}
			// RECTIF BAS
			if (VarSplit.MinScale_2 [ points ] . y > VarSplit.ImgH) {
				VarSplit.MinScale_2 [ points ] . y = VarSplit.ImgH -1;
			}
			
		}
		
		/*
		// DEDOUBLEMENT DES POINTS ?
		for (points = 3; points < VarSplit.MaxPointsInTab; points ++) {
			gint a = VarSplit.MaxScale_0 [ points -3 ] . y;
			gint b = VarSplit.MaxScale_0 [ points -2 ] . y;
			gint c = VarSplit.MaxScale_0 [ points -1 ] . y;
			gint d = VarSplit.MaxScale_0 [ points -0 ] . y;

			gint e = VarSplit.MinScale_0 [ points -3 ] . y;
			gint f = VarSplit.MinScale_0 [ points -2 ] . y;
			gint g = VarSplit.MinScale_0 [ points -1 ] . y;
			gint h = VarSplit.MinScale_0 [ points -0 ] . y;

			if (
			    a == b && a == c && a == d &&
			    e == f && e == g && e == h)
			    ) {
				
				g_print ("%6d  == %6d\n", points -1, points);
				BoolOk = TRUE;
				break;
			}
		}
		if (TRUE == BoolOk) {
			points = 1;
			while (points < VarSplit.MaxPointsInTab) {
				// NOMBRE DE points IDENTIQUES POUR idem
				idem = 0;
				for (pp = points; pp < VarSplit.MaxPointsInTab; pp ++) {
					gint a = VarSplit.MaxScale_0 [ pp -1 ] . y;
					gint b = VarSplit.MinScale_0 [ pp -1 ] . y;
					if (a == VarSplit.MaxScale_0 [ pp ] . y && b && VarSplit.MinScale_0 [ pp ] . y) {
						idem ++;
					}
					else {
						break;
					}
				}
				idem /= 2
				
				// TRATEMENT DE idem points
				DEBUT  = points		MaxScale_0
				MILIEU = idem / 2	MinScale_0
				MILIEU = idem / 2	MaxScale_0
				FIN    = pp -1		MinScale_0
				
			}
		}
		
		*/
		
		
		/*
		gdk_draw_line = 7
		
		VarSplit.SpectreY	TO	VarSplit.MaxScale_0
		VarSplit.MaxScale_0	TO	VarSplit.MaxScale_1
		VarSplit.MaxScale_1	TO	VarSplit.MaxScale_2
		VarSplit.MaxScale_2	TO	VarSplit.MinScale_2
		VarSplit.MinScale_2	TO	VarSplit.MinScale_1
		VarSplit.MinScale_1	TO	VarSplit.MinScale_0
		VarSplit.MinScale_0	TO	VarSplit.SpectreY + VarSplit.SpectreH
		
		OU
		
		gdk_draw_line = 5
		
		VarSplit.SpectreY	TO	VarSplit.MaxScale_0
		VarSplit.MaxScale_0	TO	VarSplit.VarSplit.MinScale_0
		VarSplit.MaxScale_1	TO	VarSplit.MinScale_1
		VarSplit.MaxScale_2	TO	VarSplit.MinScale_2
		VarSplit.MinScale_0	TO	VarSplit.SpectreY + VarSplit.SpectreH
		*/
		
		SelBegin = SplitSelector_get_pos_begin (VarSplit.SelecteurActif);
		SelEnd   = SplitSelector_get_pos_end (VarSplit.SelecteurActif);
		begin    = save_begin;
	
		for (points = 0; begin < end; begin ++, points ++) {
			
			// NETTOYER EN HAUT
			CRAYON_BLANC 
			gdk_draw_line (VarSplit.AdrWidgetSpectre->window,
					gc,
					begin,
					VarSplit.SpectreY,
					begin,
					VarSplit.MaxScale_0 [ points ] . y
					);
			// NETTOYER EN BAS
			gdk_draw_line (VarSplit.AdrWidgetSpectre->window,
					gc,
					begin,
					VarSplit.MinScale_0 [ points ] . y,
					begin,
					VarSplit.SpectreY + VarSplit.SpectreH
					);
			
			// MaxScale_0
			if (begin >= SelBegin &&  begin <= SelEnd) {
				// LA SELECTION
				CRAYON_BLEU
			} else {
				// LA NON SELECTION
				CRAYON_NOIR
			}
			gdk_draw_line (VarSplit.AdrWidgetSpectre->window,
					gc,
					begin,
					VarSplit.MaxScale_0 [ points ] . y,
					begin,
					VarSplit.MinScale_0 [ points ] . y
					);
			/*gdk_draw_point (VarSplit.AdrWidgetSpectre->window,
					gc,
					begin,
					VarSplit.MaxScale_0 [ points ] . y);
			gdk_draw_point (VarSplit.AdrWidgetSpectre->window,
					gc,
					begin,
					VarSplit.MinScale_0 [ points ] . y);
			if (points > 0) {
				gdk_draw_line (VarSplit.AdrWidgetSpectre->window,
						gc,
						begin -1,
						VarSplit.MaxScale_0 [ points -1 ] . y,
						begin,
						VarSplit.MaxScale_0 [ points ] . y
						);
				gdk_draw_line (VarSplit.AdrWidgetSpectre->window,
						gc,
						begin -1,
						VarSplit.MinScale_0 [ points -1 ] . y,
						begin,
						VarSplit.MinScale_0 [ points ] . y
						);
			}*/
			
			// MaxScale_1
			if (begin >= SelBegin &&  begin <= SelEnd) {
				// LA SELECTION
				CRAYON_BLEU_CLAIR
			} else {
				// LA NON SELECTION
				CRAYON_GRIS
			}
			gdk_draw_line (VarSplit.AdrWidgetSpectre->window,
					gc,
					begin,
					VarSplit.MaxScale_1 [ points ] . y,
					begin,
					VarSplit.MinScale_1 [ points ] . y
					);
			/*gdk_draw_point (VarSplit.AdrWidgetSpectre->window,
					gc,
					begin,
					VarSplit.MaxScale_1 [ points ] . y);
			gdk_draw_point (VarSplit.AdrWidgetSpectre->window,
					gc,
					begin,
					VarSplit.MinScale_1 [ points ] . y);*/
			
			// MaxScale_2
			if (begin >= SelBegin &&  begin <= SelEnd) {
				// LA SELECTION
				CRAYON_BLEU_CLAIR_PLUS
			} else {
				// LA NON SELECTION
				CRAYON_GRIS_CLAIR
			}
			gdk_draw_line (VarSplit.AdrWidgetSpectre->window,
					gc,
					begin,
					VarSplit.MaxScale_2 [ points ] . y,
					begin,
					VarSplit.MinScale_2 [ points ] . y
					);
			/*gdk_draw_point (VarSplit.AdrWidgetSpectre->window,
					gc,
					begin,
					VarSplit.MaxScale_2 [ points ] . y);
			gdk_draw_point (VarSplit.AdrWidgetSpectre->window,
					gc,
					begin,
					VarSplit.MinScale_2 [ points ] . y);*/
			

		}
		if (SelBegin >= save_begin && SelBegin < Len) {
			// AFFICHE CURSEUR DEBUT
			CRAYON_ORANGE
			gdk_draw_line (
				VarSplit.AdrWidgetSpectre->window,
				gc,
				SelBegin,
				VarSplit.SpectreY,
				SelBegin,
				VarSplit.SpectreY + VarSplit.SpectreH
				);
		}
		
		// AFFICHE CURSEUR FIN
		if (VarSplit.SelecteurActif == VarSplit.NbrSelecteurs -1) SelEnd --;
		if (SelEnd >= save_begin && SelEnd < Len) {
			CRAYON_VERT
			gdk_draw_line (
				VarSplit.AdrWidgetSpectre->window,
				gc,
				SelEnd,
				VarSplit.SpectreY,
				SelEnd,
				VarSplit.SpectreY + VarSplit.SpectreH
				);
		}
		
		// AFFICHE LE CURSEUR AUDIO
		if (VarSplit.PercentActivePlay >= 0.0) {
			SelEnd = (gint)(((gdouble)VarSplit.AdrWidgetSpectre->allocation.width * VarSplit.PercentActivePlay) / 100.0);
			if (SelEnd >= save_begin && SelEnd < Len) {
				CRAYON_ROUGE
				gdk_draw_line (
					VarSplit.AdrWidgetSpectre->window,
					gc,
					SelEnd,
					VarSplit.ImgY,
					SelEnd,
					VarSplit.ImgY + VarSplit.ImgH
					);
				
				gdk_draw_rectangle (
					VarSplit.AdrWidgetSpectre->window,
					gc,
					TRUE,
					SelEnd -6,
					VarSplit.ImgY + VarSplit.ImgH -12,
					14,
					12
					);
			}
		}
		
		// if (FALSE == GTK_WIDGET_DRAWABLE(VarSplit.AdrWidgetSpectre) || FALSE == GTK_WIDGET_MAPPED(VarSplit.AdrWidgetSpectre)) {
		// 	gtk_widget_queue_draw (VarSplit.AdrWidgetSpectre);
		// }
		
		// CLOSE DRAW
		gdk_gc_destroy (gc);
	}
	
}




















