 /*
 * file      : poche_code.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2011 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */
 
 
#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "poche.h"
 
 
 
/* Production 'convert'
 * Version: ImageMagick 6.2.4 11/24/06 Q16 http://www.imagemagick.org
 * Copyright: Copyright (C) 1999-2005 ImageMagick Studio LLC
 */
gchar *code_entete_ps [] =
{
"%!PS-Adobe-3.0",
"%%Creator: BULIN Claude - fr",
"%%For: ()",
"%%Title: X Convert File Audio",
"%%CreationDate: 2007 3 7",
"%%Pages: 1",
"%%PageMedia: A4",
"%%Orientation: Portrait",
"%%EndComments",
" ",
""
};

/* Production xcfa
 * xcfa - GTK+ implementation of the GNU shell command
 * 2003 - 2011  Claude Bulin
 */
gchar *code_xcfa_ps [] =
{
" ",
"/PACKAGE (X Convert File Audio) def	% -- PARAM_PACKAGE",
"/VERSION (3.1.2-16) def			% -- PARAM_VERSION",
" ",
"/mm { 72 mul 25.4 div } def		% definition d'un millimetre",
"/left 25 mm def				% le cote gauche de la pochette",
"/wcover 120 mm def 			% largeur du recto",
"/hcover 120 mm def 			% hauteur du recto",
"/lcover 150 mm def 			% base du recto",
"/wback 159.5 mm def 			% largeur du verso",
"/hback 117 mm def 			% hauteur du verso",
"/front 6 mm def				% epaisseur cd",
"/tongue 9.5 mm def			% onglet cd",
"/lback 25 mm def 			% base du verso",
"/gap 14 mm def				% les bords gauche, bas, droit, haut",
"/diff 10 def				% espace entre le recto et le verso",
"/tabcover 10 array def			% 6 colonnes droite vers gauche",
"					% 4 lignes bas vers haut",
" ",
"/c1 { tabcover 0 get } def		% 6 colonnes droite vers gauche",
"/c2 { tabcover 1 get } def		%",
"/c3 { tabcover 2 get } def		%",
"/c4 { tabcover 3 get } def		%",
"/c5 { tabcover 4 get } def		%",
"/c6 { tabcover 5 get } def		%",
"/l1 { tabcover 6 get } def		% 4 lignes bas vers haut",
"/l2 { tabcover 7 get } def		%",
"/l3 { tabcover 8 get } def		%",
"/l4 { tabcover 9 get } def		%",
" ",
"/title (TITRE DU CD) def		% -- PARAM_TITLE",

"/Times-Bold findfont			% prise en compte des accents",
"dup length dict begin			%",
"{ 1 index /FID ne			%",
"  {def}					%",
"  {pop pop}				%",
"  ifelse				%",
"} forall				%",
" ",
"/Encoding ISOLatin1Encoding def		%",
"currentdict				%",
"end					%",
"/Times-Bold-ISOLatin1 exch definefont pop	%",
"/fonttitle /Times-Bold-ISOLatin1 def		% la police du titre",
"/sizefonttitle 16 def			% la taille du titre",

"/bool_title_cover true def		% -- PARAM_BOOL_TITLE_COVER",
"/bool_title_back true def		% -- PARAM_BOOL_TITLE_BACK",
" ",
"/foottext (indication de pied de page) def	% -- PARAM_FOOTTEXT",
"/bool_foottext_cover true def		% -- PARAM_BOOL_FOOTTEXT_COVER",
"/bool_foottext_back true def		% -- PARAM_BOOL_FOOTTEXT_BACK",

"/Times findfont				% prise en compte des accents",
"dup length dict begin			%",
"{ 1 index /FID ne			%",
"  {def}					%",
"  {pop pop}				%",
"  ifelse				%",
"} forall				%",
" ",
"/Encoding ISOLatin1Encoding def		%",
"currentdict				%",
"end					%",
"/Times-ISOLatin1 exch definefont pop	%",
"/fontfoottext /Times-ISOLatin1 def	%",
"/sizefontfoottext 7 def			%",
" ",

"/Times-Roman findfont			% prise en compte des accents",
"dup length dict begin			%",
"{ 1 index /FID ne			%",
"  {def}					%",
"  {pop pop}				%",
"  ifelse				%",
"} forall				%",
" ",
"/Encoding ISOLatin1Encoding def		%",
"currentdict				%",
"end					%",
"/Times-Roman-ISOLatin1 exch definefont pop	%",
"/fonttextdata /Times-Roman-ISOLatin1 def	% la police pour 'cover' / 'back'",

"/sizefonttextdata 10 def		% la taille",
"/bool_textdata_cover true def		% -- PARAM_BOOL_TEXTDATA_COVER",
"/bool_textdata_back true def		% -- PARAM_BOOL_TEXTDATA_BACK",
" ",
"/bool_line_cover true def		% -- PARAM_BOOL_LINE_COVER",
"/bool_line_back true def		% -- PARAM_BOOL_LINE_BACK",
" ",
"/textdata [()()()] def			% -- PARAM_TEXTDATA",
" ",
"/choicefieldscover 0 def		% -- PARAM_CHOICEFIELDSCOVER",
"					% 0 auteur titre temps",
"					% 1 auteur titre",
"					% 2 auteur       temps",
"					% 3 auteur",
"					% 4        titre temps",
"					% 5        titre",
" ",
"/choicefieldsback 0 def			% -- PARAM_CHOICEFIELDSBACK",
"					% 0 auteur titre temps",
"					% 1 auteur titre",
"					% 2 auteur       temps",
"					% 3 auteur",
"					% 4        titre temps",
"					% 5        titre",
" ",
"/textdatalen 5 array def		% 0 plus grande longueur textdata 0",
"					% 1 plus grande longueur textdata 1",
"					% 2 plus grande longueur textdata 2",
"					% 3 addition des champs d'apres la valeur de 'choicefieldscover'",
"					% 4 addition des champs d'apres la valeur de 'choicefieldsback'",
" ",
"					% longueur de l'espace entre 2 champs",
"/lenspace 2 array def			% 0 cover",
"					% 1 back",
" ",
"					% d'apres la valeur de 'choicefieldscover'",
"/posx_cover 3 array def			% 0 champs 0 cover",
"					% 1 champs 1 cover",
"					% 2 champs 2 cover",
" ",
"					% d'apres la valeur de 'choicefieldsback'",
"/posx_back 3 array def			% 0 champs 0 back",
"					% 1 champs 1 back",
"					% 2 champs 2 back",
" ",
"/tabprint 6 array def			% 0 with cover",
"					% 1 heigth cover",
"					% 2 line print cover",
"					% 3 with back",
"					% 4 heigth back",
"					% 5 line print back",
" ",
"%=======================================================================",
"% is_bool_title_cover",
"% test si affichage du titre au recto ET si la chaine (title) existe",
"% parameter: -",
"% return: - true OR false",
"%=======================================================================",
"/is_bool_title_cover { bool_title_cover true eq { title length 0 eq { false }{ true } ifelse }{ false } ifelse } def",
" ",
"%=======================================================================",
"% is_bool_title_back",
"% test si affichage du titre au verso ET si la chaine (title) existe",
"% parameter: -",
"% return: - true OR false",
"%=======================================================================",
"/is_bool_title_back { bool_title_back true eq { title length 0 eq { false }{ true } ifelse }{ false } ifelse } def",
" ",
"%=======================================================================",
"% is_bool_foottext_cover",
"% test si affichage de foottext au recto ET si la chaine (foottext) existe",
"% parameter: -",
"% return: - true OR false",
"%=======================================================================",
"/is_bool_foottext_cover { bool_foottext_cover true eq { foottext length 0 eq { false }{ true } ifelse }{ false } ifelse } def",
" ",
"%=======================================================================",
"% is_bool_foottext_back",
"% test si affichage de foottext au recto ET si la chaine (foottext) existe",
"% parameter: -",
"% return: - true OR false",
"%=======================================================================",
"/is_bool_foottext_back { bool_foottext_back true eq { foottext length 0 eq { false }{ true } ifelse }{ false } ifelse } def",
" ",
"%=======================================================================",
"% calc_tabprint",
"% calcul hauteur:largeur:premiere ligne d'affichage des recto et verso pour",
"% tabprint en tenant compte des titres et foottext",
"% parameter: -",
"% return: - true OR false",
"%=======================================================================",
"/calc_tabprint",
"{",
"	/hauteur_recto l4 l3 sub def",
"	/largeur_recto c3 c2 sub sizefonttextdata sub sizefonttextdata sub def",
"	/line_print_recto l4 sizefonttextdata sub def",
"	is_bool_title_cover true eq {",
"		/hauteur_recto hauteur_recto sizefonttitle sub 10 sub def",
"		/line_print_recto line_print_recto sizefonttitle sub def",
"	}{",
"		/hauteur_recto hauteur_recto sizefonttextdata 2 div sub def",
"	} ifelse",
"	is_bool_foottext_cover true eq {",
"		/hauteur_recto hauteur_recto sizefontfoottext sub 10 sub def",
"	}{",
"		/hauteur_recto hauteur_recto sizefonttextdata 2 div sub def",
"	} ifelse",
"	tabprint 0 largeur_recto put",
"	tabprint 1 hauteur_recto put",
"	tabprint 2 line_print_recto put",
" ",
"	/hauteur_verso l2 l1 sub def",
"	/largeur_verso c4 c2 sub sizefonttextdata sub sizefonttextdata sub def",
"	/line_print_verso l2 sizefonttextdata sub def",
"	is_bool_title_back true eq {",
"		/hauteur_verso hauteur_verso sizefonttitle sub 10 sub def",
"		/line_print_verso line_print_verso sizefonttitle sub def",
"	}{",
"		/hauteur_verso hauteur_verso sizefonttextdata 2 div sub def",
"	} ifelse",
"	is_bool_foottext_back true eq {",
"		/hauteur_verso hauteur_verso sizefontfoottext sub 10 sub def",
"	}{",
"		/hauteur_verso hauteur_verso sizefonttextdata 2 div sub def",
"	} ifelse",
"	tabprint 3 largeur_verso put",
"	tabprint 4 hauteur_verso put",
"	tabprint 5 line_print_verso put",
"} def",
" ",
"%=======================================================================",
"% calc_pos_textdata",
"% calcul les plus grandes longueurs 'graphique' des chaines ainsi que",
"%    les positions des 3 champs sur la pochette recto et verso",
"% parameter: isize est la taille de la font utilisee",
"% return: -",
"%=======================================================================",
"/calc_pos_textdata",
"{",
"gsave",
"	textdatalen 0 0 put",
"	textdatalen 1 0 put",
"	textdatalen 2 0 put",
"	textdatalen 3 0 put",
"	textdatalen 4 0 put",
" ",
"	% declaration de la fonte, taille",
" ",
"	/isize exch def",
"	fonttextdata findfont",
"	isize scalefont",
"	setfont",
" ",
"	% chercher la plus grande longueur de chaque champs",
" ",
"	/maxi_0 0 def",
"	/maxi_1 0 def",
"	/maxi_2 0 def",
"	/ind 0 def",
"	0 3 textdata length 1 sub",
"	{",
"		% ind + 0",
"		%",
"		textdata ind get stringwidth pop",
"		maxi_0 gt {",
"			/maxi_0 textdata ind get stringwidth pop def",
"			textdatalen 0 maxi_0 put",
"		}{",
"			/maxi_0 maxi_0 def",
"			textdatalen 0 maxi_0 put",
"		} ifelse",
"		%",
"		% ind + 1",
"		%",
"		textdata ind 1 add get stringwidth pop",
"		maxi_1 gt {",
"			/maxi_1 textdata ind 1 add get stringwidth pop def",
"			textdatalen 1 maxi_1 put",
"		}{",
"			/maxi_1 maxi_1 def",
"			textdatalen 1 maxi_1 put",
"		} ifelse",
"		%",
"		% ind + 2",
"		%",
"		textdata ind 2 add get stringwidth pop",
"		maxi_2 gt {",
"			/maxi_2 textdata ind 2 add get stringwidth pop def",
"			textdatalen 2 maxi_2 put",
"		}{",
"			/maxi_2 maxi_2 def",
"			textdatalen 2 maxi_2 put",
"		} ifelse",
"		/ind ind 3 add def",
"	} for",
" ",
"	% addition des 3 champs d'apres la valeur de 'choicefieldscover' et 'choicefieldsback'",
"	% et calcul du plus petit espace entre 2 champs",
" ",
"	/wgapcover tabprint 0 get def	% largeur de cover",
"	/wgapback tabprint 3 get def	% largeur de back",
" ",
"	choicefieldscover 0 eq {",
"		textdatalen 3 textdatalen 0 get textdatalen 1 get add textdatalen 2 get add put",
"		lenspace 0 wgapcover textdatalen 3 get sub 2 div put",
"	} if",
"	choicefieldscover 1 eq {",
"		textdatalen 3 textdatalen 0 get textdatalen 1 get add put",
"		lenspace 0 wgapcover textdatalen 3 get sub put",
"	} if",
"	choicefieldscover 2 eq {",
"		textdatalen 3 textdatalen 0 get textdatalen 2 get add put",
"		lenspace 0 wgapcover textdatalen 3 get sub put",
"	} if",
"	choicefieldscover 3 eq {",
"		textdatalen 3 textdatalen 0 get put",
"		lenspace 0 wgapcover textdatalen 3 get sub put",
"	} if",
"	choicefieldscover 4 eq {",
"		textdatalen 3 textdatalen 1 get textdatalen 2 get add put",
"		lenspace 0 wgapcover textdatalen 3 get sub put",
"	} if",
"	choicefieldscover 5 eq {",
"		textdatalen 3 textdatalen 1 get put",
"		lenspace 0 wgapcover textdatalen 3 get sub put",
"	} if",
" ",
"	choicefieldsback 0 eq {",
"		textdatalen 4 textdatalen 0 get textdatalen 1 get add textdatalen 2 get add put",
"		lenspace 1 wgapback textdatalen 4 get sub 2 div put",
"	} if",
"	choicefieldsback 1 eq {",
"		textdatalen 4 textdatalen 0 get textdatalen 1 get add put",
"		lenspace 1 wgapback textdatalen 4 get sub put",
"	} if",
"	choicefieldsback 2 eq {",
"		textdatalen 4 textdatalen 0 get textdatalen 2 get add put",
"		lenspace 1 wgapback textdatalen 4 get sub put",
"	} if",
"	choicefieldsback 3 eq {",
"		textdatalen 4 textdatalen 0 get put",
"		lenspace 1 wgapback textdatalen 4 get sub put",
"	} if",
"	choicefieldsback 4 eq {",
"		textdatalen 4 textdatalen 1 get textdatalen 2 get add put",
"		lenspace 1 wgapback textdatalen 4 get sub put",
"	} if",
"	choicefieldsback 5 eq {",
"		textdatalen 4 textdatalen 1 get put",
"		lenspace 1 wgapback textdatalen 4 get sub put",
"	} if",
" ",
"	% d'apres la valeur de 'choicefieldscover' et 'choicefieldsback',",
"	% calcul des positions de debut de champs pour cover et back",
" ",
"	choicefieldscover 0 eq {",
"		posx_cover 2 c2 textdatalen 0 get add textdatalen 1 get add lenspace 0 get 2 mul add sizefonttextdata add put",
"		posx_cover 1 c2 textdatalen 0 get add lenspace 0 get add sizefonttextdata add put",
"		posx_cover 0 c2 sizefonttextdata add put",
"	} if",
"	choicefieldscover 1 eq {",
"		posx_cover 1 c2 textdatalen 0 get add lenspace 0 get add sizefonttextdata add put",
"		posx_cover 0 c2 sizefonttextdata add put",
"	} if",
"	choicefieldscover 2 eq {",
"		posx_cover 1 c2 textdatalen 0 get add lenspace 0 get add sizefonttextdata add put",
"		posx_cover 0 c2 sizefonttextdata add put",
"	} if",
"	choicefieldscover 3 eq {",
"		posx_cover 0 c2 sizefonttextdata add put",
"	} if",
"	choicefieldscover 4 eq {",
"		posx_cover 1 c2 textdatalen 1 get add lenspace 0 get add sizefonttextdata add put",
"		posx_cover 0 c2 sizefonttextdata add put",
"	} if",
"	choicefieldscover 5 eq {",
"		posx_cover 0 c2 sizefonttextdata add put",
"	} if",
" ",
"	choicefieldsback 0 eq {",
"		posx_back 2 c2 textdatalen 0 get add textdatalen 1 get add lenspace 1 get 2 mul add sizefonttextdata add put",
"		posx_back 1 c2 textdatalen 0 get add lenspace 1 get add sizefonttextdata add put",
"		posx_back 0 c2 sizefonttextdata add put",
"	} if",
"	choicefieldsback 1 eq {",
"		posx_back 1 c2 textdatalen 0 get add lenspace 1 get add sizefonttextdata add put",
"		posx_back 0 c2 sizefonttextdata add put",
"	} if",
"	choicefieldsback 2 eq {",
"		posx_back 1 c2 textdatalen 0 get add lenspace 1 get add sizefonttextdata add put",
"		posx_back 0 c2 sizefonttextdata add put",
"	} if",
"	choicefieldsback 3 eq {",
"		posx_back 0 c2 sizefonttextdata add put",
"	} if",
"	choicefieldsback 4 eq {",
"		posx_back 1 c2 textdatalen 1 get add lenspace 1 get add sizefonttextdata add put",
"		posx_back 0 c2 sizefonttextdata add put",
"	} if",
"	choicefieldsback 5 eq {",
"		posx_back 0 c2 sizefonttextdata add put",
"	} if",
"grestore",
"} def",
" ",
"/STYLE_LINE { 0.5 setlinewidth 0.8 setgray } def	% Entre deux ou trois champs",
" ",
"%=======================================================================",
"% draw_textdata_cover",
"% affiche le texte au recto de la pochette apres calculs: taille:hauteur:largeur",
"% parameter: -",
"% return: -",
"%=======================================================================",
"/draw_textdata_cover",
"{",
"	bool_textdata_cover true eq {",
"	gsave",
"		calc_tabprint",
" ",
"		% calcul la taille de la font a utiliser dans un rapport de hauteur:largeur",
" ",
"		/hauteur tabprint 1 get def",
"		/total_line textdata length 3 div def",
"		/isize hauteur total_line div def",
"		isize sizefonttextdata ge { /isize sizefonttextdata def } if",
"		isize calc_pos_textdata",
" ",
"		/line_y tabprint 2 get def",
" ",
"		fonttextdata findfont",
"		isize scalefont",
"		setfont",
" ",
"		/indice 0 def",
"		0 3 textdata length 1 sub",
"		{",
"			bool_line_cover true eq {",
"				textdata indice get length 0 eq {",
"					/OK false def",
"				}{",
"					textdata indice 1 add get length 0 eq {",
"						/OK false def",
"					}{",
"						textdata indice 2 add get length 0 eq {",
"							/OK false def",
"						}{",
"							/OK true def",
"						} ifelse",
"					} ifelse",
"				} ifelse",
"			}{",
"				/OK false def",
"			} ifelse",
" ",
"			choicefieldscover 0 eq {",
"				dup",
"				textdata exch get",
"				posx_cover 0 get line_y moveto show",
"				OK true eq {",
"					STYLE_LINE",
"					posx_cover 1 get line_y lineto",
"					stroke 0 setgray",
"				} if",
"				dup",
"				1 add",
"				textdata exch get",
"				posx_cover 1 get line_y moveto show",
"				OK true eq {",
"					STYLE_LINE",
"					posx_cover 2 get line_y lineto",
"					stroke 0 setgray",
"				} if",
"				dup",
"				2 add",
"				textdata exch get",
"				posx_cover 2 get line_y moveto show",
"			} if",
"			choicefieldscover 1 eq {",
"				dup",
"				textdata exch get",
"				posx_cover 0 get line_y moveto show",
"				OK true eq {",
"					STYLE_LINE",
"					posx_cover 1 get line_y lineto",
"					stroke 0 setgray",
"				} if",
"				dup",
"				1 add",
"				textdata exch get",
"				posx_cover 1 get line_y moveto show",
"			} if",
"			choicefieldscover 2 eq {",
"				dup",
"				textdata exch get",
"				posx_cover 0 get line_y moveto show",
"				OK true eq {",
"					STYLE_LINE",
"					posx_cover 1 get line_y lineto",
"					stroke 0 setgray",
"				} if",
"				dup",
"				2 add",
"				textdata exch get",
"				posx_cover 1 get line_y moveto show",
"			} if",
"			choicefieldscover 3 eq {",
"				dup",
"				textdata exch get",
"				posx_cover 0 get line_y moveto show",
"			} if",
"			choicefieldscover 4 eq {",
"				dup",
"				1 add",
"				textdata exch get",
"				posx_cover 0 get line_y moveto show",
"				OK true eq {",
"					STYLE_LINE",
"					posx_cover 1 get line_y lineto",
"					stroke 0 setgray",
"				} if",
"				dup",
"				2 add",
"				textdata exch get",
"				posx_cover 1 get line_y moveto show",
"			} if",
"			choicefieldscover 5 eq {",
"				dup",
"				1 add",
"				textdata exch get",
"				posx_cover 0 get line_y moveto show",
"			} if",
" ",
"			/line_y line_y isize sub def",
"			/indice indice 3 add def",
"		} for",
"	grestore",
"	} if",
"} def",
" ",
"%=======================================================================",
"% draw_textdata_back",
"% affiche le texte au recto de la pochette apres calculs: taille:hauteur:largeur",
"% parameter: -",
"% return: -",
"%=======================================================================",
"/draw_textdata_back",
"{",
"	bool_textdata_back true eq {",
"	gsave",
"		calc_tabprint",
" ",
"		% calcul la taille de la font a utiliser dans un rapport de hauteur:largeur",
" ",
"		/hauteur tabprint 4 get def",
"		/total_line textdata length 3 div def",
"		/isize hauteur total_line div def",
"		isize sizefonttextdata ge { /isize sizefonttextdata def } if",
"		isize calc_pos_textdata",
" ",
"		/line_y tabprint 5 get def",
" ",
"		fonttextdata findfont",
"		isize scalefont",
"		setfont",
" ",
"		/indice 0 def",
"		0 3 textdata length 1 sub",
"		{",
"			bool_line_back true eq {",
"				textdata indice get length 0 eq {",
"					/OK false def",
"				}{",
"					textdata indice 1 add get length 0 eq {",
"						/OK false def",
"					}{",
"						textdata indice 2 add get length 0 eq {",
"							/OK false def",
"						}{",
"							/OK true def",
"						} ifelse",
"					} ifelse",
"				} ifelse",
"			}{",
"				/OK false def",
"			} ifelse",
" ",
"			choicefieldsback 0 eq {",
"				dup",
"				textdata exch get",
"				posx_back 0 get line_y moveto show",
"				OK true eq {",
"					STYLE_LINE",
"					posx_back 1 get line_y lineto",
"					stroke 0 setgray",
"				} if",
"				dup",
"				1 add",
"				textdata exch get",
"				posx_back 1 get line_y moveto show",
"				OK true eq {",
"					STYLE_LINE",
"					posx_back 2 get line_y lineto",
"					stroke 0 setgray",
"				} if",
"				dup",
"				2 add",
"				textdata exch get",
"				posx_back 2 get line_y moveto show",
"			} if",
"			choicefieldsback 1 eq {",
"				dup",
"				textdata exch get",
"				posx_back 0 get line_y moveto show",
"				OK true eq {",
"					STYLE_LINE",
"					posx_back 1 get line_y lineto",
"					stroke 0 setgray",
"				} if",
"				dup",
"				1 add",
"				textdata exch get",
"				posx_back 1 get line_y moveto show",
"			} if",
"			choicefieldsback 2 eq {",
"				dup",
"				textdata exch get",
"				posx_back 0 get line_y moveto show",
"				OK true eq {",
"					STYLE_LINE",
"					posx_back 1 get line_y lineto",
"					stroke 0 setgray",
"				} if",
"				dup",
"				2 add",
"				textdata exch get",
"				posx_back 1 get line_y moveto show",
"			} if",
"			choicefieldsback 3 eq {",
"				dup",
"				textdata exch get",
"				posx_back 0 get line_y moveto show",
"			} if",
"			choicefieldsback 4 eq {",
"				dup",
"				1 add",
"				textdata exch get",
"				posx_back 0 get line_y moveto show",
"				OK true eq {",
"					STYLE_LINE",
"					posx_back 1 get line_y lineto",
"					stroke 0 setgray",
"				} if",
"				dup",
"				2 add",
"				textdata exch get",
"				posx_back 1 get line_y moveto show",
"			} if",
"			choicefieldsback 5 eq {",
"				dup",
"				1 add",
"				textdata exch get",
"				posx_back 0 get line_y moveto show",
"			} if",
" ",
"			/line_y line_y isize sub def",
"			/indice indice 3 add def",
"		} for",
"	grestore",
"	} if",
"} def",
" ",
"/draw_title_to_tongle",
"{",
"gsave",
"	is_bool_title_back true eq {",
"		fonttitle findfont",
"		10 scalefont",
"		setfont",
"		/x c1 12 add def",
"		/y l1 5 add def",
"		x y moveto",
"		90 rotate",
"		title show",
" ",
"	} if",
"grestore",
" ",
"gsave",
"	is_bool_title_back true eq {",
"		fonttitle findfont",
"		10 scalefont",
"		setfont",
"		/x c4 12 add def",
"		/y l1 5 add def",
"		x y moveto",
"		90 rotate",
"		title show",
"	} if",
" ",
"grestore",
"} def",
" ",
"%=======================================================================",
"% draw_title",
"% affiche titre sur recto ET/OU verso",
"% parameter: -",
"% return: -",
"%=======================================================================",
"/draw_title",
"{",
"gsave",
"	% affichage du titre sur 'cover'",
" ",
"	is_bool_title_cover true eq {",
"		fonttitle findfont",
"		sizefonttitle scalefont",
"		setfont",
"		/w title stringwidth pop def",
"		/x c2 wcover w sub 2 div add def",
"		/y l4 sizefonttitle sub def",
"		x y moveto",
"		title show",
"	} if",
" ",
"	is_bool_title_back true eq {",
"		fonttitle findfont",
"		sizefonttitle scalefont",
"		setfont",
"		/w title stringwidth pop def",
"		/x c1 wback w sub 2 div front sub add def",
"		/y l2 sizefonttitle sub def",
"		x y moveto",
"		title show",
"	} if",
" ",
"grestore",
" ",
"	draw_title_to_tongle",
"} def",
" ",
"%=======================================================================",
"% draw_foottext",
"% affiche le pied de page sur recto ET/OU verso",
"% parameter: -",
"% return: -",
"%=======================================================================",
"/draw_foottext",
"{",
"gsave",
"	foottext length 0 gt {",
"		bool_foottext_cover true eq {",
"			fontfoottext findfont",
"			sizefontfoottext scalefont",
"			setfont",
"			0.4 setgray",
"			/w foottext stringwidth pop def",
"			/x c2 wcover w sub 2 div add def",
"			/y l3 sizefontfoottext add def",
"			x y moveto",
"			foottext show",
"		} if",
"		bool_foottext_back true eq {",
"			fontfoottext findfont",
"			sizefontfoottext scalefont",
"			setfont",
"			0.4 setgray",
"			/w foottext stringwidth pop def",
"			/x c1 wback w sub 2 div front sub add def",
"			/y l1 sizefontfoottext add def",
"			x y moveto",
"			foottext show",
"		} if",
"	} if",
"grestore",
"} def",
" ",
"%=======================================================================",
"% draw_info",
"% affiche quelques informations: auteur, etc ...",
"% parameter: -",
"% return: -",
"%=======================================================================",
"/draw_info",
"{",
"gsave",
"	/Helvetica findfont",
"	7 scalefont",
"	setfont",
"	0.5 setgray",
"	/x left wback add tongue sub 2 add def",
"	/y lback hback add 10 add def",
"	x y moveto",
"	90 rotate",
"	(<-- cut here, if you don't need a tongue --- Couper ici si vous n'avez pas besoin de cette bordure) show",
"grestore",
"gsave",
"	/Helvetica findfont",
"	7 scalefont",
"	setfont",
"	0.5 setgray",
"	/x left def",
"	/y lback 20 sub def",
"	x y moveto",
"	PACKAGE show",
"	(  ) show",
"	VERSION show",
"	(  ) show",
"	(GNU General Public License  -  2003 - 2011, Claude Bulin  -  fr) show",
"grestore",
"} def",
" ",
"%=======================================================================",
"% init_tabcover",
"%   6 colonnes de droite a gauche",
"%   4 lignes de bas en haut",
"% init des coordonnees du recto et du verso",
"% parameter: -",
"% return: -",
"%=======================================================================",
"/init_tabcover",
"{",
"	% 6 colonnes droite vers gauche",
" ",
"	tabcover 0 left put",
"	tabcover 1 left front add put",
"	tabcover 2 front left add wcover add put",
"	tabcover 3 left wback add tongue sub front sub put",
"	tabcover 4 left wback add tongue sub put",
"	tabcover 5 left wback add put",
" ",
"	% 4 lignes bas vers haut",
" ",
"	tabcover 6 lback put",
"	tabcover 7 lback hback add put",
"	tabcover 8 lback hback add gap add put",
"	tabcover 9 lback hback add gap add hcover add put",
"} def",
" ",
"%=======================================================================",
"% draw_graph",
"% dessine le graphisme du recto et du verso",
"% parameter: -",
"% return: -",
"%=======================================================================",
"/draw_graph",
"{",
"gsave",
"	0.5 setlinewidth	% epaisseur du trait",
"	0.50 setgray		% contour pochette en gris clair",
" ",
"	c2 diff sub l4 moveto	% recto haut",
"	c3 diff add l4 lineto",
"	c2 diff sub l3 moveto	% recto bas",
"	c3 diff add l3 lineto",
"	c2 l3 diff sub moveto	% recto gauche",
"	c2 l4 diff add lineto",
"	c3 l3 diff sub moveto	% recto droite",
"	c3 l4 diff add lineto",
" ",
"	c1 diff sub l2 moveto	% verso ligne haut",
"	c6 diff add l2 lineto",
"	c1 diff sub l1 moveto	% verso ligne bas",
"	c6 diff add l1 lineto",
"	c1 l1 diff sub moveto	% verso ligne 1 gauche vers droite",
"	c1 l2 diff add lineto",
"	c2 l1 diff sub moveto	% verso ligne 2 gauche vers droite",
"	c2 l2 diff add lineto",
"	c4 l1 diff sub moveto	% verso ligne 3 gauche vers droite",
"	c4 l2 diff add lineto",
"	c5 l1 diff sub moveto	% verso ligne 4 gauche vers droite",
"	c5 l2 diff add lineto",
"	c6 l1 diff sub moveto	% verso ligne 5 gauche vers droite",
"	c6 l2 diff add lineto",
" ",
"	stroke",
"grestore",
"} def",
" ",
"%=======================================================================",
"% DEBUG_set_font",
"% DEBUG test d'affichage de chaine",
"% parameter: -",
"% return: -",
"%=======================================================================",
"/DEBUG_set_font",
"{",
"	gsave",
"	/Helvetica-Bold findfont",
"	12 scalefont",
"	setfont",
"	c2 10 sub l2 30 sub moveto",
"	(chaine de test chaine de test chaine de test) show",
"	grestore",
"} def",
" ",
"init_tabcover",
"draw_graph",
"draw_title",
"draw_foottext",
"draw_textdata_cover",
"draw_textdata_back",
"draw_info",
"showpage",
" ",
"%EOF",
" ",
""
};

/* Production 'convert'
 * Version: ImageMagick 6.2.4 11/24/06 Q16 http://www.imagemagick.org
 * Copyright: Copyright (C) 1999-2005 ImageMagick Studio LLC
 */
gchar *code_convert_ps [] =
{
" ",
"%%BeginProlog",
"%",
"% Display a color image.  The image is displayed in color on",
"% Postscript viewers or printers that support color, otherwise",
"% it is displayed as grayscale.",
"%",
"/DirectClassPacket",
"{",
"  %",
"  % Get a DirectClass packet.",
"  %",
"  % Parameters:",
"  %   red.",
"  %   green.",
"  %   blue.",
"  %   length: number of pixels minus one of this color (optional).",
"  %",
"  currentfile color_packet readhexstring pop pop",
"  compression 0 eq",
"  {",
"    /number_pixels 3 def",
"  }",
"  {",
"    currentfile byte readhexstring pop 0 get",
"    /number_pixels exch 1 add 3 mul def",
"  } ifelse",
"  0 3 number_pixels 1 sub",
"  {",
"    pixels exch color_packet putinterval",
"  } for",
"  pixels 0 number_pixels getinterval",
"} bind def",
" ",
"/DirectClassImage",
"{",
"  %",
"  % Display a DirectClass image.",
"  %",
"  systemdict /colorimage known",
"  {",
"    columns rows 8",
"    [",
"      columns 0 0",
"      rows neg 0 rows",
"    ]",
"    { DirectClassPacket } false 3 colorimage",
"  }",
"  {",
"    %",
"    % No colorimage operator;  convert to grayscale.",
"    %",
"    columns rows 8",
"    [",
"      columns 0 0",
"      rows neg 0 rows",
"    ]",
"    { GrayDirectClassPacket } image",
"  } ifelse",
"} bind def",
" ",
"/GrayDirectClassPacket",
"{",
"  %",
"  % Get a DirectClass packet;  convert to grayscale.",
"  %",
"  % Parameters:",
"  %   red",
"  %   green",
"  %   blue",
"  %   length: number of pixels minus one of this color (optional).",
"  %",
"  currentfile color_packet readhexstring pop pop",
"  color_packet 0 get 0.299 mul",
"  color_packet 1 get 0.587 mul add",
"  color_packet 2 get 0.114 mul add",
"  cvi",
"  /gray_packet exch def",
"  compression 0 eq",
"  {",
"    /number_pixels 1 def",
"  }",
"  {",
"    currentfile byte readhexstring pop 0 get",
"    /number_pixels exch 1 add def",
"  } ifelse",
"  0 1 number_pixels 1 sub",
"  {",
"    pixels exch gray_packet put",
"  } for",
"  pixels 0 number_pixels getinterval",
"} bind def",
" ",
"/GrayPseudoClassPacket",
"{",
"  %",
"  % Get a PseudoClass packet;  convert to grayscale.",
"  %",
"  % Parameters:",
"  %   index: index into the colormap.",
"  %   length: number of pixels minus one of this color (optional).",
"  %",
"  currentfile byte readhexstring pop 0 get",
"  /offset exch 3 mul def",
"  /color_packet colormap offset 3 getinterval def",
"  color_packet 0 get 0.299 mul",
"  color_packet 1 get 0.587 mul add",
"  color_packet 2 get 0.114 mul add",
"  cvi",
"  /gray_packet exch def",
"  compression 0 eq",
"  {",
"    /number_pixels 1 def",
"  }",
"  {",
"    currentfile byte readhexstring pop 0 get",
"    /number_pixels exch 1 add def",
"  } ifelse",
"  0 1 number_pixels 1 sub",
"  {",
"    pixels exch gray_packet put",
"  } for",
"  pixels 0 number_pixels getinterval",
"} bind def",
" ",
"/PseudoClassPacket",
"{",
"  %",
"  % Get a PseudoClass packet.",
"  %",
"  % Parameters:",
"  %   index: index into the colormap.",
"  %   length: number of pixels minus one of this color (optional).",
"  %",
"  currentfile byte readhexstring pop 0 get",
"  /offset exch 3 mul def",
"  /color_packet colormap offset 3 getinterval def",
"  compression 0 eq",
"  {",
"    /number_pixels 3 def",
"  }",
"  {",
"    currentfile byte readhexstring pop 0 get",
"    /number_pixels exch 1 add 3 mul def",
"  } ifelse",
"  0 3 number_pixels 1 sub",
"  {",
"    pixels exch color_packet putinterval",
"  } for",
"  pixels 0 number_pixels getinterval",
"} bind def",
" ",
"/PseudoClassImage",
"{",
"  %",
"  % Display a PseudoClass image.",
"  %",
"  % Parameters:",
"  %   class: 0-PseudoClass or 1-Grayscale.",
"  %",
"  currentfile buffer readline pop",
"  token pop /class exch def pop",
"  class 0 gt",
"  {",
"    currentfile buffer readline pop",
"    token pop /depth exch def pop",
"    /grays columns 8 add depth sub depth mul 8 idiv string def",
"    columns rows depth",
"    [",
"      columns 0 0",
"      rows neg 0 rows",
"    ]",
"    { currentfile grays readhexstring pop } image",
"  }",
"  {",
"    %",
"    % Parameters:",
"    %   colors: number of colors in the colormap.",
"    %   colormap: red, green, blue color packets.",
"    %",
"    currentfile buffer readline pop",
"    token pop /colors exch def pop",
"    /colors colors 3 mul def",
"    /colormap colors string def",
"    currentfile colormap readhexstring pop pop",
"    systemdict /colorimage known",
"    {",
"      columns rows 8",
"      [",
"        columns 0 0",
"        rows neg 0 rows",
"      ]",
"      { PseudoClassPacket } false 3 colorimage",
"    }",
"    {",
"      %",
"      % No colorimage operator;  convert to grayscale.",
"      %",
"      columns rows 8",
"      [",
"        columns 0 0",
"        rows neg 0 rows",
"      ]",
"      { GrayPseudoClassPacket } image",
"    } ifelse",
"  } ifelse",
"} bind def",
" ",
"/DisplayImage",
"{",
"  %",
"  % Display a DirectClass or PseudoClass image.",
"  %",
"  % Parameters:",
"  %   x & y translation.",
"  %   x & y scale.",
"  %   label pointsize.",
"  %   image label.",
"  %   image columns & rows.",
"  %   class: 0-DirectClass or 1-PseudoClass.",
"  %   compression: 0-none or 1-RunlengthEncoded.",
"  %   hex color packets.",
"  %",
"  gsave",
"  /buffer 512 string def",
"  /byte 1 string def",
"  /color_packet 3 string def",
"  /pixels 768 string def",
" ",
"  currentfile buffer readline pop",
"  token pop /x exch def",
"  token pop /y exch def pop",
"  x y translate",
"  currentfile buffer readline pop",
"  token pop /x exch def",
"  token pop /y exch def pop",
"  currentfile buffer readline pop",
"  token pop /pointsize exch def pop",
"  /Times-Roman findfont pointsize scalefont setfont",
"  x y scale",
"  currentfile buffer readline pop",
"  token pop /columns exch def",
"  token pop /rows exch def pop",
"  currentfile buffer readline pop",
"  token pop /class exch def pop",
"  currentfile buffer readline pop",
"  token pop /compression exch def pop",
"  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",
"  grestore",
"% showpage",
"} bind def",
"%%EndProlog",
" ",
""
};

