 /*
 * file      : cdtoc.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2011 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef cdtoc_h
#define cdtoc_h 1


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

typedef enum {
	SERVER_CDDB_LOCAL = 0,
	// SERVER_CDDB_AT,
	// SERVER_CDDB_CA,
	// SERVER_CDDB_DE,
	// SERVER_CDDB_FI,
	// SERVER_CDDB_FR,
	// SERVER_CDDB_NO,
	// SERVER_CDDB_UK,
	// SERVER_CDDB_US,
	SERVER_CDDB_PARAM,
	SERVER_CDDB_NONE
} SERVER_CDDB;

typedef enum {
	CONNECT_IS_FALSE,
	CONNECT_IS_TRUE,
	CONNECT_IS_NO_MATCH_FOUND
} ETAT_CONNECT;

typedef struct {
	gint   SumMin;				/* Valeurs bas niveau	*/
	gint   SumSec;				/*			*/
	gint   SumCent;				/*			*/
	gint   Min;				/* Vraies valeurs	*/
	gint   Sec;				/*			*/
	gint   Cent;				/*			*/
	gchar *TitleTrack;			/* Le titre de la piste	*/
} TIME_CD;

typedef struct {
	gchar         *TitleCD;			/* Le titre du CD				*/
	gint           TT_Min;			/* total duree du CD				*/
	gint           TT_Sec;			/*						*/
	unsigned long  Num_ID_CD;		/* ID du CD					*/
	gchar          Str_ID_CD [ 20 ];	/* string:ID du CD				*/
	gint           TotalTracks;		/* Nombre de pistes				*/
	gint           NumGenre;		/* Genre du CD					*/
	gchar         *StrGenre;		/* string:Genre du CD				*/
	gint           NumYear;			/* Annee du CD					*/
	gchar         *StrYear;			/* string:Annee du CD				*/
	TIME_CD       *TimeTrack;		/* pointeur sur TIME_CD				*/
	ETAT_CONNECT   Bool_Connected;		/* Etat de la lecture de la base sur le Web	*/
	gboolean       BoolMultiArtiste;
} CD_TOC;

extern CD_TOC *CdToc;

/*
*---------------------------------------------------------------------------
* CDTOC.C
*---------------------------------------------------------------------------
*/
GList   *cdtoc_read (void);
void     cdtoc_deallocate_cd_toc (void);

/*
*---------------------------------------------------------------------------
* CD_IOCTL.C
*---------------------------------------------------------------------------
*/
gint     cdioctl_read_toc (void);

/*
*---------------------------------------------------------------------------
* CD_PARANOIA.C
*---------------------------------------------------------------------------
*/
gint     cdparanoia_read_toc (void);

/*
*---------------------------------------------------------------------------
* CD_DB.C
*---------------------------------------------------------------------------
*/
CD_TOC   *cddb_get_datas_cddb (CD_TOC *CdToc);
void      cddb_set_bool_cancel_cddb (gboolean FLAG);
gboolean  cddb_get_bool_cancel_cddb (void);
gboolean  cddb_test_access_web (void);


#endif
