 /*
 * file      : cdtoc.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2011 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib/gprintf.h>
#include <string.h>
#include <stdlib.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "file.h"
#include "cd_audio.h"
#include "configuser.h"
#include "tags.h"
#include "cd_cue.h"
#include "cdtoc.h"

/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
CD_TOC *CdToc = NULL;



/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/

/* Desalloue la structure CD_TOC
*/
void cdtoc_deallocate_cd_toc (void)
{
	gint i;

	/* PRINT_FUNC_LF(); */
	if (CdToc != NULL) {
		if (CdToc->TimeTrack != NULL) {
			for (i = 0; i < CdToc->TotalTracks + 2; i++) {
				if (CdToc->TimeTrack [ i ].TitleTrack) {
					g_free (CdToc->TimeTrack [ i ].TitleTrack);
					CdToc->TimeTrack [ i ].TitleTrack = NULL;
				}
			}
			g_free (CdToc->TimeTrack);
			CdToc->TimeTrack = NULL;
		}
		g_free (CdToc->TitleCD);
		CdToc->TitleCD = NULL;
		g_free (CdToc->StrGenre);
		CdToc->StrGenre = NULL;
		g_free (CdToc->StrYear);
		CdToc->StrYear = NULL;
		
		g_free (CdToc);
		CdToc = NULL;
	}
}

GList *cdtoc_set_toc_to_glist_audio (void)
{
	GList	*List = NULL;
	AUDIO	*Audio = NULL;
	gint	 NumList;
	gchar   *Ptr = NULL;

	g_free (EnteteCD.TitleCD);	EnteteCD.TitleCD = NULL;
	g_free (EnteteCD.Duree_cd);	EnteteCD.Duree_cd = NULL;
	EnteteCD.Num_ID_CD = 0;
	strcpy (EnteteCD.Str_ID_CD, "");
	EnteteCD.TotalTracks = 0;
	EnteteCD.NumGenre = 0;
	g_free (EnteteCD.StrGenre);	EnteteCD.StrGenre = NULL;
	EnteteCD.Bool_Connected = CdToc->Bool_Connected;
	
	if (CdToc->Bool_Connected == CONNECT_IS_TRUE) {

		EnteteCD.TitleCD = g_strdup (CdToc->TitleCD);
		EnteteCD.Title = g_strdup (CdToc->TitleCD);
		EnteteCD.Artiste = g_strdup (CdToc->TitleCD);
		EnteteCD.Duree_cd = g_strdup_printf ("%02d:%02d", CdToc->TT_Min, CdToc->TT_Sec);
		EnteteCD.Num_ID_CD = CdToc->Num_ID_CD;
		strncpy (EnteteCD.Str_ID_CD, CdToc->Str_ID_CD, 19);
		EnteteCD.TotalTracks = CdToc->TotalTracks;
		EnteteCD.NumGenre = CdToc->NumGenre;
		EnteteCD.StrGenre = g_strdup (CdToc->StrGenre);
		if (CdToc->NumYear <= 0) {
			CdToc->NumYear = 1962;
			g_free (CdToc->StrYear);
			CdToc->StrYear = NULL;
			CdToc->StrYear = g_strdup ("1962");
		}
		EnteteCD.NumYear = CdToc->NumYear;
		EnteteCD.StrYear = g_strdup (CdToc->StrYear);
		EnteteCD.Bool_Connected = CdToc->Bool_Connected;
		EnteteCD.BoolMultiArtiste = CdToc->BoolMultiArtiste;
	}
	else if (CdToc->Bool_Connected == CONNECT_IS_FALSE) {
		
		EnteteCD.Duree_cd = g_strdup_printf ("%02d:%02d", CdToc->TT_Min, CdToc->TT_Sec);
		if (CdToc->TitleCD == NULL)
			CdToc->TitleCD = g_strdup ("Track");
		EnteteCD.TitleCD = g_strdup (CdToc->TitleCD);
		EnteteCD.Title = g_strdup (CdToc->TitleCD);
		EnteteCD.Artiste = g_strdup (CdToc->TitleCD);
			
		EnteteCD.TotalTracks = CdToc->TotalTracks;
		EnteteCD.Num_ID_CD = CdToc->Num_ID_CD;
		strncpy (EnteteCD.Str_ID_CD, CdToc->Str_ID_CD, 19);
	}
	else if (CdToc->Bool_Connected == CONNECT_IS_NO_MATCH_FOUND) {
		
		EnteteCD.Duree_cd = g_strdup_printf ("%02d:%02d", CdToc->TT_Min, CdToc->TT_Sec);
		EnteteCD.TotalTracks = CdToc->TotalTracks;
		EnteteCD.Num_ID_CD = CdToc->Num_ID_CD;
		strncpy (EnteteCD.Str_ID_CD, CdToc->Str_ID_CD, 19);
	}
	
	EnteteCD.Duree_cd = g_strdup_printf ("%02d:%02d", CdToc->TT_Min, CdToc->TT_Sec);
	EnteteCD.Num_ID_CD = CdToc->Num_ID_CD;
	strncpy (EnteteCD.Str_ID_CD, CdToc->Str_ID_CD, 19);
	EnteteCD.TotalTracks = CdToc->TotalTracks;

	EnteteCD.NumGenre = CdToc->NumGenre;
	EnteteCD.StrGenre = g_strdup (CdToc->StrGenre);
	EnteteCD.NumYear = CdToc->NumYear;
	EnteteCD.StrYear = g_strdup (CdToc->StrYear);
	EnteteCD.Bool_Connected = CdToc->Bool_Connected;
		
	for (NumList = 0; NumList < CdToc->TotalTracks; NumList++) {
		
		if ((Audio = (AUDIO *)g_malloc0 (sizeof (AUDIO))) == NULL) {
			continue;
		}
		
		Audio->EtatPlay             = CD_ETAT_PLAY_ATTENTE;

		Audio->Bool_Delette_Flac    = FALSE;
		Audio->Bool_Delette_Wav     = FALSE;
		Audio->Bool_Delette_Mp3     = FALSE;
		Audio->Bool_Delette_Ogg     = FALSE;
		Audio->Bool_Delette_M4a     = FALSE;
		Audio->Bool_Delette_Mpc     = FALSE;
		Audio->Bool_Delette_Ape     = FALSE;
		Audio->Bool_Delette_WavPack = FALSE;

		Audio->EtatSelection_Flac    = CD_ETAT_ATTENTE;
		Audio->EtatSelection_Wav     = CD_ETAT_ATTENTE;
		Audio->EtatSelection_Mp3     = CD_ETAT_ATTENTE;
		Audio->EtatSelection_Ogg     = CD_ETAT_ATTENTE;
		Audio->EtatSelection_M4a     = CD_ETAT_ATTENTE;
		Audio->EtatSelection_Mpc     = CD_ETAT_ATTENTE;
		Audio->EtatSelection_Ape     = CD_ETAT_ATTENTE;
		Audio->EtatSelection_WavPack = CD_ETAT_ATTENTE;

		Audio->Etat_Flac      = NONE;
		Audio->Etat_Wav       = NONE;
		Audio->Etat_Mp3       = NONE;
		Audio->Etat_Ogg       = NONE;
		Audio->Etat_m4a       = NONE;
		Audio->Etat_Mpc       = NONE;
		Audio->Etat_Ape       = NONE;
		Audio->Etat_WavPack   = NONE;
		Audio->EtatNormalise  = CD_NORM_PEAK_NONE;

		Audio->PathName_Dest_Flac     = NULL;
		Audio->PathName_Dest_Wav      = NULL;
		Audio->PathName_Dest_Mp3      = NULL;
		Audio->PathName_Dest_Ogg      = NULL;
		Audio->PathName_Dest_M4a      = NULL;
		Audio->PathName_Dest_Mpc      = NULL;
		Audio->PathName_Dest_Ape      = NULL;
		Audio->PathName_Dest_WavPack  = NULL;
				
		Audio->tags = (TAGS *)tags_alloc (TRUE);
	
		Audio->Num_Track      = NumList + 1;
		Audio->Str_Track      = g_strdup_printf ("%02d", NumList + 1);
		Audio->Duree          = g_strdup_printf ("%02d:%02d",
							CdToc->TimeTrack[ NumList ].Min,
								CdToc->TimeTrack[ NumList ].Sec);
		Audio->NameSong       = g_strdup_printf ("Track_%02d", NumList + 1);

		if (CdToc->Bool_Connected == CONNECT_IS_TRUE) {

				if (Audio->NameSong != NULL) {
					g_free (Audio->NameSong);	Audio->NameSong = NULL;
				}
				
				if (CdToc->TimeTrack[ NumList ].TitleTrack == NULL) {
					Audio->NameSong       = g_strdup_printf ("Track_%02d", NumList +1);
				} else {
					/*
					Muddy Waters / Mannish boy
					Keb Mo / Am i wrong
					Eddie Boyd and Fleetwod Mac / Shes real
					
					SUITE MESSAGE DE:
						http://forum.ubuntu-fr.org/viewtopic.php?pid=2770488#p2770488
					TEST POUR RECTIF D'UN CAR '/' DANS LE NOM D'UN TITRE
						http://www.m-base.com/resistance_is_futile.html
					
					Law of Balance/Figit Time
					*/
					
					Audio->NameSong       = g_strdup (CdToc->TimeTrack[ NumList ].TitleTrack);
				}

				Audio->tags = (TAGS *)tags_remove (Audio->tags);
				Audio->tags = (TAGS *)tags_alloc (TRUE);

				if ((Ptr = strstr (EnteteCD.TitleCD, " / "))) {
					Ptr += 3;
					Audio->tags->Album = g_strdup (Ptr);
				}
				else {
					if (EnteteCD.TitleCD)
						Audio->tags->Album = g_strdup (EnteteCD.TitleCD);
					else	Audio->tags->Album = g_strdup ("");
				}

				if (CdToc->TimeTrack[ NumList ].TitleTrack) {
					Audio->tags->Artist = g_strdup (CdToc->TimeTrack[ NumList ].TitleTrack);
					Audio->tags->Title = g_strdup (CdToc->TimeTrack[ NumList ].TitleTrack);
				} else {
					Audio->tags->Artist = g_strdup ("");
					Audio->tags->Title  = g_strdup ("");
				}
				
				/*   http://forum.ubuntu-fr.org/profile.php?id=66710
				 *   Xzu Rukneg
				 *   soumet un bug avec le caractere / dans un nom de fichier : RESOLU  ;)
				while ((Ptr = strchr (Audio->tags->Title, '/')) != NULL) {
					if (*(Ptr -1) != ' ' || *(Ptr +1) != ' ') {
						g_print("PTR = %s\n", Ptr);
						*Ptr = ' ';
					}
				}
				 */
				for (Ptr = Audio->tags->Title; *Ptr; Ptr ++) {
					if (*(Ptr) == '/') {
						*Ptr = '-';
					}
				}
				
				if ((Ptr = strstr (Audio->tags->Artist, " / "))) {
					*Ptr = '\0';
				}
				else {
					g_free (Audio->tags->Artist);
					Audio->tags->Artist = NULL;
					Audio->tags->Artist = g_strdup (EnteteCD.TitleCD);
					if ((Ptr = strstr (Audio->tags->Artist, " / "))) *Ptr = '\0';
				}
				
				if ((Ptr = strstr (Audio->tags->Title, " / "))) {
					gchar *dummy = NULL;
					Ptr += 3;
					dummy = g_strdup (Ptr);
					g_free (Audio->tags->Title);
					Audio->tags->Title = NULL;
					Audio->tags->Title = g_strdup (dummy);
					g_free (dummy);
					dummy = NULL;
				}
				if (CdToc->StrYear)
					Audio->tags->Year = g_strdup (CdToc->StrYear);
				else	Audio->tags->Year = g_strdup ("1962");
				
				Audio->tags->IntYear = CdToc->NumYear;
				
				/*switch (CdToc->NumGenre) {
				case 0 :  Audio->tags->IntGenre = 0;  break;
				case 1 :  Audio->tags->IntGenre = 0;  break;
				case 2 :  Audio->tags->IntGenre = 32; break;
				case 3 :  Audio->tags->IntGenre = 2;  break;
				case 4 :  Audio->tags->IntGenre = 0;  break;
				case 5 :  Audio->tags->IntGenre = 80; break;
				case 6 :  Audio->tags->IntGenre = 8;  break;
				case 7 :  Audio->tags->IntGenre = 0;  break;
				case 8 :  Audio->tags->IntGenre = 10; break;
				case 9 :  Audio->tags->IntGenre = 16; break;
				case 10 : Audio->tags->IntGenre = 17; break;
				case 11 : Audio->tags->IntGenre = 25; break;
				default : Audio->tags->IntGenre = 0;
				}*/
				Audio->tags->IntGenre = CdToc->NumGenre;
				Audio->tags->Genre = g_strdup (CdToc->StrGenre);
				
				Audio->tags->Number = g_strdup_printf ("%d", NumList +1);
				Audio->tags->IntNumber = NumList +1;
				Audio->tags->Comment = g_strdup ("By Xcfa");
				
				
				/*
				g_print("[%02d]----", NumList +1);
				g_print (  "Artist  = '%s'\n", Audio->tags->Artist  ? Audio->tags->Artist  : "");
				g_print ("\tTitle   = '%s'\n", Audio->tags->Title   ? Audio->tags->Title   : "");
				g_print ("\tAlbum   = '%s'\n", Audio->tags->Album   ? Audio->tags->Album   : "");
				g_print ("\tNumber  = '%s'\n", Audio->tags->Number  ? Audio->tags->Number  : "");
				g_print ("\tGenre   = '%s'\n", Audio->tags->Genre   ? Audio->tags->Genre   : "");
				g_print ("\tNumGenre= '%d'\n", CdToc->NumGenre);
				g_print ("\tStrGenre= '%s'\n", CdToc->StrGenre);
				g_print ("\tYear    = '%s'\n", Audio->tags->Year    ? Audio->tags->Year    : "");
				g_print ("\tComment = '%s'\n", Audio->tags->Comment ? Audio->tags->Comment : "");
				g_print ("\n");
				*/
		}
		else if (CdToc->Bool_Connected == CONNECT_IS_FALSE) {
		
				if (CdToc->TimeTrack[ NumList ].TitleTrack == NULL) {
					CdToc->TimeTrack[ NumList ].TitleTrack  = g_strdup_printf ("Track_%02d", NumList +1);
				}
				
				Audio->tags = (TAGS *)tags_remove (Audio->tags);
				Audio->tags = (TAGS *)tags_alloc (TRUE);
				
				if (Audio->NameSong != NULL) {
					g_free (Audio->NameSong);	Audio->NameSong = NULL;
				}
				
				Audio->NameSong          = g_strdup_printf ("Track_%02d", NumList +1);
				Audio->tags->Album       = g_strdup ("Track");
				Audio->tags->Artist      = g_strdup ("");
				Audio->tags->Title       = g_strdup_printf ("Track_%02d", NumList +1);
				Audio->tags->Number      = g_strdup_printf ("%d", NumList +1);
				Audio->tags->IntNumber   = NumList +1;
				Audio->tags->Genre       = g_strdup ("A Cappella");
				Audio->tags->IntGenre    = 123;
				Audio->tags->Year        = g_strdup ("1962");
				Audio->tags->IntYear     = 1962;
				Audio->tags->Comment     = g_strdup ("By Xcfa");
				Audio->tags->Description = g_strdup ("By Xcfa");
		}
		else if (CdToc->Bool_Connected == CONNECT_IS_NO_MATCH_FOUND) {
				
				Audio->tags = (TAGS *)tags_remove (Audio->tags);
				Audio->tags = (TAGS *)tags_alloc (TRUE);
				
				if (Audio->NameSong != NULL) {
					g_free (Audio->NameSong);	Audio->NameSong = NULL;
				}
				
				Audio->NameSong          = g_strdup_printf ("Track_%02d", NumList +1);
				Audio->tags->Album       = g_strdup ("Track");
				Audio->tags->Artist      = g_strdup ("");
				Audio->tags->Title       = g_strdup_printf ("Track_%02d", NumList +1);
				Audio->tags->Number      = g_strdup_printf ("%d", NumList +1);
				Audio->tags->IntNumber   = NumList +1;
				Audio->tags->Genre       = g_strdup ("A Cappella");
				Audio->tags->IntGenre    = 123;
				Audio->tags->Year        = g_strdup ("1962");
				Audio->tags->IntYear     = 1962;
				Audio->tags->Comment     = g_strdup ("By Xcfa");
				Audio->tags->Description = g_strdup ("By Xcfa");
		}

		List = g_list_append (List, (AUDIO *)Audio);
	}

	return (List);
}

gboolean cdtoc_meme (GList *List_audio, gchar *title, gint track)
{
	GList *List = NULL;
	AUDIO *Audio = NULL;
	
	List = g_list_first (List_audio);
	while (List) {
		if ((Audio = (AUDIO *)List->data) != NULL) {
			if (Audio->Num_Track != track) {
				if (strcmp (Audio->NameSong, title) == 0) return (TRUE);
			}
		}
		List = g_list_next(List);
	}
	return (FALSE);
}

void cdtoc_compare_title (GList *List_audio)
{
	GList *List = NULL;
	AUDIO *Audio = NULL;
	gint   num = 0;
	
	List = g_list_first (List_audio);
	num = 0;
	while (List) {
		if ((Audio = (AUDIO *)List->data) != NULL) {
			if (cdtoc_meme (List_audio, Audio->NameSong, Audio->Num_Track)) {
				gchar *temp = g_strdup_printf ("%d_%s", num ++, Audio->NameSong);
				g_free (Audio->NameSong);
				Audio->NameSong = NULL;
				Audio->NameSong = g_strdup (temp);
				g_free (temp);
				temp = NULL;
				
				List = g_list_first (List_audio);
				continue;
			}
		}
		List = g_list_next(List);
	}
}

/*
*/
GList *cdtoc_read (void)
{
	GList *glist = NULL;
	gint   ret;

	/* Lecture base CD-AUDIO
	*/
#ifdef HAVE_LINUX_CDROM_H
	if (TRUE == Config.ReadCdByIoctl) {
		PRINT("ret = cdioctl_read_toc ();");
		// LIRE TOC DEPUIS IOCTL
		// RENSEIGNER LA BASE toc
		ret = cdioctl_read_toc ();
	}
	else {
		PRINT("ret = cdparanoia_read_toc ();");
		// LIRE TOC DEPUIS CDPARANOIA
		// RENSEIGNER LA BASE toc
		ret = cdparanoia_read_toc ();
	}
#else
	PRINT("ret = cdparanoia_read_toc ();");
	// LIRE TOC DEPUIS CDPARANOIA
	// RENSEIGNER LA BASE toc
	ret = cdparanoia_read_toc ();
#endif
	g_print("\tRET = %d\n", ret);
	/* Prend les infos de base, allocmem, stock et retour
	 *
	 * RETURN
	 *    0  OK
	 *    1  PROBLEME D'ALLOCATION MEMOIRE
	 *    2  CD-ROM AUDIO ABSENT DU LECTEUR
	 *    3  LE CD DANS LECTEUR N'EST PAS UN CD-AUDIO
	 */
	switch (ret) {
	case 0 :

		if (gtk_combo_box_get_active (var_cd.Adr_combobox_serveur) < SERVER_CDDB_NONE && cddb_test_access_web () == TRUE) {	
			
			// LECTURE CATALOG CD DEPUIS freedb AVEC ICEDAX
			CdToc = cddb_get_datas_cddb (CdToc);
		}
		else {
			CdToc->Bool_Connected = CONNECT_IS_FALSE;
		}
		
		// FABRIQUER UNE LISTE CORRECTE POUR LE GLIST
		glist = cdtoc_set_toc_to_glist_audio ();
		
		// FABRIQUER UNE LISTE CORRECTE POUR CUE
		cdcue_make_cue ();
		cdcue_make_cue_with_cdtoc (CdToc);

		// SI MEME TITRE ALORS AJOUTER UN INCREMENT POUR LES DIFFERENCIER
		cdtoc_compare_title (glist);
		
		if (CdToc->Bool_Connected == CONNECT_IS_TRUE)
			EnteteCD.Message = g_strdup ("");
		else if (CdToc->Bool_Connected == CONNECT_IS_FALSE)
			EnteteCD.Message = g_strdup (_("Vous n'etes pas connecte au web"));
		else if (CdToc->Bool_Connected == CONNECT_IS_NO_MATCH_FOUND)
			EnteteCD.Message = g_strdup (_("Aucune donnee dans la base pour ce cd"));
		EnteteCD.Bool_Read_Infos_cd = TRUE;
		break;
	case 1 :
		EnteteCD.Message = g_strdup (_("Probleme d'allocation memoire"));
		EnteteCD.Bool_Read_Infos_cd = FALSE;
		break;
	case 2 :
		EnteteCD.Message = g_strdup (_("Le cd-audio est absent du lecteur"));
		EnteteCD.Bool_Read_Infos_cd = FALSE;
		break;
	case 3 :
		EnteteCD.Message = g_strdup (_("Le cd dans le lecteur n'est pas un cd-audio"));
		EnteteCD.Bool_Read_Infos_cd = FALSE;
		break;
	}
	
	// PLUS BESOIN DE CETTE STRUCTURE
	cdtoc_deallocate_cd_toc ();

	return ((GList *)glist);
}




