 /*
 * file    : tags_wavpack.c
 * project : xcfa
 * with    : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#include <gtk/gtk.h>
#include <glib/gstdio.h>

#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "file.h"
#include "tags.h"
#include <taglib/tag_c.h>
#include "get.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/*
typedef struct {
    char ckID [4];              "wvpk"
    uint32_t ckSize;            size of entire block (minus 8, of course)
    uint16_t version;           0x402 to 0x410 are currently valid for decode
    uchar track_no;             track number (0 if not used, like now)
    uchar index_no;             track sub-index (0 if not used, like now)
    uint32_t total_samples;     total samples for entire file, but this is
                                only valid if block_index == 0 and a value of
                                -1 indicates unknown length
    uint32_t block_index;       index of first sample in block relative to
                                beginning of file (normally this would start
                                at 0 for the first block)
    uint32_t block_samples;     number of samples in this block (0 = no audio)
    uint32_t flags;             various flags for id and decoding
    uint32_t crc;               crc for actual decoded data
} WavpackHeader;
*/

/*
typedef struct {
	gchar id [ 3 ];
	gchar title [ 30 ];
	gchar interprete [ 30 ];
	gchar album [ 30 ];
	gchar annee [ 4 ];
	gchar comment [ 30 ];
	gchar genre [ 1 ];
} TAGS_WAVPACK;
*/

/*
*---------------------------------------------------------------------------
* FILE IS WAVPACK ?
*---------------------------------------------------------------------------
*/

gboolean tagswavpack_file_is_wavpack (gchar *namefile)
{
	FILE      *fp = NULL;
	gchar      str [ 42 ] = {'\0','\0','\0','\0','\0','\0','\0','\0'};
	size_t     lenread = 0;

	if ((fp = fopen (namefile, "rb")) != NULL) {
		lenread = fread (&str[0], 1, 40, fp);
		fclose (fp);
	}

	if (str [0]  == 'w' &&
	    str [1]  == 'v' &&
	    str [2]  == 'p' &&
	    str [3]  == 'k' &&
	    
	    str [34] == 'R' &&
	    str [35] == 'I' &&
	    str [36] == 'F' &&
	    str [37] == 'F') return (TRUE);

	PRINT_FUNC_LF();
	g_print ("\tNO WAVPACK FILE: %s\n", namefile);

	return (FALSE);
}

/*
*---------------------------------------------------------------------------
* GET HEADER
*---------------------------------------------------------------------------
*/

/*
void infosong_id3_readtag_wavpack (gchar *namefile)
{
	FILE          *fp = NULL;
	gchar         *buf = NULL;
	gint           ind = 0;
	TAGS_WAVPACK   tw;

	buf = (gchar *)g_malloc0 (sizeof (gchar) * 1500);
	if (buf == NULL) {
		return;
	}
	g_print ("OUVERTURE DE: %s\n", namefile);
	fp = fopen (namefile, "rb");
	if (!fp) return;

	fseek (fp, 0, SEEK_END);
	fseek (fp, ftell( fp ) - 1000, SEEK_SET);
	fread (buf, 1, 1000, fp);
	fclose (fp);
	g_print ("FERMETURE DE: %s\n", namefile);

	ind = 0;
	while (ind < 1000) {
		if (buf [ ind+0 ] == 'A' &&
		    buf [ ind+1 ] == 'P' &&
		    buf [ ind+2 ] == 'E' &&
		    buf [ ind+3 ] == 'T' &&
		    buf [ ind+4 ] == 'A' &&
		    buf [ ind+5 ] == 'G' &&
		    buf [ ind+6 ] == 'E' &&
		    buf [ ind+7 ] == 'X') {

		    	g_print ("TAGS WAVPACK TROUVES\n");
			g_memmove (&tw,  &buf [ ind+12 ], 128);
			ind = -1;
			break;
		}
		ind ++;
	}
	if (ind > -1) {
		g_print ("PAS DE TAGS WAVPACK\n");
		g_free (buf);
		buf = NULL;
		return;
	}

	g_print ("tw.id [ 3 ]          = %s\n", tw.id);
	g_print ("tw.title [ 30 ]      = %s\n", tw.title);
	g_print ("tw.interprete [ 30 ] = %s\n", tw.interprete);
	g_print ("tw.album [ 30 ]      = %s\n", tw.album);
	g_print ("tw.annee [ 4 ]       = %s\n", tw.annee);
	g_print ("tw.comment [ 30 ]    = %s\n", tw.comment);
	g_print ("tw.genre [ 1 ]       = %s\n", tw.genre);

	g_free (buf);
	buf = NULL;
}
*/

INFO_WAVPACK *tagswavpack_remove_info (INFO_WAVPACK *info)
{
	if (info) {
		g_free (info->namefile);
		g_free (info->time);
		g_free (info->size);

		info->tags = (TAGS *)tags_remove (info->tags);

		g_free (info);
		info = NULL;
	}
	return ((INFO_WAVPACK *)NULL);
}

INFO_WAVPACK *tagswavpack_get_info (DETAIL *detail, gchar *namefile)
{
	INFO_WAVPACK	*ptrinfo = NULL;
	SHNTAG		*ShnTag = get_with_shntool (namefile);

	ptrinfo = (INFO_WAVPACK *)g_malloc0 (sizeof (INFO_WAVPACK));
	if (ptrinfo == NULL) return (NULL);
	ptrinfo->tags = (TAGS *)tags_alloc (FALSE);

	ptrinfo->namefile = g_strdup (namefile);
	
	ptrinfo->SecTime  = ShnTag->SecTime;
	ptrinfo->time     = g_strdup (ShnTag->time);
	ptrinfo->size     = g_strdup (ShnTag->size);

	if (detail != NULL) {
		detail->ValuePlay.SecTime = ptrinfo->SecTime;
	}
	
	ptrinfo->ValueMark.SecTime    = ptrinfo->SecTime;
	ptrinfo->ValueMark.ValueMarkA = 0.0;
	ptrinfo->ValueMark.ValueMarkB = 100.0;
	ptrinfo->ValueMark.Value = 0.0;
	
	/*infosong_id3_readtag_wavpack (namefile);*/

	ShnTag = get_free_shntool (ShnTag);
	
	return (ptrinfo);
}
