 /*
 * file    : tags_rm.c
 * project : xcfa
 * with    : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#include <gtk/gtk.h>
#include <glib/gstdio.h>

#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "file.h"
#include "tags.h"
#include <taglib/tag_c.h>
#include "get.h"



/*
*---------------------------------------------------------------------------
* FILE IS RM ?
*---------------------------------------------------------------------------
*/


/*
$ file *.rm
	audio01.rm:   RealMedia file
	audio02.rm:   RealMedia file

	en tête fichier RM
	--- DEC ---   --- HEX ---
	[ 00 01 02 03 ] 2e 52 4d 46 = .RMF
	[ 18 19 20 21 ] 50 52 4f 50  = PROP
*/
gboolean tagsrm_file_is_rm (gchar *namefile)
{
	FILE        *fp = NULL;
	size_t       lenread = 0;
	gchar       *buf = NULL;
	gboolean     bool_signature = FALSE;
	
	/*PRINT_FUNC_LF();*/

	buf = (gchar *)g_malloc0 (sizeof(gchar) * 512);
	if ((fp = fopen (namefile, "rb")) != NULL) {
		lenread = fread (buf, 1, 500, fp);
		fclose (fp);
	
		if (buf [  0 ] == 0x2e &&	// .
		    buf [  1 ] == 0x52 &&	// R
		    buf [  2 ] == 0x4d &&	// M
		    buf [  3 ] == 0x46 &&	// F
		    
		    buf [ 18 ] == 0x50 &&	// P
		    buf [ 19 ] == 0x52 &&	// R
		    buf [ 20 ] == 0x4f &&	// O
		    buf [ 21 ] == 0x50)	{	// P
		    
			bool_signature = TRUE;
		}
	}

	g_free (buf);
	buf = NULL;
	
	return (bool_signature);
}

/*
*---------------------------------------------------------------------------
* REMOVE HEADER
*---------------------------------------------------------------------------
*/
INFO_RM *tagsrm_remove_info (INFO_RM *info)
{
	if (info) {
		g_free (info->namefile);

		info->tags = (TAGS *)tags_remove (info->tags);

		g_free (info);
		info = NULL;
	}
	return ((INFO_RM *)NULL);
}

/*
*---------------------------------------------------------------------------
* GET HEADER
*---------------------------------------------------------------------------
*/
INFO_RM *tagsrm_get_info (gchar *namefile)
{
	INFO_RM     *ptrinfo = NULL;

	ptrinfo = (INFO_RM *)g_malloc0 (sizeof (INFO_RM));
	if (ptrinfo == NULL) return (NULL);

	ptrinfo->namefile = g_strdup (namefile);

	ptrinfo->tags = (TAGS *)tags_alloc (FALSE);
	tags_set (namefile, ptrinfo->tags);

	return ((INFO_RM *)ptrinfo);
}









