 /*
 * file      : prg_install.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

 /*
http://download.tuxfamily.org/ubunteros/pour_claude/Slack/
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "prg_install.h"
#include "utils.h"
#include "options.h"
#include "web.h"




void prginstall_set_label_type_package (GtkWidget *widget)
{
	gchar *New_Str = NULL;
	
	var_options.Adr_label_type_paquege = widget;
	
	if (utils_scan_by_which ("apt-get", NULL) == TRUE || utils_scan_by_which ("aptitude", NULL) == TRUE) {
		if (widget != NULL) {
			New_Str = g_strdup_printf (_(" <b>... les paquets: deb</b> "));
		}
		var_options.Type_Package = _DEBIAN_;
	}
	else if (utils_scan_by_which ("slackpkg", NULL) == TRUE || utils_scan_by_which ("installpkg", NULL) == TRUE) {
		if (widget != NULL) {
			New_Str = g_strdup_printf (_(" <b>... les paquets: tgz</b> "));
		}
		var_options.Type_Package = _TGZ_;
	}
	else if (utils_scan_by_which ("pacman-g2", NULL) == TRUE) {
		if (widget != NULL) {
			New_Str = g_strdup_printf (_(" <b>... les paquets: fpm</b> "));
		}
		var_options.Type_Package = _FPM_;
	}
	else if (utils_scan_by_which ("rpm", NULL) == TRUE || utils_scan_by_which ("urpmi", NULL) == TRUE  || utils_scan_by_which ("zypper", NULL) == TRUE || utils_scan_by_which ("yum", NULL) == TRUE) {
		if (widget != NULL) {
			New_Str = g_strdup_printf (_(" <b>... les paquets: rpm</b> "));
		}
		var_options.Type_Package = _RPM_;
	}
	
	if (widget != NULL && New_Str != NULL) {
		gtk_label_set_markup (GTK_LABEL (var_options.Adr_label_type_paquege), New_Str);
		// gtk_label_set_markup (GTK_LABEL (GTK_WIDGET (XCFA_GET_OBJECT("label_type_package_without_deb"))), New_Str);
		g_free (New_Str);
		New_Str = NULL;
	}
}


void on_linkbutton_xcfa_install_all_clicked (GtkLinkButton *link_button, gpointer user_data)
{
	// web_goto_xcfa_page ("http://download.tuxfamily.org/xcfaudio/PlusPlus/");
	g_print("%s\n", gtk_link_button_get_uri (link_button));
	web_goto_xcfa_page ((gchar *)gtk_link_button_get_uri (link_button));
}









