 /*
 * file      : options_oggenc.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */


#include <gtk/gtk.h>

#include <string.h>
#include "global.h"
#include "config_user.h"
#include "cd_audio.h"
#include "utils.h"
#include "options.h"
#include <stdlib.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "info_song.h"

/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/*
*---------------------------------------------------------------------------
* CODE
*---------------------------------------------------------------------------
*/
/* Recupere et renvoie la chaine de parametres
*  --
*  entree : -
*  retour :
*/
gchar *optionsOggenc_get_val_bitrate_oggenc (void)
{
	gchar *val[] = {
	"--bitrate=45",
	"--bitrate=64",
	"--bitrate=80",
	"--bitrate=96",
	"--bitrate=112",
	"--bitrate=128",
	"--bitrate=160",
	"--bitrate=192",
	"--bitrate=224",
	"--bitrate=256",
	"--bitrate=320",
	"--quality=-1",
	"--quality=0",
	"--quality=1",
	"--quality=2",
	"--quality=3",
	"--quality=4",
	"--quality=5",
	"--quality=6",
	"--quality=7",
	"--quality=8",
	"--quality=9",
	"--quality=10"
	};

	return (val[ gtk_combo_box_get_active (var_options.Adr_Widget_Oggenc_bitrate) ]);
}
/* Construction du combobox 'Oggenc'
*  --
*  entree :
*      GtkWidget *widget : Adresse du combobox
*  retour : -
*/
void optionsOggenc_make_combobox_oggenc (GtkWidget *widget)
{
	/* PRINT_FUNC_LF(); */
	var_options.Adr_Widget_Oggenc_bitrate = GTK_COMBO_BOX (widget);
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));

	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 45  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 64  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 80  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), " 96  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "112  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "128  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "160  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "192  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "224  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "256  kbit/s");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "320  kbit/s");

	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite -1   (Moins bonne qualite)"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  0"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  1"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  2"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  3"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  4"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  5"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  6"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  7"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  8"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  9"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Qualite  10  (Meilleure qualite)"));

	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.RateMp3OggOptions.Bitrate_Oggenc);
}

void optionsOggenc_combobox_oggenc_bitrate_changed (void)
{
	/* PRINT_FUNC_LF(); */

	if (var_options.Adr_Widget_Oggenc_bitrate == NULL) return;

	/* Managed ne peut etre selectionne que avec le parametre '--bitrate='
	*/
	gtk_widget_set_sensitive (
		GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_oggenc_managed")),
		gtk_combo_box_get_active (var_options.Adr_Widget_Oggenc_bitrate) < 11 ? TRUE : FALSE);

	gtk_widget_set_sensitive (
		GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_oggenc_downmix")),
		gtk_combo_box_get_active (var_options.Adr_Widget_Oggenc_bitrate) < 9 ? TRUE : FALSE);

	if (var_options.Adr_label_oggenc_ogg == NULL) return;
	options_set_datas_interne (COLOR_OGGENC_DEBIT, var_options.Adr_label_oggenc_ogg, OGGENC_WAV_TO_OGG);
}

/* Si OUI retourne TRUE sinon FALSE
*/
gboolean optionsOggenc_get_bool_managed_oggenc (void)
{
	if (GTK_WIDGET_IS_SENSITIVE(GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_oggenc_managed"))) == TRUE) {
		if (gtk_combo_box_get_active (var_options.Adr_Widget_Oggenc_managed) == 0) return (TRUE);
	}
	return (FALSE);
}
void optionsOggenc_combobox_oggenc_managed_realize (GtkWidget *widget)
{
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Oui"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Non"));

	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.RateMp3OggOptions.Managed_Oggenc);

	var_options.Adr_Widget_Oggenc_managed = GTK_COMBO_BOX (widget);
}
void optionsOggenc_combobox_oggenc_managed_changed (void)
{
	options_set_datas_interne (COLOR_OGGENC_MANAGED, var_options.Adr_label_oggenc_ogg, OGGENC_WAV_TO_OGG);
}

/* Si OUI retourne TRUE sinon FALSE
*/
gboolean optionsOggenc_get_bool_downmix_oggenc (void)
{
	if (GTK_WIDGET_IS_SENSITIVE(GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_oggenc_downmix"))) == TRUE) {
		if (gtk_combo_box_get_active (var_options.Adr_Widget_Oggenc_downmix) == 0) return (TRUE);
	}
	/*
	if (gtk_combo_box_get_active (var_options.Adr_Widget_Oggenc_downmix) == 0) return (TRUE);
	*/
	return (FALSE);
}
void optionsOggenc_combobox_oggenc_downmix_realize (GtkWidget *widget)
{
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Mono force"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Stereo"));

	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.RateMp3OggOptions.Downmix_Oggenc);

	var_options.Adr_Widget_Oggenc_downmix = GTK_COMBO_BOX (widget);
}
void optionsOggenc_combobox_oggenc_downmix_changed (void)
{
	options_set_datas_interne (COLOR_OGGENC_DOWNMIX, var_options.Adr_label_oggenc_ogg, OGGENC_WAV_TO_OGG);
}


