 /*
 * file      : options_lame.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include <glib.h>
#include <glib/gstdio.h>

#include "global.h"
#include "config_user.h"
#include "cd_audio.h"
#include "utils.h"
#include "options.h"
#include "info_song.h"
#include "conv.h"



/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/*
*---------------------------------------------------------------------------
* CODE
*---------------------------------------------------------------------------
*/

/*
	[ABR ou CBR ou VBR]

	SI ABR
		Choix:
		[
		bitrate 32
		bitrate 40
		bitrate 48
		bitrate 56
		bitrate 64
		bitrate 80
		bitrate 96
		bitrate 112
		bitrate 128
		bitrate 160
		bitrate 192
		bitrate 224
		bitrate 256
		bitrate 320
		]
		Choix: [mode]

	SI CBR
		Choix:
		[
		bitrate 32
		bitrate 40
		bitrate 48
		bitrate 56
		bitrate 64
		bitrate 80
		bitrate 96
		bitrate 112
		bitrate 128
		bitrate 160
		bitrate 192
		bitrate 224
		bitrate 256
		bitrate 320
		preset insane
		]
		Choix: [mode]

	SI VBR
		Choix:
		[
		preset medium
		preset standard
		preset extreme
		preset fast standard
		preset fast extreme
		V0 .. V9
		]
		Choix: [mode]

	SI VBR_NEW
		Choix:
		[
		preset medium
		preset standard
		preset extreme
		preset fast standard
		preset fast extreme
		V0 .. V9
		]
		Choix: [mode]
*/


void optionsLame_combobox_lame_abr_cbr_vbr_realize (GtkWidget *widget)
{
	var_options.Adr_Widget_Lame_abr_cbr_vbr = GTK_COMBO_BOX (widget);
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "ABR");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "CBR");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "VBR");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "VBR-NEW");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.RateMp3OggOptions.Bitrate_type_Lame);
}
void optionsLame_combobox_lame_abr_cbr_vbr_changed (void)
{
	if (var_options.Adr_Widget_Lame_abr_cbr_vbr == NULL || var_options.Adr_Widget_Lame_bitrate == NULL) return;

	var_options.bool_changed = FALSE;
	// utils_clear_elements_combobox (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate));
	utils_alloc_combo (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate));
	
	Config_User.RateMp3OggOptions.Bitrate_type_Lame = gtk_combo_box_get_active (var_options.Adr_Widget_Lame_abr_cbr_vbr);

	switch (Config_User.RateMp3OggOptions.Bitrate_type_Lame) {
	
	/* ABR 0 .. 13 */
	case 0 :
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 32");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 40");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 48");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 56");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 64");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 80");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 96");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "112");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "128");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "160");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "192");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "224");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "256");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "320");
		
		var_options.bool_changed = TRUE;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), Config_User.RateMp3OggOptions.If_abr);
		break;
	
	/* CBR 0 .. 14 */
	case 1 :
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 32");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 40");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 48");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 56");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 64");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 80");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), " 96");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "112");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "128");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "160");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "192");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "224");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "256");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "320");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "preset insane");
		
		var_options.bool_changed = TRUE;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), Config_User.RateMp3OggOptions.If_cbr);
		break;
	
	/* VBR 0 .. 14 */
	case 2 :
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "preset medium");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "preset standard");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "preset extreme");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "preset fast standard");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "preset fast extreme");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), _("V0     (meilleure qualite)"));
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V1");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V2");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V3");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V4");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V5");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V6");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V7");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V8");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), _("V9     (moins bonne qualite)"));
		
		var_options.bool_changed = TRUE;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), Config_User.RateMp3OggOptions.If_vbr);
		break;
	
	/* VBR_NEW 0 .. 14 */
	case 3 :
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "preset medium");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "preset standard");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "preset extreme");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "preset fast standard");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "preset fast extreme");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V0");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V1");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V2");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V3");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V4");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V5");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V6");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V7");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V8");
		gtk_combo_box_append_text (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), "V9");
		
		var_options.bool_changed = TRUE;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_options.Adr_Widget_Lame_bitrate), Config_User.RateMp3OggOptions.If_vbr_new);
		break;
	}
}
void optionsLame_combobox_lame_type_bitrate_realize (GtkWidget *widget)
{
	var_options.Adr_Widget_Lame_bitrate = GTK_COMBO_BOX (widget);
	optionsLame_combobox_lame_abr_cbr_vbr_changed ();
}
void optionsLame_combobox_lame_type_bitrate_changed (void)
{
	/* Recuperation des valeurs
	*/
	if (var_options.Adr_Widget_Lame_bitrate == NULL) return;	
	if (var_options.bool_changed == FALSE) return;

	switch (gtk_combo_box_get_active (var_options.Adr_Widget_Lame_abr_cbr_vbr)) {
	
	/* ABR */
	case 0 :
		Config_User.RateMp3OggOptions.If_abr = gtk_combo_box_get_active (var_options.Adr_Widget_Lame_bitrate);
		break;
	
	/* CBR */
	case 1 :
		Config_User.RateMp3OggOptions.If_cbr = gtk_combo_box_get_active (var_options.Adr_Widget_Lame_bitrate);
		break;
	
	/* VBR */
	case 2 :
		Config_User.RateMp3OggOptions.If_vbr = gtk_combo_box_get_active (var_options.Adr_Widget_Lame_bitrate);
		break;
	
	/* VBR_NEW */
	case 3 :
		Config_User.RateMp3OggOptions.If_vbr_new = gtk_combo_box_get_active (var_options.Adr_Widget_Lame_bitrate);
		break;
	}
	options_set_datas_interne (COLOR_LAME_DEBIT, var_options.Adr_label_lame_mp3, LAME_WAV_TO_MP3);
}




void optionsLame_make_combobox_lame_mode_realize (GtkWidget *widget)
{
	/*
	-m mode [s, j, f, d, m]
	(s)tereo
	(j)oint stereo
	(f)orced joint stereo
	(d)ual channels
	(m)ono
	*/

	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));

	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Defaut");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Stereo");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Join Stereo");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Forced Join Stereo");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Duo Channels");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Mono");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.RateMp3OggOptions.Mode_Lame);
	var_options.Adr_Widget_Lame_Mode = GTK_COMBO_BOX (widget);
}

/* Recupere et renvoie le bitrate correspondant au numero actif dans le combobox 'Lame'
*  --
*  entree : -
*  retour :
*      gint : Bitrate
*/
/*
gint options_get_val_bitrate_lame (void)
{
	gint Num[] = {32,40,48,56,64,80,96,112,128,160,192,224,256,320};
	return (Num[ gtk_combo_box_get_active (var_options.Adr_Widget_Lame_bitrate) ]);
}
*/
/*
	[ABR ou CBR ou VBR]

	SI ABR
		Choix:
		[
		bitrate 32
		bitrate 40
		bitrate 48
		bitrate 56
		bitrate 64
		bitrate 80
		bitrate 96
		bitrate 112
		bitrate 128
		bitrate 160
		bitrate 192
		bitrate 224
		bitrate 256
		bitrate 320
		]
		Choix: [mode]

	SI CBR
		Choix:
		[
		bitrate 32
		bitrate 40
		bitrate 48
		bitrate 56
		bitrate 64
		bitrate 80
		bitrate 96
		bitrate 112
		bitrate 128
		bitrate 160
		bitrate 192
		bitrate 224
		bitrate 256
		bitrate 320
		preset insane
		]
		Choix: [mode]

	SI VBR
		Choix:
		[
		preset medium
		preset standard
		preset extreme
		preset fast standard
		preset fast extreme
		V0 .. V9
		]
		Choix: [mode]

	SI VBR_NEW
		Choix:
		[
		preset medium
		preset standard
		preset extreme
		preset fast standard
		preset fast extreme
		V0 .. V9
		]
		Choix: [mode]
*/
gchar *optionsLame_get_str_val_bitrate_abr_vbr_lame (void)
{
	static gchar StrLame[ 100 ];
	
	gchar *str_abr [] = {
	"-b 32",
	"-b 40",
	"-b 48",
	"-b 56",
	"-b 64",
	"-b 80",
	"-b 96",
	"-b 112",
	"-b 128",
	"-b 160",
	"-b 192",
	"-b 224",
	"-b 256",
	"-b 320"
	};
	gchar *str_cbr [] = {
	"-b 32",
	"-b 40",
	"-b 48",
	"-b 56",
	"-b 64",
	"-b 80",
	"-b 96",
	"-b 112",
	"-b 128",
	"-b 160",
	"-b 192",
	"-b 224",
	"-b 256",
	"-b 320",
	"--preset insane"
	};
	gchar *str_vbr [] = {
	"--preset medium",
	"--preset standard",
	"--preset extreme",
	"--preset fast standard",
	"--preset fast extreme",
	"-V0",
	"-V1",
	"-V2",
	"-V3",
	"-V4",
	"-V5",
	"-V6",
	"-V7",
	"-V8",
	"-V9"
	};
	gchar *str_vbr_new [] = {
	"--vbr-new",
	"--vbr-new --preset medium",
	"--vbr-new --preset standard",
	"--vbr-new --preset extreme",
	"--vbr-new --preset fast standard",
	"--vbr-new --preset fast extreme",
	"--vbr-new -V0",
	"--vbr-new -V1",
	"--vbr-new -V2",
	"--vbr-new -V3",
	"--vbr-new -V4",
	"--vbr-new -V5",
	"--vbr-new -V6",
	"--vbr-new -V7",
	"--vbr-new -V8",
	"--vbr-new -V9"
	};
	gchar *ptr = NULL;

	strcpy (StrLame, "");
	
	if (var_options.Adr_Widget_Lame_bitrate == NULL || var_options.Adr_Widget_Lame_abr_cbr_vbr == NULL) return ((gchar *)ptr);

	switch (gtk_combo_box_get_active (var_options.Adr_Widget_Lame_abr_cbr_vbr)) {
	
	/* ABR */
	case 0 :
		Config_User.RateMp3OggOptions.If_abr = gtk_combo_box_get_active (var_options.Adr_Widget_Lame_bitrate);
		ptr = (gchar *)str_abr [ Config_User.RateMp3OggOptions.If_abr ];
		break;
	
	/* CBR */
	case 1 :
		Config_User.RateMp3OggOptions.If_cbr = gtk_combo_box_get_active (var_options.Adr_Widget_Lame_bitrate);
		ptr = (gchar *)str_cbr [ Config_User.RateMp3OggOptions.If_cbr ];
		break;
	
	/* VBR */
	case 2 :
		Config_User.RateMp3OggOptions.If_vbr = gtk_combo_box_get_active (var_options.Adr_Widget_Lame_bitrate);
		ptr = (gchar *)str_vbr [ Config_User.RateMp3OggOptions.If_vbr ];
		break;
		
	/* VBR_NEW */
	case 3 :
		Config_User.RateMp3OggOptions.If_vbr_new = gtk_combo_box_get_active (var_options.Adr_Widget_Lame_bitrate);
		ptr = (gchar *)str_vbr_new [ Config_User.RateMp3OggOptions.If_vbr_new ];
		break;
	default :
		return ((gchar *)StrLame);
	}
	strcat (StrLame, (gchar *)ptr);
	return ((gchar *)StrLame);
}

gchar *optionsLame_get_str_val_mode_lame (void)
{
	static gchar StrLame[ 100 ];
	
	gchar *str_val_mode[] = {
	"",	/* Defaut		*/
	"-m s",	/* Stereo		*/
	"-m j",	/* Join Stereo		*/
	"-m f",	/* Forced Join Stereo	*/
	"-m d",	/* Duo Channels		*/
	"-m m"	/* Mono			*/
	};
	strcpy (StrLame, "");
	
	if (!var_options.Adr_Widget_Lame_Mode) return ( (gchar *)str_val_mode[ 0 ]);

	strcpy (StrLame, str_val_mode[ gtk_combo_box_get_active (var_options.Adr_Widget_Lame_Mode) ]);
	return ((gchar *)StrLame);
}

void optionsLame_combobox_lame_mode_changed (void)
{
	options_set_datas_interne (COLOR_LAME_MODE, var_options.Adr_label_lame_mp3, LAME_WAV_TO_MP3);
}


