 /*
 * file      : mplayer.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <pthread.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "info_song.h"
#include "win_play.h"
#include "split.h"
#include "options.h"
#include "dvd_audio.h"
#include "mplayer.h"


/*
*---------------------------------------------------------------------------
* DEFINE and STRUCT and VAR
*---------------------------------------------------------------------------
*/
#define XCFA_TMP_FIFO	"/tmp/XcfaCmdToMplayer"

VAR_MPLAYER VarMplayer;



/*
*---------------------------------------------------------------------------
* EXTERNAL REF
*---------------------------------------------------------------------------
*/
extern int kill(pid_t pid, int sig);

/*
*---------------------------------------------------------------------------
* SIGNAL ET EXECUTE EXTERNAL
*---------------------------------------------------------------------------
*/
void mplayer_sigchld (gint signum)
{
	gint status;
       
        wait(&status);

	VarMplayer.SignalNumchildren --;
        if (VarMplayer.SignalNumchildren > 0)
        {
                /* re-install the signal handler */
                signal (SIGCHLD, mplayer_sigchld);
        }
}
int mplayer_call_exec (MPLAYER_ARGS *args, pid_t *p, gint p_output)
{
	gchar **ptr = (gchar **)args;

	VarMplayer.SignalNumchildren = 0;
	if (pipe (VarMplayer.Tube) != 0)
	{
		fprintf (stderr, "error: pipe\n");
		exit (1);
	}
	if ((*p = fork()) == 0)
	{
		dup2 (VarMplayer.Tube [ 1 ], p_output);
		close (VarMplayer.Tube [ 1 ]);
		execvp ((gchar *)*(ptr+0), ptr);
		fprintf (stderr, "error: exec");
		exit (2);
	}
	VarMplayer.SignalNumchildren ++;
	signal (SIGCHLD, mplayer_sigchld);
	close (VarMplayer.Tube [ 1 ]);
	return (VarMplayer.Tube [ 0 ]);
}

/*
*---------------------------------------------------------------------------
* FIFO CREATE and REMOVE
*---------------------------------------------------------------------------
*/
void mplayer_remove_list_args (void)
{
	gint	 PosArg = 0;

	if (VarMplayer.PlayerArgs != NULL) {
		for (PosArg = 0; VarMplayer.PlayerArgs[ PosArg ].str != NULL; PosArg ++) {
			g_free (VarMplayer.PlayerArgs[ PosArg ].str);
			VarMplayer.PlayerArgs[ PosArg ].str = NULL;
		}
		g_free (VarMplayer.PlayerArgs);
		VarMplayer.PlayerArgs = NULL;
	}
}
void mplayer_create_fifo (void)
{
	gchar *args[ 10 ];
	gint   pos = 0;
	gint   status;
	pid_t  NumFork;		

	if (infosong_access_mode (AM_FILE_EXIST, XCFA_TMP_FIFO, NULL) == TRUE) return;

	args [ pos++ ] = "mkfifo";
	args [ pos++ ] = XCFA_TMP_FIFO;
	args [ pos++ ] = NULL;
	args [ pos++ ] = NULL;
	/*
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/
	if ((NumFork = fork ()) == 0) {
		execvp (args[0], args);
		exit (2);
	}

	waitpid (NumFork, &status, WUNTRACED);
}
void mplayer_remove_fifo (void)
{
	gchar *args[ 10 ];
	gint   pos = 0;
	gint   status;
	pid_t  NumFork;		

	if (infosong_access_mode (AM_FILE_EXIST, XCFA_TMP_FIFO, NULL) == FALSE) return;

	args [ pos++ ] = "rm";
	args [ pos++ ] = "-rf";
	args [ pos++ ] = XCFA_TMP_FIFO;
	args [ pos++ ] = NULL;
	args [ pos++ ] = NULL;
	/*
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/
	if ((NumFork = fork ()) == 0) {
		execvp (args[0], args);
		exit (2);
	}

	waitpid (NumFork, &status, WUNTRACED);
	
	mplayer_remove_list_args ();
}

/*
*---------------------------------------------------------------------------
* FIFO COMMAND
*---------------------------------------------------------------------------
*/
void mplayer_set_fifo (gchar *str)
{
	if (VarMplayer.BoolErreurMplayer == TRUE) return;
	if (VarMplayer.BoolThreadActivate == FALSE) return;

	if (infosong_access_mode (AM_FILE_EXIST, XCFA_TMP_FIFO, NULL) == TRUE) {
		FILE *fp = NULL;
		if ((fp = fopen (XCFA_TMP_FIFO, "w")) != NULL) {
			fprintf (fp, "%s\n", str);
			fclose (fp);
		}
	}
}
void mplayer_fifo_quit (void)
{
	mplayer_set_fifo ("quit");
	VarMplayer.ListPlayFrom   = LIST_MPLAYER_FROM_NONE;
	VarMplayer.BoolPushButton = PUSH_BUTTON_MPLAYER_STOP;
	g_usleep (500000);
}
void mplayer_fifo_pause (void)
{
	VarMplayer.BoolPushButton = PUSH_BUTTON_MPLAYER_PAUSE;
	mplayer_set_fifo ("pause");
}
void mplayer_fifo_get_percent_pos (void)
{
	mplayer_set_fifo ("get_percent_pos");
}
void mplayer_fifo_get_time_pos (void)
{
	mplayer_set_fifo ("get_time_pos");
}
void mplayer_fifo_get_time_length (void)
{
	mplayer_set_fifo ("get_time_length");
}
void mplayer_fifo_seek (gdouble PercentValue)
{
	gchar *Str = NULL;
	guint sec;
	
	if (PercentValue < 0.0) PercentValue = 0.0;
	if (PercentValue > 100.0) PercentValue = 100.0;
	
	sec = (gint) ((VarMplayer.DOUBLE_TempsTotal * PercentValue) / 100.0);
	Str = g_strdup_printf ("seek %d 2", sec);
	mplayer_set_fifo (Str);
	g_free (Str);
	Str = NULL;
}
void mplayer_fifo_seek_with_hundr (gdouble PercentValue)
{
	gchar  *Mess = NULL;
	gint    sec;
	gdouble dsec;
	gint    hundr;
	
	if (PercentValue < 0.0) PercentValue = 0.0;
	if (PercentValue > 100.0) PercentValue = 100.0;
	
	sec = (gint) ((VarMplayer.DOUBLE_TempsTotal * PercentValue) / 100.0);
	dsec  = (VarMplayer.DOUBLE_TempsTotal * PercentValue) / 100.0;
	hundr = (dsec - (gdouble)sec) * 1000.0;
	if (hundr >= 1000) hundr = 999;
	Mess = g_strdup_printf ("seek %d.%d 2", sec, hundr);
	mplayer_set_fifo (Mess);
	g_free (Mess);
	Mess = NULL;
}
gboolean mplayer_is_activate (void)
{
	return (VarMplayer.BoolThreadActivate);
}

gboolean mplayer_is_activate_from_split (void)
{
	return (VarMplayer.ListPlayFrom == LIST_MPLAYER_FROM_SPLIT ? TRUE : FALSE);
}

/*
*---------------------------------------------------------------------------
* THREAD
*---------------------------------------------------------------------------
*/
static void mplayer_do_thread (void *arg)
{
#define MAX_BUF_MPLAYER 1024
	gint		 pos = 0;
	gint		 fd;
	gint		 size;
	gchar		 buf [ MAX_BUF_MPLAYER + 10 ];
	gchar		*Ptr = NULL;
	guint		 Sec;
	guint		 Hundr;
	gdouble		 SecondesTempsActuel = 0.0;
	gboolean         BoolEndRead = FALSE;
	
	PRINT("DEBUT THREAD");
	VarMplayer.BoolThreadActivate = TRUE;

	fd = mplayer_call_exec (VarMplayer.PlayerArgs, &VarMplayer.CodeFork, STDOUT_FILENO);

	do {
		if (fd < 0) {
			VarMplayer.BoolErreurMplayer = TRUE;
			break;
		}
		
		pos = -1;
		do {			
			pos++;
			if (pos >= MAX_BUF_MPLAYER) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= CONV_MAX_CARS(%d)\n", pos, MAX_BUF_MPLAYER);
				pos --;
			}
			size = read (fd, &buf[pos], 1);
			
			if (strstr(buf,"Audio: no sound")) {
				VarMplayer.BoolErreurMplayer = TRUE;
				g_print("\tAudio: no sound\n");
				break;
			}
			if (strstr(buf,"Cannot sync MAD frame")) {
				VarMplayer.BoolErreurMplayer = TRUE;
				g_print("\tCannot sync MAD frame\n");
				break;
			}
		} while (VarMplayer.BoolThreadActivate == TRUE && (buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));

		if (VarMplayer.BoolErreurMplayer == TRUE) {
			break;
		}
		
		if (VarMplayer.ListPlayFrom == LIST_MPLAYER_FROM_CD) {
			if (strstr(buf,"A:") == NULL && VarMplayer.PercentTempsActuel > 0. && *buf == '\n') {
			}
			else if (strstr(buf,"A:")) {
			}
			else if (strstr(buf,"A:") == NULL) {
			}
		}

		// ANS_PERCENT_POSITION=8.0 (04:36.0)  0.8%
		//
		if ((Ptr = strstr(buf,"ANS_PERCENT_POSITION=")) != NULL) {
			if (VarMplayer.ListPlayFrom == LIST_MPLAYER_FROM_DVD) {
				while (*Ptr != '=') Ptr++;
				if (*Ptr == '=') Ptr++;
				if (atoi(Ptr) >= 99) {
					PRINT("FIN ET ARRET LECTURE DVD-AUDIO");
					BoolEndRead = TRUE;
					break;
				}
			}
		}

		// ANS_TIME_POSITION=0.0.0 (01:25.0) ??,?% 
		// ANS_TIME_POSITION=72.785.0 (01:25.0)  3.3% 
		if ((Ptr = strstr(buf,"ANS_TIME_POSITION=")) != NULL && strstr(buf,"??,?") == NULL) {
			while (*Ptr != '=') Ptr++;
			if (*Ptr == '=') Ptr++;
			Sec = atoi (Ptr);
			while (*Ptr != '.') Ptr++;
			if (*Ptr == '.') Ptr++;
			Hundr = atoi (Ptr);
			SecondesTempsActuel = (gdouble)Sec + ((gdouble)Hundr / 10.0);
			VarMplayer.PercentTempsActuel = (SecondesTempsActuel / VarMplayer.DOUBLE_TempsTotal) * 100.0;
						
			if (VarMplayer.BeginPercentTempsActuel == -1.) {
				VarMplayer.BeginPercentTempsActuel = VarMplayer.PercentTempsActuel;
			}
			
			if (VarMplayer.ListPlayFrom == LIST_MPLAYER_FROM_FILE) {
				if (VarMplayer.PercentTempsActuel >=  100.0) {
					VarMplayer.PercentTempsActuel = 0.0;
					BoolEndRead = TRUE;
					break;
				}
			}
			else if (VarMplayer.ListPlayFrom == LIST_MPLAYER_FROM_SPLIT) {
				if (VarMplayer.PercentTempsActuel >= VarMplayer.DOUBLE_TempsTotalSection || VarMplayer.PercentTempsActuel >=  99.855072) {
					VarMplayer.PercentTempsActuel = 100.0;
					BoolEndRead = TRUE;
					break;
				}
			}
			else if (VarMplayer.ListPlayFrom != LIST_MPLAYER_FROM_DVD) {
				if (VarMplayer.PercentTempsActuel >=  99.855072) {
					BoolEndRead = TRUE;
					break;
				}
			}
		}
		
		// ANS_LENGTH=85.00of 85.0 (01:25.0)  2.7% 
		// 
		else if ((Ptr = strstr(buf,"ANS_LENGTH=")) != NULL) {
			while (*Ptr != '=') Ptr++;
			if (*Ptr == '=') Ptr++;
			Sec = atoi (Ptr);
			while (*Ptr != '.') Ptr++;
			if (*Ptr == '.') Ptr++;
			Hundr = atoi (Ptr);
			VarMplayer.DOUBLE_TempsTotal = (gdouble)Sec;
			VarMplayer.GUINT_TempsTotal = (guint)VarMplayer.DOUBLE_TempsTotal;
		}
		
		if (buf[pos] != '\n') {
			pos ++;
			buf[pos++] = '\n';
			buf[pos] = '\0';
		}
	} while (VarMplayer.BoolThreadActivate == TRUE && (size > 0));

	close(fd);
	
	if (BoolEndRead == TRUE) {
		mplayer_set_fifo ("quit");
	}
	VarMplayer.PercentTempsActuel = 100.0;
	BoolEndRead = TRUE;
	
	VarMplayer.BoolThreadActivate = FALSE;
	PRINT("FIN THREAD");

	VarMplayer.Button = -1;
	
	if (VarMplayer.BoolErreurMplayer == TRUE) {
		g_print("\n");
		g_print("KILL Process mplayer = ");
		if ((kill (VarMplayer.CodeFork, SIGKILL) != 0))
			g_print ("ERREUR\n");
		else	g_print ("OK\n");
		g_print("\n");
	}

#undef MAX_BUF_MPLAYER

	pthread_exit (0);
}

/*
*---------------------------------------------------------------------------
* TIMEOUT
*---------------------------------------------------------------------------
*/
static gint mplayer_do_timeout (gpointer data)
{
	static gint cpt = -1;

	if (VarMplayer.Button == GDK_BUTTON_PRESS) return (TRUE);
	if (VarMplayer.BoolPushButton == PUSH_BUTTON_MPLAYER_PAUSE) return (TRUE);
	if (VarMplayer.Button != -1) return (TRUE);
	
	if (cpt ++ == 0) mplayer_fifo_get_percent_pos ();
	if (cpt >= 10) cpt = -1;

	switch (VarMplayer.ListPlayFrom) {
	case LIST_MPLAYER_FROM_NONE :
		break;
	
	case  LIST_MPLAYER_FROM_DVD :
		mplayer_fifo_get_time_pos ();
		WinPlay_set_value_time (VarMplayer.PercentTempsActuel);
		break;
		
	case  LIST_MPLAYER_FROM_CD :
		if (VarMplayer.DOUBLE_TempsTotal == 0.0) mplayer_fifo_get_time_length ();
		else 					mplayer_fifo_get_time_pos ();
		WinPlay_set_value_time (VarMplayer.PercentTempsActuel);
		break;
		
	case  LIST_MPLAYER_FROM_FILE :
		if (VarMplayer.DOUBLE_TempsTotal == 0.0) mplayer_fifo_get_time_length ();
		else 					mplayer_fifo_get_time_pos ();
		WinPlay_set_value_time (VarMplayer.PercentTempsActuel);
		break;
		
	case  LIST_MPLAYER_FROM_SPLIT :
		if (VarMplayer.DOUBLE_TempsTotal == 0.0) mplayer_fifo_get_time_length ();
		else 					mplayer_fifo_get_time_pos ();
		
		if (VarMplayer.DOUBLE_TempsTotal > 0. && VarMplayer.PercentTempsActuel > 0.) {
			split_with_mplayer (VarMplayer.PercentTempsActuel - VarMplayer.BeginPercentTempsActuel);
		}
		break;
	}
	
	if (VarMplayer.BoolThreadActivate == FALSE) {
		
		VarMplayer.BeginPercentTempsActuel = -1.;
		VarMplayer.DOUBLE_TempsTotal = 0.;
		
		mplayer_set_value_time (VarMplayer.PercentTempsActuel);

		gtk_timeout_remove (VarMplayer.HandlerTimeout);
		VarMplayer.BoolTimeoutActivate = FALSE;
		PRINT("FIN TIMEOUT");

		/* Widget de l'onglet dvd, cd ou fichiers sur ATTENTE */
		switch (VarMplayer.OLDListPlayFrom) {
		case LIST_MPLAYER_FROM_NONE :
			break;
		case LIST_MPLAYER_FROM_DVD :
			VarMplayer.PercentTempsActuel = 0.0;
			WinPlay_set_value_time (VarMplayer.PercentTempsActuel);
			dvdaudio_set_etat_music_pixbuf (NULL, FALSE);
			WinPlay_after_end ();
			break;
		case LIST_MPLAYER_FROM_CD :
			VarMplayer.PercentTempsActuel = 0.0;
			WinPlay_set_value_time (VarMplayer.PercentTempsActuel);
			cdaudio_set_etat_music_pixbuf_with_detail (NULL, CD_ETAT_PLAY_ATTENTE);
			WinPlay_after_end ();
			break;
		case LIST_MPLAYER_FROM_FILE :
			VarMplayer.PercentTempsActuel = 0.0;
			WinPlay_set_value_time (VarMplayer.PercentTempsActuel);
			file_set_etat_music_pixbuf_with_detail (NULL, FILE_ETAT_PLAY_ATTENTE);
			WinPlay_after_end ();
			break;
		case LIST_MPLAYER_FROM_SPLIT :
			VarMplayer.PercentTempsActuel = 0.0;
			split_with_mplayer (VarMplayer.PercentTempsActuel);
			file_set_etat_music_pixbuf_with_detail (NULL, FILE_ETAT_PLAY_ATTENTE);
			gtk_widget_show (GTK_WIDGET (VarSplit.AdrButtonPlay));
			gtk_widget_hide (GTK_WIDGET (VarSplit.AdrButtonStop));
			gtk_widget_set_sensitive (GTK_WIDGET (VarSplit.AdrButtonStop), FALSE);
			gtk_widget_set_sensitive (GTK_WIDGET (VarSplit.AdrButtonPlay), TRUE);
			break;
		}
		
		VarMplayer.OLDListPlayFrom = VarMplayer.ListPlayFrom;
	}
	return (TRUE);
}

/*
*---------------------------------------------------------------------------
* EXTERNAL CALL
*---------------------------------------------------------------------------
*/
void mplayer_set_list (LIST_MPLAYER_FROM ListPlayFrom, gdouble p_TempsTotalSection, guint p_TempsTotalSurface, GList *p_list)
{
#define MAX_ELEMENTS_ARGS  100
	gint	 PosArg = 0;
	GList	*list = NULL;
	gchar	*Ptr = NULL;
	
	// PRINT_FUNC_LF();
	
	// INIT VAR
	VarMplayer.DOUBLE_TempsTotalSection = p_TempsTotalSection;
	VarMplayer.BeginPercentTempsActuel = -1.0;

	// DETRUIT MPLAYER VIA LE FIFO
	mplayer_fifo_quit ();
	VarMplayer.BoolPushButton = PUSH_BUTTON_MPLAYER_PLAY;
	
	// CREATE CONTROLE FILE MPLAYER VIA FIFO
	mplayer_create_fifo ();
	
	// WAITING TO DESTROY
	while (VarMplayer.BoolThreadActivate == TRUE) {
		if ( VarMplayer . BoolThreadActivate == FALSE ) break;
	}
	
	// STOCKE LE TYPE D APPEL
	VarMplayer.OLDListPlayFrom =
	VarMplayer.ListPlayFrom = ListPlayFrom;

	// DESTRUIT L ANCIENNE LIST D ARGUMENTS
	mplayer_remove_list_args ();

	VarMplayer.PlayerArgs = (MPLAYER_ARGS *)g_malloc0(sizeof(MPLAYER_ARGS) * MAX_ELEMENTS_ARGS);
	PosArg = 0;
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("nice");
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("-n");
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup_printf ("%d", options_get_val_nice ());
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("mplayer");
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("-nojoystick");
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("-nolirc");
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("-nortc");
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("-noautosub");
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("-nomouseinput");
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("-slave");
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("-idle");
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("-cache");
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("8192");
	list = g_list_first (p_list);
	while (list) {
		if ((Ptr = (gchar *)list->data)) {
			switch (ListPlayFrom) {
			case LIST_MPLAYER_FROM_NONE :
				break;
			case LIST_MPLAYER_FROM_DVD :
			case LIST_MPLAYER_FROM_CD :
			case LIST_MPLAYER_FROM_FILE :
			case LIST_MPLAYER_FROM_SPLIT :
				VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup_printf ("%s", Ptr);
				break;
			}
		}
		list = g_list_next (list);
	}
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup ("-input");
	VarMplayer.PlayerArgs[ PosArg++ ].str = g_strdup_printf ("file=%s", XCFA_TMP_FIFO);
	VarMplayer.PlayerArgs[ PosArg++ ].str = NULL;
	VarMplayer.PlayerArgs[ PosArg++ ].str = NULL;
	
	// LISTE SUR STDOUT DES ARGUMENTS
	g_print("\n");
	g_print("!-----------------------------------------------------------!\n");
	g_print("! MPLAYER  Alloc memory: %d / %d\n", PosArg -2, MAX_ELEMENTS_ARGS);
	g_print("!-----------------------------------------------------------!\n");
	for (PosArg = 0; VarMplayer.PlayerArgs[ PosArg ].str != NULL; PosArg ++) {
		g_print ("VarMplayer.PlayerArgs[ %02d ] = %s\n", PosArg, VarMplayer.PlayerArgs[ PosArg ].str);
	}
	g_print("!-----------------------------------------------------------!\n! ");
	for (PosArg = 0; VarMplayer.PlayerArgs[ PosArg ].str != NULL; PosArg ++) {
		g_print ("%s ", VarMplayer.PlayerArgs[ PosArg ].str);
	}
	g_print("\n");
	g_print("!-----------------------------------------------------------!\n\n");

	if (VarMplayer.PercentTempsActuel < 0.0) VarMplayer.PercentTempsActuel = 0.0;
	VarMplayer.BoolErreurMplayer = FALSE;
	VarMplayer.Button = -1;
	VarMplayer.BoolPushButton = PUSH_BUTTON_MPLAYER_PLAY;

	// ACTIVATE THREAD
	if (VarMplayer.BoolThreadActivate == FALSE) {
		VarMplayer.BoolThreadActivate = TRUE;
		pthread_create (&VarMplayer.NmrTid, NULL ,(void *)mplayer_do_thread, (void *)NULL);
	}
	
	// ACTIVATE TIMEOUT
	if (VarMplayer.BoolTimeoutActivate == FALSE) {
		VarMplayer.BoolTimeoutActivate = TRUE;
		PRINT("DEBUT TIMEOUT");
		VarMplayer.HandlerTimeout = gtk_timeout_add (100, mplayer_do_timeout, 0);
	}

#undef MAX_ELEMENTS_ARGS
}



void mplayer_set_value_time (gdouble value)
{
	// gchar   *Mess = NULL;
	gint     sec   = 0;

	if (value < 0.0)   value = 0.0;
	if (value > 100.0) value = 100.0;
	
	sec = (gint) ((VarMplayer.DOUBLE_TempsTotal * value) / 100.0);
	
	if (sec < 0) sec = 0;
	
	// Mess = g_strdup_printf ("<b> %02d:%02d:%02d </b>", (sec/60)/60, (sec/60)%60, sec%60);
/*g_print("%s\n", Mess);*/
	
	
	if (VarLecture.AdrAdjustAllFile) {
		gtk_adjustment_set_value (GTK_ADJUSTMENT (VarLecture.AdrAdjustAllFile), value);
	}
	
	// g_free (Mess);
	// Mess = NULL;

}
gboolean mplayer_change_value_time (GtkRange *range, GtkScrollType scroll, gdouble value, gpointer user_data)
{
	if (VarMplayer.Button == GDK_BUTTON_RELEASE) {
		mplayer_fifo_seek_with_hundr (value);
		VarMplayer.PercentTempsActuel = value;
		VarMplayer.Button = -1;
	}
	mplayer_set_value_time (value);
	return FALSE;
}
gboolean mplayer_event_music (GtkWidget *treeview, GdkEvent *event, gpointer user_data)
{
	if (event->type == GDK_BUTTON_PRESS) {
		VarMplayer.Button = GDK_BUTTON_PRESS;
	}
	if (event->type == GDK_BUTTON_RELEASE) {
		VarMplayer.Button = GDK_BUTTON_RELEASE;
	}
	
	return (FALSE);
}

/* PLAYER ONGLET DVD
*/
void mplayer_button_stop_music_clicked (GtkButton *button)
{
	mplayer_fifo_quit ();
}









