 /*
 * file      : info_song.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gstdio.h>

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdlib.h>

#include <pthread.h>
#include <sys/wait.h>
#include <signal.h>
#include <sys/stat.h>

#include "utils.h"
#include "global.h"
#include "secu.h"
#include "win_info.h"
#include "info_song.h"
#include "get.h"
#include "config_user.h"

#include <taglib/tag_c.h>

extern int fileno (FILE *stream);





/*
gboolean OLDinfosong_create_dir (gchar *NameDir)
{
	if (infosong_file_is_dir (NameDir) == TRUE) {
		return (TRUE);
	}
	return (mkdir (NameDir, 0777) == 0 ? TRUE : FALSE);
}
*/
/* Modif a la demande de:
 * 	ptiloup
 *	http://defis-libristes.tuxfamily.org/viewtopic.php?pid=667#p667
 */
gboolean infosong_create_dir (gchar *NameDir)
{
	gchar	*LineCommand = NULL;
	gint	 Dummy;
	
	/* PRINT_FUNC_LF(); */
	if (infosong_file_is_dir (NameDir) == TRUE) {
		return (TRUE);
	}
	LineCommand = g_strdup_printf ("mkdir -p \"%s\"", NameDir);
	g_print ("CREATE REP:\n\t%s\n", NameDir);
	Dummy = system (LineCommand);
	g_free (LineCommand);
	LineCommand = NULL;
	
	return (TRUE);
}

/*******************************************************************
*  gchar *infosong_create_rep (gchar *path)
*-------------------------------------------------------------------
*  call   : new = infosong_create_rep ("tmp/xcfa/test")
*  action : path deviendra $HOME/tmp/xcfa/test
*           chaque repertoire sera tester et cree si besoin
*  return : HOME/tmp/xcfa/test
*******************************************************************/
gchar *infosong_create_rep (gchar *path)
{
	gchar *Newpath = NULL;
	gchar *name = NULL;
	gchar *ptr = NULL;
	gint   i;

	/*PRINT_FUNC_LF();*/

	Newpath = g_strdup_printf ("%s/%s", getenv ("HOME"), path);
	/*
	mkdir -p Newpath
	*/
	name = g_strnfill (strlen (Newpath) + 8, '\0');
	ptr = Newpath;
	while ((ptr = strchr (ptr+1, '/'))) {
		i = ptr - Newpath;
		strncpy (name, Newpath, i);
		*(name + i) = '\0';
		infosong_create_dir (name);
	}
	infosong_create_dir (Newpath);
	g_free (name);
	name = NULL;

	return (Newpath);
}
/*******************************************************************
*  gchar *infosong_remove_rep (gchar *path)
*-------------------------------------------------------------------
*  call   : ptr = $HOME/tmp/xcfa/test
*           ptr = infosong_remove_rep (ptr)
*  action : supprime le repertoire 'path' si il existe et
*           detruit l'allocation 'path'
*  return : NULL
*******************************************************************/
gchar *infosong_remove_rep (gchar *path)
{
	gchar *LineCommand = NULL;

	/* PRINT_FUNC_LF(); */

	if (path && *path && infosong_file_is_dir (path)) {
		/*
		ORIGINAL
		--------
		path = 
			/home/cat/DVD/En concert à l'Olympia/17 Comme "Ils Disent"
		DOIT ETRE
		---------
		path =
			"/home/cat/DVD/En concert à l'Olympia/17 Comme \"Ils Disent\""
		*/
		gchar   * Ptr = NULL;
		GString *cmd = NULL;
		gint	 Dummy;
		
		cmd = g_string_new (NULL);
		for (Ptr = path; *Ptr; Ptr ++) {
			if (*Ptr == '"') {
				g_string_append_printf (cmd, "\\\"");
			}
			else {
				g_string_append_printf (cmd, "%c", *Ptr);
			}
		}
		LineCommand = g_strdup_printf ("rm -rf \"%s\"", cmd->str);
		Dummy = system (LineCommand);
		g_free (LineCommand);
		LineCommand = NULL;
		g_string_free (cmd, TRUE);
	}
	g_free (path);
	path = NULL;
	return (NULL);
}

/* Si le DOSSIER existe:
*    Retourne TRUE Sinon FALSE
*/
gboolean infosong_file_is_dir (gchar *File)
{
	struct stat status;
	gint	    ret;

	/* PRINT_FUNC_LF(); */
	ret = stat (File, &status);
	return (ret > -1 && S_ISDIR (status.st_mode));
}

/* Si le FICHIER existe:
*    Retourne TRUE Sinon FALSE
*/
gboolean infosong_file_is_reg (gchar *File)
{
	struct stat status;
	gint	    ret;

	/* PRINT_FUNC_LF(); */
	ret = stat (File, &status);
	return (ret > -1 && S_ISREG (status.st_mode));
}
void infosong_delete_file (gchar *PathName)
{
	/* PRINT_FUNC_LF(); */
	if (PathName && *PathName && infosong_file_is_reg (PathName)) {
		unlink (PathName);
	}
}
size_t infosong_get_size_file (gchar *PathName)
{
	FILE   *fp;
	size_t  size = 0;

	if ((fp = fopen (PathName, "r"))) {
		fseek (fp, 0, SEEK_END);
		size = ftell (fp);
		fclose (fp);
	}
	return (size);
}

void infosong_rename_file (gchar *oldname, gchar *newname)
{
	gchar	*OldName = g_strdup_printf ("%s", oldname);
	gchar	*NewName = g_strdup_printf ("%s", newname);
	
	if (infosong_file_is_reg (OldName)) {
		pid_t  pid;
		gint   status;

		g_print("mv %s %s\n", OldName, NewName);
		
		if ((pid = fork ()) == 0) {
			execlp (
				"mv",
				"mv",
				OldName,
				NewName,
				NULL, NULL
				);
				exit (2);
		}
		waitpid (pid, &status, WUNTRACED);
	}
	else {
		g_print("NOT EXIST: OldName = %s\n", OldName);
	}
	// infosong_delete_file (OldName);
	PRINT("infosong_rename_file ()  = OK");
	g_free (OldName);
	OldName = NULL;
	g_free (NewName);
	NewName = NULL;
}

void infosong_copy_file (gchar *oldname, gchar *newname)
{
	if (infosong_file_is_reg (oldname)) {
		pid_t  pid;
		gint   status;

		if ((pid = fork ()) == 0) {
			execlp (
				"cp",
				"cp",
				"-f",
				oldname,
				newname,
				NULL, NULL
				);
				exit (2);
		}
		waitpid (pid, &status, WUNTRACED);
	}
}

/* Return a complet etat of file
*  --
*  entree :
*      RET_ACCESS_MODE Flag_Ret_Mode  :
*      const char *nom_fichier        :
*      ACCESS_MODE  *StructAccessMode :
*  retour :
*      FALSE :
*      TRUE  :
*
*  CALL:
*    gboolean Bool_Ret = infosong_access_mode (AM_FILE_EXIST, file, NULL);
*    if (Bool_Ret == TRUE)
*        -- Le fichier existe
*
*    infosong_access_mode (AM_NO_RET, file, &StructAccessMode);
*    if (StructAccessMode.FileExist == TRUE)
*        -- Le fichier existe
*
*  RETOUR:
*    Dans
*      StructAccessMode
*         FileExist;     F_OK     Le fichier existe t-il ?
*         ReadFileOk;    R_OK     Puis-je lire le contenu du fichier ?
*         WriteFileOk;   W_OK     Puis-ecrire dans le fichier ?
*         ExecFileOk;    X_OK     Puis-executer le fichier ?
*         FileIsReg;     S_ISREG  Est un fichier regulier
*         FileIsDir;     S_ISDIR  Est un repertoire
*         FileIsBlok;    S_ISBLK  Est un fichier peripherique blok
*         BoolManipFile  TRUE     Si proprietaire du fichier
*    OU
*      Bool_Ret
*        AM_FILE_EXIST            Le fichier existe
*        AM_FILE_READ             Lire le contenu du fichier
*        AM_FILE_WRITE            Ecrire dans le fichier
*        AM_FILE_EXEC             Executer le fichier
*        AM_FILE_IS_REG           Est un fichier regulier
*        AM_FILE_IS_DIR           Est un repertoire
*        AM_FILE_IS_BLOCK         Est un fichier peripherique blok
*        AM_FILE_IS_MIND          Le fichier m'appartient
*        AM_NO_RET
*/
gboolean  infosong_access_mode (RET_ACCESS_MODE Flag_Ret_Mode, const char *nom_fichier, ACCESS_MODE  *StructAccessMode)
{
	struct stat      status;
	gint	         ret;
	ACCESS_MODE      FileAccessMode;
	gboolean         Flag = FALSE;
	// struct tm	*tm;

	// PRINT_FUNC_LF();
	FileAccessMode.FileExist   = access (nom_fichier, F_OK) == -1 ? FALSE : TRUE;
	if (FileAccessMode.FileExist == TRUE) {
		
		// Si le fichier existe
		FileAccessMode.ReadFileOk    = access (nom_fichier, R_OK) == -1 ? FALSE : TRUE;
		FileAccessMode.WriteFileOk   = access (nom_fichier, W_OK) == -1 ? FALSE : TRUE;
		FileAccessMode.ExecFileOk    = access (nom_fichier, X_OK) == -1 ? FALSE : TRUE;

		ret = stat (nom_fichier, &status);
		FileAccessMode.FileIsReg     = (ret > -1 && S_ISREG (status.st_mode));
		FileAccessMode.FileIsDir     = (ret > -1 && S_ISDIR (status.st_mode));
		FileAccessMode.FileIsBlok    = (ret > -1 && S_ISBLK (status.st_mode));

		// getuid:        UID reel du processus en cours.
		// status.st_uid: UID du proprietaire du fichier
		FileAccessMode.BoolManipFile = (ret > -1 && status.st_uid == getuid ()) ? TRUE : FALSE;
		
		/*
		g_print("Heure dernier accès           status.st_atime = %lu    ", status.st_atime);
		tm = localtime (&status.st_atime);
		g_print ("%02d/%02d/%02d    %02d:%02d:%02d\n",
				tm->tm_mday, tm->tm_mon+1, tm->tm_year % 100,
				tm->tm_hour, tm->tm_min, tm->tm_sec
				);
		g_print("Heure dernière modification   status.st_mtime = %lu    ", status.st_mtime);
		tm = localtime (&status.st_mtime);
		g_print ("%02d/%02d/%02d    %02d:%02d:%02d\n",
				tm->tm_mday, tm->tm_mon+1, tm->tm_year % 100,
				tm->tm_hour, tm->tm_min, tm->tm_sec
				);
		g_print("Heure dernier changement état status.st_ctime = %lu    ", status.st_ctime);
		tm = localtime (&status.st_ctime);
		g_print ("%02d/%02d/%02d    %02d:%02d:%02d\n",
				tm->tm_mday, tm->tm_mon+1, tm->tm_year % 100,
				tm->tm_hour, tm->tm_min, tm->tm_sec
				);
		*/
	} else {
		// Si le fichier n'existe pas
		FileAccessMode.ReadFileOk    = FALSE;
		FileAccessMode.WriteFileOk   = FALSE;
		FileAccessMode.ExecFileOk    = FALSE;
		FileAccessMode.FileIsReg     = FALSE;
		FileAccessMode.FileIsDir     = FALSE;
		FileAccessMode.FileIsBlok    = FALSE;
		FileAccessMode.BoolManipFile = FALSE;
	}

	if (StructAccessMode != NULL) {

		StructAccessMode->FileExist     = FileAccessMode.FileExist;
		StructAccessMode->ReadFileOk    = FileAccessMode.ReadFileOk;
		StructAccessMode->WriteFileOk   = FileAccessMode.WriteFileOk;
		StructAccessMode->ExecFileOk    = FileAccessMode.ExecFileOk;
		StructAccessMode->FileIsReg     = FileAccessMode.FileIsReg;
		StructAccessMode->FileIsDir     = FileAccessMode.FileIsDir;
		StructAccessMode->FileIsBlok 	= FileAccessMode.FileIsBlok;
		StructAccessMode->BoolManipFile = FileAccessMode.BoolManipFile;
	}
	/*
	g_print ("DEBUG infosong_access_mode ()\n");
	g_print ("FileAccessMode.FileExist = %s\n", FileAccessMode.FileExist ? "TRUE" : "FALSE");
	g_print ("FileAccessMode.ReadFileOk = %s\n", FileAccessMode.ReadFileOk ? "TRUE" : "FALSE");
	g_print ("FileAccessMode.WriteFileOk = %s\n", FileAccessMode.WriteFileOk ? "TRUE" : "FALSE");
	g_print ("FileAccessMode.ExecFileOk = %s\n", FileAccessMode.ExecFileOk ? "TRUE" : "FALSE");
	g_print ("FileAccessMode.FileIsReg = %s\n", FileAccessMode.FileIsReg ? "TRUE" : "FALSE");
	g_print ("FileAccessMode.FileIsDir = %s\n", FileAccessMode.FileIsDir ? "TRUE" : "FALSE");
	g_print ("FileAccessMode.FileIsBlok = %s\n", FileAccessMode.FileIsBlok ? "TRUE" : "FALSE");
	g_print ("FileAccessMode.BoolManipFile = %s\n", FileAccessMode.BoolManipFile ? "TRUE" : "FALSE");
	*/

	Flag = FALSE;
	switch (Flag_Ret_Mode) {
	case AM_FILE_EXIST :
		Flag = FileAccessMode.FileExist;
		break;
	case AM_FILE_READ :
		Flag = FileAccessMode.ReadFileOk;
		break;
	case AM_FILE_WRITE :
		Flag = FileAccessMode.WriteFileOk;
		break;
	case AM_FILE_EXEC :
		Flag = FileAccessMode.ExecFileOk;
		break;
	case AM_FILE_IS_REG :
		Flag = FileAccessMode.FileIsReg;
		break;
	case AM_FILE_IS_DIR :
		Flag = FileAccessMode.FileIsDir;
		break;
	case AM_FILE_IS_BLOCK :
		Flag = FileAccessMode.FileIsBlok;
		break;
	case AM_FILE_IS_MIND :
		Flag = FileAccessMode.BoolManipFile;
		break;
	case AM_NO_RET :
		Flag = FALSE;
		break;
	default :
		Flag = FALSE;
	}
	return (Flag);
}

/* Cherche 21 parametres dans 'xcfa_gen_conf.conf' sinon renvoie FALSE
*  --
*  entree :
*      gchar *Pathname : Name to search
*  retour :
*      FALSE :
*      TRUE  :
*/
gboolean infosong_test_xcfa_gen_conf (gchar *PathName)
{
#define MAX_CARS 255
	gchar     buf   [ MAX_CARS +1 ];
	FILE     *fp;
	gboolean  Bool_Ret = TRUE;
	gint      cpt = 0;

	/* PRINT_FUNC_LF(); */

	/* recherche de 21 identifiants */
	cpt = 0;
	fp = fopen (PathName, "r");
	while (fgets (buf, MAX_CARS, fp) != NULL) {
		if (strstr (buf, "PARAM_PATHDESTFILE"))			cpt ++;
		else if (strstr (buf, "PARAM_NAMEVISUAL_EPS"))		cpt ++;
		else if (strstr (buf, "PARAM_BOOL_POSTSCRIPT"))		cpt ++;
		else if (strstr (buf, "PARAM_PACKAGE"))			cpt ++;
		else if (strstr (buf, "PARAM_VERSION"))			cpt ++;
		else if (strstr (buf, "PARAM_TITLE"))			cpt ++;
		else if (strstr (buf, "PARAM_SUBTITLE"))		cpt ++;
		else if (strstr (buf, "PARAM_BOOL_TITLE_COVER"))	cpt ++;
		else if (strstr (buf, "PARAM_BOOL_SUBTITLE_COVER"))	cpt ++;
		else if (strstr (buf, "PARAM_BOOL_TITLE_BACK"))		cpt ++;
		else if (strstr (buf, "PARAM_BOOL_SUBTITLE_BACK"))	cpt ++;
		else if (strstr (buf, "PARAM_BOOL_FOOTTEXT_COVER"))	cpt ++;
		else if (strstr (buf, "PARAM_BOOL_FOOTTEXT_BACK"))	cpt ++;
		else if (strstr (buf, "PARAM_FOOTTEXT"))		cpt ++;
		else if (strstr (buf, "PARAM_BOOL_DRAW_GAP"))		cpt ++;
		else if (strstr (buf, "PARAM_BOOL_TEXTDATA_COVER"))	cpt ++;
		else if (strstr (buf, "PARAM_BOOL_TEXTDATA_BACK"))	cpt ++;
		else if (strstr (buf, "PARAM_BOOL_LINE_COVER"))		cpt ++;
		else if (strstr (buf, "PARAM_BOOL_LINE_BACK"))		cpt ++;
		else if (strstr (buf, "PARAM_CHOICEFIELDSCOVER"))	cpt ++;
		else if (strstr (buf, "PARAM_CHOICEFIELDSBACK"))	cpt ++;
	}
	fclose (fp);

	/* g_print ("cpt = %d / attendu = 21\n", cpt); */

	Bool_Ret = cpt == 21 ? TRUE : FALSE;
	return (Bool_Ret);
}

/* Analyse de l'entete du fichier 'PathName' pour savoir si il correspond a 'TYPE_FILE_IS type_infosong_file_is'
*  --
*  entree :
*      TYPE_FILE_IS type_infosong_file_is : Le type de fichier a rechercher:
*      gchar *PathName           : Le nom du fichier
*  retour :
*      TRUE  :
*      FALSE :
*/
TYPE_FILE_IS infosong_file_is (TYPE_FILE_IS type_infosong_file_is, gchar *PathName)
{
	gchar        *Lout = NULL;
	TYPE_FILE_IS  Bool_Ret = FILE_IS_NONE;
	size_t        lenfile = 0;
	GString      *gstr = NULL;

	/*PRINT_FUNC_LF();*/

	lenfile = infosong_get_size_file (PathName);
	if (lenfile == 0) {
		// g_print ("TAILLE = ZERO\n");
		// g_print ("\t%s\n", PathName);
		return (FILE_IS_NONE);
	}
	
	if (type_infosong_file_is == FILE_IS_SHN) {
		if (lenfile > 10 && tagsshn_file_is_shn (PathName)) return (FILE_IS_SHN);
	}

	if (type_infosong_file_is == FILE_IS_WAV) {
		if (tagswav_file_is_wav (PathName)) return (FILE_IS_WAV);
	}

	/*  Reconnaissance plus pointue du format OGG
	 *  xcfa-3.1.16
	 ********************************************
	 */
	if (type_infosong_file_is == FILE_IS_OGG) {
		if (tagsogg_file_is_ogg (PathName)) return (FILE_IS_OGG);
	}

	if (type_infosong_file_is == FILE_IS_FLAC) {
		if (tagsflac_file_is_flac (PathName)) return (FILE_IS_FLAC);
	}

	if (type_infosong_file_is == FILE_IS_APE) {
		if (tagsape_file_is_ape (PathName)) return (FILE_IS_APE);
	}

	if (type_infosong_file_is == FILE_IS_MPC) {
		if (tagsmpc_file_is_mpc (PathName)) return (FILE_IS_MPC);
	}
	
	if (type_infosong_file_is == FILE_IS_MP3) {
		if (tagsmp3_file_is_mp3 (PathName)) return (FILE_IS_MP3);
	}


	if (type_infosong_file_is == FILE_IS_WAVPACK) {
		if (tagswavpack_file_is_wavpack (PathName)) return (FILE_IS_WAVPACK);
	}
	
	if (type_infosong_file_is == FILE_IS_RM) {
		if (tagsrm_file_is_rm (PathName)) return (FILE_IS_RM);
	}

	if (type_infosong_file_is == FILE_IS_AIFF) {
		if (tagsaiff_file_is_aiff (PathName)) return (FILE_IS_AIFF);
	}
	
	gstr = get_with_file (PathName);

	Lout = gstr->str;
	if (*Lout) {
		if (type_infosong_file_is != FILE_IS_NONE) {
			/*
			FILE_IS_NONE = 0,
			FILE_IS_FLAC,
			FILE_IS_WAV,
			FILE_IS_MP3,
			FILE_IS_OGG,
			FILE_IS_M4A,
			FILE_IS_AAC,
			FILE_IS_SHN,
			FILE_IS_WMA,
			FILE_IS_RM,
			FILE_IS_DTS,
			FILE_IS_AIFF,
			FILE_IS_MPC,
			FILE_IS_APE,
			FILE_IS_WAVPACK,
			FILE_IS_WAVPACK_MD5,
			FILE_IS_IMG,
			FILE_IS_HTML,
			FILE_IS_TXT,
			FILE_IS_XCFA_GEN_CONF
			*/
			switch (type_infosong_file_is) {

			case FILE_IS_AIFF :
				Bool_Ret = strstr (Lout, "AIFF audio") ? FILE_IS_AIFF : FILE_IS_NONE;
				break;

			case FILE_IS_FLAC :
				Bool_Ret = strstr (Lout, "FLAC audio") ? FILE_IS_FLAC : FILE_IS_NONE;
				if (Bool_Ret == FILE_IS_FLAC) Bool_Ret = strstr (Lout, "bitstream data") ? FILE_IS_FLAC : FILE_IS_NONE;
				break;
			case FILE_IS_WAV :
				Bool_Ret = strstr (Lout, "RIFF") ? FILE_IS_WAV : FILE_IS_NONE;
				if (Bool_Ret == FILE_IS_WAV) Bool_Ret = strstr (Lout, "WAVE audio") ? FILE_IS_WAV : FILE_IS_NONE;
				break;
			
			case FILE_IS_APE :
				Bool_Ret = strstr (Lout, "Monkey's Audio") ? FILE_IS_APE : FILE_IS_NONE;
				break;

			case FILE_IS_MP3 :
				Bool_Ret = strstr (Lout, "MP3 file") ? FILE_IS_MP3 : FILE_IS_NONE;
				if (Bool_Ret != FILE_IS_MP3) Bool_Ret = strstr (Lout, "MP3 encoding")  ? FILE_IS_MP3 : FILE_IS_NONE;
				// if (Bool_Ret != FILE_IS_MP3) Bool_Ret = strstr (Lout, "MPEG ADTS")     ? FILE_IS_MP3 : FILE_IS_NONE;
				if (Bool_Ret != FILE_IS_MP3) Bool_Ret = strstr (Lout, "XWD X Window Dump image data")  ? FILE_IS_MP3 : FILE_IS_NONE;
				
				/*	XWD X Window Dump image data
				 *	
				 *	http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=511764
				 */
				break;
				
			case FILE_IS_OGG :
				Bool_Ret = strstr (Lout, "Ogg data") ? FILE_IS_OGG : FILE_IS_NONE;
				if (Bool_Ret == FILE_IS_OGG) Bool_Ret = strstr (Lout, "Vorbis audio") ? FILE_IS_OGG : FILE_IS_NONE;
				break;
			case FILE_IS_M4A :
				Bool_Ret = strstr (Lout, "ISO Media, MPEG v4 system") ? FILE_IS_M4A : FILE_IS_NONE;
				break;
			case FILE_IS_AAC :
				Bool_Ret = strstr (Lout, "MPEG ADTS, AAC, v4 LC") ? FILE_IS_AAC : FILE_IS_NONE;
				break;
			case FILE_IS_SHN:
				Bool_Ret = FILE_IS_NONE;
				break;
			case FILE_IS_WMA :
				Bool_Ret = strstr (Lout, "Microsoft ASF") ? FILE_IS_WMA : FILE_IS_NONE;
				break;
			
			case FILE_IS_RM :
				Bool_Ret = strstr (Lout, "RealMedia file") ? FILE_IS_RM : FILE_IS_NONE;
				break;
			case FILE_IS_DTS :
				Bool_Ret = strstr (Lout, "data") ? FILE_IS_DTS : FILE_IS_NONE;
				break;
			
			case FILE_IS_MPC :
				Bool_Ret = strstr (Lout, "Musepack") ? FILE_IS_MPC : FILE_IS_NONE;
				break;
			/* ? FILE_IS_WAVPACK, FILE_IS_WAVPACK_MD5 */
			case FILE_IS_WAVPACK :
			case FILE_IS_WAVPACK_MD5 :
				Bool_Ret = FILE_IS_NONE;
				break;
			case FILE_IS_IMG :
				Bool_Ret = strstr (Lout, "image data") ? FILE_IS_IMG : FILE_IS_NONE;
				if (Bool_Ret == FALSE) Bool_Ret = strstr (Lout, "PNG image") ? FILE_IS_IMG : FILE_IS_NONE;
				break;
			case FILE_IS_HTML :
				Bool_Ret = strstr (Lout, "HTML document text") ? FILE_IS_HTML : FILE_IS_NONE;
				break;
			case FILE_IS_TXT :
				Bool_Ret = strstr (Lout, "ASCII") ? FILE_IS_TXT : FILE_IS_NONE;
				if (Bool_Ret == FILE_IS_TXT) Bool_Ret = strstr (Lout, "text") ? FILE_IS_TXT : FILE_IS_NONE;
				break;
			case FILE_IS_XCFA_GEN_CONF :
				Bool_Ret = strstr (Lout, "ASCII") ? FILE_IS_XCFA_GEN_CONF : FILE_IS_NONE;
				if (Bool_Ret == FILE_IS_XCFA_GEN_CONF) Bool_Ret = strstr (Lout, "text") ? FILE_IS_XCFA_GEN_CONF : FILE_IS_NONE;
				if (Bool_Ret == FILE_IS_XCFA_GEN_CONF) Bool_Ret = infosong_test_xcfa_gen_conf (PathName) ? FILE_IS_XCFA_GEN_CONF : FILE_IS_NONE;
				break;

			case FILE_IS_NONE :
				Bool_Ret = FILE_IS_NONE;
				break;

			default :
				Bool_Ret = FILE_IS_NONE;
			}
		}

		if (Bool_Ret == FILE_IS_NONE) {
			/*
			FILE_IS_NONE = 0,
			FILE_IS_FLAC,
			FILE_IS_WAV,
			FILE_IS_MP3,
			FILE_IS_OGG,
			FILE_IS_M4A,
			FILE_IS_SHN,
			FILE_IS_WMA,
			FILE_IS_MPC,
			FILE_IS_APE,
			FILE_IS_WAVPACK,
			FILE_IS_WAVPACK_MD5,
			FILE_IS_IMG,
			FILE_IS_HTML,
			FILE_IS_TXT,
			FILE_IS_XCFA_GEN_CONF
			*/
			
			if (tagsaiff_file_is_aiff (PathName)) {
				Bool_Ret = FILE_IS_AIFF;
			}
			else if (tagsflac_file_is_flac (PathName)) {
				Bool_Ret = FILE_IS_FLAC;
			}
			else if (tagsape_file_is_ape (PathName)) {
				Bool_Ret = FILE_IS_APE;
			}
			else if (tagsmpc_file_is_mpc (PathName)) {
			// else if (strstr (Lout, "Musepack")) {
				Bool_Ret = FILE_IS_MPC;
			}
			else if (tagswav_file_is_wav (PathName)) {
			// else if (strstr (Lout, "RIFF") && strstr (Lout, "WAVE audio")) {
				Bool_Ret = FILE_IS_WAV;
			}
			else if (tagsmp3_file_is_mp3 (PathName)) {
				Bool_Ret = FILE_IS_MP3;
			}
			else if (tagsflac_file_is_flac (PathName)) {
			// else if (strstr (Lout, "FLAC audio") && strstr (Lout, "bitstream data")) {
				Bool_Ret = FILE_IS_FLAC;
			}
			else if (tagsape_file_is_ape (PathName)) {
			// else if (strstr (Lout, "Monkey's Audio")) {
				Bool_Ret = FILE_IS_APE;
			}
			else if (tagsshn_file_is_shn (PathName)) {
				Bool_Ret = FILE_IS_SHN;
			}
			
			/*	XWD X Window Dump image data
			 *	
			 *	http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=511764
			 */
			else if (strstr (Lout, "MP3 file") ||
				 strstr (Lout, "MP3 encoding") ||
				 // strstr (Lout, "MPEG ADTS") ||
				 strstr (Lout, "XWD X Window Dump image data")) {
				 Bool_Ret = FILE_IS_MP3;
			}
			else if (strstr (Lout, "Ogg data") && strstr (Lout, "Vorbis audio")) {
				Bool_Ret = FILE_IS_OGG;
			}
			else if (strstr (Lout, "ISO Media, MPEG v4 system")) {
				Bool_Ret = FILE_IS_M4A;
			}
			else if (strstr (Lout, "MPEG ADTS, AAC, v4 LC")) {
				Bool_Ret = FILE_IS_AAC;
			}
			else if (strstr (Lout, "Microsoft ASF")) {
				Bool_Ret = FILE_IS_WMA;
			}
			else if (tagswavpack_file_is_wavpack (PathName)) {
				Bool_Ret =  FILE_IS_WAVPACK;
			}
			else if (strstr (Lout, "RealMedia file")) {
				Bool_Ret = FILE_IS_RM;
			}
			else if (strstr (Lout, "data")) {
				Bool_Ret = FILE_IS_DTS;
			}
			else if (strstr (Lout, "image data") || strstr (Lout, "PNG image")) {
				Bool_Ret = FILE_IS_IMG;
			}
			else if (strstr (Lout, "HTML document text")) {
				Bool_Ret = FILE_IS_HTML;
			}
			else if (strstr (Lout, "ASCII") && strstr (Lout, "text")) {
				Bool_Ret = FILE_IS_TXT;
			}
			else if (strstr (Lout, "ASCII") && strstr (Lout, "text") && infosong_test_xcfa_gen_conf (PathName)) {
				Bool_Ret = FILE_IS_XCFA_GEN_CONF;
			}
			else {
				Bool_Ret = FILE_IS_NONE;
			}
		}
	}

	g_string_free (gstr, TRUE);
	Lout = NULL;

	return (Bool_Ret);
}

/* Decompose l'extention du fichier pour connaitre son type
*  --
*  entree :
*      gchar *NameSong : pointeur sur un nom de fichier
*  retour :
*      TYPE_FILE_IS : type de fichier trouve
*/
TYPE_FILE_IS infosong_get_type_file_is (gchar *NameSong)
{
	TYPE_FILE_IS  type = FILE_IS_NONE;
	gchar         Ext [ 8 ] = {'\0','\0','\0','\0','\0','\0','\0','\0',};
	gchar        *Ptr;

	/* PRINT_FUNC_LF(); */

	Ptr = strrchr (NameSong, '/');
	if (Ptr) {
		Ptr = strrchr (Ptr, '.');
		if (Ptr) {
			Ptr++;
			if (*Ptr) Ext [0] = toupper (*Ptr++);
			if (*Ptr) Ext [1] = toupper (*Ptr++);
			if (*Ptr) Ext [2] = toupper (*Ptr++);
			if (*Ptr) Ext [3] = toupper (*Ptr);
			Ext [4] = '\0';

			if      (Ext[0] == 'F' && Ext[1] == 'L' && Ext[2] == 'A' && Ext[3] == 'C'    && Ext[4] == '\0') return (FILE_IS_FLAC);
			else if (Ext[0] == 'W' && Ext[1] == 'A' && Ext[2] == 'V' && Ext[3] == '\0')             	return (FILE_IS_WAV);
			else if (Ext[0] == 'M' && Ext[1] == 'P' && Ext[2] == '3' && Ext[3] == '\0')             	return (FILE_IS_MP3);
			else if (Ext[0] == 'O' && Ext[1] == 'G' && Ext[2] == 'G' && Ext[3] == '\0')             	return (FILE_IS_OGG);
			else if (Ext[0] == 'S' && Ext[1] == 'H' && Ext[2] == 'N' && Ext[3] == '\0')            		return (FILE_IS_SHN);
			else if (Ext[0] == 'M' && Ext[1] == '4' && Ext[2] == 'A' && Ext[3] == '\0')			return (FILE_IS_M4A);
			else if (Ext[0] == 'A' && Ext[1] == 'A' && Ext[2] == 'C' && Ext[3] == '\0')			return (FILE_IS_AAC);
			else if (Ext[0] == 'W' && Ext[1] == 'M' && Ext[2] == 'A' && Ext[3] == '\0')			return (FILE_IS_WMA);
			else if (Ext[0] == 'R' && Ext[1] == 'M' && Ext[2] == '\0' && Ext[3] == '\0')            	return (FILE_IS_RM);
			else if (Ext[0] == 'D' && Ext[1] == 'T' && Ext[2] == 'S' && Ext[3] == '\0')			return (FILE_IS_DTS);
			
			// AIF
			// AIFF
			// AIFC
			else if (Ext[0] == 'A' && Ext[1] == 'I' && Ext[2] == 'F' && Ext[3] == '\0')             	return (FILE_IS_AIFF);
			else if (Ext[0] == 'A' && Ext[1] == 'I' && Ext[2] == 'F' && Ext[3] == 'F'    && Ext[4] == '\0') return (FILE_IS_AIFF);
			else if (Ext[0] == 'A' && Ext[1] == 'I' && Ext[2] == 'F' && Ext[3] == 'C'    && Ext[4] == '\0') return (FILE_IS_AIFF);
			
			else if (Ext[0] == 'M' && Ext[1] == 'P' && Ext[2] == 'C' && Ext[3] == '\0')			return (FILE_IS_MPC);
			else if (Ext[0] == 'A' && Ext[1] == 'P' && Ext[2] == 'E' && Ext[3] == '\0')			return (FILE_IS_APE);
			else if (Ext[0] == 'W' && Ext[1] == 'V' && Ext[2] == '\0')					return (FILE_IS_WAVPACK);
			else if (Ext[0] == 'C' && Ext[1] == 'U' && Ext[2] == 'E' && Ext[3] == '\0')			return (FILE_IS_CUE);
		}
	}
	return (type);
}
gboolean infosong_g_str_has_suffix (gchar *NameSong, gchar *Suffixe)
{
	gchar        *Ptr;
	gchar        *Name = NULL;
	gboolean      BoolRet = FALSE;
	
	/* PRINT_FUNC_LF(); */

	if (NameSong == NULL || Suffixe == NULL) return (FALSE);
	
	Ptr = strrchr (NameSong, '/');
	if (Ptr) {
		Ptr = strrchr (Ptr, '.');
		if (Ptr) {
			Name = g_strdup (NameSong);
			Ptr = strrchr (Name, '.');
			Ptr ++;
			while (*Ptr) {
				*Ptr = toupper (*Ptr);
				Ptr ++;
			}
			
			BoolRet = g_str_has_suffix (Name, Suffixe);
			 
			g_free (Name);
			Name = NULL;
		}
	}
	return (BoolRet);
}

gboolean infosong_type_is_song (gchar *NameSong)
{
	TYPE_FILE_IS  type = FILE_IS_NONE;

	type = infosong_get_type_file_is (NameSong);
	if (type == FILE_IS_FLAC ||
		type == FILE_IS_WAV ||
		type == FILE_IS_MP3 ||
		type == FILE_IS_OGG ||
		type == FILE_IS_SHN ||
		type == FILE_IS_M4A ||
		type == FILE_IS_AAC ||
		type == FILE_IS_WMA ||
		type == FILE_IS_RM  ||
		type == FILE_IS_DTS ||
		type == FILE_IS_AIFF ||
		type == FILE_IS_MPC ||
		type == FILE_IS_APE ||
		type == FILE_IS_WAVPACK) return (TRUE);
	return (FALSE);
}

gchar *infosong_get_str_type_file_is (TYPE_FILE_IS type)
{
	static gchar str_type_file [ 8 ];

	/* PRINT_FUNC_LF(); */

	if (type == FILE_IS_FLAC)     	   strcpy (str_type_file, "FLAC");
	else if (type == FILE_IS_WAV)      strcpy (str_type_file, "WAV ");
	else if (type == FILE_IS_MP3)      strcpy (str_type_file, "MP3 ");
	else if (type == FILE_IS_OGG)      strcpy (str_type_file, "OGG ");
	else if (type == FILE_IS_SHN)      strcpy (str_type_file, "SHN ");
	else if (type == FILE_IS_M4A)      strcpy (str_type_file, "M4A ");
	else if (type == FILE_IS_AAC)      strcpy (str_type_file, "AAC ");
	else if (type == FILE_IS_WMA)      strcpy (str_type_file, "WMA ");
	else if (type == FILE_IS_RM)       strcpy (str_type_file, "RM ");
	else if (type == FILE_IS_DTS)      strcpy (str_type_file, "DTS ");
	else if (type == FILE_IS_AIFF)     strcpy (str_type_file, "AIFF ");
	else if (type == FILE_IS_MPC)      strcpy (str_type_file, "MPC ");
	else if (type == FILE_IS_APE)      strcpy (str_type_file, "APE ");
	else if (type == FILE_IS_WAVPACK)  strcpy (str_type_file, "WVP ");
	else				   strcpy (str_type_file, "???");

	return (&str_type_file[0]);
}



typedef struct {
	gint   num;
	gchar *name;
} STRUCT_TAGS;

STRUCT_TAGS StructTags [] = {

{123, "A Cappella"},
{ 74, "Acid Jazz"},
{ 73, "Acid Punk"},
{ 34, "Acid"},
{ 99, "Acoustic"},
{ 40, "Alt. Rock"},
{ 20, "Alternative"},
{ 26, "Ambient"},
{145, "Anime"},
{ 90, "Avantgarde"},
{116, "Ballad"},
{ 41, "Bass"},
{135, "Beat"},
{ 85, "Bebob"},
{ 96, "Big Band"},
{138, "Black Metal"},
{ 89, "Bluegrass"},
{  0, "Blues"},
{107, "Booty Bass"},
{132, "BritPop"},
{ 65, "Cabaret"},
{ 88, "Celtic"},
{104, "Chamber Music"},
{102, "Chanson"},
{ 97, "Chorus"},
{136, "Christian Gangsta Rap"},
{ 61, "Christian Rap"},
{141, "Christian Rock"},
{  1, "Classic Rock"},
{ 32, "Classical"},
{128, "Club-House"},
{112, "Club"},
{ 57, "Comedy"},
{140, "Contemporary Christian"},
{  2, "Country"},
{139, "Crossover"},
{ 58, "Cult"},
{125, "Dance Hall"},
{  3, "Dance"},
{ 50, "Darkwave"},
{ 22, "Death Metal"},
{  4, "Disco"},
{ 55, "Dream"},
{127, "Drum & Bass"},
{122, "Drum Solo"},
{120, "Duet"},
{ 98, "Easy Listening"},
{ 52, "Electronic"},
{ 48, "Ethnic"},
{124, "Euro-House"},
{ 25, "Euro-Techno"},
{ 54, "Eurodance"},
{ 84, "Fast-Fusion"},
{ 81, "Folk/Rock"},
{115, "Folklore"},
{ 80, "Folk"},
{119, "Freestyle"},
{  5, "Funk"},
{ 30, "Fusion"},
{ 36, "Game"},
{ 59, "Gangsta Rap"},
{126, "Goa"},
{ 38, "Gospel"},
{ 91, "Gothic Rock"},
{ 49, "Gothic"},
{  6, "Grunge"},
{ 79, "Hard Rock"},
{129, "Hardcore"},
{137, "Heavy Metal"},
{  7, "Hip-Hop"},
{ 35, "House"},
{100, "Humour"},
{131, "Indie"},
{ 19, "Industrial"},
{ 46, "Instrumental Pop"},
{ 47, "Instrumental Rock"},
{ 33, "Instrumental"},
{146, "JPop"},
{ 29, "Jazz+Funk"},
{  8, "Jazz"},
{ 63, "Jungle"},
{ 86, "Latin"},
{ 71, "Lo-Fi"},
{ 45, "Meditative"},
{142, "Merengue"},
{  9, "Metal"},
{ 77, "Musical"},
{ 82, "National Folk"},
{ 64, "Native American"},
{133, "Negerpunk"},
{ 10, "New Age"},
{ 66, "New Wave"},
{ 39, "Noise"},
{ 11, "Oldies"},
{103, "Opera"},
{ 12, "Other"},
{ 75, "Polka"},
{134, "Polsk Punk"},
{ 53, "Pop-Folk"},
{ 62, "Pop/Funk"},
{ 13, "Pop"},
{109, "Porn Groove"},
{117, "Power Ballad"},
{ 23, "Pranks"},
{108, "Primus"},
{ 92, "Progressive Rock"},
{ 93, "Psychedelic Rock"},
{ 67, "Psychedelic"},
{121, "Punk Rock"},
{ 43, "Punk"},
{ 14, "R&B"},
{ 15, "Rap"},
{ 68, "Rave"},
{ 16, "Reggae"},
{ 76, "Retro"},
{ 87, "Revival"},
{118, "Rhythmic Soul"},
{ 78, "Rock & Roll"},
{ 17, "Rock"},
{143, "Salsa"},
{114, "Samba"},
{110, "Satire"},
{ 69, "Showtunes"},
{ 21, "Ska"},
{111, "Slow Jam"},
{ 95, "Slow Rock"},
{105, "Sonata"},
{ 42, "Soul"},
{ 37, "Sound Clip"},
{ 24, "Soundtrack"},
{ 56, "Southern Rock"},
{ 44, "Space"},
{101, "Speech"},
{ 83, "Swing"},
{ 94, "Symphonic Rock"},
{106, "Symphony"},
{147, "Synthpop"},
{113, "Tango"},
{ 51, "Techno-Industrial"},
{ 18, "Techno"},
{130, "Terror"},
{144, "Thrash Metal"},
{ 60, "Top 40"},
{ 70, "Trailer"},
{ 31, "Trance"},
{ 72, "Tribal"},
{ 27, "Trip-Hop"},
{ 28, "Vocal"},
{102, "Chanson française"},
{-1,  NULL}

};


void infosong_set_elements_combobox (GtkWidget *widget)
{
	gint i;
	
	for (i=0; StructTags[ i ].num != -1; i++)
		gtk_combo_box_append_text (GTK_COMBO_BOX (widget), StructTags[ i ].name);
	
}

gint infosong_get_elements_combobox (gint num)
{
	gint i;
	
	for (i=0; StructTags[ i ].num != num; i++);
	
	if (i > 148) i = 0;

	return (i);
}

gint infosong_get_num_combobox (gint value)
{
	return (StructTags[ value ].num);
}


gint infosong_get_genre_by_value (gchar *name)
{
	gint	 i;
	gchar	 NewName [ 100 ];
	gchar	*PtrNewName = NewName;
		
	if (!name || !*name) return (-1);
	
	strcpy (NewName, name);

	while (*PtrNewName) {
		/*if (*PtrNewName == ' ') {*/
		if (g_ascii_isspace(*PtrNewName)) {
			PtrNewName ++;
			continue;
		}
		if (g_ascii_isalpha(*PtrNewName) == FALSE) break;
		PtrNewName ++;
	}
	*PtrNewName = '\0';

	for (i=0; StructTags[ i ].num != -1; i++)
		if (strncmp (StructTags[ i ].name, NewName, strlen (NewName)) == 0) return (StructTags[ i ].num);
	
	return (-1);
}

gchar *infosong_get_genre_by_name (gint value)
{
	gint i;

	if (value < 0 || value > 148) return ((gchar *)NULL);

	for (i=0; StructTags[ i ].num != value; i++);

	return ((gchar *)StructTags[ i ].name);
}




