 /*
 * file      : get.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#ifndef __get_h__
#define __get_h__ 1

typedef struct {
	guint	 SecTime;
	gchar	*time;
	gchar	*size;
} SHNTAG;

SHNTAG  *get_with_shntool (gchar *file);
SHNTAG  *get_free_shntool (SHNTAG *ShnTag);

GString *get_with_file (gchar *file);
GString *get_with_checkmp3 (gchar *file);
GString *get_with_cdparanoia (gchar *file);
GString *get_with_faad (gchar *file);
GString *get_with_ogginfo (gchar *file);
GString *get_with_mediainfo (gchar *file);
GString *get_with_which (gchar *file);
GString *get_with_cdplay (gchar *file);
GString *get_with_metaflac (gchar *file);
void     get_with_wget (void);
gboolean get_version_metaflac_is_ok (void);
gint     get_in_super_user (void);
void     get_with_eject (gchar *StrDevice);
gchar   *get_set_cpu_info (void);

#endif

