 /*
 * file      : fileselect.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __fileselect_h__
#define __fileselect_h__ 1


typedef enum {

	_PATH_DESTINATION_CD_ = 0,
	_PATH_DESTINATION_DVD_,
	_PATH_DESTINATION_FILE_,
	_PATH_DESTINATION_FILE_WAV_,
	_PATH_DESTINATION_FILE_MP3OGG_,
	_PATH_DESTINATION_SPLIT_,
	_PATH_LOAD_FILE_,
	_PATH_IMPORT_FILE_WAV_,
	_PATH_IMPORT_FILE_MP3OGG_,
	_PATH_IMPORT_FILE_SPLIT_,
	_PATH_IMPORT_IMAGES_,
	_PATH_STOCKE_IMAGES_POCHETTE_,
	_PATH_DEST_FILE_POSTSCRIPT_,
	_PATH_LOAD_DVD_FROM_DIRECTORY_,
	_PATH_TEMP_,
	_PATH_DEST_JOURNAL_,

	_NB_PATH_                       /* Do Not Use This Var, It's reserved */

} TYPE_FILESELECTION;


void     fileselect_remove_comment (void);
void	 fileselect_create (TYPE_FILESELECTION Choice, void *Func_Extern);
void	 fileselect_clear_glist (void);
GList	*fileselect_set_glist_from_str (gchar *p_str);
GList   *fileselect_get_glist (void);


#endif
