 /*
 * file      : file_wav_conv.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <pthread.h>
#include <stdlib.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>

#include "global.h"
#include "file.h"
#include "utils.h"
#include "options.h"
#include "win_info.h"
#include "info_song.h"
#include "file.h"
#include "conv.h"
#include "secu.h"
#include "win_control.h"




/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

typedef struct {
	GtkWidget	*AdrWin;
	gboolean	 Bool;
	GtkWidget	*AdrLabelTitre;
	GtkWidget	*AdrLabelCompteur;
	GtkWidget	*AdrProgressBar;
	
	gboolean	 BoolEndTimeout;
	
	gchar		*Mess;
	gint		 PassMplayer;
	gboolean	 BoolCopy;
	gboolean	 BoolRest;
	gboolean	 BoolSox;
	gboolean	 BoolMplayer;
	
} VAR_FILEWAVCONF;

VAR_FILEWAVCONF VarFilewavconv;




/*
*---------------------------------------------------------------------------
* ACTION
*---------------------------------------------------------------------------
*/


/*
*---------------------------------------------------------------------------
* NOUVEAU CODE 
*---------------------------------------------------------------------------
*/

void filewavconv_quit (void)
{
	NEW_wincontrol_realize_window (&VarFilewavconv.AdrWin, "wind_wav_to_wav", &VarFilewavconv.Bool, WIND_IS_SHOW, WIND_USE_STRUCT, WIND_IS_MODAL, WIND_IS_TRANSIENT);
}

gboolean filewavconv_delete_event (void)
{
	filewavconv_quit ();
	return TRUE;
}
gboolean filewavconv_destroy_event (void)
{
	filewavconv_quit ();
	return TRUE;
}
void filewavconv_stop_wav_to_wav_clicked (void)
{
	filewavconv_quit ();
}

static void filewavconv_thread (void *arg)
{
	GList    *list = NULL;
	DETAIL   *detail = NULL;
	FIC_WAV  *FicWav = NULL;
	INFO_WAV *info = NULL;

	PRINT_FUNC_LF();

	conv.bool_thread_conv  = TRUE;

	/* Copie vers le dossier temporaire
	*/
	list = g_list_first (entetefile);
	while (!conv.bool_stop && list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->type_infosong_file_is != FILE_IS_WAV) {
				list = g_list_next(list);
				continue;
			}
			if (!(FicWav = (FIC_WAV *)detail->fic_wav)) {
				list = g_list_next(list);
				continue;
			}

			if (!FicWav->Bool_Conv) {
				list = g_list_next(list);
				continue;
			}

			if (infosong_file_is_reg (detail->namefile)) {
				conv.type_conv = COPY_FILE;
				
				VarFilewavconv.BoolCopy = TRUE;
				conv_copy_src_to_dest (detail->namefile, FicWav->TmpSrc);
				VarFilewavconv.BoolCopy = FALSE;
				conv.encode_completed ++;
			}
		}
		list = g_list_next (list);
	}

	/* Transformation avec MPLAYER et SOX
	*/	
	list = g_list_first (entetefile);
	while (!conv.bool_stop && list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->type_infosong_file_is != FILE_IS_WAV) {
				list = g_list_next(list);
				continue;
			}
			if (!(FicWav = (FIC_WAV *)detail->fic_wav)) {
				list = g_list_next(list);
				continue;
			}

			if (FicWav->Bool_Conv) {
				
				info = (INFO_WAV *)detail->info;
				
				if (atoi (info->voie) != atoi (FicWav->NewVoie) ||
				    atoi (info->hertz) != atoi (FicWav->NewHertz) ||
				    atoi (info->bits) != atoi (FicWav->NewBits)
				    )  {


					GList *listmplayer = NULL;
					GList *list = NULL;
					gchar *ptr = NULL;
					
					conv.type_conv = MPLAYER_WAV_TO_WAV;
					
				GDK_THREADS_ENTER();
					listmplayer = g_list_append (listmplayer, g_strdup ("nice"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-n"));
					listmplayer = g_list_append (listmplayer, g_strdup (conv.valuenice));
					listmplayer = g_list_append (listmplayer, g_strdup ("mplayer"));
					
					listmplayer = g_list_append (listmplayer, g_strdup ("-nojoystick"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-nolirc"));

					listmplayer = g_list_append (listmplayer, g_strdup (FicWav->TmpSrc));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup ("pcm"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup_printf ("pcm:file=%s", FicWav->TmpMplayer));
					listmplayer = g_list_append (listmplayer, g_strdup ("-af"));
					listmplayer = g_list_append (listmplayer, g_strdup_printf ("channels=%s", FicWav->NewVoie));
					listmplayer = g_list_append (listmplayer, g_strdup ("-srate"));
					listmplayer = g_list_append (listmplayer, g_strdup (FicWav->NewHertz));
				GDK_THREADS_LEAVE();
					
					VarFilewavconv.BoolMplayer = TRUE;
					conv.ArgConv = conv_alloc_arg (listmplayer);
					conv_exec (FALSE, MPLAYER_WAV_TO_WAV, listmplayer, "MPLAYER_WAV_TO_WAV");
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
					VarFilewavconv.BoolMplayer = FALSE;
					
					list = g_list_first (listmplayer);
					while (list) {
						if ((ptr = (gchar *)list->data)) {
							g_free (ptr);
							ptr = NULL;
							list->data = NULL;
						}
						list = g_list_next(list);
					}
					g_list_free (listmplayer);
					listmplayer = NULL;
					conv.encode_completed ++;

					VarFilewavconv.BoolCopy = TRUE;
					conv_copy_src_to_dest (FicWav->TmpMplayer, FicWav->TmpSrc);
					VarFilewavconv.BoolCopy = FALSE;

					detail->info = (INFO_WAV *)tagswav_remove_info (info);
					info = (INFO_WAV *)detail->info;

					detail->info = (INFO_WAV *)tagswav_get_info (detail, FicWav->TmpSrc);
					info = (INFO_WAV *)detail->info;
					
					conv.encode_completed ++;
				}

				if (atoi (info->bits) != atoi (FicWav->NewBits)) {
				
					GList *ListSox = NULL;
					
					conv.type_conv = SOX_WAV_TO_WAV;
					
					VarFilewavconv.BoolSox = TRUE;

					ListSox = conv_with_sox_get_param (FicWav->TmpSrc, FicWav->TmpDest, FicWav->NewHertz, FicWav->NewVoie, FicWav->NewBits);
					conv.ArgConv = conv_alloc_arg (ListSox);
					conv_exec (FALSE, SOX_WAV_TO_WAV, ListSox, "SOX_WAV_TO_WAV");
					ListSox = filelc_remove_glist (ListSox);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
					conv.encode_completed ++;
					
					VarFilewavconv.BoolSox = FALSE;
					conv.type_conv = COPY_FILE;
					VarFilewavconv.BoolCopy = TRUE;
					conv_copy_src_to_dest (FicWav->TmpDest, FicWav->TmpSrc);
					VarFilewavconv.BoolCopy = FALSE;
					
					conv.encode_completed ++;
				}
				
				detail->info = (INFO_WAV *)tagswav_remove_info (info);
				info = (INFO_WAV *)detail->info;
				detail->info = (INFO_WAV *)tagswav_get_info (detail, detail->namefile);
				info = (INFO_WAV *)detail->info;
				
				g_free (FicWav->Hertz);
				FicWav->Hertz = NULL;
				FicWav->Hertz = g_strdup (info->hertz);
				
				g_free (FicWav->NewHertz);
				FicWav->NewHertz = NULL;
				FicWav->NewHertz = g_strdup (info->hertz);
				
				g_free (FicWav->Voie);
				FicWav->Voie = NULL;
				FicWav->Voie = g_strdup (info->voie);
				
				g_free (FicWav->NewVoie);
				FicWav->NewVoie = NULL;
				FicWav->NewVoie = g_strdup (info->voie);
				
				g_free (FicWav->Bits);
				FicWav->Bits = NULL;
				FicWav->Bits = g_strdup (info->bits);
				
				g_free (FicWav->NewBits);
				FicWav->NewBits = NULL;
				FicWav->NewBits = g_strdup (info->bits);
			}
		}
		list = g_list_next(list);
	}

	/* Copie du dossier temporaire vers l'origine
	*/
	list = g_list_first (entetefile);
	while (!conv.bool_stop && list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->type_infosong_file_is != FILE_IS_WAV) {
				list = g_list_next(list);
				continue;
			}
			if (!(FicWav = (FIC_WAV *)detail->fic_wav)) {
				list = g_list_next(list);
				continue;
			}

			if (!FicWav->Bool_Conv) {
				list = g_list_next(list);
				continue;
			}
			
			FicWav->Bool_Conv = FALSE;
			
			conv.type_conv = COPY_FILE;
			
			if (infosong_file_is_reg (FicWav->TmpSrc)) {

				VarFilewavconv.BoolRest = TRUE;
				conv_copy_src_to_dest (FicWav->TmpSrc, FicWav->NameDest);
				VarFilewavconv.BoolRest = FALSE;
			}
			else {
				g_print ("LE FICHIER <%s>\n", FicWav->TmpDest);
				g_print ("\tEST RESTITUE SANS AVOIR ETE MODIFIE :\n");
				g_print ("\tL' ENTETE NE CORRESPOND PAS A L'EXTENTION !!!\n");

				VarFilewavconv.BoolRest = TRUE;
				conv_copy_src_to_dest (FicWav->TmpSrc, FicWav->NameDest);
				VarFilewavconv.BoolRest = FALSE;
			}
			conv.encode_completed ++;
			
			infosong_delete_file (FicWav->TmpSrc);
			infosong_delete_file (FicWav->TmpDest);
			infosong_delete_file (FicWav->TmpMplayer);

			g_free (FicWav->TmpSrc);		FicWav->TmpSrc = NULL;
			g_free (FicWav->TmpDest);		FicWav->TmpDest = NULL;
			g_free (FicWav->TmpMplayer);		FicWav->TmpMplayer = NULL;
			g_free (FicWav->NameDest);		FicWav->NameDest = NULL;
		}
		list = g_list_next (list);
	}

	secu_thread_sub ();
	conv.bool_thread_conv = FALSE;
	pthread_exit(0);
}

void filewavconv_puts_statusbar (gchar *mess_label_status)
{
	if (VarFilewavconv.AdrLabelCompteur) {
		
		gchar *New_Str = NULL;
		
		New_Str = g_strdup_printf (" <span font_desc=\"Courier bold 8\"><span color=\"black\"><b>%s</b></span></span>", mess_label_status);
		gtk_label_set_use_markup (GTK_LABEL (VarFilewavconv.AdrLabelCompteur), TRUE);
		gtk_label_set_justify (GTK_LABEL (VarFilewavconv.AdrLabelCompteur), GTK_JUSTIFY_CENTER);
		gtk_label_set_markup (GTK_LABEL (VarFilewavconv.AdrLabelCompteur), New_Str);

		g_free (New_Str);
		New_Str = NULL;
	}
}

static gint filewavconv_timeout (gpointer data)
{
	if (conv.bool_percent_conv) {

		conv_set_data_progressBar (VarFilewavconv.AdrProgressBar, conv.total_percent);
		conv.bool_percent_conv = FALSE;

		if (VarFilewavconv.BoolCopy == TRUE) {
			g_free (VarFilewavconv.Mess);
			VarFilewavconv.Mess = NULL;
			VarFilewavconv.Mess = g_strdup_printf (_("Copie fichier: %d%%"), (gint)(conv.conversion_percent*100));
			filewavconv_puts_statusbar (VarFilewavconv.Mess);
			g_free (VarFilewavconv.Mess);
			VarFilewavconv.Mess = NULL;
		}
		else if (VarFilewavconv.BoolRest == TRUE) {	
			g_free (VarFilewavconv.Mess);
			VarFilewavconv.Mess = NULL;
			VarFilewavconv.Mess = g_strdup_printf (_("Restitution fichier: %d%%"), (gint)(conv.conversion_percent*100));
			filewavconv_puts_statusbar (VarFilewavconv.Mess);
			g_free (VarFilewavconv.Mess);
			VarFilewavconv.Mess = NULL;
		}
		else if (VarFilewavconv.BoolSox == TRUE) {
			g_free (VarFilewavconv.Mess);
			VarFilewavconv.Mess = NULL;
			VarFilewavconv.Mess = g_strdup_printf (_("Traitement Sox: %d%%"), (gint)(conv.conversion_percent*100));
			filewavconv_puts_statusbar (VarFilewavconv.Mess);
			g_free (VarFilewavconv.Mess);
			VarFilewavconv.Mess = NULL;
		}
	}
	
	if (VarFilewavconv.BoolMplayer == TRUE) {
    		
    		gchar *spinner="|/-\\";
		gchar  foo [ 2 ];
		
		foo [ 0 ] = spinner[VarFilewavconv.PassMplayer++%4];
		foo [ 1 ] = '\0';
    		
 		if (VarFilewavconv.Mess != NULL) {
 			g_free (VarFilewavconv.Mess);
 			VarFilewavconv.Mess = NULL;
 		}
		VarFilewavconv.Mess = g_strdup_printf (_("Traitement Mplayer:   %s   %d%%"),
						foo,
						(gint)(conv.conversion_percent * 100));
		filewavconv_puts_statusbar (VarFilewavconv.Mess);
 		g_free (VarFilewavconv.Mess);
 		VarFilewavconv.Mess = NULL;
	}
	
	if (conv.bool_thread_conv == FALSE) {
		gtk_timeout_remove (conv.handler_timeout_conv);
		filewavconv_quit ();

		/* mise a jour des champs de 'EnteteWav.glist' */
		file_update_glist_wav ();
		fileanalyze_update_info ();
		conv_set_struct_not_used ();
	}
	
	return (TRUE);
}

/* Initialisation des variables avant l'activation des threads d'extraction et de conversion
*  --
*  entree : -
*  retour : -
*/
void filewavconv_set_flags_before (void)
{
	GList    *list = NULL;
	DETAIL   *detail = NULL;
	FIC_WAV  *FicWav = NULL;
	gint      NumFile = 0;
	INFO_WAV *info = NULL;

	/* PRINT_FUNC_LF(); */

	/* recup du niveau de gentillesse */
	g_snprintf (conv.valuenice , 4, "%d", options_get_val_nice ());

	list = g_list_first (entetefile);
	while (!conv.bool_stop && list) {
		if ((detail = (DETAIL *)list->data)) {
			if (detail->type_infosong_file_is != FILE_IS_WAV) {
				list = g_list_next(list);
				continue;
			}
			if (!(FicWav = (FIC_WAV *)detail->fic_wav)) {
				list = g_list_next(list);
				continue;
			}

			if (!FicWav->Bool_Conv) {
				list = g_list_next(list);
				continue;
			}

			detail->modif = TRUE;

			/* Create temporary rep */
			if (!conv.TmpRep)  {
				conv.TmpRep  = utils_create_temporary_rep (PATH_TMP_XCFA_AUDIOFILEWAVCONV);
				/*g_print ("\nCREATE TEMPORARY REP: %s\n", conv.TmpRep);*/
			}
	
			/* Nouvelles: source et destination
			*/
			/* $TMP/original */
			FicWav->TmpSrc         = g_strdup_printf ("%s/%03d.wav", conv.TmpRep, NumFile ++);
			
			/* $TMP/modifie */
			FicWav->TmpDest        = g_strdup_printf ("%s/%03d.wav", conv.TmpRep, NumFile ++);
			
			/* $TMP/ */
			FicWav->TmpMplayer     = g_strdup_printf ("%s/%03d.wav", conv.TmpRep, NumFile ++);
	 		
	 		/* Copie vers la destination */
	 		/* FicWav->NameDest       = filewavconv_get_pathname (detail); */
	 		FicWav->NameDest       = file_make_pathname_file (detail, FILE_IS_WAV);
	 		
	 		g_print ("fic->TmpSrc     = %s\n", FicWav->TmpSrc);
	 		g_print ("fic->TmpDest    = %s\n", FicWav->TmpDest);
	 		g_print ("fic->TmpMplayer = %s\n", FicWav->TmpMplayer);
	 		g_print ("fic->NameDest   = %s\n\n", FicWav->NameDest);
			
			/* Rectification des parametres si incomprehensible par SOX
			*/
			if (*FicWav->NewHertz == '\0') {
				glong value = atol (FicWav->Hertz);
				g_free (FicWav->NewHertz);
				FicWav->NewHertz = NULL;
				if (value < 0 || value > 44100) FicWav->NewHertz = g_strdup ("44100");
				else				FicWav->NewHertz = g_strdup (FicWav->Hertz);
			}
			if (*FicWav->NewVoie == '\0') {
				glong value = atol (FicWav->Voie);
				g_free (FicWav->NewVoie);
				FicWav->NewVoie = NULL;
				if (value != '1' || value != '2' || value != '4') FicWav->NewVoie = g_strdup ("2");
				else					 	  FicWav->NewVoie = g_strdup (FicWav->Voie);
			}
			if (*FicWav->NewBits == '\0') {
				glong value = atol (FicWav->Bits);
				g_free (FicWav->NewBits);
				FicWav->NewBits = NULL;
				if (value != 8 || value != 16 || value != 32 || value != 64) FicWav->NewBits = g_strdup ("16");
				else							     FicWav->NewBits = g_strdup (FicWav->Bits);
			}

			info = (INFO_WAV *)detail->info;
			if (atoi (info->voie) != atoi (FicWav->NewVoie) || atoi (info->hertz) != atoi (FicWav->NewHertz))  {
				conv.total_convert ++;
				conv.total_convert ++;
			}
			if (atoi (info->bits) != atoi (FicWav->NewBits)) {
				conv.total_convert ++;
				conv.total_convert ++;
			}
			conv.total_convert ++;
			conv.total_convert ++;
			
			// g_print ("--> conv.total_convert = %d\n", conv.total_convert);
			
		}
		list = g_list_next (list);
	}

	file_change_parameters_MP3OGG ();
}

void filewavconv_apply (void)
{
	pthread_t nmr_tid;

	PRINT_FUNC_LF();

	NEW_wincontrol_realize_window (&VarFilewavconv.AdrWin, "wind_wav_to_wav", &VarFilewavconv.Bool, WIND_IS_SHOW, WIND_USE_STRUCT, WIND_IS_MODAL, WIND_IS_TRANSIENT);

	VarFilewavconv.AdrLabelTitre    = GTK_WIDGET (XCFA_GET_OBJECT("label_wav_to_wav"));
	VarFilewavconv.AdrLabelCompteur = GTK_WIDGET (XCFA_GET_OBJECT("label_compteur_wav_to_wav"));
	VarFilewavconv.AdrProgressBar   = GTK_WIDGET (XCFA_GET_OBJECT("progressbar_wav_to_wav"));

	gtk_label_set_use_markup (GTK_LABEL (VarFilewavconv.AdrLabelTitre), TRUE);
	gtk_label_set_justify (GTK_LABEL (VarFilewavconv.AdrLabelTitre), GTK_JUSTIFY_CENTER);
	gtk_label_set_markup (GTK_LABEL (VarFilewavconv.AdrLabelTitre),
			"<span font_desc=\"Courier bold 11\"><span color=\"black\"><b>Conversions WAV TO WAV</b></span></span>");
	
	conv_reset_struct ();
	filewavconv_set_flags_before ();

	conv_activate_progressBar (VarFilewavconv.AdrProgressBar);
	
	secu_thread_add ();	
	conv.bool_thread_conv = TRUE;
	conv.handler_timeout_conv = gtk_timeout_add (100, filewavconv_timeout, 0);
 	pthread_create (&nmr_tid, NULL ,(void *)filewavconv_thread, (void *)NULL);

 	utils_puts_statusbar_global (_("Conversion en cours. Veuillez patienter ..."));
}


