 /*
 * file      : file_scan_db.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <pthread.h>

#include "global.h"
#include "utils.h"
#include "config_user.h"
#include "dragNdrop.h"
#include "info_song.h"
#include "file.h"
#include "options.h"
#include "fileselect.h"
#include "popup.h"
#include "level.h"
#include "win_control.h"
#include "win_norm_replay.h"
#include "secu.h"



/*
*---------------------------------------------------------------------------
* VARIABLES: GESTION THREAD & TIMEOUT FOR LEVEL
*---------------------------------------------------------------------------
*/

typedef struct {
	gboolean         bool_etat;
	gchar		*MessUser;
	
	gint             NbrElementsInList;
	gint             ElementActif;
	double           total_percent;
	
	pthread_t        nmr_tid;
	guint            handler_timeout;
	guint            handler_timeout_waiting;
	gboolean         bool_thread_end;

	gboolean         bool_compteur;
	gint             pass_conv;
	
	gboolean         bool_update;
	
} VAR_FILE_SCAN_DB;

VAR_FILE_SCAN_DB VarFileScanDB;

/*
*---------------------------------------------------------------------------
* GESTION THREAD & TIMEOUT FOR LEVEL
*---------------------------------------------------------------------------
*/



static void FileScanDB_thread (void *arg)
{
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;
	GList         *list = NULL;
	/*gint		FicLevelMix = ~((gint)gtk_spin_button_get_value (var_file.AdrSpinbuttonNormalise) -1);*/
	gint		FicLevelMix = (gint)gtk_spin_button_get_value (var_file.AdrSpinbuttonNormalise);
	
 	VarFileScanDB.bool_thread_end = FALSE;

	list = g_list_first (entetefile);
	while (list) {
		
		if ((detail = (DETAIL *)list->data) &&
		    detail->choice_treeview != _TREEVIEW_SPLIT_ &&
		    (fic = (FIC *)detail->fic) &&
		    fic->Etat_Scan == ETAT_SCAN_DEMANDE &&
		    (detail->type_infosong_file_is == FILE_IS_WAV ||
		     detail->type_infosong_file_is == FILE_IS_OGG ||
		     detail->type_infosong_file_is == FILE_IS_MP3)) {
		
			if (detail->type_infosong_file_is == FILE_IS_WAV) {
				
				INFO_WAV *info = (INFO_WAV *)detail->info;

				VarFileScanDB.bool_compteur = TRUE;
				
				fic->LevelMix            = FicLevelMix;
				info->LevelDbfs.NewLevel = FicLevelMix;
				info->LevelDbfs.level    = level_get_from (FILE_IS_WAV, detail->namefile);
				
				fic->Etat_Scan = ETAT_SCAN_OK;
				VarFileScanDB.ElementActif ++;
				VarFileScanDB.bool_compteur = FALSE;
				VarFileScanDB.bool_etat = TRUE;
				VarFileScanDB.bool_update = TRUE;
			}
			else if (detail->type_infosong_file_is == FILE_IS_OGG) {
				
				INFO_OGG *info = (INFO_OGG *)detail->info;
				
				VarFileScanDB.bool_compteur = TRUE;
			
				fic->LevelMix            = FicLevelMix;
				info->LevelDbfs.NewLevel = FicLevelMix;
				info->LevelDbfs.level    = level_get_from (FILE_IS_OGG, detail->namefile);
				
				fic->Etat_Scan = ETAT_SCAN_OK;
				VarFileScanDB.ElementActif ++;
				VarFileScanDB.bool_compteur = FALSE;
				VarFileScanDB.bool_etat = TRUE;
				VarFileScanDB.bool_update = TRUE;
			}
			else if (detail->type_infosong_file_is == FILE_IS_MP3) {
				
				INFO_MP3 *info = (INFO_MP3 *)detail->info;
				
				VarFileScanDB.bool_compteur = TRUE;
			
				fic->LevelMix            = FicLevelMix;
				info->LevelDbfs.NewLevel = FicLevelMix;
				info->LevelDbfs.level    = level_get_from (FILE_IS_MP3, detail->namefile);
				
				fic->Etat_Scan = ETAT_SCAN_OK;
				VarFileScanDB.ElementActif ++;
				VarFileScanDB.bool_compteur = FALSE;
				VarFileScanDB.bool_etat = TRUE;
				VarFileScanDB.bool_update = TRUE;
			}
		}
		list = g_list_next (list);
	} 
	
	VarFileScanDB.bool_thread_end = TRUE;
	secu_thread_sub ();
	pthread_exit(0);
}

static gint FileScanDB_timeout (gpointer data)
{
	if (WinNormReplay_is_get_close () == TRUE) {
		conv_stop_conversion ();
	}
	
	if (level_bool_percent () == TRUE) {
		VarFileScanDB.total_percent = (double)(VarFileScanDB.ElementActif +1) / (double)VarFileScanDB.NbrElementsInList;
		WinNormReplay_set_data_progressBar (VarFileScanDB.total_percent);
	}
	
	if (VarFileScanDB.bool_etat == TRUE) {
		/*WinNormReplay_set_etat (VarFileScanDB.MessUser);*/
		g_free (VarFileScanDB.MessUser);
		VarFileScanDB.MessUser = NULL;
		VarFileScanDB.bool_etat = FALSE;
	}
	
	if (VarFileScanDB.bool_compteur == TRUE) {
		
		gchar *str = NULL;
    		gchar *spinner="|/-\\";
		// gchar *Ptr = NULL;
		gchar  foo [ 2 ];
		
		foo [ 0 ] = spinner[VarFileScanDB.pass_conv++%4];
		foo [ 1 ] = '\0';
		// Ptr = utils_convert_string (foo, TRUE);
		
		str = g_strdup_printf ("<b>En cours: %d sur %d   %s</b>",
					VarFileScanDB.ElementActif +1,
					VarFileScanDB.NbrElementsInList,
					foo
					);
		WinNormReplay_set_compteur (str);
		g_free (str);
		str = NULL;
		// g_free (Ptr);
		// Ptr = NULL;
	}
	
	if (VarFileScanDB.bool_update == TRUE) {
		VarFileScanDB.bool_update = FALSE;
		file_pixbuf_update_glist_file ();
		return (TRUE);
	}
	
	if (VarFileScanDB.bool_thread_end == TRUE) {
		WinNormReplay_close ();
		gtk_timeout_remove (VarFileScanDB.handler_timeout);
		conv_set_struct_not_used ();
	}
	
	return (TRUE);
}

static gint FileScanDB_timeout_waiting (gpointer data)
{
	if (conv_struct_is_used () == FALSE) {
		
		gtk_timeout_remove (VarFileScanDB.handler_timeout_waiting);

		if (file_set_scan () > 0) {
		
			g_snprintf (conv.valuenice ,    4, "%d", options_get_val_nice ());
			
			VarFileScanDB.bool_thread_end = FALSE;
			VarFileScanDB.bool_etat = FALSE;
			VarFileScanDB.NbrElementsInList = 1;
			VarFileScanDB.ElementActif = 0;
			VarFileScanDB.bool_compteur = FALSE;
			VarFileScanDB.pass_conv = -1;
			VarFileScanDB.bool_update = FALSE;
			VarFileScanDB.MessUser = NULL;
			
			/* Tous les fichiers wav, mp3 et ogg sont a scanner */
			/*if (BoolAllScan == TRUE) VarFileScanDB.NbrElementsInList = file_set_scan ();*/
			VarFileScanDB.NbrElementsInList = file_set_scan ();
			
			conv_reset_struct ();
			WinNormReplay_Create ("Scan DB");
			WinNormReplay_reset_progressBar ();
			secu_thread_add ();
			VarFileScanDB.handler_timeout = gtk_timeout_add (100, FileScanDB_timeout, 0);
			pthread_create (&VarFileScanDB.nmr_tid, NULL ,(void *)FileScanDB_thread, (void *)NULL);
		}
	}
	return (TRUE);
}

void FileScanDB_action (gboolean BoolAllScan)
{
	VarFileScanDB.handler_timeout_waiting = gtk_timeout_add (100, FileScanDB_timeout_waiting, 0);
}










