 /*
 * file      : file_expander.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <string.h>
#include <stdlib.h>

#include "utils.h"
#include "global.h"
#include "file.h"
#include <taglib/tag_c.h>


/*
*---------------------------------------------------------------------------
* FILE TAGS
*---------------------------------------------------------------------------
*
* FILE_IS_FLAC
* FILE_IS_MP3
* FILE_IS_OGG
* FILE_IS_MPC
* 
* if (detail->type_infosong_file_is == FILE_IS_FLAC ||
* 	detail->type_infosong_file_is == FILE_IS_MP3 ||
* 	detail->type_infosong_file_is == FILE_IS_OGG ||
* 	detail->type_infosong_file_is == FILE_IS_MPC) {
*/


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
gboolean filexpander_bool_changed_OK = TRUE;

/*
*---------------------------------------------------------------------------
* MODIF WIDGET
*---------------------------------------------------------------------------
*/
/*
	INFO_WAVPACK *info = (INFO_WAVPACK *)detail->info;
	INFO_MPC *info = (INFO_MPC *)detail->info;
	INFO_M4A *info = (INFO_M4A
	INFO_WAV *info = (INFO_WAV
	INFO_MP3 *info = (INFO_MP3
	INFO_OGG *info = (INFO_OGG
	INFO_FLAC *info = (INFO_FLAC
	INFO_SHN *info = (INFO_SHN
	INFO_WMA *info = (INFO_WMA
	INFO_MPC *info = (INFO_MPC
	INFO_APE *info = (INFO_APE
	INFO_WAVPACK *info = (INFO_WAVPACK
	
	TAGS  *tags = (TAGS  *)detail->info->tags;
*/

	/*	
	TAGLIB
		flac
		ogg
		mp3
		mpc
	*/

TAGS *filexpander_get_tag (DETAIL *detail)
{
	INFO_WAV     *infoWAV = NULL;
	INFO_SHN     *infoSHN = NULL;
	INFO_WMA     *infoWMA = NULL;
	INFO_RM      *infoRM  = NULL;
	INFO_DTS     *infoDTS = NULL;
	INFO_AIFF    *infoAIFF = NULL;
	INFO_APE     *infoAPE = NULL;
	
	INFO_FLAC     *infoFLAC = NULL;
	INFO_MP3      *infoMP3 = NULL;
	INFO_OGG      *infoOGG = NULL;
	INFO_M4A      *infoM4A = NULL;
	INFO_AAC      *infoAAC = NULL;
	INFO_MPC      *infoMPC = NULL;
	INFO_WAVPACK  *infoWAVPACK = NULL;
	TAGS          *tags = NULL;
	
	/*if (!detail) return ((TAGS  *)tags);*/
	if (!detail) {
		detail = file_get_line_selected ();
		if (!detail) return ((TAGS  *)tags);
	}
	switch (detail->type_infosong_file_is) {
	case FILE_IS_NONE :
	case FILE_IS_CUE :
	case FILE_IS_WAVPACK_MD5 :
	case FILE_TO_NORMALISE :
	case FILE_TO_NORMALISE_COLLECTIF :
	case FILE_IS_IMG :
	case FILE_IS_HTML :
	case FILE_IS_TXT :
	case FILE_IS_XCFA_GEN_CONF :
	case FILE_TO_REPLAYGAIN :
		break;
		
	case FILE_IS_WAV :
		infoWAV = (INFO_WAV *)detail->info;
		tags = (TAGS  *)infoWAV->tags;
		break;
	case FILE_IS_SHN :
		infoSHN = (INFO_SHN *)detail->info;
		tags = (TAGS  *)infoSHN->tags;
		break;
	case FILE_IS_WMA :
		infoWMA = (INFO_WMA *)detail->info;
		tags = (TAGS  *)infoWMA->tags;
		break;
	case FILE_IS_RM :
		infoRM = (INFO_RM *)detail->info;
		tags = (TAGS  *)infoRM->tags;
		break;
	
	case FILE_IS_DTS :
		infoDTS = (INFO_DTS *)detail->info;
		tags = (TAGS  *)infoDTS->tags;
		break;

	case FILE_IS_AIFF :
		infoAIFF = (INFO_AIFF *)detail->info;
		tags = (TAGS  *)infoDTS->tags;
		break;
	
	case FILE_IS_APE :
		infoAPE = (INFO_APE *)detail->info;
		tags = (TAGS  *)infoAPE->tags;
		break;
	
	case FILE_IS_M4A :
		infoM4A = (INFO_M4A *)detail->info;
		tags = (TAGS  *)infoM4A->tags;
		break;
		
	case FILE_IS_AAC :
		infoAAC = (INFO_AAC *)detail->info;
		tags = (TAGS  *)infoAAC->tags;
		break;
		
	case FILE_IS_WAVPACK :
		infoWAVPACK = (INFO_WAVPACK *)detail->info;
		tags = (TAGS  *)infoWAVPACK->tags;
		break;
	
	/* Fichiers geres par la librairie TagFile */
	
	case FILE_IS_FLAC :
		infoFLAC = (INFO_FLAC *)detail->info;
		tags = (TAGS  *)infoFLAC->tags;
		break;
	case FILE_IS_MP3 :
		infoMP3 = (INFO_MP3 *)detail->info;
		tags = (TAGS  *)infoMP3->tags;
		break;
	case FILE_IS_OGG :
		infoOGG = (INFO_OGG *)detail->info;
		tags = (TAGS  *)infoOGG->tags;
		break;
	case FILE_IS_MPC :
		infoMPC = (INFO_MPC *)detail->info;
		tags = (TAGS  *)infoMPC->tags;
		break;
	}
	return ((TAGS  *)tags);
}

void filexpander_set_entry_tag_album (void)
{
	TAGS	*tags = filexpander_get_tag (NULL);
	gchar	*ptr = NULL;
	gchar	*PtrStr = NULL;

	if (!var_file.Adr_entry_tag_album) return;
	filexpander_bool_changed_OK = FALSE;
	ptr = g_strdup (tags ? tags->Album : "ééé");
	PtrStr = utils_convert_string (tags->Album, TRUE);
	gtk_entry_set_text (GTK_ENTRY (var_file.Adr_entry_tag_album), tags ? tags->Album ?  PtrStr : "" : "");
	g_free (PtrStr);
	PtrStr = NULL;
	filexpander_bool_changed_OK = TRUE;
}
void filexpander_set_entry_tag_title (void)
{
	TAGS	*tags = filexpander_get_tag (NULL);
	gchar	*PtrStr = NULL;

	if (!var_file.Adr_entry_tag_title) return;
	filexpander_bool_changed_OK = FALSE;
	PtrStr = utils_convert_string (tags->Title, TRUE);
	gtk_entry_set_text (GTK_ENTRY (var_file.Adr_entry_tag_title), tags ? tags->Title ?  PtrStr : "" : "");
	g_free (PtrStr);
	PtrStr = NULL;
	filexpander_bool_changed_OK = TRUE;
}
void filexpander_set_entry_tag_artist (void)
{
	TAGS	*tags = filexpander_get_tag (NULL);
	gchar	*PtrStr = NULL;

	if (!var_file.Adr_entry_tag_artist) return;
	filexpander_bool_changed_OK = FALSE;
	PtrStr = utils_convert_string (tags->Artist, TRUE);
	gtk_entry_set_text (GTK_ENTRY (var_file.Adr_entry_tag_artist), tags ? tags->Artist ? PtrStr : "" : "");
	g_free (PtrStr);
	PtrStr = NULL;
	filexpander_bool_changed_OK = TRUE;
}
void filexpander_set_entry_tag_comment (void)
{
	TAGS	*tags = filexpander_get_tag (NULL);
	gchar	*PtrStr = NULL;

	if (!var_file.Adr_entry_tag_comment) return;
	filexpander_bool_changed_OK = FALSE;
	PtrStr = utils_convert_string (tags->Comment, TRUE);
	gtk_entry_set_text (GTK_ENTRY (var_file.Adr_entry_tag_comment), tags ? tags->Comment ? PtrStr : "" : "");
	g_free (PtrStr);
	PtrStr = NULL;
	filexpander_bool_changed_OK = TRUE;
}
void filexpander_set_spinbutton_tag_year (void)
{
	TAGS  *tags = filexpander_get_tag (NULL);
	
	if (!var_file.Adr_spinbutton_tag_year) return;
	if (!tags) return;

	filexpander_bool_changed_OK = FALSE;
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (var_file.Adr_spinbutton_tag_year), (gdouble)tags->IntYear);
	filexpander_bool_changed_OK = TRUE;
}
void filexpander_set_spinbutton_tag_track (void)
{
	TAGS  *tags = filexpander_get_tag (NULL);
	
	if (!var_file.Adr_spinbutton_tag_track) return;
	if (!tags) return;
	filexpander_bool_changed_OK = FALSE;
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (var_file.Adr_spinbutton_tag_track), (gdouble)tags->IntNumber);
	filexpander_bool_changed_OK = TRUE;
}
void filexpander_set_combobox_tag_genre (void)
{
	TAGS  *tags = filexpander_get_tag (NULL);
	
	if (!var_file.Adr_combobox_tag_genre) return;
	if (!tags) return;
	
	filexpander_bool_changed_OK = FALSE;

	gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_tag_genre), infosong_get_elements_combobox (tags->IntGenre));
	filexpander_bool_changed_OK = TRUE;
}
void filexpander_set_label_tag_change (void)
{
	GList         *list = NULL;
	DETAIL        *detail = NULL;
	TAGS          *tags = NULL;
	gchar         *str = NULL;
	gint           changed = 0;
	
	
	if (!var_file.Adr_label_tag_change) return;
	/* SI NOT(tag) return
	*/
	tags = filexpander_get_tag (NULL);
	gtk_widget_set_sensitive (GTK_WIDGET (var_file.Adr_table_tag), tags ? TRUE : FALSE);
	/* IF selected <> 1 THEN RETURN */
	if (!tags) return;

	/*
	* Le nombre total de modifications sera calcule ici
	* 
	* > modif == 0 sensitive->clicked = FALSE
	* > modif >  0 sensitive->clicked = TRUE
	*/
	/*	
	TAGLIB
		flac
		ogg
		mp3
		mpc
	*/
	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			
			/*
			type_infosong_file_is
			FILE_IS_FLAC
			FILE_IS_MP3
			FILE_IS_OGG
			FILE_IS_MPC
			*/
			if (detail->type_infosong_file_is == FILE_IS_FLAC || detail->type_infosong_file_is == FILE_IS_MP3 ||
				detail->type_infosong_file_is == FILE_IS_OGG || detail->type_infosong_file_is == FILE_IS_MPC) {
				
				if ((tags = (TAGS *)filexpander_get_tag (detail)) && tags->bool_save == TRUE) {
					changed ++;
				}
			}
			if ((tags = (TAGS *)filexpander_get_tag (detail))) {
					g_print ("\n");
					g_print ("Album   = %s\n", tags->Album);
					g_print ("Artist  = %s\n", tags->Artist);
					g_print ("Title   = %s\n", tags->Title);
					g_print ("Comment = %s\n", tags->Comment);
					g_print ("Genre   = %s [%d]\n", tags->Genre, tags->IntGenre);
					g_print ("Year    = %s [%d]\n", tags->Year, tags->IntYear);
					g_print ("Number  = %s [%d]\n", tags->Number, tags->IntNumber);
					g_print ("\n");
			}
		}
		list = g_list_next (list);
	}

	gtk_widget_set_sensitive (GTK_WIDGET (var_file.Adr_button_tag_appliquer), changed > 0 ? TRUE : FALSE);
	gtk_label_set_use_markup (GTK_LABEL (var_file.Adr_label_tag_change), TRUE);
	str = g_strdup_printf ("<b>%d</b>", changed);
	gtk_label_set_markup (GTK_LABEL (var_file.Adr_label_tag_change), str);
	g_free (str);
	str = NULL;
	
	file_affiche_type ();
}

/*
*---------------------------------------------------------------------------
* REALIZE && CHANGED
*---------------------------------------------------------------------------
*/

void on_combobox_tag_genre_file_realize (GtkWidget *widget, gpointer user_data)
{
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	infosong_set_elements_combobox (widget);
	gtk_combo_box_set_wrap_width (GTK_COMBO_BOX (widget), 4);
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
	var_file.Adr_combobox_tag_genre = GTK_COMBO_BOX (widget);
}

#define	TAG_GENRE	0
#define	TAG_TRACK	1
#define	TAG_YEAR	2
#define	TAG_COMMENT	3
#define	TAG_ARTIST	4
#define	TAG_ALBUM	5
#define	TAG_TITLE	6

void fileexpander_changed_all_tags (gint TYPE_TAG)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *begin_list = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	TAGS		 *tags = NULL;

	if (!var_file.Adr_TreeView) return;
	if (!var_file.Adr_Tree_Model) return;
	if (!var_file.Adr_Line_Selected) return;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_file.Adr_TreeView));
	begin_list = gtk_tree_selection_get_selected_rows (var_file.Adr_Line_Selected, &model);
	list = g_list_first (begin_list);
	while (list) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (var_file.Adr_Tree_Model, &iter, file_get_pointer_struct (), &detail, -1);
			
			if ((DETAIL *)detail != NULL) {

				switch (TYPE_TAG) {
				case TAG_GENRE :
					if ((tags = filexpander_get_tag (detail)) != NULL) {
						g_free (tags->Genre);
						tags->Genre = NULL;
						tags->Genre = g_strdup ((gchar *)gtk_combo_box_get_active_text (var_file.Adr_combobox_tag_genre));
						tags->IntGenre = infosong_get_num_combobox ((gint)gtk_combo_box_get_active (var_file.Adr_combobox_tag_genre));
						tags_set_flag_modification (tags, TRUE);
						filexpander_set_label_tag_change ();
					}
					break;
				case TAG_TRACK :
					if ((tags = filexpander_get_tag (detail)) != NULL) {
						g_free (tags->Number);
						tags->Number = NULL;
						tags->IntNumber = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(var_file.Adr_spinbutton_tag_track));
						tags->Number    = g_strdup_printf ("%d", tags->IntNumber);
						tags_set_flag_modification (tags, TRUE);
						filexpander_set_label_tag_change ();
					}
					break;
				case TAG_YEAR :
					if ((tags = filexpander_get_tag (detail)) != NULL) {
						g_free (tags->Year);
						tags->Year = NULL;
						tags->IntYear = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(var_file.Adr_spinbutton_tag_year));
						tags->Year    = g_strdup_printf ("%d", tags->IntYear);
						tags_set_flag_modification (tags, TRUE);
						filexpander_set_label_tag_change ();
					}
					break;
				case TAG_COMMENT :
					if ((tags = filexpander_get_tag (detail)) != NULL) {
						g_free (tags->Comment);
						tags->Comment = NULL;
						tags->Comment = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY (var_file.Adr_entry_tag_comment)));
						tags_set_flag_modification (tags, TRUE);
						filexpander_set_label_tag_change ();
					}
					break;
				case TAG_ARTIST :
					if ((tags = filexpander_get_tag (detail)) != NULL) {
						g_free (tags->Artist);
						tags->Artist = NULL;
						tags->Artist = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY (var_file.Adr_entry_tag_artist)));
						tags_set_flag_modification (tags, TRUE);
						filexpander_set_label_tag_change ();
					}
					break;
				case TAG_ALBUM :
					if ((tags = filexpander_get_tag (detail)) != NULL) {
						g_free (tags->Album);
						tags->Album = NULL;
						tags->Album = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY (var_file.Adr_entry_tag_album)));
						tags_set_flag_modification (tags, TRUE);
						filexpander_set_label_tag_change ();
					}
					break;
				case TAG_TITLE :
					if ((tags = filexpander_get_tag (detail)) != NULL) {
						gchar	*str = NULL;
						gchar	*ptr = NULL;
												
						g_free (tags->Title);
						tags->Title = NULL;
						tags->Title = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY (var_file.Adr_entry_tag_title)));
						
						// Suppression du caracteres '/' interdit si il existe
						str = g_strdup (tags->Title);
						if (strchr (str, '/')) {
							while ((ptr = strchr (str, '/'))) {
								strcpy (ptr, ptr+1);
							}
							gtk_entry_set_text (GTK_ENTRY (var_file.Adr_entry_tag_title), str);
						}
						g_free (tags->Title);
						tags->Title = NULL;
						tags->Title = g_strdup (str);
						g_free (str);
						str = NULL;
						
						tags_set_flag_modification (tags, TRUE);
						filexpander_set_label_tag_change ();
					}
					break;
				}
			}
		}
		list = g_list_next (list);
	}
}

void on_combobox_tag_genre_file_changed (GtkEditable *editable, gpointer user_data)
{
/*
	TAGS  *tags = filexpander_get_tag (NULL);
	
	if (!var_file.Adr_combobox_tag_genre) return;
	if(!filexpander_bool_changed_OK) return;
	if (!tags) return;

	g_free (tags->Genre);
	tags->Genre = NULL;
	tags->Genre = g_strdup ((gchar *)gtk_combo_box_get_active_text (var_file.Adr_combobox_tag_genre));
	tags->IntGenre = infosong_get_num_combobox ((gint)gtk_combo_box_get_active (var_file.Adr_combobox_tag_genre));
	tags_set_flag_modification (tags, TRUE);
	filexpander_set_label_tag_change ();
*/
	if (!var_file.Adr_combobox_tag_genre) return;
	if(!filexpander_bool_changed_OK) return;
	fileexpander_changed_all_tags (TAG_GENRE);
}
void on_spinbutton_tag_track_file_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
/*
	TAGS  *tags = filexpander_get_tag (NULL);
	
	if (!var_file.Adr_spinbutton_tag_track) return;
	if(!filexpander_bool_changed_OK) return;
	if (!tags) return;
	
	g_free (tags->Number);
	tags->Number = NULL;
	tags->IntNumber = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(var_file.Adr_spinbutton_tag_track));
	tags->Number    = g_strdup_printf ("%d", tags->IntNumber);

	tags_set_flag_modification (tags, TRUE);
	filexpander_set_label_tag_change ();
*/
	if (!var_file.Adr_spinbutton_tag_track) return;
	if(!filexpander_bool_changed_OK) return;
	fileexpander_changed_all_tags (TAG_TRACK);
}
void on_spinbutton_tag_year_file_changed (GtkSpinButton *spinbutton, gpointer user_data)
{
/*	TAGS  *tags = filexpander_get_tag (NULL);

	if (!var_file.Adr_spinbutton_tag_year) return;
	if(!filexpander_bool_changed_OK) return;
	if (!tags) return;

	g_free (tags->Year);
	tags->Year = NULL;
	tags->IntYear = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(var_file.Adr_spinbutton_tag_year));
	tags->Year    = g_strdup_printf ("%d", tags->IntYear);

	tags_set_flag_modification (tags, TRUE);
	filexpander_set_label_tag_change ();
*/
	if (!var_file.Adr_spinbutton_tag_year) return;
	if(!filexpander_bool_changed_OK) return;
	fileexpander_changed_all_tags (TAG_YEAR);
}
void on_entry_tag_comment_file_changed (GtkEditable *editable, gpointer user_data)
{
/*
	TAGS  *tags = filexpander_get_tag (NULL);
	
	if (!var_file.Adr_entry_tag_comment) return;
	if(!filexpander_bool_changed_OK) return;
	if (!tags) return;
	
	g_free (tags->Comment);
	tags->Comment = NULL;
	tags->Comment = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY (var_file.Adr_entry_tag_comment)));
	
	tags_set_flag_modification (tags, TRUE);
	filexpander_set_label_tag_change ();
*/
	
	if (!var_file.Adr_entry_tag_comment) return;
	if(!filexpander_bool_changed_OK) return;
	fileexpander_changed_all_tags (TAG_COMMENT);
}
void on_entry_tag_artist_file_changed (GtkEditable *editable, gpointer user_data)
{
/*
	TAGS  *tags = filexpander_get_tag (NULL);
	
	if (!var_file.Adr_entry_tag_artist) return;
	if(!filexpander_bool_changed_OK) return;
	if (!tags) return;
	
	g_free (tags->Artist);
	tags->Artist = NULL;
	tags->Artist = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY (var_file.Adr_entry_tag_artist)));
	
	tags_set_flag_modification (tags, TRUE);
	filexpander_set_label_tag_change ();
*/
	if (!var_file.Adr_entry_tag_artist) return;
	if(!filexpander_bool_changed_OK) return;
	fileexpander_changed_all_tags (TAG_ARTIST);
}
void on_entry_tag_album_file_changed (GtkEditable *editable, gpointer user_data)
{
/*
	TAGS  *tags = filexpander_get_tag (NULL);
	
	if (!var_file.Adr_entry_tag_album) return;
	if(!filexpander_bool_changed_OK) return;
	if (!tags) return;
	
	g_free (tags->Album);
	tags->Album = NULL;
	tags->Album = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY (var_file.Adr_entry_tag_album)));
	
	tags_set_flag_modification (tags, TRUE);
	filexpander_set_label_tag_change ();
*/
	if (!var_file.Adr_entry_tag_album) return;
	if(!filexpander_bool_changed_OK) return;
	fileexpander_changed_all_tags (TAG_ALBUM);
}
void on_entry_tag_title_file_changed (GtkEditable *editable, gpointer user_data)
{
/*
	TAGS	*tags = filexpander_get_tag (NULL);
	gchar	*str = NULL;
	gchar	*ptr = NULL;
	
	if (!var_file.Adr_entry_tag_title) return;
	if(!filexpander_bool_changed_OK) return;
	if (!tags) return;
	
	g_free (tags->Title);
	tags->Title = NULL;
	tags->Title = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY (var_file.Adr_entry_tag_title)));
	
	// Suppression du caracteres '/' interdit si il existe
	str = g_strdup (tags->Title);
	if (strchr (str, '/')) {
		while ((ptr = strchr (str, '/'))) {
			strcpy (ptr, ptr+1);
		}
		gtk_entry_set_text (GTK_ENTRY (var_file.Adr_entry_tag_title), str);
	}
	g_free (tags->Title);
	tags->Title = NULL;
	tags->Title = g_strdup (str);
	g_free (str);
	str = NULL;
	
	tags_set_flag_modification (tags, TRUE);
	filexpander_set_label_tag_change ();
*/
	if (!var_file.Adr_entry_tag_title) return;
	if(!filexpander_bool_changed_OK) return;
	fileexpander_changed_all_tags (TAG_TITLE);
}

void on_button_tag_appliquer_clicked (GtkButton *button, gpointer user_data)
{
	TAGS		*tags = filexpander_get_tag (NULL);
	TagLib_File	*file;
	TagLib_Tag	*tag;
	DETAIL		*detail = NULL;
	GList		*list = NULL;
	gchar		*Ptr = NULL;

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			
			if (detail->type_infosong_file_is == FILE_IS_FLAC || detail->type_infosong_file_is == FILE_IS_MP3 ||
				detail->type_infosong_file_is == FILE_IS_OGG || detail->type_infosong_file_is == FILE_IS_MPC) {
				
				if ((tags = (TAGS *)filexpander_get_tag (detail)) && tags->bool_save == TRUE) {
					
					g_print ("\n");
					g_print ("Album   = %s\n", tags->Album);
					g_print ("Artist  = %s\n", tags->Artist);
					g_print ("Title   = %s\n", tags->Title);
					g_print ("Comment = %s\n", tags->Comment);
					g_print ("Genre   = %s [%d]\n", tags->Genre, tags->IntGenre);
					g_print ("Year    = %s [%d]\n", tags->Year, tags->IntYear);
					g_print ("Number  = %s [%d]\n", tags->Number, tags->IntNumber);
					g_print ("\n");

					if ((file = taglib_file_new (detail->namefile))) {
						
						tag = taglib_file_tag(file);
						Ptr = utils_convert_from_utf8 (tags->Title);
						taglib_tag_set_title (tag, Ptr);
						g_free (Ptr);	Ptr = NULL;

						Ptr = utils_convert_from_utf8 (tags->Artist);
						taglib_tag_set_artist (tag, Ptr);
						g_free (Ptr);	Ptr = NULL;

						Ptr = utils_convert_from_utf8 (tags->Album);
						taglib_tag_set_album (tag, Ptr);
						g_free (Ptr);	Ptr = NULL;

						Ptr = utils_convert_from_utf8 (tags->Comment);
						taglib_tag_set_comment (tag, Ptr);
						g_free (Ptr);	Ptr = NULL;

						Ptr = utils_convert_from_utf8 (tags->Genre);
						taglib_tag_set_genre (tag, Ptr);
						g_free (Ptr);	Ptr = NULL;

						taglib_tag_set_year (tag, tags->IntYear);
						taglib_tag_set_track (tag, tags->IntNumber);
						
						taglib_file_save(file);
						
						taglib_tag_free_strings();
						taglib_file_free (file);
					}
					tags->bool_save = FALSE;
				}
			}
		}
		list = g_list_next (list);
	}
	gtk_widget_set_sensitive (GTK_WIDGET (var_file.Adr_button_tag_appliquer), FALSE);
	gtk_label_set_use_markup (GTK_LABEL (var_file.Adr_label_tag_change), TRUE);
	gtk_label_set_markup (GTK_LABEL (var_file.Adr_label_tag_change), "<b>0</b>");

	file_affiche_type ();
}


