 /*
 * file      : conv.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#ifndef __conv_h__
#define __conv_h__ 1

#include <sys/types.h>
#include <signal.h>

typedef enum {
	_EXTRACT_ = 0,					/*  */
	_CONV_						/*  */
} TYPE_OPER;

typedef enum {						/* Les types de conversions possibles */
	NONE_CONV = 0,					/*  */
	FLAC_FLAC_TO_WAV,				/*  */
	FLAC_WAV_TO_FLAC,				/*  */
	LAME_WAV_TO_MP3,				/*  */
	LAME_FLAC_TO_MP3,				/*  */
	OGGENC_WAV_TO_OGG,				/*  */
	OGGENC_FLAC_TO_OGG,				/*  */
	OGG123_OGG_TO_WAV,				/*  */
	MPG321_MP3_TO_WAV,				/*  */
	SOX_WAV_TO_WAV,					/*  */
	SHORTEN_SHN_TO_WAV,				/*  */
	FAAD_M4A_TO_WAV,				/*  */
	FAAC_WAV_TO_M4A,				/*  */
	MPLAYER_WMA_TO_WAV,				/*  */
	MPLAYER_WAV_TO_WAV,				/*  */
	MPLAYER_AUDIO_TO_WAV,				/*  */
	MPLAYER_M4A_TO_WAV,				/*  */
	MPLAYER_OGG_TO_WAV,				/*  */
	MPLAYER_RM_TO_WAV,				/*  */
	MPLAYER_DTS_TO_WAV,				/*  */
	MPLAYER_AIFF_TO_WAV,				/*  */
	COPY_FILE,					/*  */
	NORMALISE_CALCUL,				/*  */
	NORMALISE_APPLIQUE,				/*  */
	NORMALISE_EXEC,					/*  */
	NORMALISE_GET_LEVEL,				/*  */
	MPPDEC_MPC_TO_WAV,				/*  */
	MPPENC_WAV_TO_MPC,				/*  */
	MAC_APE_TO_WAV,					/*  */
	MAC_WAV_TO_APE,					/*  */
	WAVPACK_WAV_TO_WAVPACK,				/*  */
	WVUNPACK_WAVPACK_TO_WAV,			/*  */
	CDPARANOIA_CD_TO_WAV,				/*  */
	CDPARANOIA_CD_TO_WAV_EXPERT,			/*  */
	CDPARANOIA_CD_TO_WAV_EXPERT_SEGMENT,		/*  */
	CDDA2WAV_CD_TO_WAV,				/*  */
	REPLAYGAIN,					/*  */
	LSDVD,						/*  */
	SPLIT,						/*  */
	CDDB_TOOL,					/*  */
	ICEDAX,						/*  */
	AACPLUSENC_WAV_TO_AAC				/*  */
	
} TYPE_CONV;

#define   MAX_LIMITE_NAME 40				/* MAX_LIMITE_NAME caracteres */

typedef enum {						/* WINPULSE POUR LES WMA */
	TYPE_WIN_OPEN = 0,				/* Ouverture fenetre */
	TYPE_WIN_CLOSE,					/* Fermeture fenetre */
	TYPE_WIN_PROGRESS,				/* Progression de la barre */
	TYPE_WIN_NONE					/* Ne rien Faire */
} TYPE_WIN;

typedef struct {
	gchar *str;
} ARGS_TO_EXEC;


typedef struct {
	gboolean       BoolUsed;
	
	GtkWidget     *Adr_wind;			/* Adresse fenetre							*/
	gboolean	Bool;

	GtkWidget     *Adr_label_info_wind;		/* Adresse label information						*/
	GtkWidget     *Adr_label_extract;		/* Adresse label extraction						*/
	GtkWidget     *Adr_progressbar_extract;		/* Adresse Progressbar extraction					*/
	GtkWidget     *Adr_label_conversion;		/* Adresse label conversion */
	GtkWidget     *Adr_progressbar_conversion;	/* Adresse Progressbar conversion					*/
	GtkWidget     *Adr_label_total;			/* Adresse label total */
	GtkWidget     *Adr_progressbar_total;		/* Adresse Progressbar total						*/
	GtkWidget     *Adr_textview;			/* Adresse du Textview							*/
	
	TYPE_OPER      typeoper;			/* Par defaut est egal a _CONV_						*/

	gchar         *name_extract;			/* Nom actuel du fichier en extraction <= MAX_LIMITE_NAME caracteres	*/
	gchar         *name_file;			/* Nom actuel du fichier en conversion <= MAX_LIMITE_NAME caracteres	*/

	TYPE_CONV      type_conv;			/* Type de conversion en cours						*/

	double         extract_percent;			/* Pourcentage actuel de progession					*/
	gint           total_rip;			/* Nombre total de fichiers a extraires					*/
	gint           rip_completed;			/* Nombre de fichiers extraits						*/

	double         conversion_percent;		/* Pourcentage actuel de progession					*/
	gdouble        TimeMplayer;			/* Pourcentage actuel de progession en temps				*/

	gint           total_convert;			/* Nombre total de fichiers a convertir					*/
	gint           encode_completed;		/* Nombre de fichiers convertis						*/
	double         total_percent;			/* Pourcentage TOTAL actuel de progession				*/

	gboolean       BoolPutTextview;			/**/
	GList         *ListPutTextview;			/**/
	
	gboolean       bool_percent_conv;		/* TRUE : print(conversion_percent, total_percent)			*/
	gboolean       bool_percent_extract;		/* TRUE : print(conversion_percent, total_percent)			*/
	gboolean       bool_reset_conv;			/* Force reset with 'conversion_percent = 0.0 '				*/
	gboolean       bool_reset_extract;		/* Force reset with 'conversion_percent = 0.0 '				*/
	gboolean       bool_set_log_wvunpack;		/* */
	gboolean       bool_set_log_wavpack;		/* */
	
	gboolean       BoolPercentCdparanoia;		/* */
	gboolean       BoolPercentCdda2wav;		/* */
	gboolean       BoolPercentWav;			/* */
	gboolean       BoolPercentFlac;			/* */
	gboolean       BoolPercentApe;			/* */
	gboolean       BoolPercentWavPack;		/* */
	gboolean       BoolPercentOgg;			/* */
	gboolean       BoolPercentM4a;			/* */
	gboolean       BoolPercentMpc;			/* */
	gboolean       BoolPercentMp3;			/* */
	
	gboolean       bool_stop;			/* TRUE : stop thread and timeout					*/

	gchar         *TmpRep;				/* Le repertoire temporaire d'extractions/conversions			*/

	pid_t          code_fork_conv;			/* Num Code Fork							*/
	pid_t          code_fork_extract;		/* Num Code Fork							*/

	guint          handler_timeout_conv;		/* Numerate timeout							*/
	gboolean       bool_thread_conv;		/* TRUE : thread in							*/
	gboolean       bool_thread_extract;		/* TRUE : thread in							*/

	int            signal_numchildren_conv;		/* the signal handler							*/
	int            signal_numchildren_extract;	/* the signal handler							*/
	int            tube_conv [ 2 ];			/* for pipe								*/
	int            tube_extract [ 2 ];		/* for pipe								*/

	gchar          valuenice [ 4 ];			/* niveau de gentilesse							*/
	/*gchar          bitratelame [ 60 ];*/		/* valeur du bitrate							*/
	/*gchar          modelame [ 60 ];*/			/* mode lame								*/
	/*gchar          bitrateoggenc [ 60 ];*/		/* valeur du bitrate							*/

	gboolean       Bool_artist_tag;			/* TRUE if set tag artist						*/
	gboolean       Bool_title_tag;			/* TRUE if set tag title						*/
	gboolean       Bool_album_tag;			/* TRUE if set tag album						*/
	gboolean       Bool_numerate_tag;		/* TRUE if set tag numerate						*/
	gboolean       Bool_genre_tag;			/* TRUE if set tag genre						*/
	gboolean       Bool_year_tag;			/* TRUE if set tag year							*/
	gboolean       Bool_comment_tag;		/* TRUE if set tag comment						*/
	
	gboolean       Bool_MAJ_select;			/* TRUE */

	ARGS_TO_EXEC  *ArgConv;				/* */
	ARGS_TO_EXEC  *ArgExtract;			/* */
	double         value_PEAK_RMS_GROUP_ARGS;	/* */

} CONV;

extern CONV conv;

gchar        *conv_get_BufResultCddbTool (void);
void          conv_remove_BufResultCddbTool (void);

void          conv_set_type_oper (TYPE_OPER typeoper);
void          conv_stop_conversion (void);
void          conv_create_window_extract (gchar *title_wind, gboolean BoolModeExpert);
void          conv_create_window (gchar *title_wind);
void          conv_close_window (void);
void          conv_activate_progressBar (GtkWidget *Adr_Progressbar);
void          conv_set_data_progressBar (GtkWidget *Adr_Progressbar, double Etat);
gboolean      conv_copy_src_to_dest (gchar *filesrc, gchar *filedest);
void          conv_product_name_for_label_extract (gchar *NameFile);
void          conv_product_name_for_label (gchar *NameFile);
gchar        *conv_remove_name_for_label_extract (TYPE_OPER typename);
gchar        *conv_remove_name_for_label (TYPE_OPER typename);
void          conv_reset_struct (void);
void          conv_set_struct_not_used (void);
gboolean      conv_struct_is_used (void);
void          conv_set_label_extract (void);
void          conv_set_label_conversion (void);
void          conv_set_label_total (TYPE_OPER type);
GList        *conv_with_lsdvd_get_param (gchar *pathdev);
GList        *conv_with_glist_sox_get_param (GList *p_list, gchar *filedest);
GList        *conv_with_sox_float_get_param (gchar *filesrc, gchar *filedest);
GList        *conv_with_sox_get_param (gchar *filesrc, gchar *filedest, gchar *frequence, gchar *voie, gchar *bits);
ARGS_TO_EXEC *conv_alloc_arg (GList *p_list);
gint          conv_g_list_length (GList *p_list, gint *p_NbrList);
gboolean      conv_exec (gboolean WithParameter, TYPE_CONV type_conv, GList *p_list, gchar *info);
gboolean      conv_exec_extract (gboolean WithParameter, TYPE_CONV type_conv, GList *p_list, gchar *info);
gboolean      conv_bash (gchar *PathNameFileBash);
GList        *conv_with_normalise_get_param (gchar *filesrc, gboolean bool_fix, gint value_fix);
void          conv_inc_rip_completed (void);
void          conv_inc_encode_completed (void);

#endif


