 /*
 * file      : cd_expander.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <string.h>
#include <stdlib.h>

#include "utils.h"
#include "global.h"
#include "file.h"
#include "cd_audio.h"
#include "config_user.h"
#include "parse.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/*
*---------------------------------------------------------------------------
* DEFINITION TITRES CD-AUDIO
*---------------------------------------------------------------------------
*/
gboolean Bool_Changed_Ok = TRUE;

/*
*---------------------------------------------------------------------------
* MODIF WIDGET
*---------------------------------------------------------------------------
*/
void cdexpander_set_sensitive_notebook (void)
{
	AUDIO            *Audio = NULL;
	
	if (!var_cd.Adr_notebook) return;
	Audio = cdaudio_get_line_selected ();
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("table_tags_expanderCD")), Audio ? TRUE : FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("vbox_titres_expanderCD")), Audio ? TRUE : FALSE);
	
	/*
	if (!Audio) return;
	vbox_action_expanderCD
	table_tags_expanderCD
	vbox_titres_expanderCD
	*/
}

void cdexpander_set_entry_tag_titre_album (void)
{
	AUDIO            *Audio = NULL;
	
	if (!var_cd.Adr_entry_tag_titre_album) return;
	if ((Audio = cdaudio_get_line_selected ())) {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_album), Audio->tags->Album);
		Bool_Changed_Ok = TRUE;
	}
	else {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_album), "");
		Bool_Changed_Ok = TRUE;
	}
}
void cdexpander_set_entry_tag_nom_artiste (void)
{
	AUDIO            *Audio = NULL;
	
	if (!var_cd.Adr_entry_tag_nom_artiste) return;
	if ((Audio = cdaudio_get_line_selected ())) {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_nom_artiste), Audio->tags->Artist);
		Bool_Changed_Ok = TRUE;
	}
	else {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_nom_artiste), "");
		Bool_Changed_Ok = TRUE;
	}
}

void cdexpander_set_spinbutton_tag_piste (void)
{
	AUDIO        *Audio = NULL;
	
	if ((Audio = cdaudio_get_line_selected ()) && var_cd.Adr_spinbutton_tag_piste) {
		Bool_Changed_Ok = FALSE;
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (var_cd.Adr_spinbutton_tag_piste), (gdouble)Audio->tags->IntNumber);
		Bool_Changed_Ok = TRUE;
	}
}

void cdexpander_set_spinbutton_tag_annee (void)
{
	AUDIO        *Audio = NULL;
	
	if ((Audio = cdaudio_get_line_selected ()) && var_cd.Adr_spinbutton_tag_annee) {
		Bool_Changed_Ok = FALSE;
		gtk_spin_button_set_value (GTK_SPIN_BUTTON (var_cd.Adr_spinbutton_tag_annee), (gdouble)Audio->tags->IntYear);
		Bool_Changed_Ok = TRUE;
	}
}
gint cdexpander_get_spinbutton_tag_annee (void)
{
	if (var_cd.Adr_spinbutton_tag_annee) {
		return (gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(var_cd.Adr_spinbutton_tag_annee)));
	}
	return (0);
}
void cdexpander_set_entry_tag_titre_chanson (void)
{
	AUDIO            *Audio = NULL;
	
	if ((Audio = cdaudio_get_line_selected ()) && var_cd.Adr_entry_tag_titre_chanson) {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_chanson), Audio->tags->Title);
		Bool_Changed_Ok = TRUE;		
	}
	else {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_chanson), "");
		Bool_Changed_Ok = TRUE;
	}
}
void cdexpander_set_new_genre (void)
{
	AUDIO            *Audio = NULL;

	if ((Audio = cdaudio_get_line_selected ()) && var_cd.Adr_combobox_tag_genre_cd) {
		Bool_Changed_Ok = FALSE;
		gtk_combo_box_set_active (GTK_COMBO_BOX (var_cd.Adr_combobox_tag_genre_cd), infosong_get_elements_combobox (Audio->tags->IntGenre));
		Bool_Changed_Ok = TRUE;
	}
}
void cdexpander_set_entry_new_titre_cdaudio (gchar *p_str)
{
	if (var_cd.Adr_entry_new_titre_cdaudio && p_str) {
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio), p_str);
	}
}
void cdexpander_set_entry_tag_commentaire (void)
{
	AUDIO            *Audio = NULL;
	
	if ((Audio = cdaudio_get_line_selected ()) && var_cd.Adr_entry_tag_commentaire) {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_commentaire), Audio->tags->Comment);
		Bool_Changed_Ok = TRUE;		
	}
	else {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_commentaire), "");
		Bool_Changed_Ok = TRUE;
	}
}

void cdexpander_set_entry_tag_titre_fichier_m3u (void)
{
	if (Bool_Changed_Ok == FALSE) return;
	if (var_cd.Adr_entry_tag_titre_fichier) {
		Bool_Changed_Ok = FALSE;
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_fichier), Config_User.Name_file_m3u ? Config_User.Name_file_m3u : "");
		Bool_Changed_Ok = TRUE;		
	}
}


/* FROM CALLBACKS.C CHANGED
*/

void cdexpander_entry_tag_titre_chanson_changed (void)
{
	gchar        *ptr_template = NULL;
	AUDIO        *Audio = NULL;
	gchar        *str = NULL;
	gchar        *ptr = NULL;
	
	if (!var_cd.Adr_entry_tag_titre_chanson) return;
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_chanson));
	
	/* Suppression du caracteres '/' interdit si il existe */
	str = g_strdup (ptr_template);
	if (strchr (str, '/')) {
		while ((ptr = strchr (str, '/'))) {
			strcpy (ptr, ptr+1);
		}
		gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_chanson), str);
	}
	g_free (str);
	str = NULL;
	
	if (Bool_Changed_Ok == FALSE) return;
	if ((Audio = cdaudio_get_line_selected ())) {
		g_free (Audio->tags->Title);
		Audio->tags->Title = NULL;
		Audio->tags->Title = g_strdup (ptr_template);
	}
	cdaudio_set_titre_chanson ();
}
void cdexpander_entry_tag_titre_album_changed (void)
{
	gint          Num_cell = 0;
	gboolean      valid;
	GtkTreeIter   iter;
	GList        *List = NULL;
	gchar        *ptr_template = NULL;
	AUDIO        *Audio = NULL;
	
	if (!var_cd.Adr_entry_tag_titre_album) return;
	if (Bool_Changed_Ok == FALSE) return;
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_album));

	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
		if ((Audio = (AUDIO *)List->data)) {
			g_free (Audio->tags->Album);
			Audio->tags->Album = NULL;
			Audio->tags->Album = g_strdup (ptr_template);
		}
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
		Num_cell ++;
	}

	cdaudio_set_titre_chanson ();
}
void cdexpander_entry_tag_nom_artiste_changed (void)
{
	gint          Num_cell = 0;
	gboolean      valid;
	GtkTreeIter   iter;
	GList        *List = NULL;
	gchar        *ptr_template = NULL;
	AUDIO        *Audio = NULL;
	
	if (!var_cd.Adr_entry_tag_nom_artiste) return;
	if (Bool_Changed_Ok == FALSE) return;
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_tag_nom_artiste));
	
	if (EnteteCD.BoolMultiArtiste == TRUE) {
		if ((Audio = cdaudio_get_line_selected ())) {
			g_free (Audio->tags->Artist);
			Audio->tags->Artist = NULL;
			Audio->tags->Artist = g_strdup (ptr_template);
		}
	}
	else {
		valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
		while (valid) {
			List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
			if ((Audio = (AUDIO *)List->data)) {
				g_free (Audio->tags->Artist);
				Audio->tags->Artist = NULL;
				Audio->tags->Artist = g_strdup (ptr_template);
			}
			valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
			Num_cell ++;
		}
	}
	cdaudio_set_titre_chanson ();
}

void cdexpander_entry_copy_tag_commentaire (void)
{
	gchar        *ptr_template = NULL;
	
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_tag_commentaire));
	if (EnteteCD.StrMemoTagComment != NULL) {
		g_free (EnteteCD.StrMemoTagComment);
		EnteteCD.StrMemoTagComment = NULL;
	}
	EnteteCD.StrMemoTagComment = g_strdup (ptr_template);
	
	cdaudio_set_flag_buttons_audio_cd ();
}
void cdexpander_entry_paste_tag_commentaire (void)
{
	gint          Num_cell = 0;
	gboolean      valid;
	GtkTreeIter   iter;
	GList        *List = NULL;
	AUDIO        *Audio = NULL;
	
	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
		if ((Audio = (AUDIO *)List->data)) {
			g_free (Audio->tags->Comment);
			Audio->tags->Comment = NULL;
			Audio->tags->Comment = g_strdup (EnteteCD.StrMemoTagComment);
		}
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
		Num_cell ++;
	}
	gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_tag_commentaire), EnteteCD.StrMemoTagComment);
	cdaudio_set_titre_chanson ();
}

void cdexpander_entry_tag_commentaire_changed (void)
{
	gint          Num_cell = 0;
	gboolean      valid;
	GtkTreeIter   iter;
	GList        *List = NULL;
	gchar        *ptr_template = NULL;
	AUDIO        *Audio = NULL;
	
	if (!var_cd.Adr_entry_tag_commentaire) return;
	if (Bool_Changed_Ok == FALSE) return;
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_tag_commentaire));
		
	if (EnteteCD.BoolMultiArtiste == TRUE) {
		if ((Audio = cdaudio_get_line_selected ())) {
			g_free (Audio->tags->Comment);
			Audio->tags->Comment = NULL;
			Audio->tags->Comment = g_strdup (ptr_template);
		}
	}
	else {
		valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
		while (valid) {
			List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
			if ((Audio = (AUDIO *)List->data)) {
				g_free (Audio->tags->Comment);
				Audio->tags->Comment = NULL;
				Audio->tags->Comment = g_strdup (ptr_template);
			}
			valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
			Num_cell ++;
		}
	}
	cdaudio_set_titre_chanson ();
}
void cdexpander_spinbutton_tag_annee_value_changed (void)
{
	gint          Num_cell = 0;
	gboolean      valid;
	GtkTreeIter   iter;
	GList        *List = NULL;
	AUDIO        *Audio = NULL;
	gint          Value;
	
	if (!var_cd.Adr_spinbutton_tag_annee) return;
	Value = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(var_cd.Adr_spinbutton_tag_annee));
	
	if (EnteteCD.BoolMultiArtiste == TRUE) {
		if ((Audio = cdaudio_get_line_selected ())) {
			g_free (Audio->tags->Year);
			Audio->tags->Year = NULL;
			Audio->tags->Year = g_strdup_printf ("%d", Value);
			Audio->tags->IntYear = Value;
		}
	}
	else {
		valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
		while (valid) {
			List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
			if ((Audio = (AUDIO *)List->data)) {
				g_free (Audio->tags->Year);
				Audio->tags->Year = NULL;
				Audio->tags->Year = g_strdup_printf ("%d", Value);
				Audio->tags->IntYear = Value;
			}
			valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
			Num_cell ++;
		}
	}
	cdaudio_set_titre_chanson ();
}
void cdexpander_spinbutton_tag_piste_value_changed (void)
{
	AUDIO        *Audio = NULL;
	gint          Value;
	
	if (!var_cd.Adr_spinbutton_tag_piste) return;
	Value = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(var_cd.Adr_spinbutton_tag_piste));
	
		if ((Audio = cdaudio_get_line_selected ())) {
			g_free (Audio->tags->Number);
			Audio->tags->Number = NULL;
			Audio->tags->Number = g_strdup_printf ("%d", Value);
			Audio->tags->IntNumber = Value;
		}
	cdaudio_set_titre_chanson ();
}
void cdexpander_entry_tag_titre_fichier_m3u_changed (void)
{
	if (Bool_Changed_Ok == FALSE) return;
	if (var_cd.Adr_entry_tag_titre_fichier) {
		g_free (Config_User.Name_file_m3u);
		Config_User.Name_file_m3u = NULL;
		Config_User.Name_file_m3u = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_tag_titre_fichier)));
		
		if (strstr (gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio)), "%f") == NULL) {

			gchar *Str = NULL;
		
			Str = g_strdup_printf ("%s %%f", gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio)));
			gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio), Str);
			g_free (Str);
			Str = NULL;
		}
	}
}
void cdexpander_combobox_tag_genre_cd_changed (void)
{
	gint          Num_cell = 0;
	gboolean      valid;
	GtkTreeIter   iter;
	GList        *List = NULL;
	gchar        *ptr_template = NULL;
	AUDIO        *Audio = NULL;
	gint          IntGenre;
	
	if (!var_cd.Adr_combobox_tag_genre_cd) return;
	
	IntGenre = gtk_combo_box_get_active (var_cd.Adr_combobox_tag_genre_cd);
	ptr_template = (gchar *)gtk_combo_box_get_active_text (var_cd.Adr_combobox_tag_genre_cd);

	if (EnteteCD.BoolMultiArtiste == TRUE) {
		if ((Audio = cdaudio_get_line_selected ())) {
			g_free (Audio->tags->Genre);
			Audio->tags->Genre = NULL;
			Audio->tags->Genre = g_strdup (ptr_template);
			Audio->tags->IntGenre = infosong_get_num_combobox (IntGenre);
		}
	}
	else {
		valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
		while (valid) {
			List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
			if ((Audio = (AUDIO *)List->data)) {
				g_free (Audio->tags->Genre);
				Audio->tags->Genre = NULL;
				Audio->tags->Genre = g_strdup (ptr_template);
				Audio->tags->IntGenre = infosong_get_num_combobox (IntGenre);
			}
			valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
			Num_cell ++;
		}
	}
	cdaudio_set_titre_chanson ();
}

gboolean cdexpander_bool_entree_cd_verif_car = TRUE;
void cdexpander_entry_new_titre_cdaudio_changed (void)
{
	if (cdexpander_bool_entree_cd_verif_car == FALSE) return;
	
	if (var_cd.Adr_entry_new_titre_cdaudio != NULL) {
		gchar	*StrVerif = NULL;
		gchar	*ptr = NULL;
		
		// PRINT_FUNC_LF();
		
		// LA CARACTERE / EST INTERDIT
		StrVerif = g_strdup ((gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio)));
		if (strchr (StrVerif, '/')) {
			cdexpander_bool_entree_cd_verif_car = FALSE;
			while ((ptr = strchr (StrVerif, '/'))) {
				strcpy (ptr, ptr+1);
			}
			gtk_entry_set_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio), StrVerif);
			cdexpander_bool_entree_cd_verif_car = TRUE;
		}
		g_free (StrVerif);
		StrVerif = NULL;
		
		Parse_entry (PARSE_TYPE_TITLE_CD);

		cdaudio_set_titre_chanson ();
	}
}

/* FROM CALLBACKS.C REALIZE
*/

void cdexpander_expander_cd_realize (GtkWidget *widget)
{
	var_cd.Adr_Expander = widget;
}
void cdexpander_notebook_expander_cd_realize (GtkWidget *widget)
{
	var_cd.Adr_notebook = widget;
}
void cdexpander_entry_tag_titre_chanson_realize (GtkWidget *widget)
{
	var_cd.Adr_entry_tag_titre_chanson = widget;
}
void cdexpander_entry_tag_titre_album_realize (GtkWidget *widget)
{
	var_cd.Adr_entry_tag_titre_album = widget;
}
void cdexpander_entry_tag_nom_artiste_realize (GtkWidget *widget)
{
	var_cd.Adr_entry_tag_nom_artiste = widget;
}
void cdexpander_entry_tag_commentaire_realize (GtkWidget *widget)
{
	var_cd.Adr_entry_tag_commentaire = widget;
}
void cdexpander_spinbutton_tag_annee_realize (GtkWidget *widget)
{
	var_cd.Adr_spinbutton_tag_annee = widget;
}
void cdexpander_spinbutton_tag_piste_realize (GtkWidget *widget)
{
	var_cd.Adr_spinbutton_tag_piste = widget;
}
void cdexpander_entry_tag_titre_fichier_m3u_realize (GtkWidget *widget)
{
	var_cd.Adr_entry_tag_titre_fichier = widget;
}
void cdexpander_combobox_tag_genre_cd_realize (GtkWidget *widget)
{
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	infosong_set_elements_combobox (widget);
	gtk_combo_box_set_wrap_width (GTK_COMBO_BOX (widget), 4);
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
	var_cd.Adr_combobox_tag_genre_cd = GTK_COMBO_BOX (widget);
}
void cdexpander_entry_new_titre_cdaudio_realize (GtkWidget *widget)
{
	var_cd.Adr_entry_new_titre_cdaudio = widget;
	gtk_entry_set_text (GTK_ENTRY (widget), Config_User.Templates_title_cdaudio);
	var_cd.Bool_create_file_m3u = FALSE;
	var_cd.Pathname_m3u = NULL;
}


