 /*
 * file      : callbacks.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __callbacks_h__
#define __callbacks_h__ 1


#include <gtk/gtk.h>

/*
*---------------------------------------------------------------------------
* WIND MAIN
*---------------------------------------------------------------------------
*/

gboolean on_wind_main_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_wind_main_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_wind_main_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);

/*
*---------------------------------------------------------------------------
* WIND MAIN -> MENU
*---------------------------------------------------------------------------
*/

/* MENU FICHIERS */

void on_quitter1_activate (GtkMenuItem *menuitem, gpointer user_data);

/* MENU ONGLETS */

void on_dvd_audio1_activate (GtkMenuItem *menuitem, gpointer user_data);
void on_cd_audio1_activate (GtkMenuItem *menuitem, gpointer user_data);
void on_fichiers1_activate (GtkMenuItem *menuitem, gpointer user_data);
void on_wav1_activate (GtkMenuItem *menuitem, gpointer user_data);
void on_analyse_mp3_ogg1_activate (GtkMenuItem *menuitem, gpointer user_data);
void on_tags1_activate (GtkMenuItem *menuitem, gpointer user_data);
void on_logs1_activate (GtkMenuItem *menuitem, gpointer user_data);
void on_options1_activate (GtkMenuItem *menuitem, gpointer user_data);
void on_expert2_activate (GtkMenuItem *menuitem, gpointer user_data);

void on_select_popup_tongle_activate (GtkMenuItem *menuitem, gpointer user_data);

/* MENU OUTILS */

void on_applications_externes_activate (GtkMenuItem *menuitem, gpointer user_data);
void on_preferences1_activate (GtkMenuItem *menuitem, gpointer user_data);

/* MENU AIDE */

void on_le_site_d_xcfa1_activate (GtkMenuItem *menuitem, gpointer user_data);
void on_a_propos1_activate (GtkMenuItem *menuitem, gpointer user_data);

/*
*---------------------------------------------------------------------------
* ONGLET CD-AUDIO
*---------------------------------------------------------------------------
*/

void on_button_cancel_cddb_clicked (GtkButton *button, gpointer user_data);
void on_button_cancel_cddb_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_peripherique_cd_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_peripherique_cd_realize (GtkWidget *widget, gpointer user_data);
void on_button_destination_cd_clicked (GtkButton *button, gpointer user_data);
void on_scrolledwindow_cd_realize (GtkWidget *widget, gpointer user_data);
void on_label_duree_cd_realize (GtkWidget *widget, gpointer user_data);
void on_label_titre_cd_realize (GtkWidget *widget, gpointer user_data);
void on_progressbar_cd_audio_realize (GtkWidget *widget, gpointer user_data);
void on_button_destination_cd_realize (GtkWidget *widget, gpointer user_data);
void on_cdaudio_combobox_serveur_cd_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_serveur_cd_changed (GtkComboBox *combobox, gpointer user_data);
void on_eventbox_action_realize (GtkWidget *widget, gpointer user_data);
void on_cdaudio_combobox_action_realize (GtkWidget *widget,  gpointer user_data);
void on_cdaudio_combobox_action_changed (GtkComboBox *combobox, gpointer user_data);
void on_button_rafraichir_cd_realize (GtkWidget *widget, gpointer user_data);
void on_button_rafraichir_cd_clicked (GtkButton *button, gpointer user_data);
void on_frame_action_cd_realize (GtkWidget *widget, gpointer user_data);
void on_button_applique_change_realize (GtkWidget *widget, gpointer user_data);
void on_button_applique_change_clicked (GtkButton *button, gpointer user_data);

/*
*---------------------------------------------------------------------------
* ONGLET FICHIER
*---------------------------------------------------------------------------
*/

void on_file_scrolledwindow_file_realize (GtkWidget *widget, gpointer user_data);
void on_button_import_file_clicked (GtkButton *button, gpointer user_data);
void on_file_button_del_file_clicked (GtkButton *button, gpointer user_data);
void on_label_number_files_realize (GtkWidget *widget, gpointer user_data);
void on_button_normalyse_file_clicked (GtkButton *button, gpointer user_data);
void on_button_normalyse_file_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_dest_file_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_dest_file_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_select_type_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_select_type_changed (GtkComboBox *combobox, gpointer user_data);
void on_button_apply_file_clicked (GtkButton *button, gpointer user_data);

/*
*---------------------------------------------------------------------------
* ONGLET ANALYZE WAV
*---------------------------------------------------------------------------
*/

void on_spinbutton_frequence_wav_realize (GtkWidget *widget, gpointer user_data);
void on_filewav_spinbutton_frequence_value_changed (GtkSpinButton *spinbutton, gpointer user_data);


/*
*---------------------------------------------------------------------------
* ONGLET ANALYZE MP3 OGG
*---------------------------------------------------------------------------
*/

void on_filemp3ogg_button_efface_bitrate_clicked (GtkButton *button, gpointer user_data);


/*
*---------------------------------------------------------------------------
* ONGLET OPTIONS
*---------------------------------------------------------------------------
*/

void on_scrolledwindow_applications_externes_realize (GtkWidget *widget, gpointer user_data);
void on_button_scan_clicked (GtkButton *button, gpointer user_data);
void on_button_scan_without_deb_clicked (GtkButton *button, gpointer user_data);
void on_combobox_nice_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_nice_changed (GtkComboBox *combobox, gpointer user_data);

void on_combobox_lame_type_bitrate_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_lame_type_bitrate_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_lame_abr_cbr_vbr_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_lame_abr_cbr_vbr_changed (GtkComboBox *combobox, gpointer user_data);

void on_combobox_lame_mode_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_lame_mode_changed (GtkComboBox *combobox, gpointer user_data);

void on_combobox_mppenc_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_mppenc_changed (GtkComboBox *combobox, gpointer user_data);

void on_combobox_wavpack_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_wavpack_sound_realize (GtkWidget *widget, gpointer user_data);

void on_combobox_wavpack_mode_hybride_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_wavpack_mode_hybride_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_wavpack_fichier_de_correction_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_wavpack_compression_maximum_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_wavpack_signature_md5_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_wavpack_extra_encoding_realize (GtkWidget *widget, gpointer user_data);

void on_combobox_wavpack_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_wavpack_sound_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_wavpack_fichier_de_correction_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_wavpack_compression_maximum_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_wavpack_signature_md5_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_wavpack_extra_encoding_changed (GtkComboBox *combobox, gpointer user_data);

void on_combobox_oggenc_bitrate_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_oggenc_bitrate_changed (GtkComboBox *combobox, gpointer user_data);
void on_eventbox_combobox_oggenc_managed_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_oggenc_managed_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_oggenc_managed_changed (GtkComboBox *combobox, gpointer user_data);
void on_eventbox_combobox_oggenc_downmix_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_oggenc_downmix_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_oggenc_downmix_changed (GtkComboBox *combobox, gpointer user_data);

void on_radiobutton_cdparanoia_realize (GtkWidget *widget, gpointer user_data);
void on_radiobutton_ioctl_realize (GtkWidget *widget, gpointer user_data);
void on_eventbox_flac_compression_realize (GtkWidget *widget, gpointer user_data);
void on_options_combobox_flac_compression_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_flac_compression_changed (GtkComboBox *combobox, gpointer user_data);
void on_eventbox_combobox_ape_compression_realize (GtkWidget *widget,  gpointer user_data);
void on_combobox_ape_compression_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_ape_compression_changed (GtkComboBox *combobox, gpointer user_data);
void  on_button_defaut_convertisseur_clicked (GtkButton *button, gpointer user_data);


/*
*---------------------------------------------------------------------------
* ONGLET POCHETTE
*---------------------------------------------------------------------------
*/

/* Callbacks Preview Image */
void on_image_preview_realize (GtkWidget *widget, gpointer user_data);
void on_button_path_image_preview_realize (GtkWidget *widget, gpointer user_data);
void on_button_path_image_preview_clicked (GtkButton *button, gpointer user_data);
void on_togglebutton_recto_realize (GtkWidget *widget, gpointer user_data);
void on_togglebutton_recto_clicked (GtkButton *button, gpointer user_data);
void on_togglebutton_verso_realize (GtkWidget *widget, gpointer user_data);
void on_togglebutton_verso_clicked (GtkButton *button, gpointer user_data);
void on_combobox_zoom_choiximage_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_zoom_choiximage_changed (GtkComboBox *combobox, gpointer user_data);
void on_button_load_choiximage_clicked (GtkButton *button, gpointer user_data);
void on_togglebutton_remove_realize (GtkWidget *widget, gpointer user_data);
void on_togglebutton_remove_clicked (GtkButton *button, gpointer user_data);
void on_viewport_image_preview_realize (GtkWidget *widget, gpointer user_data);

/* Titre volume cd-audio */
void on_comboboxentry_cdaudio_realize (GtkWidget *widget, gpointer user_data);

void on_entry_name_volume_cdaudio_realize (GtkWidget *widget, gpointer user_data);
void on_entry_name_volume_cdaudio_changed (GtkEditable *editable, gpointer user_data);
void on_button_get_from_web_clicked (GtkButton *button, gpointer user_data);
void on_button_get_title_cdaudio_clicked (GtkButton *button, gpointer user_data);

/* recto */
gboolean on_spinbutton_zoom_recto_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
gboolean on_spinbutton_zoom_recto_button_release_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
void on_spinbutton_zoom_recto_value_changed (GtkSpinButton *spinbutton, gpointer user_data);

/* verso */
gboolean on_spinbutton_zoom_verso_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
gboolean on_spinbutton_zoom_verso_button_release_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
void on_spinbutton_zoom_verso_value_changed (GtkSpinButton *spinbutton, gpointer user_data);

/* Titre */
void on_entry_titre_ps_realize (GtkWidget *widget, gpointer user_data);
void on_entry_titre_ps_changed (GtkEditable *editable, gpointer user_data);
void on_combobox_entry_title_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_entry_title_changed (GtkComboBox *combobox, gpointer user_data);

/* Pied de page */
void on_entry_foottext_ps_realize (GtkWidget *widget, gpointer user_data);
void on_entry_foottext_ps_changed (GtkEditable *editable, gpointer user_data);
void on_combobox_foottext_ps_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_foottext_ps_changed (GtkComboBox *combobox, gpointer user_data);

/* Texte */
void on_combobox_text_recto_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_text_recto_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_text_verso_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_text_verso_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_link_fields_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_link_fields_changed (GtkComboBox *combobox, gpointer user_data);
void on_button_liste_numerate_realize (GtkWidget *widget, gpointer user_data);
void on_button_liste_numerate_clicked (GtkButton *button, gpointer user_data);
void on_button_importation_titre_cd_realize (GtkWidget *widget, gpointer user_data);
void on_button_importation_titre_cd_clicked (GtkButton *button, gpointer user_data);
void on_textview_text_poche_realize (GtkWidget *widget, gpointer user_data);
void on_textview_text_poche_drag_data_received
                                        (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gint             x,
                                        gint             y,
                                        GtkSelectionData *data,
                                        guint            info,
                                        guint            time,
                                        gpointer         user_data);


/* Choix, preview, make fichier PostScript */

void on_button_preview_postscript_clicked (GtkButton *button, gpointer user_data);
void on_combobox_choice_preview_postscript_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_choice_preview_postscript_changed (GtkComboBox *combobox, gpointer user_data);
void on_eventbox_combobox_generate_ps_pdf_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_generate_ps_pdf_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_generate_ps_pdf_changed (GtkComboBox *combobox, gpointer user_data);

/* Evenements dessin pochette */

gboolean on_eventbox_image_preview_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_eventbox_image_preview_event_after (GtkWidget *widget, GdkEvent *event, gpointer user_data);

/* TAGS */

void on_checkbutton_artist_tag_realize (GtkWidget *widget, gpointer user_data);
void on_checkbutton_title_tag_realize (GtkWidget *widget, gpointer user_data);
void on_checkbutton_album_tag_realize (GtkWidget *widget, gpointer user_data);
void on_checkbutton_numerate_tag_realize (GtkWidget *widget, gpointer user_data);
void on_checkbutton_genre_tag_realize (GtkWidget *widget, gpointer user_data);
void on_checkbutton_year_tag_realize (GtkWidget *widget, gpointer user_data);
void on_checkbutton_comment_tag_realize (GtkWidget *widget, gpointer user_data);

void on_checkbutton_tag_clicked (GtkButton *button, gpointer user_data);

/* Doc onglet pochette */

/*
void on_label_texte_doc_options_realize (GtkWidget *widget, gpointer user_data);
*/
void on_scrolledwindow_applications_navigator_realize (GtkWidget *widget, gpointer user_data);
void on_button_add_navigator_realize (GtkWidget *widget, gpointer user_data);
void on_entry_name_navigator_realize (GtkWidget *widget, gpointer user_data);
void on_button_del_navigator_realize (GtkWidget *widget, gpointer user_data);
void on_button_add_navigator_clicked (GtkButton *button, gpointer user_data);
void on_entry_name_navigator_changed (GtkEditable *editable, gpointer user_data);
void on_button_del_navigator_clicked (GtkButton *button, gpointer user_data);


void on_scrolledwindow_applications_postscript_realize (GtkWidget *widget, gpointer user_data);
void on_button_add_postscript_realize (GtkWidget *widget, gpointer user_data);
void on_button_add_postscript_clicked (GtkButton *button, gpointer user_data);
void on_entry_name_postscript_realize (GtkWidget *widget, gpointer user_data);
void on_entry_name_postscript_changed (GtkEditable *editable, gpointer user_data);
void on_button_del_postscript_realize (GtkWidget *widget, gpointer user_data);
void on_button_del_postscript_clicked (GtkButton *button, gpointer user_data);


void on_label_type_package_realize (GtkWidget *widget, gpointer user_data);

/* DVD AUDIO */

void on_scrolledwindow_dvd_audio_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_peripherique_dvd_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_peripherique_dvd_changed (GtkComboBox *combobox, gpointer user_data);
void on_button_rafraichir_dvd_clicked (GtkButton *button, gpointer user_data);

void on_button_destination_dvd_realize (GtkWidget *widget, gpointer user_data);
void on_button_destination_dvd_clicked (GtkButton *button, gpointer user_data);

void on_button_extraction_dvd_clicked (GtkButton *button, gpointer user_data);
void on_button_deplier_dvd_clicked (GtkButton *button, gpointer user_data);
void on_button_replier_dvd_clicked (GtkButton *button, gpointer user_data);

void on_progressbar_dvd_audio_realize (GtkWidget *widget, gpointer user_data);
void on_button_annuler_lecture_dvd_clicked (GtkButton *button, gpointer user_data);

/* SUB & AMBIANCE DVD */
void on_combobox_sub_dvd_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_ambiance_dvd_realize (GtkWidget *widget, gpointer user_data);
void on_eventbox_combobox_sub_dvd_realize (GtkWidget *widget, gpointer user_data);
void on_eventbox_combobox_ambiance_dvd_realize (GtkWidget *widget, gpointer user_data);

/* WAV */

void on_progressbar_wav_realize (GtkWidget *widget, gpointer user_data);

void on_notebook_general_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data);
void on_notebook_options_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data);
void on_notebook_pochette_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data);
void on_notebook_app_externes_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data);

void on_label_entry_internal_visual_realize (GtkWidget *widget, gpointer user_data);
void on_entry_internal_visual_realize (GtkWidget *widget, gpointer user_data);

void on_entry_Lame_realize (GtkWidget *widget, gpointer user_data);
void on_entry_Oggenc_realize (GtkWidget *widget, gpointer user_data);
void on_entry_Flac_realize (GtkWidget *widget, gpointer user_data);
void on_entry_Faac_realize (GtkWidget *widget, gpointer user_data);
void on_entry_Mppenc_realize (GtkWidget *widget, gpointer user_data);
void on_entry_Mac_realize (GtkWidget *widget, gpointer user_data);
void on_entry_Wavpack_realize (GtkWidget *widget, gpointer user_data);
void on_entry_Cdparanoia_realize (GtkWidget *widget, gpointer user_data);
void on_entry_Mplayer_realize (GtkWidget *widget, gpointer user_data);

void on_button_WebInformations_clicked (GtkButton *button, gpointer user_data);

void on_entry_lame_mp3_realize (GtkWidget *widget, gpointer user_data);
void on_label_lame_mp3_realize (GtkWidget *widget, gpointer user_data);
void on_entry_oggenc_ogg_realize (GtkWidget *widget, gpointer user_data);
void on_label_oggenc_ogg_realize (GtkWidget *widget, gpointer user_data);

void on_entry_flac_flac_realize (GtkWidget *widget, gpointer user_data);
void on_label_flac_flac_realize (GtkWidget *widget, gpointer user_data);

void on_entry_mac_ape_realize (GtkWidget *widget, gpointer user_data);
void on_label_mac_ape_realize (GtkWidget *widget, gpointer user_data);

void on_entry_wavpack_wv_realize (GtkWidget *widget, gpointer user_data);
void on_label_wavpack_wv_realize (GtkWidget *widget, gpointer user_data);

void on_entry_musepack_mpc_realize (GtkWidget *widget, gpointer user_data);
void on_label_musepack_mpc_realize (GtkWidget *widget, gpointer user_data);

void on_entry_faac_m4a_realize (GtkWidget *widget, gpointer user_data);
void on_label_faac_m4a_realize (GtkWidget *widget, gpointer user_data);

void on_entry_op_internal_changed (GtkEditable *editable, gpointer user_data);


void on_button_dossier_de_conversion_realize (GtkWidget *widget, gpointer user_data);
void on_button_dossier_de_conversion_clicked (GtkButton *button, gpointer user_data);

void on_hbox_expander_cdaudio_realize (GtkWidget *widget, gpointer user_data);

void on_entry_stockage_cdaudio_realize (GtkWidget *widget, gpointer user_data);
void on_label_stockage_cdaudio_exemple_realize (GtkWidget *widget, gpointer user_data);
void on_entry_stockage_cdaudio_changed (GtkEditable *editable, gpointer user_data);
void on_hbox_expander_file_realize (GtkWidget *widget, gpointer user_data);

void on_radiobutton_extract_with_cdparanoia_realize (GtkWidget *widget, gpointer user_data);
void on_radiobutton_extract_with_cdda2wav_realize (GtkWidget *widget, gpointer user_data);
void on_radiobutton_cdparanoia_mode_expert_realize (GtkWidget *widget, gpointer user_data);
void on_radiobutton_choice_extract_with_clicked (GtkButton *button, gpointer user_data);


/* SPLIT */

void on_scrolledwindow_file_split_realize (GtkWidget *widget, gpointer user_data);

/* PLAYER SPLIT */

void on_button_lecture_split_clicked (GtkButton *button, gpointer user_data);
void on_button_stop_lecture_split_clicked (GtkButton *button, gpointer user_data);

/* Player split realize */

void on_button_lecture_split_realize (GtkWidget *widget, gpointer user_data);
void on_button_pause_lecture_split_realize (GtkWidget *widget, gpointer user_data);
void on_button_stop_lecture_split_realize (GtkWidget *widget, gpointer user_data);



void on_button_importer_split_clicked (GtkButton *button, gpointer user_data);
void on_button_remove_file_split_clicked (GtkButton *button, gpointer user_data);

void on_button_action_split_clicked (GtkButton *button, gpointer user_data);
void on_button_ajouter_tache_split_clicked (GtkButton *button, gpointer user_data);
void on_button_nettoyer_tout_split_clicked (GtkButton *button, gpointer user_data);

/* combobox -> dest file */

void on_combobox_dest_split_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_dest_split_changed (GtkComboBox *combobox, gpointer user_data);

/* SWITCH PAGE IN FILE
*/

void on_notebook_in_file_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data);

void on_entry_tag_title_file_changed (GtkEditable *editable, gpointer user_data);
void on_entry_tag_title_file_realize (GtkWidget *widget, gpointer user_data);
void on_entry_tag_album_file_changed (GtkEditable *editable, gpointer user_data);
void on_entry_tag_album_file_realize (GtkWidget *widget, gpointer user_data);
void on_entry_tag_artist_file_changed (GtkEditable *editable, gpointer user_data);
void on_entry_tag_artist_file_realize (GtkWidget *widget, gpointer user_data);
void on_entry_tag_comment_file_changed (GtkEditable *editable, gpointer user_data);
void on_entry_tag_comment_file_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_tag_genre_file_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_tag_genre_file_changed (GtkComboBox *combobox, gpointer user_data);
void on_spinbutton_tag_track_file_realize (GtkWidget *widget, gpointer user_data);
void on_spinbutton_tag_track_file_changed (GtkEditable *editable, gpointer user_data);
void on_spinbutton_tag_year_file_realize (GtkWidget *widget, gpointer user_data);
void on_spinbutton_tag_year_file_changed (GtkEditable *editable, gpointer user_data);
void on_label_tag_change_realize (GtkWidget *widget, gpointer user_data);
void on_button_tag_appliquer_realize (GtkWidget *widget, gpointer user_data);
void on_button_tag_appliquer_clicked (GtkButton *button, gpointer user_data);
void on_table_tag_realize (GtkWidget *widget, gpointer user_data);
void on_expander_in_file_realize (GtkWidget *widget, gpointer user_data);

/* LABEL STATUSBAR GLOBAL
*/
void on_label_statusbar_global_realize (GtkWidget *widget, gpointer user_data);


/* WIN WAV_TO_WAV
*/
gboolean on_wind_wav_to_wav_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_wind_wav_to_wav_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_button_stop_wav_to_wav_clicked (GtkButton *button, gpointer user_data);

/* AIDE
*/
gboolean on_button_lecture_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
gboolean on_button_lecture_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);

gboolean on_button_split_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
gboolean on_button_split_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);

gboolean on_button_file_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
gboolean on_button_file_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);

gboolean on_button_dvd_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
gboolean on_button_dvd_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);

gboolean on_button_cd_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
gboolean on_button_cd_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);

gboolean on_button_pochette_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
gboolean on_button_pochette_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);

gboolean on_button_AppExt_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
gboolean on_button_AppExt_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);

gboolean on_button_options_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
gboolean on_button_options_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);


/*  AFFICHER / CACHER LES CHAMPS DES TREEVIEWS
 *  DVD, CD, ALLFILE, WAV, MP3OGG, SPLIT
 */
gboolean on_wind_treeview_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_wind_treeview_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_notebook_windtreeview_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data);
void on_button_select_global_windtreeview_clicked (GtkButton *button, gpointer user_data);
void on_button_deselect_global_windtreeview_clicked (GtkButton *button, gpointer user_data);
void on_button_quit_windtreeview_clicked (GtkButton *button, gpointer user_data);
void on_checkbutton_modif_treeview_clicked (GtkButton *button, gpointer user_data);
void on_radiobutton_modif_treeview_clicked (GtkButton *button, gpointer user_data);

/*  WIND ABOUT
*/
gboolean on_wind_about_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_wind_about_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_image_about_realize (GtkWidget *widget, gpointer user_data);
void on_label_xcfa_about_realize (GtkWidget *widget, gpointer user_data);
void on_label_author_about_realize (GtkWidget *widget, gpointer user_data);
void on_label_contrib_about_realize (GtkWidget *widget, gpointer user_data);
void on_button_ok_about_clicked (GtkButton *button, gpointer user_data);
void on_label_button_pagexcfa_about_realize (GtkWidget *widget, gpointer user_data);
void on_textview_label_license_about_realize (GtkWidget *widget, gpointer user_data);
void on_button_contrib_about_clicked (GtkButton *button, gpointer user_data);

/* ONGKET CD ACTION ET TAGS
*/
void on_entry_tag_titre_chanson_realize (GtkWidget *widget, gpointer user_data);
void on_entry_tag_titre_chanson_changed (GtkEditable *editable, gpointer user_data);
void on_entry_tag_titre_album_realize (GtkWidget *widget, gpointer user_data);
void on_entry_tag_titre_album_changed (GtkEditable *editable, gpointer user_data);
void on_entry_tag_nom_artiste_realize (GtkWidget *widget, gpointer user_data);
void on_entry_tag_nom_artiste_changed (GtkEditable *editable, gpointer user_data);
void on_entry_tag_commentaire_realize (GtkWidget *widget, gpointer user_data);
void on_entry_tag_commentaire_changed (GtkEditable *editable, gpointer user_data);
void on_spinbutton_tag_annee_realize (GtkWidget *widget, gpointer user_data);
void on_spinbutton_tag_annee_value_changed (GtkSpinButton *spinbutton, gpointer user_data);
void on_spinbutton_tag_piste_realize (GtkWidget *widget, gpointer user_data);
void on_spinbutton_tag_piste_value_changed (GtkSpinButton *spinbutton, gpointer user_data);
void on_entry_tag_titre_fichier_m3u_realize (GtkWidget *widget, gpointer user_data);
void on_entry_tag_titre_fichier_m3u_changed (GtkEditable *editable, gpointer user_data);
void on_combobox_tag_genre_cd_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_tag_genre_cd_changed (GtkComboBox *combobox, gpointer user_data);
void on_entry_new_titre_cdaudio_realize (GtkWidget *widget, gpointer user_data);
void on_entry_new_titre_cdaudio_changed (GtkEditable *editable, gpointer user_data);
void on_expander_cd_realize (GtkWidget *widget, gpointer user_data);
void on_notebook_expander_cd_realize (GtkWidget *widget, gpointer user_data);

/* PLAYER ONGLET FICHIER
*/
void on_button_stop_music_clicked (GtkButton *button, gpointer user_data);

/* FAAC
*/
void on_combobox_faac_conteneur_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_faac_conteneur_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_faac_choice_vbr_abr_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_faac_choice_vbr_abr_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_faac_set_choice_vbr_abr_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_faac_set_choice_vbr_abr_changed (GtkComboBox *combobox, gpointer user_data);



/* FENETRE DE LECTURE
*/
gboolean on_wind_lecture_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_wind_lecture_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_button_lecture_clicked (GtkButton *button, gpointer user_data);
void on_hbox_lecture_realize (GtkWidget *widget, gpointer user_data);
void on_label_lecture_namefile_realize (GtkWidget *widget, gpointer user_data);
void on_label_statusbar_lecture_realize (GtkWidget *widget, gpointer user_data);

void on_combobox_normalise_cd_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_normalise_cd_changed (GtkComboBox *combobox, gpointer user_data);

void on_combobox_normalise_dvd_realize (GtkWidget *widget, gpointer user_data);

void on_radiobutton_ioctl_clicked (GtkButton *button, gpointer user_data);

/* SIMPLIFICATION DE LA NORMALISATION SELON @Dzef
*/
void on_combobox_normalise_file_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_normalise_file_changed (GtkComboBox *combobox, gpointer user_data);
void on_spinbutton_choix_niveau_file_realize (GtkWidget *widget, gpointer user_data);
void on_spinbutton_choix_niveau_file_value_changed (GtkSpinButton *spinbutton, gpointer user_data);
                                   
void on_spinbutton_secondes_mark_A_split_realize (GtkWidget *widget, gpointer user_data);
void on_spinbutton_centiemes_mark_A_split_realize (GtkWidget *widget, gpointer user_data);
void on_spinbutton_secondes_mark_B_split_realize (GtkWidget *widget, gpointer user_data);
void on_spinbutton_centiemes_mark_B_split_realize (GtkWidget *widget, gpointer user_data);

void on_spinbutton_secondes_mark_A_split_value_changed (GtkSpinButton *spinbutton, gpointer user_data);
void on_spinbutton_centiemes_mark_A_split_value_changed (GtkSpinButton *spinbutton, gpointer user_data);
void on_spinbutton_secondes_mark_B_split_value_changed (GtkSpinButton *spinbutton, gpointer user_data);
void on_spinbutton_centiemes_mark_B_split_value_changed (GtkSpinButton *spinbutton, gpointer user_data);



void on_image_button_coller_mark_A_split_realize (GtkWidget *widget, gpointer user_data);
void on_image_button_coller_mark_B_split_realize (GtkWidget *widget, gpointer user_data);

void on_combobox_choice_file_cue_realize (GtkWidget *widget, gpointer user_data);
void on_button_cue_creation_from_cd_clicked (GtkButton *button, gpointer user_data);
void on_entry_name_fichier_unique_cue_changed (GtkEditable *editable, gpointer user_data);
void on_entry_name_fichier_unique_cue_realize (GtkWidget *widget, gpointer user_data);
void on_checkbutton_creation_fichier_cue_clicked (GtkButton *button, gpointer user_data);
void on_checkbutton_creation_fichier_unique_cue_clicked (GtkButton *button, gpointer user_data);

/* WIN_CHOICE
*/
gboolean on_wind_choice_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_wind_choice_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_button_cancel_wind_choice_clicked (GtkButton *button, gpointer user_data);
void on_button_ok_wind_choice_clicked (GtkButton *button, gpointer user_data);

void on_notebook_expander_cd_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data);
void on_button_eject_cd_clicked (GtkButton *button, gpointer user_data);
void on_button_eject_dvd_clicked (GtkButton *button, gpointer user_data);




void on_combobox_accplusenc_stereo_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_accplusenc_mono_realize (GtkWidget *widget, gpointer user_data);



void on_combobox_lame_type_bitrate_mp3ogg_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_lame_mode_mp3ogg_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_lame_abr_cbr_vbr_mp3ogg_realize (GtkWidget *widget, gpointer user_data);

void on_combobox_lame_abr_cbr_vbr_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_lame_type_bitrate_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_lame_mode_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data);

void on_combobox_oggenc_bitrate_mp3ogg_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_oggenc_managed_mp3ogg_realize (GtkWidget *widget, gpointer user_data);
void on_combobox_oggenc_downmix_m3ogg_realize (GtkWidget *widget, gpointer user_data);

void on_combobox_oggenc_bitrate_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_oggenc_managed_mp3ogg_changed (GtkComboBox *combobox, gpointer user_data);
void on_combobox_oggenc_downmix_m3ogg_changed (GtkComboBox *combobox, gpointer user_data);

void on_scrolledwindow_applications_audio_realize (GtkWidget *widget, gpointer user_data);
void on_button_add_audio_realize (GtkWidget *widget, gpointer user_data);
void on_entry_name_audio_realize (GtkWidget *widget, gpointer user_data);
void on_button_del_audio_realize (GtkWidget *widget, gpointer user_data);
void on_entry_name_audio_changed (GtkEditable *editable, gpointer user_data);
void on_button_add_audio_clicked (GtkButton *button, gpointer user_data);
void on_button_del_audio_clicked (GtkButton *button, gpointer user_data);

void on_button_copy_commentaire_clicked (GtkButton *button, gpointer user_data);
void on_button_paste_comment_clicked (GtkButton *button, gpointer user_data);

/* WIND_EXTRACT
*/
gboolean on_wind_extract_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_wind_extract_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_label_info_wind_extract_realize (GtkWidget *widget, gpointer user_data);
void on_label_titre_extraction_wind_extract_realize (GtkWidget *widget, gpointer user_data);
void on_progressbar_extraction_wind_extract_realize (GtkWidget *widget, gpointer user_data);
void on_label_titre_conversion_wind_extract_realize (GtkWidget *widget, gpointer user_data);
void on_progressbar_conversion_wind_extract_realize (GtkWidget *widget, gpointer user_data);
void on_label_total_wind_extract_realize (GtkWidget *widget, gpointer user_data);
void on_progressbar_total_wind_extract_realize (GtkWidget *widget, gpointer user_data);
void on_button_stop_wind_extract_clicked (GtkButton *button, gpointer user_data);
void on_textview_expander_wind_extract_realize (GtkWidget *widget, gpointer user_data);

/* WIND_PULSE
*/
gboolean on_wind_pulse_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_wind_pulse_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_label_titre_wind_pulse_realize (GtkWidget *widget, gpointer user_data);
void on_progressbar_wind_pulse_realize (GtkWidget *widget, gpointer user_data);
void on_label_track_wind_pulse_realize (GtkWidget *widget, gpointer user_data);
void on_button_cancel_wind_pulse_realize (GtkButton *button, gpointer user_data);

/* WIND_SCAN
*/
gboolean on_wind_scan_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_wind_scan_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_label_titre_wind_scan_realize (GtkWidget *widget, gpointer user_data);
void on_progressbar_wind_scan_realize (GtkWidget *widget, gpointer user_data);
void on_label_compteur_wind_scan_realize (GtkWidget *widget, gpointer user_data);
void on_button_cancel_wind_scan_clicked (GtkButton *button, gpointer user_data);

/* NOUVEAU WIDGET SPLIT
*/
GtkWidget* splitshuttle_create (gchar *widget_name, gchar *string1, gchar *string2, gint int1, gint int2);


gboolean on_button_split_enter_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
gboolean on_button_split_leave_notify_event (GtkWidget *widget, GdkEventCrossing *event, gpointer user_data);
void on_checkbutton_contour_split_clicked (GtkButton *button, gpointer user_data);

// void on_button_split_tst_realize (GtkWidget *widget, gpointer user_data);
// void on_viewport_split_realize (GtkWidget *widget, gpointer user_data);
void on_hbox_splitshuttle_realize (GtkWidget *widget, gpointer user_data);
#endif


