 /*
 * file      : split.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __split_h__
#define __split_h__ 1

#include "file.h"	


typedef struct {
	
	GtkWidget		*Adr_scroll;			/* Adresse scroll				*/
	GtkTreeModel		*Adr_Tree_Model;		/* Adresse tree model				*/
	GtkWidget		*Adr_TreeView;			/* Adresse tree view				*/
	GtkTreeSelection	*Adr_Line_Selected;		/* Adresse line selected			*/
	gboolean		 BoolLineSelected;		/* TRUE is ok else FALSE			*/
	
	GtkSpinButton		*AdrSpinbuttonSecondesDebut;	/* Adresse					*/
	GtkSpinButton		*AdrSpinbuttonSecondesFin;	/* Adresse					*/
	GtkSpinButton		*AdrSpinbuttonCentiemeDebut;	/* Adresse					*/
	GtkSpinButton		*AdrSpinbuttonCentiemeFin;	/* Adresse					*/		
	GtkComboBox		*AdrComboboxDest;		/* Adresse Combo destination fichiers		*/
	GtkWidget		*AdrButtonPlay;			/* Adresse bouton Play				*/
	GtkWidget		*AdrButtonStop;			/* Adresse bouton Stop				*/
		
	guint			 HandlerTimeout;		/*						*/
	gchar			*Dummy;				/* Nom du fichier CUE				*/
	gchar			*TmpRep;			/*						*/

	FIC_SPLIT		*FicSplit;			/* Remise a jour depuis la ligne en selection	*/
	FIC_SPLIT		*OldSelectedFicSplit;		/* 						*/
	DETAIL			*Detail;			/* Remise a jour depuis la ligne en selection	*/
	
	gchar			*TmpSPlit;			/* Le dossier temporaire pour les formats PCM	*/
								/* VarSplit.TmpSPlit =				*/
								/* utils_create_temporary_rep(PATH_TMP_XCFA_SPLIT);*/
	
} VAR_SPLIT;

extern VAR_SPLIT VarSplit;



typedef enum {
	_SPLIT_TYPE_BEGIN_ZERO_ = 0,				/*						*/
	_SPLIT_TYPE_ELSE_,					/*						*/
	_SPLIT_TYPE_OGG_,					/*						*/
	_SPLIT_TYPE_MP3_					/*						*/
} SPLIT_TYPE_STRUCT;

typedef struct {
	gdouble			 TimeDebut;			/* Temps debut					*/
	gdouble			 TimeFin;			/* Temps fin					*/
	GList			*list;				/* Fichier CUE | action pour OGG et MP3		*/
	gchar			*StrfileBash;			/* Contenu du futur fichier bash		*/
	gchar			*PathNameFileSong;		/* Path + Name of source			*/

	gint			 NbrAlloc;			/* Nombre total d'allocations			*/
	TYPE_FILE_IS		 TypeFileIs;			/* Type du fichier				*/
	SPLIT_TYPE_STRUCT	 TypeStruct;			/* Type de lma structure			*/
		
} VAR_SPLIT_ALLOC;

extern VAR_SPLIT_ALLOC *VarSplitAlloc;



/*
*---------------------------------------------------------------------------
* S P L I T . C
*---------------------------------------------------------------------------
*/

/* Make Scrolledwindow */

void		 split_scrolledwindow_file_split_realize (GtkWidget *widget);

/* Labels Hscale */

void		 split_label_depuis_split_realize (GtkWidget *widget);

/* Perso */

void		 split_affiche_glist (void);
void		 split_set_flag_buttons_audio (void);
void		 split_button_lecture_split_clicked (void);
void		 split_button_stop_lecture_split_clicked (void);
gboolean         split_is_dupply (gchar *namefile);
void             split_WaitPlay (void);
void             split_StopPlay (void);

void             split_NEW_set_debut (gdouble Percent);
void             split_NEW_set_fin (gdouble Percent);
void             split_NEW_WaitPlay (void);
void             split_NEW_StopPlay (void);

/* combobox -> dest file */

void		 split_combobox_dest_split_realize (GtkWidget *widget);
void		 split_combobox_dest_split_changed (void);

/* button clicked */

void		 split_button_importer_split_clicked (void);
void		 split_button_ajouter_tache_clicked (void);
void		 split_button_remove_file_split_clicked (void);
void		 split_button_remove_all_file_split_clicked (void);
void		 split_button_import_cue_split_clicked (void);
void		 split_with_mplayer (gdouble percent);
DETAIL		*split_get_first_line_is_selected (void);
void		 split_spinbutton_set_mark_A_split_value_changed (void);
void		 split_spinbutton_set_mark_B_split_value_changed (void);
gint             split_get_elements (void);


/*
*---------------------------------------------------------------------------
* S P L I T _ A C T I O N . C
*---------------------------------------------------------------------------
*/

void		 splitaction_button_clicked (void);


/*
*---------------------------------------------------------------------------
* NEW NEW NEW NEW  NEW  NEW  NEW  NEW  NEW  NEW  NEW 
*---------------------------------------------------------------------------
*/

void             split_xcfa_event (GdkEvent *event);

#endif

