 /*
 * file      : dragNdrop.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include <glib/gprintf.h>

#include <string.h>

#include "global.h"
#include "utils.h"
#include "file.h"
#include "poche.h"
#include "split.h"
#include "fileselect.h"
#include "dragNdrop.h"



/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

enum
{
	TARGET_URI_LIST = 100
};

const GtkTargetEntry drag_types[] =
{
	{ "text/uri-list", 0, TARGET_URI_LIST },
};
/*
const GtkTargetEntry drag_types[] =
{
        { "MY_TREE_MODEL_ROW", GTK_TARGET_SAME_APP, 0 },
	{ "text/plain",    0, TARGET_URI_LIST },
	{ "text/uri-list", 1, TARGET_URI_LIST },
	{ "STRING"       , 2, TARGET_URI_LIST }
};
const GtkTargetEntry drag_types[] =
{
	{ "INTEGER",       0, TARGET_URI_LIST },
	{ "STRING",        0, TARGET_URI_LIST },
	{ "text/plain",    0, TARGET_URI_LIST },
	{ "text/uri-list", 0, TARGET_URI_LIST }
};
*/

gint n_drag_types = sizeof (drag_types) / sizeof (drag_types [0]);



/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/

/* Cette fonction est appelle depuis 'file.c :: file_drag_data_received_file' et elle
*  extrait les noms de fichiers pour les injecter dans le 'GList EnteteFile.GList_file'
*  --
*  entree :
*      GtkWidget *widget : L'adresse du widget destinataire
*      gchar *string     : pointeur buffer de texte
*  retour : -
*/
void dragndrop_list_drag_data (GtkWidget *widget, gchar *string)
{
	gboolean   Bool_add_ok = FALSE;
	gchar     *Ptr = NULL;
	gchar     *temp = NULL;

	/*PRINT_FUNC_LF();*/

	/* test for input
	*/
	if ((widget != var_file.Adr_TreeView) &&
	    (widget != VarSplit.Adr_TreeView) &&
	    (widget != poche.Adr_viewport_image_preview)) {
		PRINT_FUNC_LF();
		g_print ("\tERREUR DRAG N DROP : WIDGET(dragndrop_list_drag_data) INCONNU --> RETOUR\n");
		return;
	}

	Ptr = dragndrop_xcfa_convert_utf8 (string);
	
	fileselect_clear_glist ();
	
	while (*Ptr)
	{
		temp = strchr (Ptr, '\n');
		if (temp)
		{
			if (*(temp - 1) == '\r') *(temp - 1) = '\0';
			*temp = '\0';
		}

		if (widget == poche.Adr_viewport_image_preview) {
			if (pochedir_create_glist (Ptr, TRUE)) Bool_add_ok = TRUE;
		}
		
		else {
			Bool_add_ok = TRUE;
			/*
			if (widget == VarSplit.Adr_TreeView) {
				
				if (infosong_g_str_has_suffix (Ptr, ".CUE") == TRUE) {
					
					splitcue_import_file_cue (Ptr);
					
					// UN SEUL FICHIER CUE A LA FOIS
					break;
				}
				else if (fileanalyze_create_glist_analyze_file (NULL, Ptr, FALSE)) Bool_add_ok = TRUE;
			}
			else if (fileanalyze_create_glist_analyze_file (NULL, Ptr, FALSE)) Bool_add_ok = TRUE;
			*/
			
			fileselect_set_glist_from_str (Ptr);
		}
		
		if (!temp) break;

		Ptr = temp + 1;
	}
	
	if (Bool_add_ok == TRUE) {
	
		if (widget == var_file.Adr_TreeView) {

			fileanalyze_add_file_to_treeview_ (_TREEVIEW_ALL_, FALSE);
		}
		else if (widget == VarSplit.Adr_TreeView) {
		
			fileanalyze_add_file_to_treeview_ (_TREEVIEW_SPLIT_, TRUE);

		}
		else if (widget == poche.Adr_viewport_image_preview) {
		
			pochedir_search ();
		}
	}
}

/* Lors d'un drag and drop, les caracteres sont curieusements transformés en CAR utf-8,
*  par exemple : c8 apparait comme 'C' et '8' dans le texte, il faut alors le chercher et
*  le retransformer en numerique decimale puis le reinjecter dans le buffer
*  --
*  entree :
*      gchar *Texte : pointeur buffer de texte
*  retour : -
*      gchar * : pointeur nouveau buffer de texte
*/
gchar *dragndrop_xcfa_convert_utf8 (gchar *Texte)
{
	gchar    *Ptr = NULL;
	gchar    *New_Str = NULL;
	gchar    *Ptr_Txt = NULL;
	gchar     Str [ 8 ];
	size_t    Len;
	
	/* PRINT_FUNC_LF(); */

	/* allocate new string
	*/
	Len = strlen (Texte);

	New_Str = g_strnfill (Len * 3, '\0');
	Ptr = New_Str;

	/* delette this 'file://' in old string
	*/
	while ( (Ptr_Txt = strstr (Texte, "file://")) != NULL)
		strcpy (Ptr_Txt, Ptr_Txt + 7);
	Ptr_Txt = Texte;

	Str [ 0 ] = '0';
	Str [ 1 ] = 'x';
	Str [ 2 ] = '\0';
	Str [ 3 ] = '\0';
	Str [ 4 ] = '\0';
	Str [ 5 ] = '\0';

	while (*Ptr_Txt) {
		if (*Ptr_Txt == '%') {
			Ptr_Txt ++;
			Str [ 2 ] = *Ptr_Txt ++;
			Str [ 3 ] = *Ptr_Txt ++;
			*Ptr = (gint)utils_hexa_to_int (Str);
			Ptr ++;
		}
		else {
			*Ptr ++ = *Ptr_Txt ++;
		}
	}

	return (New_Str);
}



