 /*
 * file      : config_user.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __config_user_h__
#define __config_user_h__ 1

typedef struct {
	gint        Bitrate_type_Lame;			/* Bitrate Lame								*/
	gint        If_abr;				/* SI ABR est defini							*/
	gint        If_cbr;				/* SI CBR est defini							*/
	gint        If_vbr;				/* SI VBR est defini							*/
	gint        If_vbr_new;				/* SI VBR_NEW est defini						*/
	gint        Mode_Lame;				/* Mode Lame								*/
	gint        Bitrate_Oggenc;			/* Bitrate Oggenc							*/
	gint        Managed_Oggenc;			/* Managed Oggenc							*/
	gint        Downmix_Oggenc;			/* Downmix Oggenc							*/
} RATE_MP3OGG;


/* Definition de l'etat du fichier de configuration */
typedef struct {

	gchar      *Version;				/* Numero de version							*/
	gboolean    BoolNewVersion;			/*									*/
	
	gboolean    Bool_Config_Ok;			/*									*/

	gint        WinPos_X;				/* Window Position X							*/
	gint        WinPos_Y;				/* Window Position Y							*/
	gint        Win_Width;				/* Window Width								*/
	gint        Win_Height;				/* Window Heigh								*/

	gint        Nice;				/* Priorite systeme: 0..19						*/
	
	RATE_MP3OGG RateMp3OggOptions;
	RATE_MP3OGG RateMp3OggFile;
	
	gchar      *Path_Destination_CD;		/* Dest of extracting CD						*/
	gchar      *Path_Destination_DVD;		/* Dest of converting DVD						*/
	gchar      *Path_Destination_file;		/* Dest of converting file						*/
	gchar      *Path_Destination_file_wav;		/* Dest of converting file wav						*/
	gchar      *Path_Destination_file_mp3ogg;	/* Dest of converting file mp3ogg					*/
	gchar      *Path_Destination_split;		/* Dest of converting file split					*/
	gchar      *Path_Load_file;			/* Path of load file							*/
	gchar      *Path_Import_File_WAV;		/* Path of load file to SOX						*/
	gchar      *Path_Import_File_MP3OGG;		/* Path of load file to MP3OGG						*/
	gchar      *Path_Import_FileSplit;
	gchar      *Path_Load_Images;			/* Path load of image							*/
	
	gchar      *Path_Load_file_CUE;			/* Path load file CUE							*/
	
	gchar      *Path_Stocke_Images_Pochette;	/* Path Stocke of poche-image						*/
	gchar      *Path_Dest_File_PostScript;		/* Path Dest File PostScript						*/
	gchar      *Path_Load_File_DVD;			/* Path Load File DVD							*/
	gchar      *Path_TMP;				/* Path d'extractions / conversions					*/

	gchar      *Name_file_m3u;			/* Nom du fichier m3u							*/
	
	gboolean    Bool_artist_tag;			/* TRUE if set tag artist						*/
	gboolean    Bool_title_tag;			/* TRUE if set tag title						*/
	gboolean    Bool_album_tag;			/* TRUE if set tag album						*/
	gboolean    Bool_numerate_tag;			/* TRUE if set tag numerate						*/
	gboolean    Bool_genre_tag;			/* TRUE if set tag genre						*/
	gboolean    Bool_year_tag;			/* TRUE if set tag year							*/
	gboolean    Bool_comment_tag;			/* TRUE if set tag comment						*/

	gint        serveur_cddb;			/* auto, at, ca, de, fi, fr, no, uk, us					*/

	gboolean    Bool_directory_by_ioctl;		/* TRUE = ioctl, FALSE = cdparanoia					*/
	gboolean    Extract_cd_with;			/* 0 = cdparanoia,  1 = cdparanoia expert, 2 = cdda2wav			*/
	
	gint        compression_level_flac;		/* 0 .. 12								*/
	gint        compression_level_ape;		/* 0 .. 4 								*/

	gint        quality_mppenc;			/* telephone=0 thumb radio standard xtreme insane braindead		*/

	gint        compression_wavpack;		/* -f = 0, -h = 1, -hh = 2						*/
	gint        sound_wavpack;			/* -j0 = 0, -j1 = 1							*/
	gint        wavpack_mode_hybride;		/*  */
	gint        wavpack_correction_file;		/*  */
	gint        wavpack_maximum_compression;	/*  */
	gint        wavpack_signature_md5;		/*  */
	gint        wavpack_extra_encoding;		/*  */

	gint        faac_conteneur;			/*  */
	gint        faac_choice_vbr_abr;		/*  */
	gint        faac_set_choice_vbr;		/*  */
	gint        faac_set_choice_abr;		/*  */
	
	gint        aacplusenc_choice_mono;		/*  */
	gint        aacplusenc_choice_stereo;		/*  */
	
	gboolean    Bool_GoTo_Togle_Import_File;	/* TRUE = GoTo								*/

	gboolean    Bool_init_img_xcfa;			/* TRUE = Load images ELSE FALSE = none					*/

	gint        Value_fix_dvdaudio;			/* Valeur de FIX onglet dvd-audio					*/
	gint        Value_fix_cdaudio;			/* Valeur de FIX onglet cd-audio					*/
	gint        Value_fix_fichiers;			/* Valeur de FIX onglet fichiers					*/

	gchar      *Templates_title_cdaudio;		/* Format titres cdaudio						*/
	gchar      *Templates_rep_cdaudio;		/* Dossier de sauvegarde des fichiers cdaudio				*/

	gint        Value_choice_file_dest;		/* Sauvegarde choix ComBoBox : Path_Destination_file			*/
	gint        Value_choice_file_dest_wav;		/* Sauvegarde choix ComBoBox : Path_Destination_file			*/
	gint        Value_choice_file_mp3ogg_dest;	/* Sauvegarde choix ComBoBox : Path_Destination_file_mp3ogg		*/
	gint        Value_choice_split;			/* Sauvegarde choix ComBoBox : Path_Import_FileSplit		*/

	gchar      *String_expander_Lame;		/* Lignes de saisie: options pour les geeks				*/
	gchar      *String_expander_Oggenc;		/**/
	gchar      *String_expander_Flac;		/**/
	gchar      *String_expander_Faac;		/**/
	gchar      *String_expander_Mppenc;		/**/
	gchar      *String_expander_Mac;		/**/
	gchar      *String_expander_Wavpack;		/**/

	gint        AdministratorOfPackets;		/* Gestionnaire de paquets: 0 = apt-get, 1 = aptitude			*/

	gboolean    Bool_save_pos_notebook;		/**/
	gint        notebook_general;			/**/
	gint        notebook_expander_cd;		/**/
	gint        notebook_file;			/**/
	gint        notebook_options;			/**/
	gint        notebook_pochette;			/**/
	gint        notebook_logs;			/**/
	gint        notebook_app;			/**/
	gchar      *StringBoolFieldsIsVisible;		/* 0 = champs invisible, 1 = champs visible				*/
	gchar       StringPosFieldsName [ 16 ];		/* dvd,cd,files,wav,mp3ogg,split: 0=left, 1=center, 2=right		*/
	
	gboolean    BoolEtatExpanderFile;		/* TRUE is open else FALSE						*/
	gboolean    BoolEtatExpanderCd;			/* TRUE is open else FALSE						*/
	
	gint        IntSelectCd;			/* 0=entry is one, etc ...						*/
	
} CONFIG_USER;

extern CONFIG_USER Config_User;
extern CONFIG_USER ConfigUserSave;

void configuser_read_file_config (void);
void configuser_save_file_config (void);
void configuser_remove_struct (void);


#endif
