/*
 * file user.c - communication interface for users
 *
 * $Id: user.c,v 1.3 2004/05/14 10:00:35 alfie Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 * Added by Koen De Raedt for central support
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "user.h"

#include "atom.h"
#include "com_to_central.h"
#include "cfg_player.h"
#include "util.h"
#include "str_util.h"
/*
 * local macros
 */
#define TIME_POLL_QUERY 5

/*
 * local variables
 */
static XBComm  *comm  = NULL;
int PID=-1001;
int AllDone=0;
//static XBComm  *dgram = NULL;

/*
 * local prototypes
 */

/*
 * try to connect to server
 */
XBBool
User_Connect (CFGCentralSetup *cfg)
{
  int  j;
  char tmp[16];
  /* create communincation */
  assert (comm == NULL);
  comm = X2C_CreateComm (cfg);
  if (NULL == comm) {
    return XBFalse;
  }
  PID=-1001;
  AllDone=0;

  j=sprintf(tmp,"tmpPlayer");
  tmp[j+1]=0;
  Network_SetPlayer (0, 0, GUI_StringToAtom (tmp)) ;

  return XBTrue;
} /* User_Connect */

/*
 * disconnect from server 
 */
void
User_Disconnect ()
{
  if (comm != NULL) { 
    CommDelete (comm);
    comm = NULL;
  }
  PID=-1001;
  AllDone=0;
} /* User_Disconnect */

/*
 * 
 */
void
User_SetDisconnected ()
{
  comm = NULL;
} /* User_SetDisonnect */

void 
User_SendDisconnect() {
  X2C_SendDisconnect(comm);
}

/*
 *
 */
void
User_NotifyError (void)
{
  /* shutdown datagram connection */
  /* inform application */
  Network_QueueEvent (XBNW_Error, 0);
  GUI_SendEventValue (XBE_SERVER, XBSE_ERROR);
} /* User_NotifyError */

/*
 * receive player config from server
 */
void
User_ReceivePlayerConfig (const char *data)
{
  XBAtom atom,atomID;
  CFGPlayerEx tmpPlayer;
  int         i;

  atom=Network_ReceivePlayerConfig (CT_Central, 0,0, data); // XBCC
  /* if atom is valid, data is complete */
  if (ATOM_INVALID != atom) {
    // Dbg_Out("Got player from central\n");
    RetrievePlayerEx(CT_Central, atom, &tmpPlayer);
    i=tmpPlayer.id.PID;
    // Dbg_Out("Player PID = %i\n",i);
    if(i>=0) { // udpate
      AllDone++;
      atomID=GUI_IntToAtom(i);
      StorePlayerEx(CT_Central, atomID, &tmpPlayer);
    }
    DeletePlayerConfig(CT_Central, atom);
  }
} /* User_ReceivePlayerConfig */

/*
 * receive player config from server
 */
void
User_ReceivePlayerPID (const char *data)
{
  if(!sscanf(data,"%i",&PID)) {
    PID=-3;
  }
} /* User_ReceivePlayerConfig */

int
User_GetPID()
{
  return PID;
}

void
User_NoMorePlayers() {
  AllDone=-(AllDone+1);
}

int 
User_AllDone() {
  return AllDone;
}

/*
 * another peer has diconnected
 */
void
User_ReceiveDisconnect (unsigned id)
{
  Network_QueueEvent (XBNW_Disconnected, id);
} /* User_PeerDisconnected */

void
User_SendRegisterPlayer (XBAtom atom)
{
  PID=-1001;
  X2C_SendPlayerConfig(comm, atom);
}

void
User_SendUnregisterPlayer (XBAtom atom)
{
}

void 
User_RequestUpdate()
{
  AllDone=XBFalse;
  /* perhaps delete DB first if 'update' can not work */
  RemoveAllPlayers(CT_Central);
  X2C_QueryPlayerConfig(comm);
}


// XBST
void
User_SendGameStat (int numPlayers, BMPlayer *playerStat, int *pa)
{
  int PID[MAX_PLAYER];
  int Score[MAX_PLAYER];
  BMPlayer *ps,*ps2;
  int i,j,t=0,k;

  if(numPlayers>0) {
    for (i=0,j=0, ps = playerStat; i < numPlayers; ps ++, i++) {
      if(pa[i]) {
	PID[j]=ps->PID;
	Score[j]=0;
	for (k=0, ps2 = playerStat; k < numPlayers; ps2 ++, k++) {
	  if((ps->team==ps2->team) && (ps2->lives>0)) Score[j]=1;
	}
	t+=Score[j];
	j++;
      }
    }
    if(t==0) { // draw
      for(i=0;i<j;i++) {
	Score[i]=1;
      }
    }
  } else { // game stat
    j=-numPlayers;
    for (i=0, ps = playerStat; i < j; ps ++, i++) {
      PID[i]=ps->PID;
      Score[i]=ps->lives;
      Dbg_Out("send %d %d\n",PID[i],Score[i]);
    }    
  }
  
  X2C_SendGameStat(comm, j, PID, Score);
}


/*
 * end of file user.c
 */
