/*
 * file server.h - communication interface for the server
 *
 * $Id: server.h,v 1.4 2004/07/07 10:24:20 iskywalker Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef XBLAST_SERVER_H
#define XBLAST_SERVER_H

#include "player.h"
#include "network.h"

/*
 * global prototypes
 */
extern XBBool Server_StartListen (CFGGameHost *);
extern void   Server_StopListen (void);
extern void   Server_Accept (unsigned id, const char *host, unsigned port);
extern void   Server_NotifyError (unsigned id);

extern void Server_SendDisconnect (unsigned id);
extern void Server_SendDisconnectAll (void);
extern void Server_SendHostState (unsigned id, XBBool in);

extern void Server_SendTeamState (unsigned id, unsigned team);

extern void Server_SendStart (unsigned id); 
extern void Server_SendLevel (const DBRoot *level);
extern void Server_SendSync (XBNetworkEvent);
extern void Server_SendPlayerAction (int gameTime, const PlayerAction *action);

extern void Server_ReceiveGameConfig (unsigned id, const char *line);
extern void Server_ReceivePlayerConfig (unsigned id, int player, const char *line);
extern void Server_ReceiveDisconnect (unsigned id);
extern void Server_ReceiveDgramPort (unsigned id, unsigned short port);
extern void Server_ReceiveSync (unsigned id, XBNetworkEvent);
extern void Server_ReceivePlayerAction (unsigned id, int gameTime, const PlayerAction *playerAction);
extern void Server_ReceiveFinish (unsigned id);
extern void Server_ReceivePing (unsigned id);

extern void   Server_ResetPlayerAction (void);
extern void   Server_FinishPlayerAction (int gameTime);
extern XBBool Server_FlushPlayerAction (void);
extern void   Server_GetPlayerAction (unsigned id, int player, PlayerAction *action);
extern void   Server_ClearPlayerAction (void);
extern int    Server_GetPingTime (unsigned id);

extern void   Server_StartCentralNewGame (const CFGGameHost *cfg, const CFGGameSetup *setup);
/* GAMEONFIX */
extern void   Server_RestartNewGame (const char *busy);
/* GAMEONFIX */
extern void   Server_CloseNewGame (void);
extern void   Server_StopNewGame (void);

#endif
/*
 * end of file server.h
 */
