/*
 * file network.h - shared functions for server and clients
 *
 * $Id: network.h,v 1.6 2004/06/04 11:24:19 iskywalker Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef XBLAST_NETWORK_H
#define XBLAST_NETWORK_H

#include "event.h"
#include "cfg_main.h" // XBCC

/*
 * type definition
 */
typedef enum {
  XBNW_None = 0,
  XBNW_Accepted,          /* connection to client accepted */
  XBNW_GameConfig,        /* client has send game config */
  XBNW_RightPlayerConfig, /* client has send player config */
  XBNW_LeftPlayerConfig , /* client has send player config */
  XBNW_Joy1PlayerConfig,  /* client has send player config 5 */
  XBNW_Joy2PlayerConfig,  /* client has send player config */
  XBNW_Disconnected,      /* connection to client accepted */
  XBNW_StartGame,         /* server wants to start game */
  XBNW_EndOfInit,         /* client is initialized */
  XBNW_LevelConfig,       /* server has sent level data 10*/
  XBNW_SyncEndOfInit,     /* sync after level intro */
  XBNW_SyncLevelIntro,    /* sync after level intro */
  XBNW_SyncLevelResult,   /* sync before level results are calculated */
  XBNW_SyncLevelEnd,      /* sync after level end */
  XBNW_SyncScoreboard,    /* sync after scoreboard 15*/
  XBNW_HostIsIn,          /* hsot is in game */
  XBNW_HostIsOut,         /* host is out of game */
  XBNW_TeamChange,        /* Team Change */
  XBNW_TeamChangeData,    /* Team Change Data*/
  XBNW_Error,             /* error while writung to host 20*/
  XBNW_PingReceived,      /* received ping from client  */
  XBNW_NetworkGame,       /* a new network game was added to the list */     
  XBNW_ASYNC,  
  XBNW_P0,                /* draw */
  XBNW_P1,                /* player one won 25*/
  XBNW_P2,                  /*  */
  XBNW_P3,
  XBNW_P4,
  XBNW_P5,
  XBNW_P6, /* error 30 */
#ifdef SMPF
  XBNW_P7,               
  XBNW_P8,             
  XBNW_P9,             
  XBNW_P10,             
  XBNW_P11,             /* 35 */
  XBNW_P12,             
  XBNW_P13,             
  XBNW_P14,            
  XBNW_P15,            
  XBNW_P16,    /* 40 */
#endif                 

  /* no new message behind this line */
  XBNW_MAX
} XBNetworkEvent;

/*
 * global prototypes
 */
extern XBNetworkEvent Network_GetEvent (unsigned *pId);
extern void Network_QueueEvent (XBNetworkEvent msg, unsigned id);
extern XBAtom Network_GetPlayer (unsigned id, int player);
extern void Network_SetPlayer (unsigned id, int player, XBAtom atom);

extern XBAtom Network_ReceivePlayerConfig (CFGType cfgType, unsigned id, int player, const char *line);
extern XBAtom Network_ReceiveGameConfig (unsigned id, const char *data, int *numPlayers);

#endif
/*
 * end of file network.h
 */
