/*
 * file menu_network.c - user interface for setting up networks games
 *
 * $Id: menu_network.c,v 1.7 2004/07/07 10:24:20 iskywalker Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "menu_network.h"

#include "atom.h"
#include "menu.h"
#include "menu_game.h"
#include "menu_layout.h"
#include "mi_tool.h"
#include "server.h"
#include "central.h" /* XBCC */
#include "random.h" /* XBCC */
#include "str_util.h"
#ifndef W32
#include <sys/time.h>
#endif

/*
 * local constants
 */ 
#define ANIME_LENGTH 4


/*
 * local variables
 */

/* all koen's shit for teams */
#define largeNUMBER 254

static MENU_ID  teamItem[MAX_HOSTS][NUM_LOCAL_PLAYER];
static XBTeamState  teamState[MAX_HOSTS][NUM_LOCAL_PLAYER];
static XBTeamState  oldTeamState[MAX_HOSTS][NUM_LOCAL_PLAYER];
static unsigned  teamID=-1, clientTeam=-1;
static int teamMode = 0; // set to the ....

/* server configuration */
static char        serverName[128];
static int         serverPort;
static char        serverGame[48];
static CFGGameHost cfgServer;
static CFGGameHost cfgServerhis[10];
/* names of all possible players */
static char        *hostName[MAX_HOSTS];         
static const char  *playerName[MAX_HOSTS][NUM_LOCAL_PLAYER];
static XBHostState  hostState[MAX_HOSTS];
static XBHostState  oldHostState[MAX_HOSTS];
static unsigned     hostComplete[MAX_HOSTS];
static int          hostPing[MAX_HOSTS];
/* host buttons */
#ifndef SMPF
static MENU_ID  hostItem[MAX_HOSTS];
#endif
static MENU_ID  lastFocus = 0;
static unsigned lastHost  = MAX_HOSTS;
/* player graphics */
static XBBool                   playerValid[MAX_HOSTS][NUM_LOCAL_PLAYER];
static CFGPlayerGraphics        playerGfx[MAX_HOSTS][NUM_LOCAL_PLAYER];
static const CFGPlayerGraphics *pPlayerGfx[NUM_LOCAL_PLAYER];
//static const CFGPlayerGraphics *pPlayerGfx[MAX_PLAYER];
static BMSpriteAnimation        playerAnime[ANIME_LENGTH] = {
    SpriteStopDown, SpriteWinner3,  SpriteWinner2, SpriteWinner, 
};
/* network games */
static const XBNetworkGame *networkGame[NUM_SEARCH_ROWS];
static XBNetworkGame **networkGamehis;
static MENU_ID              networkItem[NUM_SEARCH_ROWS];
static XBAtom               networkAtom;


static void CreateHostItems (XBBool server);
static void CreateTeamItems ();
static XBBool CreateCentralWaitMenu (void *par);
static XBBool ButtonCentralUpdate (void *par);
static XBBool ButtonStartLanGamehis (void *par);
static XBBool ButtonStartLanGame (void *par);
XBBool ButtonRefreshSearchCentral (void *par);

char title[256]; // XBCC
char stat0[256]; // XBCC
char stat1[256]; // XBCC
char stat2[256]; // XBCC
char stat3[256]; // XBCC
char stat4[256]; // XBCC

XBBool autoCentral2=XBFalse;

/*
 *
 */
static void
ClearHosts (void)
{
  int i;

  for (i = 0; i < MAX_HOSTS; i ++) {
    if (NULL != hostName[i]) {
      free (hostName[i]);
      hostName[i] = NULL;
    }
  }
} /* ClearHosts */

/*
 * start network game as client 
 */
static XBBool
ButtonClientStart (void *par)
{
  ClearHosts ();
  /* clean up */
  MenuClear ();
  return XBTrue;
} /* ButtonClientStart */

/*
 * start network game as server
 */
static XBBool
ButtonServerStart (void *par)
{
  int            i, j, k, reinco, N;
  XBPlayerHost   host;
  XBAtom         gameAtom;
  CFGGamePlayers cfgAllPlayers, cfgHostPlayers;
  CFGGameSetup   cfgSetup;

  N=0;
  if(teamMode) {
    reinco=0;
    for (i = 0; i < MAX_HOSTS; i ++) {
      for (j = 0; j < NUM_LOCAL_PLAYER; j ++) {
	if (teamState[i][j] >= XBTS_Red) {
	  if(!(reinco&(1 << teamState[i][j]))) {
	    reinco|=1 << teamState[i][j];
	    N++;
	  }
	}
      }
    }
    if(N <= 1) { 
      GUI_ErrorMessage ("Only one team you dumb fuck!");
      return XBFalse;
    }
  }

  /* retrieve all player configs */
  j = 0;
  for (i = 0, host = XBPH_Server; i < MAX_HOSTS; i ++, host ++) {
    if (i == 0) {
      gameAtom = atomLocal;
    } else if (hostState[i] == XBHS_In) {
      gameAtom = atomArrayHost0[i];
    } else {
      continue;
    }
    if (! RetrieveGamePlayers (CT_Remote, gameAtom, &cfgHostPlayers) ) {
      continue;
    }
    for (k = 0; k < cfgHostPlayers.num; k ++) {
      cfgAllPlayers.player[j]  = Network_GetPlayer (i, k);
      cfgAllPlayers.control[j] = cfgHostPlayers.control[k];
      cfgAllPlayers.playerID[j]= cfgHostPlayers.playerID[k];
      cfgAllPlayers.host[j]    = host;
      cfgAllPlayers.team[j]    = (teamMode?teamState[i][k]:XBPT_None);
      j ++;
    }
  }
  cfgAllPlayers.num = j;
  /* and store it */

  StoreGamePlayers (CT_Remote, atomArrayHost0[0], &cfgAllPlayers);
  /* now the other configs */
  if (RetrieveGameSetup (CT_Remote, atomLocal, &cfgSetup)) {
    StoreGameSetup (CT_Remote, atomArrayHost0[0], &cfgSetup);
  }
  /* close port for listening */
  Server_StopListen ();
  /* send data to clients */
  if(teamMode) {
    for (i = 0; i < MAX_HOSTS; i ++) {
      for (j = 0; j < NUM_LOCAL_PLAYER; j ++) {
	Server_SendTeamState(i*NUM_LOCAL_PLAYER+j, (unsigned) teamState[i][j]);
      }
    }
  }

  for (i = 1; i < MAX_HOSTS; i ++) {
    switch (hostState[i]) {
    case XBHS_In:
      Server_SendStart (i);
      break;
    default:
      Server_SendDisconnect (i);
      break;
    }
  }
  /* clean up */
  ClearHosts ();
  MenuClear ();
  return XBTrue;
} /* ButtonServerStart */

/*
 * handle network event "player config"
 */
static void
HandlePlayerConfig (unsigned clientID, int player)
{
  int i,j;
  XBAtom playerAtom;

  assert (clientID < MAX_HOSTS);
  assert (player >= 0);
  assert (player < NUM_LOCAL_PLAYER);
  /* get player graphics */
  playerAtom                    = Network_GetPlayer (clientID, player);
  playerName[clientID][player]  = GetPlayerName (CT_Remote, playerAtom);
  playerValid[clientID][player] = XBTrue;
  RetrievePlayerGraphics (CT_Remote, playerAtom, COLOR_INVALID, &playerGfx[clientID][player]); 
  /* todo: check completeness */
  hostComplete[clientID] &= ~ (1 << player);
  Dbg_Out ("HandlePlayerConfig: %u %02u\n", clientID, hostComplete[clientID]);
  if (0 == hostComplete[clientID]) {
    hostState[clientID] = XBHS_In;
#ifndef SMPF
    MenuSetActive (hostItem[clientID], XBTrue);
#endif
  }
  if(teamMode) {
    teamState[clientID][player] = XBTS_Red;
    MenuSetActive (teamItem[clientID][player], XBTrue);
    for (i = 0; i < MAX_HOSTS; i ++) {
      for (j = 0; j < NUM_LOCAL_PLAYER; j ++) {
	Server_SendTeamState(i*NUM_LOCAL_PLAYER+j, (unsigned) teamState[i][j]);
      }
    }
  }
} /* HandlePlayerConfig */

/*
 * handle network event "game config"
 */
static void
HandleGameConfig (unsigned clientID)
{
  int i;
  CFGGamePlayers cfgPlayers;

  assert (clientID < MAX_HOSTS);
  /* get host name */
  if (NULL != hostName[clientID]) {
    free (hostName[clientID]);
  }
  hostName[clientID]     = DupString (GetHostName (CT_Remote, atomArrayHost0[clientID]));
  hostState[clientID]    = XBHS_Wait;
  hostComplete[clientID] = 0;


  /* start check for completion */
  if (RetrieveGamePlayers (CT_Remote, atomArrayHost0[clientID], &cfgPlayers) ) {
    for (i = 0; i < cfgPlayers.num && i < NUM_LOCAL_PLAYER; i ++) {
      if (ATOM_INVALID == cfgPlayers.player[i]) {
	break;
      }
      hostComplete[clientID] |= (1 << i);
    }
  }
  Dbg_Out ("HandleGameConfig: %u %02X\n", clientID, hostComplete[clientID]);
  /* resend hoststates for other clients */
  memset (oldHostState, 0, sizeof (oldHostState));
} /* HandleGameConfig */

/*
 * handle network event "disconnected"
 */
static void
HandleShutdown (unsigned clientID)
{
  int j;
  assert (clientID < MAX_HOSTS);
  /* cleat host entry */
  if (NULL != hostName[clientID]) {
    free (hostName[clientID]);
    hostName[clientID] = NULL;
  }
  hostState[clientID] = XBHS_None;
  for (j = 0; j < NUM_LOCAL_PLAYER; j ++) {
    teamState[clientID][j] = XBTS_None;
  }
  hostPing[clientID]  = -1;
  /* clear player data */
  memset (playerValid[clientID], 0, sizeof (playerValid[clientID]));
  memset (playerName[clientID],  0, sizeof (playerName[clientID]));
  /* disable button */
#ifndef SMPF
  MenuSetActive (hostItem[clientID], XBFalse);
#endif
  for (j = 0; j < NUM_LOCAL_PLAYER; j ++) {
    MenuSetActive (teamItem[clientID][j], XBFalse);
  }
  /* exit menu if server has disconnected */
  if (0 == clientID) {
    Client_Disconnect ();
    MenuExecFunc (CreateMainMenu, NULL);
  }
} /* HandleShutdown */

/*
 * Handle network event "start game"
 */ 
static void
HandleStartGame (unsigned clientID)
{
  assert (clientID < MAX_HOSTS);

  SetHostType (XBPH_Client1 + clientID - 1);
  MenuExecFunc (ButtonClientStart, NULL);
} /* HandleStartGame */

/*
 * Handle network events "host state"
 */
static void
HandleHostState (unsigned clientID, XBBool isIn)
{
  assert (clientID < MAX_HOSTS);
  if (isIn) {
    hostState[clientID] = XBHS_In;
  } else {
    hostState[clientID] = XBHS_Out;
  }
  Dbg_Out ("server changed host %u to %s\n", clientID, isIn ? "in" : "out");
} /* HandleHostState */

/*
 * Handle network events "team state"
 */
static void
HandleTeamChange (unsigned clientID, unsigned teamID)
{
  assert (clientID < MAX_HOSTS*NUM_LOCAL_PLAYER);
  teamState[clientID / NUM_LOCAL_PLAYER][clientID % NUM_LOCAL_PLAYER] = teamID;
  /*  Dbg_Out ("server changed team %u (host %u, player %u) state to %u\n", clientID, 
      (clientID / NUM_LOCAL_PLAYER),(clientID % NUM_LOCAL_PLAYER), teamID); */
} /* HandleHostState */

/*
 * handle network event "ping received"
 */
static void
HandlePingReceived (unsigned clientID, XBBool isServer)
{
  assert (clientID < MAX_HOSTS);
  if (isServer) {
    hostPing[clientID] = Server_GetPingTime (clientID);
  } else {
    hostPing[clientID] = Client_GetPingTime (clientID);
  }
} /* HandlePingReceived */

/*
 * Handle any networks events
 */
static void
HandleNetworkEvents (XBBool isServer)
{
  XBNetworkEvent msg;
  unsigned       clientID;

  while (XBNW_None != (msg = Network_GetEvent (&clientID) ) ) {
    switch (msg) {
      /* player data received */
    case XBNW_RightPlayerConfig: HandlePlayerConfig (clientID, 0); 	  break;
    case XBNW_LeftPlayerConfig:  HandlePlayerConfig (clientID, 1); 	  break;
    case XBNW_Joy1PlayerConfig:  HandlePlayerConfig (clientID, 2); 	  break;
    case XBNW_Joy2PlayerConfig:  HandlePlayerConfig (clientID, 3); 	  break;
      /* game config received */       
    case XBNW_GameConfig:        HandleGameConfig (clientID);      	  break;
      /* one host has disconnected */	    
    case XBNW_Disconnected:      HandleShutdown (clientID);        	  break;
      /* error in connection to host */	      
    case XBNW_Error:             HandleShutdown (clientID);         	  break;
      /* ping received from client */
    case XBNW_PingReceived:      HandlePingReceived (clientID, isServer); break;
      /* server wants to start game */
    case XBNW_StartGame:         HandleStartGame (clientID);              break;
      /* server has changed host state */
    case XBNW_HostIsIn:          
      if (! isServer) {
	HandleHostState (clientID, XBTrue);
      }
      break;
    case XBNW_HostIsOut:          
      if (! isServer) {
	HandleHostState (clientID, XBFalse);
      }
      break;
    case XBNW_TeamChange:
      //Dbg_Out("--- Team %u %u %u---\n", clientID, clientTeam, teamID);
      if(teamMode==0) { 
	teamMode=1;
	CreateTeamItems(); 
      }
      if (!isServer) {
	if(clientTeam>largeNUMBER) {
	  if(teamID<largeNUMBER) {
	    HandleTeamChange (clientID, teamID);
	    clientTeam=-1;
	    teamID=-1;
	  } else {
	    clientTeam=clientID;
	  }
	} else {
	    // error
	  Dbg_Out("--- Team set error ---\n");
	}
      }
      break;
    case XBNW_TeamChangeData:
      //Dbg_Out("--- Team data %u %u %u ---\n", clientID, clientTeam, teamID);
      if(teamMode==0) { 
	teamMode=1;
	CreateTeamItems(); 
      }
      if(clientID<largeNUMBER) { 
	if (!isServer) {
	  if(teamID>largeNUMBER) {
	    if(clientTeam<largeNUMBER) {
	      HandleTeamChange (clientTeam, clientID);
	      clientTeam=-1;
	      teamID=-1;
	    } else {
	      teamID=clientID;
	    }
	  } else {
	    // error
	    Dbg_Out("--- Team data set error ---\n");
	  }
	}
      }
      break;
      /* anything else */
    default:
      break;
    }
  }
} /* HandleNetworkEvents */ 

/*
 *
 */
static void
UpdateFocus (void)
{
  MENU_ID  newFocus;
  unsigned newHost;
  int      player,j;

  newFocus = MenuGetFocus ();
  if (lastFocus != newFocus) {
    if (0 != newFocus) {
      /* which host */
      for (newHost = 0; newHost < MAX_HOSTS; newHost ++) {
#ifndef SMPF
	if (hostItem[newHost] == newFocus) {
	  if (newHost != lastHost) {
	    for (player = 0; player < NUM_LOCAL_PLAYER; player ++) {
	      if (playerValid[newHost][player]) {
		pPlayerGfx[player] = &playerGfx[newHost][player];
	      } else {
		pPlayerGfx[player] = NULL;
	      }
	    }
	    lastHost = newHost;
	  }
	  break;
	}
#endif
	/* Added by KOEN team focus: does not work don't know why not! I Fixed IT!! */
	for(j=0; j< NUM_LOCAL_PLAYER; j++) {
	  if (teamItem[newHost][j] == newFocus) {
	    if (newHost != lastHost) {
	      for (player = 0; player < NUM_LOCAL_PLAYER; player ++) {
		if (playerValid[newHost][player]) {
		  pPlayerGfx[player] = &playerGfx[newHost][player];
		} else {
		  pPlayerGfx[player] = NULL;
		}
	      }
	      lastHost = newHost;
	    }
	    j=-1;
	    break;
	  } 
	}
	if(j<0) { break; }
      }
    }
    lastFocus = newFocus;
  }
} /* UpdateFocus */

/*
 *
 */
static void
CheckHostStates (void)
{
  unsigned i,j;

  /* Added by KOEN make seperate sub?? has to be done first */
  if(teamMode) {
    for (i = 0; i < MAX_HOSTS; i ++) {
      for(j=0; j< NUM_LOCAL_PLAYER; j++) {
	if (oldTeamState[i][j] != teamState[i][j]) {
	  Server_SendTeamState(i*NUM_LOCAL_PLAYER+j, (unsigned) teamState[i][j]);
	  oldTeamState[i][j] = teamState[i][j];
	}
      }
    }
  }

  for (i = 0; i < MAX_HOSTS; i ++) {
    if (oldHostState[i] != hostState[i]) {
      /* inform clients about state change */
      switch (hostState[i]) {
      case XBHS_In:  Server_SendHostState (i, XBTrue);  break;
      case XBHS_Out: Server_SendHostState (i, XBFalse); break;
      default:       break;
      }
      oldHostState[i] = hostState[i];
    }
  }

} /* CheckHostStates (void) */

/*
 *
 */
static void
PollNetwork (void *par)
{
  XBBool isServer;
  static char i=0;
  XBAtom *atom = par;
  assert (atom != NULL);

  isServer = (*atom == atomServer);
  /* check network events */
  HandleNetworkEvents (isServer);
  /* show players according to selected host */
  UpdateFocus ();
  /* check host states if server */
  if (isServer) {
    CheckHostStates ();
  }
  if(cfgServer.central && (i++ ==0)) { // XBCC retransmit game up
/* GAMEONFIX */
    Server_RestartNewGame("");
/* GAMEONFIX */
  }
} /* PollNetwork */

/*
 * 
 */
static XBBool
ButtonServerDisconnect (void *par)
{
  int i;
  /* close port for listening */
  Server_StopListen ();
  /* finish communication with clients */
  Server_SendDisconnectAll ();
  /* clean up */
  for (i = 1; i < MAX_HOSTS; i ++) {
    if (NULL != hostName[i]) {
      free (hostName[i]);
    }
  }
  /* back to connection menu */
  return CreateServerMenu (par);
} /* ButtonServerDisconnect */

/*
 * 
 */
static XBBool
ButtonServerKickOut (void *par)
{
  int i;

  /* disconnect unwanted clients  */
  for (i = 1; i < MAX_HOSTS; i ++) {
    if (hostState[i] == XBHS_Out) {
      /* disconnect this client */
      Server_SendDisconnect (i);
      /* simluate disconnect from client */
      Server_ReceiveDisconnect (i);
    }
  }
  /* back to connection menu */
  return XBFalse;
} /* ButtonServerDisconnect */

/*
 * local initializations
 */
static void
LocalInit (void)
{
  int i;
  memset (hostName,     0, sizeof (hostName));
  memset (hostState,    0, sizeof (hostState));
  memset (oldHostState, 0, sizeof (oldHostState));
  memset (hostComplete, 0, sizeof (hostComplete));
  memset (playerName,   0, sizeof (playerName));
  memset (playerGfx,    0, sizeof (playerGfx));
  memset (playerValid,  0, sizeof (playerValid));
  memset (hostPing,    -1, sizeof (hostPing));
  memset (teamState,    0, sizeof (teamState));
  memset (oldTeamState, 0, sizeof (oldTeamState));
  lastFocus   = 0;
  teamMode    = 0;
  lastHost    = MAX_HOSTS;
  for(i=0; i<NUM_LOCAL_PLAYER; i++) {
    pPlayerGfx[i]=NULL;
  }
} /* LocalInit */

/*
 * create player graphics
 */
static void
CreatePlayerItems (void)
{
  int i;

  for (i = 0; i < NUM_LOCAL_PLAYER; i ++) {
    MenuAddPlayer (PLAYER_LEFT (i, NUM_LOCAL_PLAYER), PLAYER_TOP, PLAYER_WIDTH, i, pPlayerGfx + i, -ANIME_LENGTH, playerAnime);
  }
} /* CreatePlayerItems */


/*
 * create host items
 */
static void 
CreateTeamItems ()
{
#ifndef SMPF
  int x, y;
#endif
  int client = 0;
  int c,r      = MENU_TOP;

#ifdef SMPF
  r -= CELL_H;
  for (client = 0; client < MAX_PLAYER; client++) {
    if (client % 3 == 0) {
      c = 5 * CELL_W / 2;
      r += CELL_H;
    } else {
      c += 4*CELL_W;
    }
    if(teamMode) {
      teamItem[client][0] = MenuAddTeam (c+1*CELL_W, r+2*CELL_H/2, 2*CELL_W, &teamState[client][0],1); 
      teamItem[client][1] = MenuAddTeam (c+1*CELL_W, r+3*CELL_H/2, 2*CELL_W, &teamState[client][1],1);
      MenuSetActive (teamItem[client][0], XBFalse);
      MenuSetActive (teamItem[client][1], XBFalse);
    }
  }  
#else
  for (y = 0; y < 3; y ++) {
    c = 5 * CELL_W / 2;
    for (x = 0; x < 2; x ++) {
      /* host */
      if(teamMode) {
	teamItem[client][0] = MenuAddTeam (c+2*CELL_W, r+2*CELL_H/2, 2*CELL_W, &teamState[client][0],0); 
	teamItem[client][1] = MenuAddTeam (c+2*CELL_W, r+3*CELL_H/2, 2*CELL_W, &teamState[client][1],0); 
	MenuSetActive (teamItem[client][0], XBFalse);
	MenuSetActive (teamItem[client][1], XBFalse);
      }
      client ++;
      c += 6*CELL_W;
    }
    r += 2*CELL_H;
  }  
#endif
} /* CreateTeamItems */


/*
 * create host items
 */
static void 
CreateHostItems (XBBool server)
{
#ifndef SMPF
  int x, y;
  int player;
#endif
  int client = 0;
  int i, c, r      = MENU_TOP;

  CFGGameSetup   cfgSetup;
  CFGGamePlayers cfgPlayers;

  Dbg_Out("====================\n");
  if(server) {
    RetrieveGameSetup (CT_Remote, atomLocal, &cfgSetup);
    teamMode=(XBPT_None!=cfgSetup.teamMode);
    Dbg_Out ("TeamMode = %u\n", teamMode);  
    if(teamMode) { 
      RetrieveGamePlayers (CT_Remote, atomLocal, &cfgPlayers);
      for (i = 0; i < cfgPlayers.num && i < NUM_LOCAL_PLAYER; i ++) {
	teamState[0][i]=XBTS_Red;
      }
    }
  }
#ifdef SMPF
  r -= CELL_H;
  for (client = 0; client < MAX_PLAYER; client++) {
    if (client % 3 == 0) {
      c = 5 * CELL_W / 2;
      r += CELL_H;
    } else {
      c += 4*CELL_W;
    }
    if (0 == client) {
      if(teamMode && server) {
	teamItem[client][0] = MenuAddTeam (c+1*CELL_W, r+2*CELL_H/2, 2*CELL_W, &teamState[client][0],server);
	teamItem[client][1] = MenuAddTeam (c+1*CELL_W, r+3*CELL_H/2, 2*CELL_W, &teamState[client][1],server);
	if(cfgPlayers.num <= 1) { MenuSetActive (teamItem[client][1], XBFalse); }
      }
    } else {
      if(teamMode && server) {
	teamItem[client][0] = MenuAddTeam (c+1*CELL_W, r+2*CELL_H/2, 2*CELL_W, &teamState[client][0],1); 
	teamItem[client][1] = MenuAddTeam (c+1*CELL_W, r+3*CELL_H/2, 2*CELL_W, &teamState[client][1],1);
      }
    }
    MenuAddTag (c - 2*CELL_W/2, r + 2*CELL_H/2, 2*CELL_W, &playerName[client][0]);
    MenuAddTag (c - 2*CELL_W/2, r + 3*CELL_H/2, 2*CELL_W, &playerName[client][1]);
  }  
#else
  for (y = 0; y < MAX_PLAYER / 2; y ++) {
    c = 5 * CELL_W / 2;
    for (x = 0; x < 2; x ++) {
      /* host */
      if (0 == client) {
	hostItem[client] = MenuAddServer (c, r, 4*CELL_W, (const char **) hostName + client);
	if(teamMode && server) {
	  teamItem[client][0] = MenuAddTeam (c+2*CELL_W, r+2*CELL_H/2, 2*CELL_W, &teamState[client][0],server);
	  teamItem[client][1] = MenuAddTeam (c+2*CELL_W, r+3*CELL_H/2, 2*CELL_W, &teamState[client][1],server);
	  if(cfgPlayers.num <= 1) { MenuSetActive (teamItem[client][1], XBFalse); }
	}
      } else {
	if (server) {
	  hostItem[client] = MenuAddClient (c, r, 4*CELL_W, (const char **) hostName + client, hostState + client, hostPing + client);
	  if(teamMode && server) {
	    teamItem[client][0] = MenuAddTeam (c+2*CELL_W, r+2*CELL_H/2, 2*CELL_W, &teamState[client][0],1); 
	    teamItem[client][1] = MenuAddTeam (c+2*CELL_W, r+3*CELL_H/2, 2*CELL_W, &teamState[client][1],1);
	  }
	} else {
	  hostItem[client] = MenuAddPeer (c, r, 4*CELL_W, (const char **) hostName + client, hostState + client, hostPing + client);
	  if(teamMode && server) {
	    teamItem[client][0] = MenuAddTeam (c+2*CELL_W, r+2*CELL_H/2, 2*CELL_W, &teamState[client][0],0);
	    teamItem[client][1] = MenuAddTeam (c+2*CELL_W, r+3*CELL_H/2, 2*CELL_W, &teamState[client][1],0);
	  }
	}
	if(teamMode && server) { 
	  MenuSetActive (teamItem[client][0], XBFalse);
	  MenuSetActive (teamItem[client][1], XBFalse);
	}
	MenuSetActive (hostItem[client], XBFalse);
      }

      /* players */
      player = 0;
      MenuAddTag (c - 2*CELL_W/2, r + 2*CELL_H/2, 2*CELL_W, &playerName[client][player ++]);
      MenuAddTag (c - 2*CELL_W/2, r + 3*CELL_H/2, 2*CELL_W, &playerName[client][player ++]);
      if(0) {
	MenuAddTag (c + 1*CELL_W, r + 2*CELL_H/2, 2*CELL_W, &playerName[client][player ++]);
	MenuAddTag (c + 1*CELL_W, r + 3*CELL_H/2, 2*CELL_W, &playerName[client][player ++]);
	MenuAddTag (c + 3*CELL_W, r + 2*CELL_H/2, 2*CELL_W, &playerName[client][player ++]);
	MenuAddTag (c + 3*CELL_W, r + 3*CELL_H/2, 2*CELL_W, &playerName[client][player ++]);
      } else {
	player+=4;
      }
      client ++;
      c += 6*CELL_W;
    }
    r += 2*CELL_H;
  }  
#endif
  Dbg_Out("====================\n");

} /* CreateHostItems */

/*
 *
 */
static XBBool
CreateServerWaitMenu (void *par) 
{
  XBAtom *atom = par;
  int player;
  CFGGamePlayers cfgGame;

  assert (atom != NULL);
  /* inits */
  LocalInit ();
  hostName[0] = DupString ("localhost");
  /* get local player data */
  if (RetrieveGamePlayers (CT_Local, atomServer, &cfgGame) ) {
    for (player = 0; player < cfgGame.num; player ++) {
      playerValid[0][player] = XBTrue;
      RetrievePlayerGraphics (CT_Local, cfgGame.player[player], COLOR_INVALID, &playerGfx[0][player]); 
      playerName[0][player] = GetPlayerName (CT_Local, cfgGame.player[player]);
    }
  }
  /* build menu */
  MenuClear ();
  /* poll function */
  MenuAddCyclic (PollNetwork, par);
  /* players */
  CreatePlayerItems ();
  /* Title */
  MenuAddLabel (TITLE_LEFT, TITLE_TOP, TITLE_WIDTH, "Waiting for Clients");
 MenuAddLabel1 (10, 79, TITLE_WIDTH+60, "Chat with lamer Rado and others in http://irc.xblast-center.com/");
  /* hosts */
  CreateHostItems (XBTrue);


  /* Buttons */
  MenuSetAbort   (MenuAddHButton ( 3 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Disconnect", ButtonServerDisconnect, par) );
  (void)          MenuAddHButton (11 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Kick out",   ButtonServerKickOut,    par);
  MenuSetDefault (MenuAddHButton (19 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Start",      ButtonServerStart,      NULL) );
  /* --- */
  MenuSetLinks ();
  /* that's all*/
  return XBFalse;
} /* CreateServerWaitMenu */

/*
 * 
 */
static XBBool
ButtonClientDisconnect (void *par)
{
  /* finish communication to server */
  Client_Disconnect ();
  /* back to connection menu */
  return CreateJoinNetGameMenu (par);
} /* ButtonDisconnect */

/*
 *
 */
static XBBool
CreateClientWaitMenu (void *par) 
{
  XBAtom *atom = par;
  
  assert (atom != NULL);
  /* needed inits */
  LocalInit ();
  /* build menu */
  MenuClear ();
  /* poll function */
  MenuAddCyclic (PollNetwork, par);
  /* players */
  CreatePlayerItems ();
  /* Title */
  MenuAddLabel (TITLE_LEFT, TITLE_TOP, TITLE_WIDTH, "Game Setup by Server");
  /* hosts */
  teamMode=0;
  CreateHostItems (XBFalse);

 MenuAddLabel1 (10, 79, TITLE_WIDTH+60, "Chat with lamer Rado and others in http://irc.xblast-center.com/");
  /* Buttons */
  MenuSetAbort (MenuAddHButton (9*CELL_W/2, MENU_BOTTOM, 6*CELL_W, "Disconnect", ButtonClientDisconnect, par) );
  /* --- */
  MenuSetLinks ();
  /* that's all*/
  return XBFalse;
} /* CreateClientWaitMenu */

/*
 *
 */
XBBool
ButtonServerListen (void *par)
{
  XBAtom *atom = par;

  assert (atom != NULL);
  /* set server connection */
  cfgServer.name = NULL;
  cfgServer.port = serverPort;
  cfgServer.game = serverGame;
  /* store in database */
  StoreGameHost (CT_Local, *atom, &cfgServer);
  /* get game setup */
  /* now try connection */
  if (! Server_StartListen (&cfgServer) ) {
    /* connection failed */
    GUI_ErrorMessage ("Failed to listen on port %hu", serverPort);
    return CreateServerMenu (par);
  }
  return CreateServerWaitMenu (par); 
} /* ButtonServerListen */


/*
 * XBCC
 */
static XBBool
ButtonCentralStop (void *par)
{
  /* finish communication to server */
  Central_StopListen ();
  /* finish communication with clients */
  Central_SendDisconnectAll ();
  /* back to connection menu */
  return CreateCentralMenu (par);
} /* ButtonDisconnect */

/*
 * XBCC
 */
static XBBool
ButtonCentralUpdate (void *par)
{
  return CreateCentralWaitMenu (par);
} /* ButtonCentralUpdate */


/*
 *
 */
static void
PollCentral (void *par)
{
  static char i=0;
  XBAtom *atom = par;
  assert (atom != NULL);

  if(i++ == 0) {
    Central_ClearOldGames();
  }
} /* PollNetwork */

/*
 * XBCC
 */
static XBBool
CreateCentralWaitMenu (void *par) 
{
  XBAtom *atom = par;
  int nPlayers, nGames, nGamesPlayed, nTotalGames, nLogins;
  
  assert (atom != NULL);

  MenuClear ();
  /* poll function */
  MenuAddCyclic (PollCentral, par); // func has to be void mi_tool.h:46
  /* Title */
  sprintf(title,"Central: %s", serverGame);
  MenuAddLabel (TITLE_LEFT, TITLE_TOP, TITLE_WIDTH, title);
  
  Central_GetStatistics(&nPlayers, &nGames, &nGamesPlayed, &nTotalGames, &nLogins);
  sprintf(stat0,"Number of known players: %i", nPlayers); 
  MenuAddLabel (5*CELL_W/2, MENU_ROW (1), 10*CELL_W, stat0);

  sprintf(stat1,"Number of open games: %i", nGames);
  MenuAddLabel (5*CELL_W/2, MENU_ROW (2), 10*CELL_W, stat1);

  sprintf(stat2,"Number of played games: %i", nGamesPlayed);
  MenuAddLabel (5*CELL_W/2, MENU_ROW (3), 10*CELL_W, stat2);

  sprintf(stat3,"Total number of games played: %i", nTotalGames);
  MenuAddLabel (5*CELL_W/2, MENU_ROW (4), 10*CELL_W, stat3);

  sprintf(stat4,"Total number of logins: %i", nLogins);
  MenuAddLabel (5*CELL_W/2, MENU_ROW (5), 10*CELL_W, stat4);
  /* Buttons */
  MenuSetDefault (MenuAddHButton (16*CELL_W/2, MENU_BOTTOM, 5*CELL_W, "Update now", ButtonCentralUpdate, par) );
  MenuSetAbort (MenuAddHButton (4*CELL_W/2, MENU_BOTTOM, 5*CELL_W, "Stop", ButtonCentralStop, par) );
  /* --- */
  MenuSetLinks ();
  /* that's all*/
  return XBFalse;
} /* CreateClientWaitMenu */


/*
 * XBCC
 */
XBBool
ButtonCentralListen (void *par)
{
  XBAtom *atom = par;

  assert (atom != NULL);
  /* set server connection */
  cfgServer.name = NULL;
  cfgServer.port = serverPort;
  cfgServer.game = serverGame;
  /* store in database */
  StoreGameHost (CT_Local, *atom, &cfgServer);
  /* get game setup */
  /* now try connection */
  if (! Central_StartListen (&cfgServer) ) {
    /* connection failed */
    GUI_ErrorMessage ("Failed to listen on port %hu", serverPort);
    return CreateCentralMenu (par);
  }
  return CreateCentralWaitMenu (par);
} /* ButtonServerListen */

/*
 * XBCC
 */
static XBBool
ButtonMainMenu (void *par)
{
  /* call main menu */
  return CreateMainMenu (par);
} /* ButtonMainMenu */

/*
 * setup xblast server
 */
XBBool
CreateServerMenu (void *par)
{
  XBAtom *atom = par;

  assert (atom != NULL);
  /* get old server from database */
  if (! RetrieveGameHost (CT_Local, *atom, &cfgServer)) {
    serverPort    = 16168;
    serverGame[0] = 0;
  } else {
    serverPort = cfgServer.port;
    strncpy (serverGame, cfgServer.game, sizeof (serverGame));
    serverGame[sizeof (serverGame) - 1] = 0;
  }
  /* build menu */
  MenuClear ();
  /* Title */
  MenuAddLabel (TITLE_LEFT, TITLE_TOP, TITLE_WIDTH, "Setup Server");
  /* parameters */
  MenuAddInteger   (DLG_LEFT, MENU_ROW (0), DLG_WIDTH, "TCP-Port:",               2*CELL_W, &serverPort, 4096, 65535);
  MenuAddComboBool (DLG_LEFT, MENU_ROW (1), DLG_WIDTH, "Use fixed UDP-ports",     2*CELL_W, &cfgServer.fixedUdpPort);
  MenuAddComboBool (DLG_LEFT, MENU_ROW (2), DLG_WIDTH, "Allow clients using NAT", 2*CELL_W, &cfgServer.allowNat);
  MenuAddComboBool (DLG_LEFT, MENU_ROW (3), DLG_WIDTH, "Visible in LAN:",         2*CELL_W, &cfgServer.browseLan);
  MenuAddComboBool (DLG_LEFT, MENU_ROW (4), DLG_WIDTH, "Visible in central:",     2*CELL_W, &cfgServer.central); // XBCC
  MenuAddString    (DLG_LEFT, MENU_ROW (5), DLG_WIDTH, "Name:",                   4*CELL_W, serverGame, sizeof (serverGame));
  /* Buttons */
  MenuSetAbort   (MenuAddHButton ( 5 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Back",     CreateStartNetGameMenu, par) );
  MenuSetDefault (MenuAddHButton (17 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Continue", ButtonServerListen,     par) );
  /* --- */
  MenuSetLinks ();
  /* that's all*/
  return XBFalse;
} /* CreateServerMenu */

/*
 * Connect to server
 */
static XBBool
ButtonClientConnect (void *par)
{
  XBAtom *atom = par;
  CFGGameHost host;

  assert (atom != NULL);
  /* get server connection */
  cfgServer.name = serverName;
  cfgServer.port = serverPort;
  /* store in database */
  
  StoreIpHistory(&cfgServer,*atom);
  StoreGameHost (CT_Local, *atom, &cfgServer);
  /* now try connection */
  if (! Client_Connect (&cfgServer) ) {
    /* connection failed */
    GUI_ErrorMessage ("Connection to %s:%hu failed", serverName, serverPort);
    return CreateClientMenu (par);
  }
  return CreateClientWaitMenu (par);
} /* ButtonClientConnect */

/*
 * setup central connection XBCC
 */
void setAutoCentral2(XBBool set) {
  autoCentral2=set;
} 

XBBool 
CreateCentralMenu (void *par)
{
  XBAtom *atom = par;

  assert (atom != NULL);
  /* get old server from database */
  if (! RetrieveGameHost (CT_Local, *atom, &cfgServer)) {
    serverGame[0] = 0;
    serverPort    = 16168;
  } else {
    strncpy (serverGame, cfgServer.game, sizeof (serverGame));
    serverGame[sizeof (serverGame) - 1] = 0;
    serverPort = cfgServer.port;
  }
  if(autoCentral2) {
    return ButtonCentralListen(par);
  } else {
    /* build menu */
    MenuClear ();
    /* Title */
    MenuAddLabel (TITLE_LEFT, TITLE_TOP, TITLE_WIDTH, "Create a central");
    /* parameters */
    MenuAddString  (DLG_LEFT, MENU_ROW (0), DLG_WIDTH, "Central name:", 4*CELL_W, serverGame, sizeof (serverGame));
    MenuAddInteger (DLG_LEFT, MENU_ROW (1), DLG_WIDTH, "TCP-Port:", 4*CELL_W, &serverPort, 4096, 65535);
    /* Buttons */
    MenuSetAbort   (MenuAddHButton ( 5 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Back",    ButtonMainMenu, par) );
    MenuSetDefault (MenuAddHButton (17 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Start",   ButtonCentralListen,   par) );
    /* --- */
    MenuSetLinks ();
    /* that's all*/
    return XBFalse;
  }
} /* CreateClientMenu */


/*
 * setup server connection
 */
XBBool 
CreateHistoryNetGameMenu (void *par)
{
  XBAtom *atom = par;
  int i;

  assert (NULL != atom);
  networkAtom = *atom;
  
  /* setup */
  //  memset (networkGame, 0, sizeof (networkGame));
  if(RetrieveIpHistory( cfgServerhis,networkAtom)==XBFalse){
    return XBFalse;
  }
   networkGamehis=malloc( sizeof (*networkGame)*NUM_SEARCH_ROWS);
  for(i=0;i<NUM_SEARCH_ROWS;i++){
     (networkGamehis[i])=malloc(sizeof(networkGame));
     if(i<10){
    (*networkGamehis[i]).port=cfgServerhis[i].port;
  (*networkGamehis[i]).host=malloc(strlen (cfgServerhis[i].name));
  strcpy ((*networkGamehis[i]).host, cfgServerhis[i].name);
  fprintf(stderr," %s \n",(*networkGamehis[i]).host);
  (*networkGamehis[i]).game=" bla";
  (*networkGamehis[i]).version=" bla";
     }
      
  (*networkGamehis[i]).ping=1;

  (*networkGamehis[i]).numLives=1;
  (*networkGamehis[i]).numWins=1;
  (*networkGamehis[i]).frameRate=1;
  }


  MenuClear ();
  /* Title */
  MenuAddLabel (TITLE_LEFT, TITLE_TOP, TITLE_WIDTH, "History Ips");
  /* list of games */
  MenuSetActive (MenuAddGameHeader (SEARCH_LEFT, SEARCH_TOP, SEARCH_WIDTH), XBFalse);
  for (i = 0; i < 10; i ++) {
    networkItem[i] = MenuAddGameEntry (SEARCH_LEFT, SEARCH_ROW(i), SEARCH_WIDTH,(const XBNetworkGame **) (networkGamehis)+i, ButtonStartLanGamehis);	
   

    MenuSetActive (networkItem[i], XBTrue);
  }
  /* Buttons */
  MenuSetAbort   (MenuAddHButton ( 5 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Back",  CreateJoinNetGameMenu  ,    par) );
 
  /* add polling routine */
  // MenuAddCyclic (PollNetworkGame, NULL);
  /* query for local games */
  //  Client_StartCentralQuery ();

  MenuSetLinks ();// should work infinite loop ??
  /* that's all*/
  return XBFalse;
} /* CreateClientMenu */

 

/*
 * setup server connection
 */
XBBool 
CreateClientMenu (void *par)
{
  XBAtom *atom = par;

  assert (atom != NULL);
  /* get old server from database */
  if (! RetrieveGameHost (CT_Local, *atom, &cfgServer)) {
    serverName[0] = 0;
    serverPort    = 16168;
  } else {
    strncpy (serverName, cfgServer.name, sizeof (serverName));
    serverName[sizeof (hostName) - 1] = 0;
    serverPort = cfgServer.port;
  }
  /* build menu */
  MenuClear ();
  /* Title */
  MenuAddLabel (TITLE_LEFT, TITLE_TOP, TITLE_WIDTH, "Connect to Server");
  /* parameters */
  MenuAddString  (DLG_LEFT, MENU_ROW (0), DLG_WIDTH, "Hostname:", 4*CELL_W, serverName, sizeof (serverName));
  MenuAddInteger (DLG_LEFT, MENU_ROW (1), DLG_WIDTH, "TCP-Port:", 4*CELL_W, &serverPort, 4096, 65535);
  /* Buttons */
  MenuSetAbort   (MenuAddHButton ( 3 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Back",    CreateJoinNetGameMenu, par) );
  MenuAddHButton ( 11 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "History",    CreateHistoryNetGameMenu, par) ;
  MenuSetDefault (MenuAddHButton (19 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Connect", ButtonClientConnect,   par) );
  /* --- */
  MenuSetLinks ();
  /* that's all*/
  return XBFalse;
} /* CreateClientMenu */

/*
 * poll incoming network games
 */
static void
PollNetworkGame (void *par)
{
  unsigned       gameID;
  XBNetworkEvent msg;

#ifdef W32
 
#else
  static struct timeval old;
  struct timeval tv;
  gettimeofday(&tv,NULL);
  if(tv.tv_sec-old.tv_sec>=10){
    ButtonRefreshSearchCentral(NULL);
    old=tv;
  }
#endif
  while (XBNW_None != (msg = Network_GetEvent (&gameID) ) ) {
    if (msg == XBNW_NetworkGame) {
      const XBNetworkGame *game = Client_NextNetworkGame ();
      if (gameID < NUM_SEARCH_ROWS) {
	networkGame[gameID] =( XBNetworkGame *)game;	
	MenuSetActive (networkItem [gameID], ((NULL != game) && (game->frameRate!=0)&& (game->frameRate!=255)));
      } 
    }
  }
} /* PollNetworkGame */

/*
 * 
 */
static XBBool 
ButtonExitSearchLan (void *par)
{
  /* stop network search */
  Client_StopQuery ();
  teamMode=0;
  /* back to client menu */
  return CreateJoinNetGameMenu (par);
} /* ButtonExitSearchLan */

/*
 *
 */
static XBBool
ButtonRefreshSearchLan (void *par)
{
  unsigned i;

  /* delete old games */
  teamMode=0;
  memset (networkGame, 0, sizeof (networkGame));
  for (i = 0; i < NUM_SEARCH_ROWS; i ++) {
    MenuSetActive (networkItem[i], XBFalse);
  }
  /* starts new query */
  Client_RestartQuery ();
  return XBFalse;
} /* ButtonRefreshSearchLan */

/*
 *  XBCC
 */
static XBBool 
ButtonExitSearchCentral (void *par)
{
  /* stop network search */
  Client_StopQuery ();
  teamMode=0;
  /* back to client menu */
  return CreateJoinNetGameMenu (par);
} /* ButtonExitSearchLan */

/*
 *
 */
XBBool
ButtonRefreshSearchCentral (void *par)
{
  unsigned i;

  /* delete old games */
  teamMode=0;
  memset (networkGame, 0, sizeof (networkGame));
  for (i = 0; i < NUM_SEARCH_ROWS; i ++) {
    MenuSetActive (networkItem[i], XBFalse);
  }
  /* starts new query */
  Client_RestartQuery ();
  return XBFalse;
} /* ButtonRefreshSearchLan */

/*
 *
 */
static XBBool
ButtonStartLanGame (void *par)
{
  const XBNetworkGame **ptr = par;
  XBBool connect;

  assert (NULL != ptr);
  if (NULL == *ptr) {
    return XBFalse;
  }

  /* get server connection */
  cfgServer.name = (*ptr)->host;
  cfgServer.port = (*ptr)->port;
  /* store in database */
  StoreGameHost (CT_Local, networkAtom, &cfgServer);
  /* now try connection */
  connect = Client_Connect (&cfgServer);
  /* clean up */
  Client_StopQuery ();
  memset (networkGame, 0, sizeof (networkGame));
  if (! connect) {
    /* connection failed */
    GUI_ErrorMessage ("Connection to %s:%hu failed", serverName, serverPort);
    return CreateSearchLanMenu (&networkAtom);
  }

  return CreateClientWaitMenu (&networkAtom);
} 

/*
 *
 */
static XBBool
ButtonStartLanGamehis (void *par)
{
  const XBNetworkGame **ptr = par;
  XBBool connect;
  int i=0;

  assert (NULL != ptr);
  if (NULL == *ptr) {
    return XBFalse;
  }

  /* get server connection */
   cfgServer.name = (*ptr)->host;
   cfgServer.port = (*ptr)->port;
  /* store in database */
  StoreGameHost (CT_Local, networkAtom, &cfgServer);
  /* now try connection */
  connect = Client_Connect (&cfgServer);
  /* clean up */
  Client_StopQuery ();
  memset (networkGame, 0, sizeof (networkGame));
  if (! connect) {
    /* connection failed */
    GUI_ErrorMessage ("Connection to %s:%hu failed", serverName, serverPort);
    return CreateHistoryNetGameMenu (&networkAtom);
  }
  /*
    free networkgamehis, should be implemented!!!
    somehow i couldnt...
for(i=0;i<NUM_SEARCH_ROWS;i++){
    free((*networkGamehis[i]).host);
   free(networkGamehis[i]);
 }
 free(networkGamehis);*/

  return CreateClientWaitMenu (&networkAtom);
} 

/*
 *
 */
static XBBool
ButtonStartCentralGame (void *par)
{
  const XBNetworkGame **ptr = par;
  XBBool connect;

  assert (NULL != ptr);
  if (NULL == *ptr) {
    return XBFalse;
  }

  /* get server connection */
  cfgServer.name = (*ptr)->host;
  cfgServer.port = (*ptr)->port;
  /* store in database */
  StoreGameHost (CT_Local, networkAtom, &cfgServer);
  /* now try connection */
  connect = Client_Connect (&cfgServer);
  /* clean up */
  Client_StopQuery ();
  memset (networkGame, 0, sizeof (networkGame));
  if (! connect) {
    /* connection failed */
    GUI_ErrorMessage ("Connection to %s:%hu failed", serverName, serverPort);
    return CreateSearchCentralMenu (&networkAtom);
  }

  return CreateClientWaitMenu (&networkAtom);
} 

/*
 * search LAN for network games
 */
XBBool
CreateSearchLanMenu (void *par)
{
  XBAtom *atom = par;
  int i;

  assert (NULL != atom);
  networkAtom = *atom;
  /* setup */
  memset (networkGame, 0, sizeof (networkGame));
  (void) RetrieveGameHost (CT_Local, networkAtom, &cfgServer);
  /* build menu */
  MenuClear ();
  /* Title */
  MenuAddLabel (TITLE_LEFT, TITLE_TOP, TITLE_WIDTH, "Search LAN for Games");
  /* list of games */
  MenuSetActive (MenuAddGameHeader (SEARCH_LEFT, SEARCH_TOP, SEARCH_WIDTH), XBFalse);
  for (i = 0; i < NUM_SEARCH_ROWS; i ++) {
    networkItem[i] = MenuAddGameEntry (SEARCH_LEFT, SEARCH_ROW(i), SEARCH_WIDTH,(const XBNetworkGame **) networkGame + i, ButtonStartLanGame);
    MenuSetActive (networkItem[i], XBFalse);
  }
  /* Buttons */
  MenuSetAbort   (MenuAddHButton ( 5 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Back",    ButtonExitSearchLan,    par) );
  MenuSetDefault (MenuAddHButton (17 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Refresh", ButtonRefreshSearchLan, par) );
  /* add polling routine */
  MenuAddCyclic (PollNetworkGame, NULL);
  /* query for local games */
  Client_StartQuery ();

  // MenuSetLinks (); should work infinite loop ??
  /* that's all*/
  return XBFalse;
} /* CreateSearchLanMenu */

/*
 * search CENTRAL for network games XBCC
 */
XBBool
CreateSearchCentralMenu (void *par)
{
  XBAtom *atom = par;
  int i;

  assert (NULL != atom);
  networkAtom = *atom;
  /* setup */
  memset (networkGame, 0, sizeof (networkGame));
  (void) RetrieveGameHost (CT_Local, networkAtom, &cfgServer);
  /* build menu */
  MenuClear ();
  /* Title */

 MenuAddLabel2 (TITLE_LEFT-25, TITLE_TOP-15, TITLE_WIDTH+50, "Lamer Rado waits for you in http://irc.xblast-center.com");
  MenuAddLabel (TITLE_LEFT, TITLE_TOP, TITLE_WIDTH, "Central Games");
  /* list of games */
  MenuSetActive (MenuAddGameHeader (SEARCH_LEFT, SEARCH_TOP, SEARCH_WIDTH), XBFalse);
  for (i = 0; i < NUM_SEARCH_ROWS; i ++) {
    networkItem[i] = MenuAddGameEntry (SEARCH_LEFT, SEARCH_ROW(i), SEARCH_WIDTH,( const XBNetworkGame **)networkGame + i, ButtonStartCentralGame);
    MenuSetActive (networkItem[i], XBFalse);
  }
  /* Buttons */
  MenuSetAbort   (MenuAddHButton ( 5 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Back",    ButtonExitSearchCentral,    par) );
  MenuSetDefault (MenuAddHButton (17 * CELL_W/2, MENU_BOTTOM, 4*CELL_W, "Refresh", ButtonRefreshSearchCentral, par) );
  /* add polling routine */
  MenuAddCyclic (PollNetworkGame, NULL);
  /* query for local games */
  Client_StartCentralQuery ();

  // MenuSetLinks (); should work infinite loop ??
  /* that's all*/
  return XBFalse;
} /* CreateSearchLanMenu */

/*
 * end of file menu_network.c
 */









