/*
 * file debug.h - memory debugging
 * 
 * $Id: debug.h,v 1.3 2004/05/14 10:00:33 alfie Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef XBLAST_DEBUG_H
#define XBLAST_DEBUG_H

#include "common.h"

/*
 * global macros
 */
#ifndef DEBUG
#define DEBUG
#endif

#ifndef DEBUG
#define Dbg_Out (void)
#endif
#ifdef DEBUG_ALLOC
#define malloc(a)   Dbg_Malloc (__FILE__,__LINE__,a) 
#define calloc(a,b) Dbg_Calloc (__FILE__,__LINE__,a,b) 
#define free(a)     Dbg_Free   (__FILE__,__LINE__,a) 
#endif

/*
 * global prototypes
 */
#ifdef DEBUG
extern void   Dbg_StartClock (void);
extern time_t Dbg_FinishClock (void);
extern void   Dbg_Out (const char *fmt, ...);
#endif

#ifdef DEBUG_ALLOC
extern void *Dbg_Malloc (const char *file, int line, size_t nBytes);
extern void *Dbg_Calloc (const char *file, int line, size_t nElem, size_t sElem);
extern void  Dbg_Free (const char *file, int line, void *ptr);
extern void  Dbg_Vfree (const char *file, int line, void *ptr);
extern void  Dbg_FinishAlloc (void);
#endif

#endif
/*
 * end of file alloc.h
 */
