/*
 * file com_listen.c - listen for client to connect
 *
 * $Id: com_listen.c,v 1.3 2004/05/14 10:00:33 alfie Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "com_listen.h"

#include "com_to_client.h"
#include "com_from_central.h"

/*
 * local types
 */
typedef struct {
  XBComm comm;
} XBCommListen;

XBBool isCentral; // XBCC

/*
 *
 */
static XBCommResult
ReadListen (XBComm *comm)
{
  if(isCentral) { // XBCC
    if (NULL != (C2X_CreateComm (comm->socket) ) ) {
      fprintf (stderr, "User has connected\n");
    }
  } else {
    if (NULL != (S2C_CreateComm (comm->socket) ) ) {
      fprintf (stderr, "Client has connected\n");
    }
  }
  return XCR_OK;
} /* ReadListen */

/*
 *
 */
static XBCommResult
WriteListen (XBComm *comm)
{
  return XCR_OK;
} /* ReadListen */

/*
 *
 */
static XBCommResult
DeleteListen (XBComm *comm)
{
  CommFinish (comm);
  free (comm);
  return XCR_OK;
} /* CommDeleteListen */

/*
 * create listeneing communication
 */
XBComm *
CommCreateListen (const CFGGameHost *cfg, XBBool central) // XBCC
{
  XBSocket     *pSocket;
  XBCommListen *lCom;
  
  assert (cfg != NULL);
  /* create listen socket */
  pSocket = Net_ListenInet (cfg->port);
  if (NULL == pSocket) {
    return NULL;
  }
  /* create communication data structure */
  lCom = calloc (1, sizeof (XBCommListen) );
  assert (NULL != lCom);
  /* set values */
  CommInit (&lCom->comm, COMM_Listen, pSocket, ReadListen, WriteListen, DeleteListen);
  /* that's all */
  isCentral=central; // XBCC

  return &lCom->comm;
} /* CommCreateListen */

/*
 * end of file com_listen.c
 */
