/*
 * file com_dgram.h - base struct und functions for datagram connections
 *
 * $Id: com_dgram.h,v 1.3 2004/06/26 03:29:56 iskywalker Exp $
 *
 * Program XBLAST 
 * (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 */
#ifndef XBLAST_COM_DGRAM_H
#define XBLAST_COM_DGRAM_H

#include "com_base.h"
#include "action.h"
#include "net_dgram.h"

#ifdef WMS
#include "timeval.h"
#endif

/*
 * macros
 */
#define MAX_DGRAM_BUFFER   32
#define LINK_LOST          10L
#define NUM_PLAYER_ACTION (GAME_TIME+2)

/*
 * type definitions
 */
typedef struct _xb_comm_dgram  XBCommDgram;

typedef void (*DgramPingFunc)   (XBCommDgram *, unsigned, unsigned short);
typedef void (*DgramFinishFunc) (XBCommDgram *);
typedef void (*DgramActionFunc) (XBCommDgram *, int, const PlayerAction *);

/*
 * local types
 */
typedef struct packed {
  size_t        numBytes;
  unsigned char mask;
  unsigned char action[MAX_PLAYER];
  unsigned char pad;
} PackedPlayerAction;

struct _xb_comm_dgram {
  XBComm             comm;
  unsigned           port;
  const char *       host;
  XBBool             connected;
  XBBool             primary;
  size_t             first;
  size_t             next;
  unsigned           nextFrame;
  XBDatagram        *snd;
  struct timeval     lastSnd;
  struct timeval     lastRcv;
  DgramPingFunc      pingFunc;
  DgramFinishFunc    finishFunc;
  DgramActionFunc    actionFunc;
  PackedPlayerAction ppa[NUM_PLAYER_ACTION];
};

/*
 * global prototypes
 */
extern XBComm *Dgram_CommInit (XBCommDgram *, XBCommType, XBSocket *, XBBool primary, DgramPingFunc, DgramFinishFunc, DgramActionFunc);
extern unsigned short Dgram_Port (const XBCommDgram *);
extern void Dgram_Reset (XBCommDgram *);
extern void Dgram_SendPing (XBCommDgram *);
extern void Dgram_SendPingData (XBCommDgram *, const int pingData[]);
extern void Dgram_SendPlayerAction (XBCommDgram *, int, const PlayerAction *);
extern void Dgram_SendFinish (XBCommDgram *, int gameTime);
extern XBBool Dgram_Flush (XBCommDgram *dgram);

#endif
/*
 * end of file com_dgram.h
 */
