/*
 *  Copyright (C) 1997, 1998 Olivetti & Oracle Research Laboratory
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 *
 *  Seriously modified by Fredrik Hbinette <hubbe@hubbe.net>
 */

/*
 * x2vnc - control VNC displays without showing them
 */

#include <x2vnc.h>

int main(int argc, char **argv)
{
  fd_set fds;
  struct timeval tv, *tvp;
  int msWait;
  
  processArgs(argc, argv);
  
  if (listenSpecified) {
    
    listenForIncomingConnections();
    /* returns only with a succesful connection */
    
  } else {
    if (!ConnectToRFBServer(hostname, port)) exit(1);
  }
  
  if (!InitialiseRFBConnection(rfbsock)) exit(1);
  
  if (!CreateXWindow()) exit(1);
  
  if (!SetFormatAndEncodings()) {
    ShutdownX();
    exit(1);
  }
  
  
  while (1)
  {
    /*
     * Always handle all X events before doing select.  This is the
     * simplest way of ensuring that we don't block in select while
     * Xlib has some events on its queue.
     */
    
    if (!HandleXEvents()) {
      ShutdownX();
      exit(1);
    }
    
    tv.tv_sec = 5;
    tv.tv_usec = 0;
    
    FD_ZERO(&fds);
    FD_SET(ConnectionNumber(dpy),&fds);
    FD_SET(rfbsock,&fds);
    
    if (select(FD_SETSIZE, &fds, NULL, NULL, &tv) < 0) {
      perror("select");
      ShutdownX();
      exit(1);
    }
    
    if (FD_ISSET(rfbsock, &fds)) {
      if (!HandleRFBServerMessage()) {
		ShutdownX();
		exit(1);
	    }
	}
    }

    return 0;
}
