import os,sys,re
from minixsv import pyxsval
from defclass import *
#from structures import *
import wx.wxsvg


[ITEM_UNEDITABLE, ITEM_CONTAINER, ITEM_BUTTON, ITEM_TEXT, ITEM_SCROLLBAR, ITEM_ROTATING, ITEM_NOTEBOOK] = range(7)

ITEM_CONTAINER = "Container"
ITEM_BUTTON = "Button"
ITEM_TEXT = "TextCtrl"
ITEM_SCROLLBAR = "ScrollBar"
ITEM_ROTATING = "RotatingCtrl"
ITEM_NOTEBOOK = "NoteBook"
ITEM_TRANSFORM = "Transform"


class DEFControler:
    
    def __init__(self):
        self.maxindex = 0
        self.filepath = ""
        self.Window = None
        self.selected_obj = None
        self.cut_obj = None
        self.selected_parent = None
        self.BusNumber = ""
        self.SvgFilepath = ""
        self.SvgFile = None
        self.SvguiCtrl = None
        self.SVGUIRootElement = None
        
    def Reset(self):
        self.filepath = ""
        self.SvgFilepath = ""
        self.Window = None
        self.SvgFile = None
        self.SvguiCtrl = None
        self.SVGUIRootElement = None
        
    def HasOpenedProject(self):
        return self.Window != None
    
    def HasObjSelected(self):
        return self.selected_obj != None
    
    def HasSelectedRoot(self):
        return self.Window == self.selected_obj
            
    def HasContainerObjSelected(self):
        if self.selected_obj != None :
            return self.selected_obj.GetElementInfos()["type"] == ITEM_CONTAINER
        
    def IsExistingName(self,value):
        if value.upper() in self.GetElementsNames():
            return True
        else:
            return False
        
    def SelectedHasChildren(self):
        infos = self.selected_obj.GetElementInfos()
        if infos["type"] == ITEM_CONTAINER:
            if len(infos["children"])!=0:
                return True
        return False
    
    def GetRootInfos(self):
        if self.Window != None:
            return self.Window.GetElementInfos()
        
    def GetSelectedItemNumber(self,parent = None,obj=None):
        if parent == None:
            parent = self.selected_parent
        if obj == None:
            obj=self.selected_obj
        infos = obj.GetElementInfos()
        name = self.GetElementName(infos)
        ctn_obj = parent.GetContainerObj()
        i = 0
        for obj_val in ctn_obj["values"]:
            infos = obj_val.GetElementInfos()
            child_name = self.GetElementName(infos)
            if child_name == name:
                return i
            else:
                i+=1
    
    def GetSelectedElementType(self):
        if self.selected_obj != None :
            return self.selected_obj.GetElementInfos()["type"]
        
    def GetSelectedElementName(self):
        if self.selected_obj != None :
            return self.GetElementName(self.selected_obj.GetElementInfos())
    
    
    def GetRootObj(self):
        return self.Window
    
    def GetSelectedObj(self):
        return self.selected_obj
    
    def GetCutObj(self):
        return self.cut_obj

    def GetFilePath(self):
        return self.filepath
    
    def SelectByName(self,selected_name,selected_parent_name):
        objs = self.GetRootObj()
        sel_obj = self.LookForObj(objs,selected_name)
        if selected_parent_name == "":
            sel_parent = None
        else:
            sel_parent = self.LookForObj(objs,selected_parent_name)
        self.SelectThisObj(sel_obj,sel_parent)
    
    def SelectThisObj(self,obj,parent):
        self.selected_obj = obj
        self.selected_parent = parent
    
    def SetFilePath(self, filepath):
        self.filepath = filepath
        if filepath == "":
            self.LastNewIndex += 1
            self.FileName = "Unnamed%d"%self.LastNewIndex
        else:
            self.FileName = os.path.splitext(os.path.basename(filepath))[0]
    
    def OpenXMLFile(self, filepath):
        tree = pyxsval.parseAndValidate(filepath, os.path.join(os.path.dirname(__file__),"defclass", "def_xsd.xsd"))

        if sys:
            sys.stdout = sys.__stdout__
        
        self.Window = defclass.Container()
        self.Window.loadXMLTree(tree.getTree().childNodes[0])
        self.SetFilePath(filepath)
        self.maxindex =  int(self.GetMaxId())
        return True

    
    def SaveXMLFile(self, filepath = None):
        if not filepath and self.filepath == "":
            return False
        else:
            text = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n"
            extras = {"xmlns":"http://www.w3.org/2001/XMLSchema",
                      "xmlns:xsi":"http://www.w3.org/2001/XMLSchema-instance",
                      "xsi:noNamespaceSchemaLocation":"def_xsd.xsd"}
            text += self.Window.generateXMLText("Container", 0, extras)

            pyxsval.parseAndValidateString(text, open(os.path.join(os.path.dirname(__file__),"defclass", "def_xsd.xsd"),"r").read())
            if sys:
                sys.stdout = sys.__stdout__
            
            if filepath:
                xmlfile = open(filepath,"w")
            else:
                xmlfile = open(self.filepath,"w")
            xmlfile.write(text)
            xmlfile.close()
            if filepath:
                self.SetFilePath(filepath)
            return True
        
    def GetMaxId(self,objs=None):
        if objs == None:
            objs = self.Window
        max=0
        ctn_obj = objs.GetContainerObj()
        if ctn_obj["id"]>max:
            max = ctn_obj["id"]
        for obj in ctn_obj["values"]:
            infos = obj.GetElementInfos()
            if infos["type"] == ITEM_CONTAINER:
                max_child = self.GetMaxId(obj)
                if max_child > max:
                    max = max_child
            else:
                if infos["id"] >max:
                    max = infos["id"]
        return max
        
    def CreateRootElement(self):
        self.Window = defclass.Container()
        self.Window.SetRootAttributes()
        
    def AddElement(self,parent,type,name):  
        self.maxindex+=1
        parent.AddElement(type,name,self.maxindex)
    
    def DeleteSelectedElement(self):
        if self.selected_parent != None:
            self.selected_parent.removeContent(self.GetSelectedItemNumber())
        else:
            self.Window = None
        self.selected_obj = None
        
    def CutSelectedElement(self):
        self.cut_obj = self.selected_obj
        self.selected_parent.removeContent(self.GetSelectedItemNumber())
    
    def PasteElement(self):
        self.selected_obj.PasteElement(self.cut_obj)
        self.cut_obj = None
        
    def DragDropElement(self,drag_elt,drag_prt,drop_ctn):
        infos = drop_ctn.GetElementInfos()
        infos_drag_elt = drag_elt.GetElementInfos()
        if infos_drag_elt["type"] == ITEM_CONTAINER:
            child = self.LookForObj(drag_elt,self.GetElementName(infos))
            if child:
                return False
        if infos["type"] == ITEM_CONTAINER:
            drag_prt.removeContent(self.GetSelectedItemNumber(drag_prt,drag_elt))
            drop_ctn.PasteElement(drag_elt)
            return True
        else:
            return False
            
        
    def GetElementsNames(self,objs=None):
        if not objs:
            objs = self.GetRootObj()
        name_tab = []
        ctn_obj = objs.GetContainerObj()
        ctn_infos = objs.GetElementInfos()
        name = self.GetElementName(ctn_infos)
        name_tab.append(name.upper())
        for obj in ctn_obj["values"]:
            infos = obj.GetElementInfos()
            if infos["type"] == ITEM_CONTAINER:
                for name_chiltab in self.GetElementsNames(obj):
                    name_tab.append(name_chiltab)
            else:
                name = self.GetElementName(infos)
                name_tab.append(name.upper())
        return name_tab
    
    def GetElementsTab(self,objs=None):
        if not objs:
            objs = self.GetRootObj()
        elements_tab = [objs]
        ctn_obj = objs.GetContainerObj()
        for obj in ctn_obj["values"]:
            infos = obj.GetElementInfos()
            if infos["type"] == ITEM_CONTAINER:
                for element in self.GetElementsTab(obj):
                    elements_tab.append(element)
            else:
                elements_tab.append(obj)
        return elements_tab
    
    def LookForObj(self,objs,item_name):
        #ctn_obj = objs.GetContainerObj()
        #name = ctn_obj["name"]
        ctn_infos = objs.GetElementInfos()
        name = self.GetElementName(ctn_infos)
        if (name == item_name):
           return  objs
        else:
            ctn_obj = objs.GetContainerObj()
            for obj in ctn_obj["values"]:
                infos = obj.GetElementInfos()
                if infos["type"] == ITEM_CONTAINER:
                    child_obj = self.LookForObj(obj,item_name)
                    if child_obj != None:
                        return child_obj
                else:
                    name = self.GetElementName(infos)
                    if name == item_name:
                        return obj
            return None
        
    def GetElementIdFromName(self,name):
        objs = self.GetRootObj()
        obj = self.LookForObj(objs, name)
        return self.GetElementId(obj.GetElementInfos())
    
        
    def GetElementId(self,infos):
        for attr in infos["attr"]:
            if attr["name"] == "id":
                return attr["value"]
    
    def GetElementName(self,infos):
        for attr in infos["attr"]:
            if attr["name"] == "name":
                return attr["value"]
                    
    def GetGridInfos(self,grid,table):
        if self.selected_obj != None:
            infos =  self.selected_obj.getElementAttributes()
            attrs = []
            for info in infos:
                if info["name"] != "id":
                    if info["value"] == None:
                        attrs.append({"attribute" : info["name"],"value" : "","require": info["require"]})
                    elif info ["type"].startswith("cls:"):
                        attrs.append({"attribute" : info["name"],"value" : info["value"].getValue(),"require": info["require"]})
                    else:
                        attrs.append({"attribute" : info["name"],"value" : info["value"],"require": info["require"]})
            return attrs
        
    def GetNoteBooksList(self,objs):
        ctn_infos = objs.GetElementInfos()
        name = self.GetElementName(ctn_infos)
        ctn_obj = objs.GetContainerObj()
        notebooks = []
        for obj in ctn_obj["values"]:
            infos = obj.GetElementInfos()
            if infos["type"] == ITEM_CONTAINER:
                child_nb = self.GetNoteBooksList(obj)
                for nb in child_nb:
                    notebooks.append(nb)
            elif infos["type"] == ITEM_NOTEBOOK:
                notebooks.append({"notebook":obj,"selected":None})
                #for attr in infos["attr"]:
                #    if (attr["name"] == "page0_content") or (attr["name"] == "page1_content"):
                #        notebooks.append(attr["value"])
        return notebooks
    
    def GetScrollBarsList(self,objs):
        ctn_infos = objs.GetElementInfos()
        name = self.GetElementName(ctn_infos)
        ctn_obj = objs.GetContainerObj()
        scrollbars = []
        for obj in ctn_obj["values"]:
            infos = obj.GetElementInfos()
            if infos["type"] == ITEM_CONTAINER:
                child_sb = self.GetScrollBarsList(obj)
                for sb in child_sb:
                    scrollbars.append(sb)
            elif infos["type"] == ITEM_SCROLLBAR:
                scroll_infos = obj.GetElementInfos()
                for attr in scroll_infos["attr"]:
                    if attr["name"] == "id":
                        scrollbars.append(attr["value"])
        return scrollbars
    
    def GetClickedSvgTab(self,notebooks,list):
        for notebook in notebooks:
            infos = notebook["notebook"].GetElementInfos()
            for attr in infos["attr"]:
                if (attr["name"] == "page0_id"):
                    if attr["value"] in list:
                        for attr2 in infos["attr"]:
                            if (attr2["name"] == "page0_content") and (attr2["value"] != notebook["selected"]):
                                return  attr2["value"]
                elif (attr["name"] == "page1_id"):
                    if attr["value"] in list:
                        for attr2 in infos["attr"]:
                            if (attr2["name"] == "page1_content") and (attr2["value"] != notebook["selected"]):
                                return  attr2["value"]
        return None
                            
    def GetClickedNotebook(self,notebooks,list):
        for notebook in notebooks:
            infos = notebook["notebook"].GetElementInfos()
            for attr in infos["attr"]:
                if (attr["name"] == "page0_id") or (attr["name"] == "page1_id") :
                    if attr["value"] in list:
                        return  notebook
    
    def SetClickedNotebookTab(self,notebooks,notebook,element):
        for nb in notebooks:
            if nb["notebook"] == notebook["notebook"]:
                nb["selected"] = element
                return
            
    def GetContentTab(self,notebook):
        infos = notebook.GetElementInfos()
        for attr in infos["attr"]:
            if (attr["name"] == "content_id"):
                return attr["value"]
            
    def LookForRotating(self,objs):
        ctn_infos = objs.GetElementInfos()
        name = self.GetElementName(ctn_infos)
        ctn_obj = objs.GetContainerObj()
        rotatings = []
        for obj in ctn_obj["values"]:
            rotat_hash={}
            infos = obj.GetElementInfos()
            if infos["type"] == ITEM_CONTAINER:
                child_rot = self.LookForRotating(obj)
                for rot in child_rot:
                    rotatings.append(rot)
            elif infos["type"] == ITEM_ROTATING:
                rotinf=obj.GetElementInfos()
                for attr in rotinf["attr"]:
                    if (attr["name"] == "id"):
                        rotat_hash["id"] = attr["value"]
                    elif (attr["name"] == "background_id"):
                        rotat_hash["name"] = attr["value"]
                    elif (attr["name"] == "x_center"):
                        rotat_hash["x_center"] = attr["value"]
                    elif (attr["name"] == "y_center"):
                        rotat_hash["y_center"] = attr["value"]
                rotatings.append(rotat_hash)
        return rotatings
        
                    
                    
        
    def getCellType(self):
        infos =  self.selected_obj.getElementAttributes()
        types = []
        for info in infos:
            if info["name"] != "id":
                if info["type"] == "bse:decimal":
                    types.append({"type" : "float"})
                elif info["type"] == "bse:boolean":
                    types.append({"type" : "choice", "value" : "True,False"})
                elif info["type"] == "bse:integer":
                    types.append({"type" : "int"})
                elif info["type"].startswith("cls:"):
                    cls_name = info["type"].split(":")[1]
                    cls_name +="_enum"
                    enums = ""
                    for enum in getattr(defclass, cls_name, []):
                        if enums != "":
                            enums += ","
                        enums += enum
                    types.append({"type" : "choice", "value" : enums})
                else:
                    types.append({"type" : "text"})
        return types
    
    def SetAttrValue(self,attr,value,require_value):
        return self.selected_obj.SetAttrValue(attr,value,require_value)
    
    def GenerateProgramHeaders(self,directory,progname):
        elementsTab = self.GetElementsTab()
        text = ""
        h_define = progname.upper()+"_H"
        text += "#ifndef "+h_define+"\n"
        text += "#define "+h_define+"\n\n"

        text += "#include <wx/wx.h>\n"
        text += "#include <wxSVG/svgctrl.h>\n"
        text += "#include <wxSVGXML/svgxml.h>\n"
        text += "#include <wxSVG/SVGUIWindow.h>\n\n"
        
        text += "class Program: public SVGUIWindow\n{\n"
        text += "  public:\n"
        text += "    Program(wxWindow* parent);\n"
        text += "    void InitScrollBars();\n"
        for element in elementsTab:
            infos = element.getElementAttributes()
            for info in infos:
                if info["name"] == "id":
                    element_id = str(info["value"])
                if info["name"] == "name":
                    element_name = str(info["value"])
            type = element.GetElementInfos()["type"]
            if type == "Button":
                text += "    void On"+element_name+"Click(wxCommandEvent& event);\n"
            elif type == "RotatingCtrl":
                text += "    void On"+element_name+"Changed(wxScrollEvent& event);\n"
            elif type == "NoteBook":
                text += "    void On"+element_name+"TabChanged(wxNotebookEvent& event);\n"
            elif type == "Transform":
                text += "    void On"+element_name+"Paint(wxPaintEvent& event);\n"
            elif type == "Container":
                text += "    void On"+element_name+"Paint(wxPaintEvent& event);\n" 
        text += "    void OnChar(wxKeyEvent& event);\n"
        text += "    void OnClick(wxMouseEvent& event);\n\n"
        
        pub_vars = self.GenerateProgramHeadersPublicVars()
        if (pub_vars):
            text += pub_vars
        
        text += "  private:\n"
        pri_vars = self.GenerateProgramHeadersPrivateVars()
        if (pri_vars):
            text += pri_vars
        text += "    DECLARE_EVENT_TABLE()\n"
        text += "};\n\n"
        
        text += "class MainFrame: public wxFrame\n{\n"
        text += "  public:\n"
        text += "    MainFrame(wxWindow *parent, const wxString& title, const wxPoint& pos, const wxSize& size, long style = wxDEFAULT_FRAME_STYLE);\n"
        text += "    Program* m_svgCtrl;\n"
        text += "};\n\n"
        
        text += "class SVGViewApp: public wxApp\n{\n"
        text += "  public:\n"
        text += "    MainFrame* frame;\n"
        text += "    bool OnInit();\n"
        text += "};\n\n"
        
        text += "#endif /*"+h_define+"*/\n"
        
        
        
        current_directory, filename = os.path.split(self.filepath)
        hfilepath = os.path.join(directory,progname+".h")
        #DEBUG
        #hfilepath = "/taf/Pim/workspace_john/wxsvg/svgui/svgui-test.h"
        if sys:
            sys.stdout = sys.__stdout__    
        
        hfile = open(hfilepath,"w")
        hfile.write(text)
        hfile.close()
    
    def GenerateProgramHeadersPublicVars(self):
        return None
    
    def GenerateProgramHeadersPrivateVars(self):
        return None
    
    
    
    def GenerateProgramCFile(self,directory,progname):
        text = ""
        elementsTab = self.GetElementsTab()
        
        text += "//Compile this file with :\n"
        text += "//gcc `wx-config-2.6 --cppflags --libs` -lwxsvg program.cpp -o program\n\n"
        text += "#if defined(__GNUG__) && !defined(__APPLE__)\n"
        text += "#pragma implementation\n"
        text += "#pragma interface\n"
        text += "#endif\n\n"
        
        text += "#include \"wx/wxprec.h\"\n\n"
        
        text += "#ifdef __BORLANDC__\n"
        text += "#pragma hdrstop\n"
        text += "#endif\n\n"
        
        text += "#ifndef WX_PRECOMP\n"
        text += "#include \"wx/wx.h\"\n"
        text += "#endif\n\n"
        
        text += "#ifndef __WXMSW__\n"
        text += "#include <locale.h>\n"
        text += "#endif\n\n"
       
        #text += "#include \"svgui-test.h\"\n" #DEBUG
        text += "#include \"program.h\"\n"
        text += "#include <wxSVG/svg.h>\n\n\n"
        
        glob_vars = self.GenerateGlobalVarsAndFuncs()
        if glob_vars:
            text += glob_vars
            
        event_table = self.GenerateProgramEventTable()
        if event_table:
            text += event_table
            
        init_frame = self.GenerateProgramInitFrame()
        if init_frame:
            text += init_frame
        
        init_program = self.GenerateProgramInitProgram()
        if init_program:
            text += init_program
        
        text += "void Program::InitScrollBars()\n{\n"
        text += "  SVGUIScrollBar* scrollbar;\n"
        for element in elementsTab:
            infos = element.getElementAttributes()
            for info in infos:
                if info["name"] == "id":
                    element_id = str(info["value"])
            type = element.GetElementInfos()["type"]
            if type == "ScrollBar":
                text += "  scrollbar = (SVGUIScrollBar*)GetElementById(wxT(\""+element_id+"\"));\n"
                text += "  scrollbar->Init_ScrollBar(0,1,10);\n"
        text +="}\n\n"
        
        event_functions = self.GenerateProgramEventFunctions()
        if event_functions:
            text += event_functions
            
        private_functions = self.GenerateProgramPrivateFunctions()
        if private_functions:
            text += private_functions
            
        current_directory, filename = os.path.split(self.filepath)
        cfilepath = os.path.join(directory, progname+".cpp")
        #cfilepath = "/taf/Pim/workspace_john/wxsvg/svgui/svgui-test.cpp"#DEBUG
        if sys:
            sys.stdout = sys.__stdout__    
        
        cfile = open(cfilepath,"w")
        cfile.write(text)
        cfile.close()
            
    def GenerateGlobalVarsAndFuncs(self):
        if (self.SVGUIRootElement):
            width = self.SVGUIRootElement.GetBBox().GetWidth()
            height = self.SVGUIRootElement.GetBBox().GetHeight()
        else :
            width = 250
            height = 350
        txt = "IMPLEMENT_APP(SVGViewApp)\n\n"
        txt+= "bool SVGViewApp::OnInit()\n"
        txt+= "{\n"
        txt+= "#ifndef __WXMSW__\n"
        txt+= "  setlocale(LC_NUMERIC, \"C\");\n"
        txt+= "#endif\n"
        txt+= "  //wxLog::SetActiveTarget(new wxLogStderr);\n"
        txt+= "  new MainFrame(NULL, wxT(\"Program\"),\n"
        #txt+= "    wxDefaultPosition, wxDefaultSize);\n"
        txt+= "    wxDefaultPosition, wxSize((int)"+str(width)+", (int)"+str(height)+"));\n"
        txt+= "  return true;\n"
        txt+= "}\n\n"
        return txt
        
    def GenerateProgramEventTable(self):
        evt = ""
        elementsTab = self.GetElementsTab()
        #Event Table Declaration
        evt += "BEGIN_EVENT_TABLE(Program, SVGUIWindow)\n"
        for element in elementsTab:
            infos = element.getElementAttributes()
            for info in infos:
                if info["name"] == "id":
                    element_id = str(info["value"])
                if info["name"] == "name":
                    element_name = str(info["value"])
            type = element.GetElementInfos()["type"]
            if type == "Button":
                evt += "  EVT_BUTTON (SVGUIID(\""+element_id+"\"), Program::On"+element_name+"Click)\n"
            elif type == "ScrollBar":
                pass
                #evt += "  EVT_LEFT_UP (Program::OnClick)\n"
                #evt += "  EVT_COMMAND_SCROLL_THUMBTRACK (SVGUIID(\""+element_id+"\"), Program::On"+element_name+"Changed)\n"
            elif type == "RotatingCtrl":
                evt += "  EVT_COMMAND_SCROLL_THUMBTRACK (SVGUIID(\""+element_id+"\"), Program::On"+element_name+"Changed)\n"
            elif type == "NoteBook":
                evt += "  EVT_NOTEBOOK_PAGE_CHANGED (SVGUIID(\""+element_id+"\"), Program::On"+element_name+"TabChanged)\n"
            elif type == "Container" or type == "Transform":
                evt += "  EVT_PAINT(Program::On"+element_name+"Paint)\n"
        evt += "  EVT_LEFT_UP (Program::OnClick)\n"
        evt += "END_EVENT_TABLE()\n\n"
        return evt
        
    def GenerateProgramInitFrame(self):
        text = "MainFrame::MainFrame(wxWindow *parent, const wxString& title, const wxPoint& pos,const wxSize& size, long style): wxFrame(parent, wxID_ANY, title, pos, size, style)\n{\n"
        text += "  m_svgCtrl = new Program(this);\n"
        text += "  if (m_svgCtrl->LoadFiles(wxT(\""+self.SvgFilepath+"\"), wxT(\""+self.filepath+"\")))\n"
        text += "  {\n"
        text += "    Show(true);\n"
        text += "    m_svgCtrl->SetFocus();\n"
        text += "    m_svgCtrl->SetFitToFrame(true);\n"
        text += "    m_svgCtrl->RefreshScale();\n"
        text += "    m_svgCtrl->InitScrollBars();\n"
        text += "    m_svgCtrl->Update();\n"
        text += "  }\n"
        text += "  else\n"
        text += "  {\n"
        text += "    printf(\"Error while opening files\\n\");\n"
        text += "    exit(0);\n"
        text += "  }\n"
        text += "}\n\n\n"
        return text
    
    def GenerateProgramInitProgram(self):
        text = "Program::Program(wxWindow* parent):SVGUIWindow(parent)\n{\n"
        text += "}\n\n"
        return text
    
    def GenerateProgramEventFunctions(self):
        fct=""
        elementsTab = self.GetElementsTab()
        for element in elementsTab:
            infos = element.getElementAttributes()
            for info in infos:
                if info["name"] == "id":
                    element_id = str(info["value"])
                if info["name"] == "name":
                    element_name = str(info["value"])
            type = element.GetElementInfos()["type"]
            if type == "Button":
                fct += "void Program::On"+element_name+"Click(wxCommandEvent& event)\n{\n"
                fct += "  SVGUIButton* button = (SVGUIButton*)GetElementById(wxT(\""+element_id+"\"));\n"
                fct += "  event.Skip();\n"
                fct += "}\n\n"
            elif type == "RotatingCtrl":
                fct += "void Program::On"+element_name+"Changed(wxScrollEvent& event)\n{\n"
                fct += "  SVGUIRotatingCtrl* rotating = (SVGUIRotatingCtrl*)GetElementById(wxT(\""+element_id+"\"));\n"
                fct += "  rotating->SendScrollEvent(event);\n"
                fct += "  double angle = rotating->GetAngle();\n"
                fct += "}\n\n"
            elif type == "NoteBook":
                fct += "void Program::On"+element_name+"TabChanged(wxNotebookEvent& event)\n{\n"
                fct += "  SVGUINoteBook* notebook = (SVGUINoteBook*)GetElementById(wxT(\""+element_id+"\"));\n"
                fct += "  notebook->SendNotebookEvent(event);\n"
                fct += "  unsigned int selected = notebook->GetCurrentPage();\n"
                fct += "}\n\n"
            elif type == "Transform":
                fct += "void Program::On"+element_name+"Paint(wxPaintEvent& event)\n{\n"
                fct += "  SVGUITransform* transform = (SVGUITransform*)GetElementById(wxT(\""+element_id+"\"));\n"
                fct += "  event.Skip();\n"
                fct += "}\n\n"
            elif type == "Container":
                fct += "void Program::On"+element_name+"Paint(wxPaintEvent& event)\n{\n"
                fct += "  SVGUIContainer* container = (SVGUIContainer*)GetElementById(wxT(\""+element_id+"\"));\n"
                fct += "  event.Skip();\n"
                fct += "}\n\n"
        
        fct += "void Program::OnChar(wxKeyEvent& event)\n{\n"
        fct += "  SVGUIContainer* container = GetSVGUIRootElement();\n"
        fct += "  if (container->GetFocusedElementName() == wxT(\"TextCtrl\"))\n"
        fct += "  {\n"
        fct += "    wxString focusedName = container->GetFocusedElementName();\n"
        fct += "    SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementById(container->GetFocusedElement());\n"
        fct += "    text->SendKeyEvent(event);\n"
        for element in elementsTab:
            infos = element.getElementAttributes()
            for info in infos:
                if info["name"] == "id":
                    element_id = str(info["value"])
                if info["name"] == "name":
                    element_name = str(info["value"])
            type = element.GetElementInfos()["type"]
            if type == "TextCtrl":
                fct += "    if (focusedName == wxT(\""+element_name+"\"))\n"
                fct += "    {\n"
                fct += "      /* Put your code here */\n"
                fct += "    }\n"
        fct += "  }\n"
        fct += "}\n\n"
        
        
        fct += "void Program::OnClick(wxMouseEvent& event)\n{\n"
        fct += "  SVGUIContainer* container = GetSVGUIRootElement();\n"
        fct += "  if (container->GetFocusedElementName() == wxT(\"ScrollBar\"))\n"
        fct += "  {\n"
        fct += "    wxString focusedName = container->GetFocusedElementName();\n"
        fct += "    SVGUIScrollBar* scrollbar = (SVGUIScrollBar*)GetElementById(container->GetFocusedElement());\n"
        fct += "    scrollbar->SendMouseEvent(event);\n"
        for element in elementsTab:
            infos = element.getElementAttributes()
            for info in infos:
                if info["name"] == "id":
                    element_id = str(info["value"])
                if info["name"] == "name":
                    element_name = str(info["value"])
            type = element.GetElementInfos()["type"]
            if type == "ScrollBar":
                fct += "    if (focusedName == wxT(\""+element_name+"\"))\n"
                fct += "    {\n"
                fct += "    }\n"
        fct += "  }\n"
        fct += "  event.Skip();\n"
        fct += "}\n"
        
        return fct
    
    def GenerateProgramPrivateFunctions(self):
        return None
        
        
        
    def GenerateProgram(self,directory,progname="program"):
        elementsTab = self.GetElementsTab()
        
        self.GenerateProgramHeaders(directory,progname)
        self.GenerateProgramCFile(directory,progname)

        