(dp1
S'GetOsDescription'
p2
S'\n.. function:: wx.GetOsDescription()\n\n   Returns the string containing the description of the current platform in a user-readable form.                  \n\n   For example, this function may return strings like "Windows NT Version 4.0" or "Linux 2.2.2 i386". \n\n\n                \n\n   :rtype: `string`\n\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.GetOsVersion`  \n\n\n\n\n\n'
p3
sS'GetHostName'
p4
S"\n.. function:: wx.GetHostName()\n\n   Copies the current host machine's name into the supplied buffer.                  \n\n   Please note that the returned name is `not`  fully qualified, i.e. it does not include the domain name. \n\n   Under Windows or NT, this function first looks in the environment variable ``SYSTEM_NAME``; if this is not found, the entry **HostName**  in the wxWidgets section of the WIN.INI file is tried. \n\n\n                \n\n   :rtype: `string`\n\n\n\n\n\n\n\n   :returns: \n\n      The hostname if successful or an empty string otherwise.  \n\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.GetFullHostName`  \n\n\n\n\n\n"
p5
sS'InfoMessageBox'
p6
V\u000a.. function:: wx.InfoMessageBox(parent)\u000a\u000a   Shows a message box with the information about the wxWidgets build used, including its version, most important build parameters and the version of the underlying GUI toolkit.                  \u000a\u000a   This is mainly used for diagnostic purposes and can be invoked by Ctrl-Alt-middle clicking on any :ref:`wx.Window`  which doesn't otherwise handle this event. \u000a\u000a\u000a                \u000a\u000a\u000a   :param `parent`: \u000a   :type `parent`: wx.Window\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. versionadded:: 2.9.0 \u000a    \u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.GetLibraryVersionInfo`  \u000a\u000a\u000a\u000a\u000a\u000a
p7
sS'LogFatalError'
p8
S'\n.. function:: wx.LogFatalError(message)\n\n   Like :ref:`wx.LogError`, but also terminates the program with the exit code 3.                  \n\n   Using `abort()`  standard function also terminates the program with this exit code. \n\n                \n\n\n   :param `message`: \n   :type `message`: :class:`String`\n\n\n\n\n'
p9
sS'GetOsVersion'
p10
V\u000a.. function:: wx.GetOsVersion()\u000a\u000a   Gets the version and the operating system ``ID`` for currently running OS.                  \u000a\u000a   The returned OperatingSystemId value can be used for a basic categorization of the OS family; the major and minor version numbers allows detecting a specific system. \u000a\u000a   For Unix-like systems ( ``OS_UNIX`` ) the major and minor version integers will contain the kernel major and minor version numbers (as returned by the 'uname -r' command); e.g. "2" and "6" if the machine is using kernel 2.6.19. \u000a\u000a   For Mac OS X systems ( ``OS_MAC`` ) the major and minor version integers are the natural version numbers associated with the OS; e.g. "10" and "6" if the machine is using Mac OS X Snow Leopard. \u000a\u000a   For Windows-like systems ( ``OS_WINDOWS`` ) the major and minor version integers will contain the following values:  \u000a\u000a   ============================= ===================== ===================== \u000a   **Windows OS name**           **Major version**     **Minor version**     \u000a   ============================= ===================== ===================== \u000a   Windows 7                     6                     1                     \u000a   Windows Server 2008 ``R2``    6                     1                     \u000a   Windows Server 2008           6                     0                     \u000a   Windows Vista                 6                     0                     \u000a   Windows Server 2003 ``R2``    5                     2                     \u000a   Windows Server 2003           5                     2                     \u000a   Windows XP                    5                     1                     \u000a   Windows 2000                  5                     0                     \u000a   ============================= ===================== ===================== \u000a\u000a   |\u000a\u000a\u000a   See the`MSDN <http://msdn.microsoft.com/en-us/library/ms724832(VS.85).aspx>`_  for more info about the values above. \u000a\u000a\u000a                \u000a\u000a   :rtype: `tuple`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   :returns: \u000a\u000a      ( :ref:`wx.OperatingSystemId`, `major`, `minor` ) \u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.GetOsDescription`, :ref:`PlatformInfo`  \u000a\u000a\u000a\u000a\u000a\u000a
p11
sS'MicroSleep'
p12
S'\n.. function:: wx.MicroSleep(microseconds)\n\n   Sleeps for the specified number of microseconds.                  \n\n   The microsecond resolution may not, in fact, be available on all platforms (currently only Unix platforms with nanosleep(2) may provide it) in which case this is the same as calling :ref:`wx.MilliSleep`  with the argument of `microseconds/1000`. \n\n                \n\n\n   :param `microseconds`: \n   :type `microseconds`: long\n\n\n\n\n'
p13
sS'GetProcessId'
p14
S'\n.. function:: wx.GetProcessId()\n\n   Returns the number uniquely identifying the current process in the system.                  \n\n   If an error occurs, 0 is returned. \n\n                \n\n   :rtype: `int`\n\n\n\n\n\n'
p15
sS'WakeUpIdle'
p16
V\u000a.. function:: wx.WakeUpIdle()\u000a\u000a   This function wakes up the (internal and platform dependent) idle system, i.e.                  \u000a\u000a   it will force the system to send an idle event even if the system currently `is`  idle and thus would not send any idle event until after some other event would get sent. This is also useful for sending events between two threads and is used by the corresponding functions :ref:`wx.PostEvent`  and :meth:`wx.EvtHandler.AddPendingEvent` . \u000a\u000a                 \u000a\u000a\u000a
p17
sS'DateTimeFromDMY'
p18
S'\n.. function:: wx.DateTimeFromDMY(day, month, year=DateTime.Inv_Year, hour=0, minute=0, second=0, millisecond=0)\n\n   Compatibility wrapper for :meth:`DateTime.FromDMY`\n\n\n'
p19
sS'GetMouseState'
p20
V\u000a.. function:: wx.GetMouseState()\u000a\u000a   Returns the current state of the mouse.                  \u000a\u000a   Returns a :ref:`wx.MouseState`  instance that contains the current position of the mouse pointer in screen coordinates, as well as boolean values indicating the up/down status of the mouse buttons and the modifier keys. \u000a\u000a                \u000a\u000a   :rtype: :ref:`wx.MouseState`\u000a\u000a\u000a\u000a\u000a\u000a
p21
sS'FindWindowByName'
p22
V\u000a.. function:: wx.FindWindowByName(name, parent=None)\u000a\u000a\u000a\u000a\u000a\u000a   Find a window by its name (as given in a window constructor or `Create`  function call). If `parent`  is ``None``, the search will start from all top-level frames and dialog boxes; if non-NULL, the search will be limited to the given window hierarchy. The search is recursive in both cases. \u000a\u000a   If no such named window is found, :ref:`wx.FindWindowByLabel`  is called. \u000a\u000a                \u000a\u000a\u000a   :param `name`: \u000a   :type `name`: string\u000a   :param `parent`: \u000a   :type `parent`: wx.Window\u000a\u000a\u000a\u000a\u000a   :rtype: :ref:`wx.Window`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. wxdeprecated:: \u000a      Replaced by :meth:`wx.Window.FindWindowByName` .   \u000a\u000a\u000a\u000a\u000a\u000a
p23
sS'GetTranslation'
p24
V\u000a.. function:: wx.GetTranslation(*args, **kw)\u000a\u000a\u000a\u000a   |overload| Overloaded Implementations:\u000a\u000a   **~~~**\u000a\u000a   \u000a   **GetTranslation** `(string, domain=EmptyString)`\u000a   \u000a   This function returns the translation of `string`  in the current  ``locale()`` .                   \u000a   \u000a   If the string is not found in any of the loaded message catalogs (see :ref:`Internationalization`), the original string is returned. In debug build, an error message is logged `domain`  is specified then only that domain/catalog is searched for a matching string. As this function is used very often, an alternative (and also common in Unix world) syntax is provided: the :ref:`wx._`  macro is defined to do the same thing as :ref:`wx.GetTranslation`. \u000a   \u000a   This function is thread-safe. \u000a   \u000a   \u000a                   \u000a   \u000a   \u000a   :param `string`: \u000a   :type `string`: string\u000a   :param `domain`: \u000a   :type `domain`: string\u000a   \u000a   \u000a   \u000a   \u000a   :rtype: `string`\u000a   \u000a   \u000a   \u000a   \u000a   \u000a   \u000a   \u000a   .. note:: \u000a   \u000a      This function is not suitable for literal strings in Unicode builds since the literal strings must be enclosed in :meth:`T`   macro which makes them unrecognised by  ``xgettext`` , and so they are not extracted to the message catalog. Instead, use the  :ref:`wx._`  and ``PLURAL``  macro for all literal strings.  \u000a   \u000a   \u000a   \u000a   \u000a   \u000a   \u000a   \u000a   .. seealso:: :ref:`wx.GetTranslation`  \u000a   \u000a   \u000a   \u000a   \u000a   \u000a   **~~~**\u000a\u000a   \u000a   **GetTranslation** `(string, plural, n, domain=EmptyString)`\u000a   \u000a   This is an overloaded version of :ref:`wx.GetTranslation`, please see its documentation for general information.                  \u000a   \u000a   This version is used when retrieving translation of string that has different singular and plural forms in English or different plural forms in some other language. Like :ref:`wx.GetTranslation`, the `string`  parameter must contain the singular form of the string to be converted and is used as the key for the search in the catalog. The `plural`  parameter is the plural form (in English). The parameter `n`  is used to determine the plural form. If no message catalog is found, `string`  is returned if "n == 1", otherwise `plural`  is returned. \u000a   \u000a   See ``GNU`` gettext Manual for additional information on plural forms handling: `http://www.gnu.org/software/gettext/manual/gettext.html#Plural-forms <http://www.gnu.org/software/gettext/manual/gettext.html#Plural-forms>`_  For a shorter alternative see the ``PLURAL``  macro. \u000a   \u000a   This function is thread-safe. \u000a   \u000a                   \u000a   \u000a   \u000a   :param `string`: \u000a   :type `string`: string\u000a   :param `plural`: \u000a   :type `plural`: string\u000a   :param `n`: \u000a   :param `domain`: \u000a   :type `domain`: string\u000a   \u000a   \u000a   \u000a   \u000a   :rtype: `string`\u000a   \u000a   \u000a   \u000a   \u000a   \u000a   **~~~**\u000a\u000a\u000a\u000a
p25
sS'pydate2wxdate'
p26
S'\n.. function:: wx.pydate2wxdate(date)\n\n   Convert a Python date or datetime to a :class:`DateTime` object\n\n\n'
p27
sS'Now'
p28
S'\n.. function:: wx.Now()\n\n   Returns a string representing the current date and time.                  \n\n                \n\n   :rtype: `string`\n\n\n\n\n\n'
p29
sS'SafeShowMessage'
p30
V\u000a.. function:: wx.SafeShowMessage(title, text)\u000a\u000a   This function shows a message to the user in a safe way and should be safe to call even before the application has been initialized or if it is currently in some other strange state (for example, about to crash).                  \u000a\u000a   Under Windows this function shows a message box using a native dialog instead of :ref:`wx.MessageBox`  (which might be unsafe to call), elsewhere it simply prints the message to the standard output using the title as prefix. \u000a\u000a\u000a\u000a\u000a   :param `title`: The title of the message box shown to the user or the prefix of the message string.   \u000a   :type `title`: string\u000a   :param `text`: The text to show to the user.  \u000a   :type `text`: string\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a                  \u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.LogFatalError`  \u000a\u000a\u000a\u000a\u000a\u000a
p31
sS'Execute'
p32
V\u000a.. function:: wx.Execute(command, flags=EXEC_ASYNC, callback=None, env=None)\u000a\u000a   Executes another program in Unix or Windows.                  \u000a\u000a   In the overloaded versions of this function, if `flags`  parameter contains  ``EXEC_ASYNC``   flag (the default), flow of control immediately returns. If it contains   ``EXEC_SYNC`` , the current application waits until the other program has terminated. \u000a\u000a   In the case of synchronous execution, the return value is the exit code of the process (which terminates by the moment the function returns) and will be -1 if the process couldn't be started and typically 0 if the process terminated successfully. Also, while waiting for the process to terminate, :ref:`wx.Execute`  will call :ref:`wx.Yield`. Because of this, by default this function disables all application windows to avoid unexpected reentrancies which could result from the users interaction with the program while the child process is running. If you are sure that it is safe to not disable the program windows, you may pass  ``EXEC_NODISABLE``   flag to prevent this automatic disabling from happening. \u000a\u000a   For asynchronous execution, however, the return value is the process id and zero value indicates that the command could not be executed. As an added complication, the return value of -1 in this case indicates that we didn't launch a new process, but connected to the running one (this can only happen when using ``DDE`` under Windows for command execution). In particular, in this case only, the calling code will not get the notification about process termination. \u000a\u000a   If `callback`  isn't ``None`` and if execution is asynchronous, :meth:`wx.Process.OnTerminate`   will be called when the process finishes. Specifying this parameter also allows you to redirect the standard input and/or output of the process being launched by calling :meth:`wx.Process.Redirect` . \u000a\u000a   Under Windows, when launching a console process its console is shown by default but hidden if its ``IO`` is redirected. Both of these default behaviours may be overridden: if ``EXEC_HIDE_CONSOLE``  is specified, the console will never be shown. If ``EXEC_SHOW_CONSOLE``  is used, the console will be shown even if the child process ``IO`` is redirected. Neither of these flags affect non-console Windows applications or does anything under the other systems. \u000a\u000a   Under Unix the flag  ``EXEC_MAKE_GROUP_LEADER``   may be used to ensure that the new process is a group leader (this will create a new session if needed). Calling  :ref:`wx.Kill`  passing ``wx.KILL_CHILDREN`` will kill this process as well as all of its children (except those which have started their own session). Under MSW, this flag can be used with console processes only and corresponds to the native  ``CREATE_NEW_PROCESS_GROUP``   flag. \u000a\u000a   The  ``EXEC_NOEVENTS``   flag prevents processing of any events from taking place while the child process is running. It should be only used for very short-lived processes as otherwise the application windows risk becoming unresponsive from the users point of view. As this flag only makes sense with   ``EXEC_SYNC`` ,   ``EXEC_BLOCK``   equal to the sum of both of these flags is provided as a convenience. \u000a\u000a\u000a\u000a\u000a   :param `command`: The command to execute and any parameters to pass to it as a single string, i.e. "emacs file.txt".   \u000a   :type `command`: string\u000a   :param `flags`: Must include either ``wx.EXEC_ASYNC`` or ``wx.EXEC_SYNC`` and can also include ``wx.EXEC_SHOW_CONSOLE``, ``wx.EXEC_HIDE_CONSOLE``, ``wx.EXEC_MAKE_GROUP_LEADER`` (in either case) or ``wx.EXEC_NODISABLE`` and ``wx.EXEC_NOEVENTS`` or ``wx.EXEC_BLOCK``, which is equal to their combination, in ``wx.EXEC_SYNC`` case.   \u000a   :type `flags`: int\u000a   :param `callback`: An optional pointer to :ref:`wx.Process`.   \u000a   :type `callback`: wx.Process\u000a   :param `env`: An optional pointer to additional parameters for the child process, such as its initial working directory and environment variables. This parameter is available in wxWidgets 2.9.2 and later only.  \u000a   :type `env`: ExecuteEnv\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   :rtype: `long`\u000a\u000a\u000a\u000a\u000a\u000a\u000a   \u000a\u000a
p33
sS'SysErrorMsg'
p34
S'\n.. function:: wx.SysErrorMsg(errCode=0)\n\n   Returns the error message corresponding to the given system error code.                  \n\n   If `errCode`  is 0 (default), the last error code (as returned by :ref:`wx.SysErrorCode`) is used. \n\n\n                \n\n\n   :param `errCode`: \n   :type `errCode`: long\n\n\n\n\n   :rtype: `string`\n\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.SysErrorCode`, :ref:`wx.LogSysError`  \n\n\n\n\n\n'
p35
sS'FindWindowAtPoint'
p36
V\u000a.. function:: wx.FindWindowAtPoint(pt)\u000a\u000a   Find the deepest window at the given mouse position in screen coordinates, returning the window if found, or ``None`` if not.                  \u000a\u000a   This function takes child windows at the given position into account even if they are disabled. The hidden children are however skipped by it. \u000a\u000a                \u000a\u000a\u000a   :param `pt`: \u000a   :type `pt`: wx.Point\u000a\u000a\u000a\u000a\u000a   :rtype: :ref:`wx.Window`\u000a\u000a\u000a\u000a\u000a\u000a
p37
sS'Yield'
p38
S'\n.. function:: wx.Yield()\n\n   Calls :meth:`wx.AppConsole.Yield` .                  \n\n\n\n                \n\n   :rtype: `bool`\n\n\n\n\n\n\n\n   .. wxdeprecated:: \n      This function is kept only for backwards compatibility. Please use the :meth:`wx.AppConsole.Yield`   method instead in any new code.   \n\n\n\n\n\n'
p39
sS'GetTopLevelParent'
p40
S'\n.. function:: wx.GetTopLevelParent(window)\n\n   Returns the first top level parent of the given window, or in other words, the frame or dialog containing it, or ``None``.                  \n\n                \n\n\n   :param `window`: \n   :type `window`: wx.Window\n\n\n\n\n   :rtype: :ref:`wx.Window`\n\n\n\n\n\n'
p41
sS'StripMenuCodes'
p42
V\u000a.. function:: wx.StripMenuCodes(str, flags=Strip_All)\u000a\u000a   Strips any menu codes from `str`  and returns the result.                  \u000a\u000a   By default, the functions strips both the mnemonics character ( ``'&'`` ) which is used to indicate a keyboard shortkey, and the accelerators, which are used only in the menu items and are separated from the main text by the   ``\u005ct``   (``TAB``) character. By using  `flags`  of  ``Strip_Mnemonics``   or   ``Strip_Accel``   to strip only the former or the latter part, respectively. \u000a\u000a   Notice that in most cases :meth:`wx.MenuItem.GetLabelFromText`   or :meth:`wx.Control.GetLabelText`   can be used instead. \u000a\u000a                \u000a\u000a\u000a   :param `str`: \u000a   :type `str`: string\u000a   :param `flags`: \u000a   :type `flags`: int\u000a\u000a\u000a\u000a\u000a   :rtype: `string`\u000a\u000a\u000a\u000a\u000a\u000a
p43
sS'GetFullHostName'
p44
S'\n.. function:: wx.GetFullHostName()\n\n   Returns the ``FQDN`` (fully qualified domain host name) or an empty string on error.                  \n\n\n                \n\n   :rtype: `string`\n\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.GetHostName`  \n\n\n\n\n\n'
p45
sS'GetColourFromUser'
p46
V\u000a.. function:: wx.GetColourFromUser(parent, colInit, caption=EmptyString, data=None)\u000a\u000a   Shows the colour selection dialog and returns the colour selected by user or invalid colour (use :meth:`wx.Colour.IsOk`   to test whether a colour is valid) if the dialog was cancelled.                  \u000a\u000a\u000a\u000a\u000a   :param `parent`: The parent window for the colour selection dialog.   \u000a   :type `parent`: wx.Window\u000a   :param `colInit`: If given, this will be the colour initially selected in the dialog.   \u000a   :type `colInit`: wx.Colour\u000a   :param `caption`: If given, this will be used for the dialog caption.   \u000a   :type `caption`: string\u000a   :param `data`: Optional object storing additional colour dialog settings, such as custom colours. If none is provided the same settings as the last time are used.  \u000a   :type `data`: wx.ColourData\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   :rtype: :ref:`wx.Colour`\u000a\u000a\u000a\u000a                  \u000a\u000a\u000a
p47
sS'GetDisplaySize'
p48
V\u000a.. function:: wx.GetDisplaySize()\u000a\u000a   Returns the display size in pixels.                  \u000a\u000a\u000a                \u000a\u000a   :rtype: :ref:`wx.Size`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.Display`  \u000a\u000a\u000a\u000a\u000a\u000a
p49
sS'GetActiveWindow'
p50
S'\n.. function:: wx.GetActiveWindow()\n\n   Gets the currently active window (implemented for MSW and GTK only currently, always returns ``None`` in the other ports).                  \n\n                \n\n   :rtype: :ref:`wx.Window`\n\n\n\n\n\n'
p51
sS'ImageFromDataWithAlpha'
p52
S'\n.. function:: wx.ImageFromDataWithAlpha(width, height, data, alpha)\n\n   Compatibility wrapper for creating an image from RGB and Alpha data\n\n\n'
p53
sS'NewEventType'
p54
S'\n.. function:: wx.NewEventType()\n\n   Generates a new unique event type.                  \n\n   Usually this function is only used by ``DEFINE_EVENT``  and not called directly.                  \n\n   :rtype: :ref:`wx.EventType`\n\n\n\n\n\n'
p55
sS'Kill'
p56
V\u000a.. function:: wx.Kill(pid, sig=SIGTERM, rc=None, flags=KILL_NOCHILDREN)\u000a\u000a   Equivalent to the Unix kill function: send the given signal `sig`  to the process with ``PID`` `pid`.                  \u000a\u000a   The valid signal values are: \u000a\u000a   ::\u000a\u000a               # Signal enumeration\u000a\u000a               wx.SIGNONE  # verify if the process exists under Unix\u000a               wx.SIGHUP\u000a               wx.SIGINT\u000a               wx.SIGQUIT\u000a               wx.SIGILL\u000a               wx.SIGTRAP\u000a               wx.SIGABRT\u000a               wx.SIGEMT\u000a               wx.SIGFPE\u000a               wx.SIGKILL  # forcefully kill, dangerous!\u000a               wx.SIGBUS\u000a               wx.SIGSEGV\u000a               wx.SIGSYS\u000a               wx.SIGPIPE\u000a               wx.SIGALRM\u000a               wx.SIGTERM  # terminate the process gently\u000a\u000a\u000a\u000a    ``SIGNONE`` ,   ``SIGKILL``   and   ``SIGTERM``   have the same meaning under both Unix and Windows but all the other signals are equivalent to   ``SIGTERM``   under Windows. Moreover, under Windows,   ``SIGTERM``   is implemented by posting a message to the application window, so it only works if the application does have windows. If it doesn't, as is notably always the case for the console applications, you need to use   ``SIGKILL``   to actually kill the process. Of course, this doesn't allow the process to shut down gracefully and so should be avoided if possible. \u000a\u000a   Returns 0 on success, -1 on failure. If the `rc`  parameter is not ``None``, it will be filled with a value from the  ``KillError``   enum: \u000a\u000a   ::\u000a\u000a           # KillError enumeration\u000a\u000a           wx.KILL_OK             # no error\u000a           wx.KILL_BAD_SIGNAL     # no such signal\u000a           wx.KILL_ACCESS_DENIED  # permission denied\u000a           wx.KILL_NO_PROCESS     # no such process\u000a           wx.KILL_ERROR          # another, unspecified error\u000a\u000a\u000a\u000a   The `flags`  parameter can be ``wx.KILL_NOCHILDREN`` (the default), or ``wx.KILL_CHILDREN``, in which case the child processes of this process will be killed too. Note that under Unix, for ``wx.KILL_CHILDREN`` to work you should have created the process by passing ``wx.EXEC_MAKE_GROUP_LEADER`` to :ref:`wx.Execute`. \u000a\u000a\u000a                \u000a\u000a\u000a   :param `pid`: \u000a   :type `pid`: long\u000a   :param `sig`: \u000a   :type `sig`: wx.Signal\u000a   :param `rc`: \u000a   :type `rc`: wx.KillError\u000a   :param `flags`: \u000a   :type `flags`: int\u000a\u000a\u000a\u000a\u000a   :rtype: `int`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :meth:`wx.Process.Kill` , :meth:`wx.Process.Exists` , :ref:`External Program Execution Sample <external program execution sample>`  \u000a\u000a\u000a\u000a\u000a\u000a
p57
sS'GetUserName'
p58
S'\n.. function:: wx.GetUserName()\n\n   This function returns the full user name (something like "Mr. John Smith").                  \n\n   Under Windows or NT, this function looks for the entry UserName in the wxWidgets section of the WIN.INI file. If PenWindows is running, the entry Current in the section User of the PENWIN.INI file is used. \n\n\n                \n\n   :rtype: `string`\n\n\n\n\n\n\n\n   :returns: \n\n      The full user name if successful or an empty string otherwise.  \n\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.GetUserId`  \n\n\n\n\n\n'
p59
sS'IsDragResultOk'
p60
S'\n.. function:: wx.IsDragResultOk(res)\n\n   Returns ``True`` if res indicates that something was done during a DnD operation, i.e.                  \n\n   is neither error nor none nor cancel.                  \n\n\n   :param `res`: \n   :type `res`: wx.DragResult\n\n\n\n\n   :rtype: `bool`\n\n\n\n\n\n'
p61
sS'EnableTopLevelWindows'
p62
V\u000a.. function:: wx.EnableTopLevelWindows(enable=True)\u000a\u000a   This function enables or disables all top level windows.                  \u000a\u000a   It is used by :ref:`wx.SafeYield`. \u000a\u000a                \u000a\u000a\u000a   :param `enable`: \u000a   :type `enable`: bool\u000a\u000a\u000a\u000a\u000a
p63
sS'LogVerbose'
p64
S'\n.. function:: wx.LogVerbose(message)\n\n   For verbose output.                  \n\n   Normally, it is suppressed, but might be activated if the user wishes to know more details about the program progress (another, but possibly confusing name for the same function could be  ``LogInfo`` ). \n\n                \n\n\n   :param `message`: \n   :type `message`: :class:`String`\n\n\n\n\n'
p65
sS'GetApp'
p66
S'\n.. function:: wx.GetApp()\n\n   Returns the current application object. \n\n   :rtype: :ref:`wx.PyApp`\n\n\n\n\n\n'
p67
sS'EmptyBitmapRGBA'
p68
S'\n.. function:: wx.EmptyBitmapRGBA(width, height, red=0, green=0, blue=0, alpha=0)\n\n   A compatibility wrapper for :meth:`wx.Bitmap.FromRGBA`\n\n\n'
p69
sS'NewIdRef'
p70
S'\n.. function:: wx.NewIdRef(count=1)\n\n   Reserves a new Window ID (or range of WindowIDs) and returns a \n   :class:`wx.WindowIDRef` object (or list of them) that will help \n   manage the reservation of that ID.\n\n   This function is intended to be a drop-in replacement of the old \n   and deprecated :func:`wx.NewId` function, with the added benefit \n   that the ID should never conflict with an in-use ID or other IDs \n   generated by this function.\n            \n\n\n'
p71
sS'ImageFromBuffer'
p72
S"\n.. function:: wx.ImageFromBuffer(width, height, dataBuffer, alphaBuffer=None)\n\n   Creates a :class:`Image` from the data in `dataBuffer`.  The `dataBuffer`\n   parameter must be a Python object that implements the buffer interface,\n   such as a string, array, etc.  The `dataBuffer` object is expected to\n   contain a series of RGB bytes and be width*height*3 bytes long.  A buffer\n   object can optionally be supplied for the image's alpha channel data, and\n   it is expected to be width*height bytes long.\n\n   The :class:`Image` will be created with its data and alpha pointers initialized\n   to the memory address pointed to by the buffer objects, thus saving the\n   time needed to copy the image data from the buffer object to the :class:`Image`.\n   While this has advantages, it also has the shoot-yourself-in-the-foot\n   risks associated with sharing a C pointer between two objects.\n\n   To help alleviate the risk a reference to the data and alpha buffer\n   objects are kept with the :class:`Image`, so that they won't get deleted until\n   after the wx.Image is deleted.  However please be aware that it is not\n   guaranteed that an object won't move its memory buffer to a new location\n   when it needs to resize its contents.  If that happens then the :class:`Image`\n   will end up referring to an invalid memory location and could cause the\n   application to crash.  Therefore care should be taken to not manipulate\n   the objects used for the data and alpha buffers in a way that would cause\n   them to change size.\n            \n\n\n"
p73
sS'MessageBox'
p74
V\u000a.. function:: wx.MessageBox(message, caption=MessageBoxCaptionStr, style=OK|CENTRE, parent=None, x=DefaultCoord, y=DefaultCoord)\u000a\u000a   Show a general purpose message dialog.                  \u000a\u000a   This is a convenient function which is usually used instead of using :ref:`wx.MessageDialog`  directly. Notice however that some of the features, such as extended text and custom labels for the message box buttons, are not provided by this function but only by :ref:`wx.MessageDialog`. \u000a\u000a   The return value is one of:  ``YES`` ,   ``NO`` ,   ``CANCEL`` ,   ``OK``   or   ``HELP``   (notice that this return value is  **different**  from the return value of :meth:`wx.MessageDialog.ShowModal` ). \u000a\u000a   For example: ::\u000a\u000a           answer = wx.MessageBox("Quit program?", "Confirm",\u000a                                  wx.YES_NO | wx.CANCEL, main_frame)\u000a           if answer == wx.YES:\u000a               main_frame.Close()\u000a\u000a\u000a\u000a   `message`  may contain newline characters, in which case the message will be split into separate lines, to cater for large messages. \u000a\u000a\u000a\u000a\u000a   :param `message`: Message to show in the dialog.   \u000a   :type `message`: string\u000a   :param `caption`: The dialog title.   \u000a   :type `caption`: string\u000a   :param `style`: Combination of style flags described in :ref:`wx.MessageDialog`  documentation.   \u000a   :type `style`: int\u000a   :param `parent`: Parent window.   \u000a   :type `parent`: wx.Window\u000a   :param `x`: Horizontal dialog position (ignored under MSW). Use :ref:`wx.DefaultCoord`  for  `x`  and  `y`  to let the system position the window.   \u000a   :type `x`: int\u000a   :param `y`: Vertical dialog position (ignored under MSW).  \u000a   :type `y`: int\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   :rtype: `int`\u000a\u000a\u000a\u000a                  \u000a\u000a\u000a
p75
sS'GetMousePosition'
p76
V\u000a.. function:: wx.GetMousePosition()\u000a\u000a   Returns the mouse position in screen coordinates.                  \u000a\u000a                \u000a\u000a   :rtype: :ref:`wx.Point`\u000a\u000a\u000a\u000a\u000a\u000a
p77
sS'LaunchDefaultApplication'
p78
S'\n.. function:: wx.LaunchDefaultApplication(document, flags=0)\n\n   Opens the `document`  in the application associated with the files of this type.                  \n\n   The `flags`  parameter is currently not used \n\n   Returns ``True`` if the application was successfully launched. \n\n\n                \n\n\n   :param `document`: \n   :type `document`: string\n   :param `flags`: \n   :type `flags`: int\n\n\n\n\n   :rtype: `bool`\n\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.LaunchDefaultBrowser`, :ref:`wx.Execute`  \n\n\n\n\n\n'
p79
sS'LogStatus'
p80
V\u000a.. function:: wx.LogStatus(*args, **kw)\u000a\u000a\u000a\u000a   |overload| Overloaded Implementations:\u000a\u000a   **~~~**\u000a\u000a   \u000a   **LogStatus** `(frame, message)`\u000a   \u000a   Messages logged by this function will appear in the statusbar of the `frame`  or of the top level application window by default (i.e.                  \u000a   \u000a   when using the second version of the functions). \u000a   \u000a   If the target frame doesn't have a statusbar, the message will be lost. \u000a   \u000a                   \u000a   \u000a   \u000a   :param `frame`: \u000a   :type `frame`: wx.Frame\u000a   :param `message`: \u000a   :type `message`: :class:`String`\u000a   \u000a   \u000a   \u000a   \u000a   **~~~**\u000a\u000a   \u000a   **LogStatus** `(message)`\u000a   \u000a   \u000a   \u000a   \u000a   :param `message`: \u000a   :type `message`: :class:`String`\u000a   \u000a   \u000a   \u000a   \u000a   **~~~**\u000a\u000a\u000a\u000a
p81
sS'FindWindowById'
p82
S'\n.. function:: wx.FindWindowById(id, parent=None)\n\n                           FindWindowById(id, parent=None) . Window\n\n                           Find the first window in the application with the given id. If parent\n                           is None, the search will start from all top-level frames and dialog\n                           boxes; if non-None, the search will be limited to the given window\n                           hierarchy. The search is recursive in both cases.\n                         \n\n   :rtype: :ref:`wx.Window`\n\n\n\n\n\n'
p83
sS'version'
p84
S'\n.. function:: wx.version()\n\n   Returns a string containing version and port info\n\n\n'
p85
sS'FileSelectorEx'
p86
V\u000a.. function:: wx.FileSelectorEx(message=FileSelectorPromptStr, default_path=EmptyString, default_filename=EmptyString, indexDefaultExtension=None, wildcard=FileSelectorDefaultWildcardStr, flags=0, parent=None, x=DefaultCoord, y=DefaultCoord)\u000a\u000a   An extended version of FileSelector.                  \u000a\u000a\u000a   :param `message`: \u000a   :type `message`: string\u000a   :param `default_path`: \u000a   :type `default_path`: string\u000a   :param `default_filename`: \u000a   :type `default_filename`: string\u000a   :param `indexDefaultExtension`: \u000a   :type `indexDefaultExtension`: int\u000a   :param `wildcard`: \u000a   :type `wildcard`: string\u000a   :param `flags`: \u000a   :type `flags`: int\u000a   :param `parent`: \u000a   :type `parent`: wx.Window\u000a   :param `x`: \u000a   :type `x`: int\u000a   :param `y`: \u000a   :type `y`: int\u000a\u000a\u000a\u000a\u000a   :rtype: `string`\u000a\u000a\u000a\u000a\u000a\u000a
p87
sS'GetBatteryState'
p88
V\u000a.. function:: wx.GetBatteryState()\u000a\u000a   Returns battery state as one of  ``BATTERY_NORMAL_STATE`` ,   ``BATTERY_LOW_STATE`` ,   ``BATTERY_CRITICAL_STATE`` ,   ``BATTERY_SHUTDOWN_STATE``   or   ``BATTERY_UNKNOWN_STATE`` .                   \u000a\u000a    ``BATTERY_UNKNOWN_STATE``   is also the default on platforms where this feature is not implemented (currently everywhere but MS Windows). \u000a\u000a                \u000a\u000a   :rtype: :ref:`wx.BatteryState`\u000a\u000a\u000a\u000a\u000a\u000a
p89
sS'GetLocale'
p90
S'\n.. function:: wx.GetLocale()\n\n   Get the current locale object (note that it may be ``None``!)                  \n\n   :rtype: :ref:`wx.Locale`\n\n\n\n\n\n'
p91
sS'GetDisplayPPI'
p92
V\u000a.. function:: wx.GetDisplayPPI()\u000a\u000a   Returns the display resolution in pixels per inch.                  \u000a\u000a   The  ``x``   component of the returned  :ref:`wx.Size`  object contains the horizontal resolution and the  ``y``   one   \u000a\u000a\u000a\u000a                \u000a\u000a   :rtype: :ref:`wx.Size`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. versionadded:: 2.9.0 \u000a     \u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.Display`  \u000a\u000a\u000a\u000a\u000a\u000a
p93
sS'BeginBusyCursor'
p94
V\u000a.. function:: wx.BeginBusyCursor(cursor=HOURGLASS_CURSOR)\u000a\u000a   Changes the cursor to the given cursor for all windows in the application.                  \u000a\u000a   Use :ref:`wx.EndBusyCursor`  to revert the cursor back to its previous state. These two calls can be nested, and a counter ensures that only the outer calls take effect. \u000a\u000a\u000a                \u000a\u000a\u000a   :param `cursor`: \u000a   :type `cursor`: wx.Cursor\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.IsBusy`, :ref:`wx.BusyCursor`  \u000a\u000a\u000a\u000a\u000a\u000a
p95
sS'DateTimeFromJDN'
p96
S'\n.. function:: wx.DateTimeFromJDN(jdn)\n\n   Compatibility wrapper for :meth:`DateTime.FromJDN`\n\n\n'
p97
sS'IsPlatform64Bit'
p98
S"\n.. function:: wx.IsPlatform64Bit()\n\n   Returns ``True`` if the operating system the program is running under is 64 bit.                  \n\n   The check is performed at run-time and may differ from the value available at compile-time (at compile-time you can just check if  ``sizeof(void*) == 8`` ) since the program could be running in emulation mode or in a mixed 32/64 bit system (bi-architecture operating system). \n\n\n                \n\n   :rtype: `bool`\n\n\n\n\n\n\n\n   .. note:: \n\n      This function is not 100% reliable on some systems given the fact that there isn't always a standard way to do a reliable check on the OS architecture.  \n\n\n\n\n\n"
p99
sS'FindWindowByLabel'
p100
V\u000a.. function:: wx.FindWindowByLabel(label, parent=None)\u000a\u000a\u000a\u000a\u000a\u000a   Find a window by its label. Depending on the type of window, the label may be a window title or panel item label. If `parent`  is ``None``, the search will start from all top-level frames and dialog boxes; if non-NULL, the search will be limited to the given window hierarchy. The search is recursive in both cases. \u000a\u000a                \u000a\u000a\u000a   :param `label`: \u000a   :type `label`: string\u000a   :param `parent`: \u000a   :type `parent`: wx.Window\u000a\u000a\u000a\u000a\u000a   :rtype: :ref:`wx.Window`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. wxdeprecated:: \u000a      Replaced by :meth:`wx.Window.FindWindowByLabel` .   \u000a\u000a\u000a\u000a\u000a\u000a
p101
sS'DisableAsserts'
p102
V\u000a.. function:: wx.DisableAsserts()\u000a\u000a   Disable the condition checks in the assertions.                  \u000a\u000a   This is the same as calling :ref:`wx.SetAssertHandler`  with ``None`` handler. \u000a\u000a\u000a                 \u000a\u000a\u000a\u000a   .. versionadded:: 2.9.0 \u000a    \u000a\u000a\u000a\u000a\u000a\u000a
p103
sS'GetUserHome'
p104
S"\n.. function:: wx.GetUserHome(user=EmptyString)\n\n   Returns the home directory for the given user.                  \n\n   If the `user`  is empty (default value), this function behaves like :ref:`wx.GetHomeDir`  (i.e. returns the current user home directory). \n\n   If the home directory couldn't be determined, an empty string is returned. \n\n                \n\n\n   :param `user`: \n   :type `user`: string\n\n\n\n\n   :rtype: `string`\n\n\n\n\n\n"
p105
sS'IsBusy'
p106
S'\n.. function:: wx.IsBusy()\n\n   Returns ``True`` if between two :ref:`wx.BeginBusyCursor`  and :ref:`wx.EndBusyCursor`  calls.                  \n\n\n                \n\n   :rtype: `bool`\n\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.BusyCursor`.  \n\n\n\n\n\n'
p107
sS'GetStockLabel'
p108
V\u000a.. function:: wx.GetStockLabel(id, flags=STOCK_WITH_MNEMONIC)\u000a\u000a   Returns label that should be used for given `id`  element.                  \u000a\u000a\u000a\u000a\u000a   :param `id`: Given id of the :ref:`wx.MenuItem`, :ref:`wx.Button`, :ref:`wx.ToolBar`  tool, etc.   \u000a   :type `id`: wx.WindowID\u000a   :param `flags`: Combination of the elements of StockLabelQueryFlag.  \u000a   :type `flags`: long\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   :rtype: `string`\u000a\u000a\u000a\u000a                  \u000a\u000a\u000a
p109
sS'AutoBufferedPaintDCFactory'
p110
V\u000a.. function:: wx.AutoBufferedPaintDCFactory(window)\u000a\u000a   Check if the window is natively double buffered and will return a :ref:`wx.PaintDC`  if it is, a :ref:`wx.BufferedPaintDC`  otherwise.                  \u000a\u000a   It is the caller's responsibility to delete the :ref:`wx.DC`  pointer when finished with it.                  \u000a\u000a\u000a   :param `window`: \u000a   :type `window`: wx.Window\u000a\u000a\u000a\u000a\u000a   :rtype: :ref:`wx.DC`\u000a\u000a\u000a\u000a\u000a\u000a
p111
sS'BitmapFromBufferRGBA'
p112
S'\n.. function:: wx.BitmapFromBufferRGBA(width, height, dataBuffer)\n\n   A compatibility wrapper for :meth:`wx.Bitmap.FromBufferRGBA`\n\n\n'
p113
sS'SafeYield'
p114
V\u000a.. function:: wx.SafeYield(win=None, onlyIfNeeded=False)\u000a\u000a   Calls :meth:`wx.App.SafeYield` .                  \u000a\u000a                \u000a\u000a\u000a   :param `win`: \u000a   :type `win`: wx.Window\u000a   :param `onlyIfNeeded`: \u000a   :type `onlyIfNeeded`: bool\u000a\u000a\u000a\u000a\u000a   :rtype: `bool`\u000a\u000a\u000a\u000a\u000a\u000a
p115
sS'MilliSleep'
p116
S'\n.. function:: wx.MilliSleep(milliseconds)\n\n   Sleeps for the specified number of milliseconds.                  \n\n   Notice that usage of this function is encouraged instead of calling usleep(3) directly because the standard `usleep()`  function is not ``MT`` safe. \n\n                \n\n\n   :param `milliseconds`: \n   :type `milliseconds`: long\n\n\n\n\n'
p117
sS'GetFontFromUser'
p118
V\u000a.. function:: wx.GetFontFromUser(parent, fontInit, caption=EmptyString)\u000a\u000a   Shows the font selection dialog and returns the font selected by user or invalid font (use :meth:`wx.Font.IsOk`   to test whether a font is valid) if the dialog was cancelled.                  \u000a\u000a\u000a\u000a\u000a   :param `parent`: The parent window for the font selection dialog.   \u000a   :type `parent`: wx.Window\u000a   :param `fontInit`: If given, this will be the font initially selected in the dialog.   \u000a   :type `fontInit`: wx.Font\u000a   :param `caption`: If given, this will be used for the dialog caption.  \u000a   :type `caption`: string\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   :rtype: :ref:`wx.Font`\u000a\u000a\u000a\u000a                  \u000a\u000a\u000a
p119
sS'SysErrorCode'
p120
S'\n.. function:: wx.SysErrorCode()\n\n   Returns the error code from the last system call.                  \n\n   This function uses  ``errno``   on Unix platforms and   ``GetLastError``   under Win32. \n\n\n                \n\n   :rtype: `int`\n\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.SysErrorMsg`, :ref:`wx.LogSysError`  \n\n\n\n\n\n'
p121
sS'GetNumberFromUser'
p122
V\u000a.. function:: wx.GetNumberFromUser(message, prompt, caption, value, min=0, max=100, parent=None, pos=DefaultPosition)\u000a\u000a   Shows a dialog asking the user for numeric input.                  \u000a\u000a   The dialogs title is set to  ``caption`` , it contains a (possibly) multiline   ``message``   above the single line   ``prompt``   and the zone for entering the number. \u000a\u000a   The number entered must be in the range  ``min``   to   ``max``   (both of which should be positive) and   ``value``   is the initial value of it. If the user enters an invalid value, it is forced to fall into the specified range. If the user cancels the dialog, the function returns -1. If it is important to distinguish between cancelling the dialog and actually entering -1 in it, i.e. if -1 is a valid input value, this convenience function can't be used and  :ref:`wx.NumberEntryDialog`  should be used directly instead. \u000a\u000a   Dialog is centered on its  ``parent``   unless an explicit position is given in   ``pos`` . \u000a\u000a\u000a\u000a                \u000a\u000a\u000a   :param `message`: \u000a   :type `message`: string\u000a   :param `prompt`: \u000a   :type `prompt`: string\u000a   :param `caption`: \u000a   :type `caption`: string\u000a   :param `value`: \u000a   :type `value`: long\u000a   :param `min`: \u000a   :type `min`: long\u000a   :param `max`: \u000a   :type `max`: long\u000a   :param `parent`: \u000a   :type `parent`: wx.Window\u000a   :param `pos`: \u000a   :type `pos`: wx.Point\u000a\u000a\u000a\u000a\u000a   :rtype: `long`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.NumberEntryDialog`    \u000a\u000a\u000a\u000a\u000a\u000a
p123
sS'ColourDisplay'
p124
S'\n.. function:: wx.ColourDisplay()\n\n   Returns ``True`` if the display is colour, ``False`` otherwise.                  \n\n                \n\n   :rtype: `bool`\n\n\n\n\n\n'
p125
sS'LoadFileSelector'
p126
V\u000a.. function:: wx.LoadFileSelector(what, extension, default_name=EmptyString, parent=None)\u000a\u000a   Ask for filename to load.                  \u000a\u000a\u000a   :param `what`: \u000a   :type `what`: string\u000a   :param `extension`: \u000a   :type `extension`: string\u000a   :param `default_name`: \u000a   :type `default_name`: string\u000a   :param `parent`: \u000a   :type `parent`: wx.Window\u000a\u000a\u000a\u000a\u000a   :rtype: `string`\u000a\u000a\u000a\u000a\u000a\u000a
p127
sS'LogSysError'
p128
S'\n.. function:: wx.LogSysError(message)\n\n   Mostly used by wxWidgets itself, but might be handy for logging errors after system call (API function) failure.                  \n\n   It logs the specified message text as well as the last system error code (`errno`  or `GetLastError()`  depending on the platform) and the corresponding error message. The second form of this function takes the error code explicitly as the first argument. \n\n\n                \n\n\n   :param `message`: \n   :type `message`: :class:`String`\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.SysErrorCode`, :ref:`wx.SysErrorMsg`  \n\n\n\n\n\n'
p129
sS'DateTimeFromHMS'
p130
S'\n.. function:: wx.DateTimeFromHMS(hour, minute=0, second=0, millisecond=0)\n\n   Compatibility wrapper for :meth:`DateTime.FromHMS`\n\n\n'
p131
sS'GetEmailAddress'
p132
S"\n.. function:: wx.GetEmailAddress()\n\n   Copies the user's email address into the supplied buffer, by concatenating the values returned by :ref:`wx.GetFullHostName`  and :ref:`wx.GetUserId`.                  \n\n\n                \n\n   :rtype: `string`\n\n\n\n\n\n\n\n   :returns: \n\n      ``True`` if successful, ``False`` otherwise.  \n\n\n\n\n\n"
p133
sS'Exit'
p134
V\u000a.. function:: wx.Exit()\u000a\u000a   Exits application after calling :meth:`wx.App.OnExit` .                  \u000a\u000a   Should only be used in an emergency: normally the top-level frame should be deleted (after deleting all other frames) to terminate the application. See :ref:`wx.CloseEvent`  and :ref:`wx.App`. \u000a\u000a                 \u000a\u000a\u000a
p135
sS'RegisterId'
p136
S'\n.. function:: wx.RegisterId(id)\n\n   Ensures that Ids subsequently generated by :ref:`wx.NewId`  do not clash with the given `id`.                  \n\n                \n\n\n   :param `id`: \n   :type `id`: int\n\n\n\n\n'
p137
sS'GetUserId'
p138
S'\n.. function:: wx.GetUserId()\n\n   This function returns the "user id" also known as "login name" under Unix (i.e.                  \n\n   something like "jsmith"). It uniquely identifies the current user (on this system). Under Windows or NT, this function first looks in the environment variables ``USER`` and ``LOGNAME``; if neither of these is found, the entry **UserId**  in the **wxWidgets**  section of the WIN.INI file is tried. \n\n\n                \n\n   :rtype: `string`\n\n\n\n\n\n\n\n   :returns: \n\n      The login name if successful or an empty string otherwise.  \n\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.GetUserName`  \n\n\n\n\n\n'
p139
sS'SaveFileSelector'
p140
V\u000a.. function:: wx.SaveFileSelector(what, extension, default_name=EmptyString, parent=None)\u000a\u000a   Ask for filename to save.                  \u000a\u000a\u000a   :param `what`: \u000a   :type `what`: string\u000a   :param `extension`: \u000a   :type `extension`: string\u000a   :param `default_name`: \u000a   :type `default_name`: string\u000a   :param `parent`: \u000a   :type `parent`: wx.Window\u000a\u000a\u000a\u000a\u000a   :rtype: `string`\u000a\u000a\u000a\u000a\u000a\u000a
p141
sS'ImageFromData'
p142
S'\n.. function:: wx.ImageFromData(width, height, data)\n\n   Compatibility wrapper for creating an image from RGB data\n\n\n'
p143
sS'GetTextFromUser'
p144
V\u000a.. function:: wx.GetTextFromUser(message, caption=GetTextFromUserPromptStr, default_value=EmptyString, parent=None, x=DefaultCoord, y=DefaultCoord, centre=True)\u000a\u000a   Pop up a dialog box with title set to `caption`,  ``message`` , and a   ``default_value`` .                   \u000a\u000a   The user may type in text and press ``wx.OK`` to return this text, or press Cancel to return the empty string. \u000a\u000a   If  ``centre``   is ``True``, the message text (which may include new line characters) is centred; if ``False``, the message is left-justified. \u000a\u000a   This function is a wrapper around :ref:`wx.TextEntryDialog`  and while it is usually more convenient to use, using the dialog directly is more flexible, e.g. it allows you to specify the  ``TE_MULTILINE``   to allow the user enter multiple lines of text while this function is limited to single line entry only. \u000a\u000a                \u000a\u000a\u000a   :param `message`: \u000a   :type `message`: string\u000a   :param `caption`: \u000a   :type `caption`: string\u000a   :param `default_value`: \u000a   :type `default_value`: string\u000a   :param `parent`: \u000a   :type `parent`: wx.Window\u000a   :param `x`: \u000a   :type `x`: int\u000a   :param `y`: \u000a   :type `y`: int\u000a   :param `centre`: \u000a   :type `centre`: bool\u000a\u000a\u000a\u000a\u000a   :rtype: `string`\u000a\u000a\u000a\u000a\u000a\u000a
p145
sS'IsMainThread'
p146
S'\n.. function:: wx.IsMainThread()\n\n   Returns ``True`` if the current thread is what  considers the GUI thread. \n\n   :rtype: `bool`\n\n\n\n\n\n'
p147
sS'DisplaySize'
p148
V\u000a.. function:: wx.DisplaySize()\u000a\u000a   Returns the display size in pixels.                  \u000a\u000a   Either of output pointers can be ``None`` if the caller is not interested in the corresponding value. \u000a\u000a\u000a                \u000a\u000a   :rtype: `tuple`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   :returns: \u000a\u000a      ( `width`, `height` ) \u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.GetDisplaySize`, :ref:`wx.Display`  \u000a\u000a\u000a\u000a\u000a\u000a
p149
sS'FFont'
p150
S'\n.. function:: wx.FFont(pointSize, family, flags=FONTFLAG_DEFAULT, faceName=EmptyString, encoding=FONTENCODING_DEFAULT)\n\n\n\n'
p151
sS'ImageFromBitmap'
p152
S'\n.. function:: wx.ImageFromBitmap(bitmap)\n\n   Create a :class:`Image` from a :class:`wx.Bitmap`\n\n\n'
p153
sS'MacThemeColour'
p154
S'\n.. function:: wx.MacThemeColour(themeBrushID)\n\n\n\n   :rtype: :ref:`wx.Colour`\n\n\n\n\n\n'
p155
sS'InitAllImageHandlers'
p156
S'\n.. function:: wx.InitAllImageHandlers()\n\n   Initializes all available image handlers.                  \n\n   This function calls :meth:`wx.Image.AddHandler`   for all the available image handlers (see :ref:`Available image handlers <wx.Image>`  for the full list). Calling it is the simplest way to initialize :ref:`wx.Image`  but it creates and registers even the handlers your program may not use. If you want to avoid the overhead of doing this you need to call :meth:`wx.Image.AddHandler`   manually just for the handlers that you do want to use. \n\n\n                 \n\n\n\n   .. seealso:: :ref:`wx.Image`, :ref:`wx.ImageHandler`  \n\n\n\n\n\n'
p157
sS'GetSingleChoice'
p158
V\u000a.. function:: wx.GetSingleChoice(*args, **kw)\u000a\u000a\u000a\u000a   |overload| Overloaded Implementations:\u000a\u000a   **~~~**\u000a\u000a   \u000a   **GetSingleChoice** `(message, caption, aChoices, parent=None, x=DefaultCoord, y=DefaultCoord, centre=True, width=CHOICE_WIDTH, height=CHOICE_HEIGHT, initialSelection=0)`\u000a   \u000a   Pops up a dialog box containing a message, OK/Cancel buttons and a single-selection listbox.                  \u000a   \u000a   The user may choose an item and press ``wx.OK`` to return a string or Cancel to return the empty string. Use :ref:`wx.GetSingleChoiceIndex`  if empty string is a valid choice and if you want to be able to detect pressing Cancel reliably. \u000a   \u000a   You may pass the list of strings to choose from either using  ``choices``   which is an array of  `n`  strings for the listbox or by using a single  ``aChoices``   parameter of type  :ref:`ArrayString`. \u000a   \u000a   If  ``centre``   is ``True``, the message text (which may include new line characters) is centred; if ``False``, the message is left-justified. \u000a   \u000a   \u000a   \u000a   \u000a   \u000a   **~~~**\u000a\u000a   \u000a   **GetSingleChoice** `(message, caption, choices, initialSelection, parent=None)`\u000a   \u000a   \u000a   \u000a   \u000a   :param `message`: \u000a   :type `message`: string\u000a   :param `caption`: \u000a   :type `caption`: string\u000a   :param `choices`: \u000a   :type `choices`: list of strings\u000a   :param `initialSelection`: \u000a   :type `initialSelection`: int\u000a   :param `parent`: \u000a   :type `parent`: wx.Window\u000a   \u000a   \u000a   \u000a   \u000a   :rtype: `string`\u000a   \u000a   \u000a   \u000a   \u000a   \u000a   **~~~**\u000a\u000a\u000a\u000a
p159
sS'QueueEvent'
p160
S"\n.. function:: wx.QueueEvent(dest, event)\n\n   Queue an event for processing on the given object.                  \n\n   This is a wrapper around :meth:`wx.EvtHandler.QueueEvent` , see its documentation for more details. \n\n\n\n\n\n\n   :param `dest`: The object to queue the event on, can't be  ``NULL`` .    \n   :type `dest`: wx.EvtHandler\n   :param `event`: The heap-allocated and non- ``NULL``   event to queue, the function takes ownership of it.    \n   :type `event`: wx.Event\n\n\n\n\n\n\n                  \n\n\n"
p161
sS'FindMenuItemId'
p162
V\u000a.. function:: wx.FindMenuItemId(frame, menuString, itemString)\u000a\u000a   Find a menu item identifier associated with the given frame's menu bar.                  \u000a\u000a                \u000a\u000a\u000a   :param `frame`: \u000a   :type `frame`: wx.Frame\u000a   :param `menuString`: \u000a   :type `menuString`: string\u000a   :param `itemString`: \u000a   :type `itemString`: string\u000a\u000a\u000a\u000a\u000a   :rtype: `int`\u000a\u000a\u000a\u000a\u000a\u000a
p163
sS'BitmapFromBuffer'
p164
S'\n.. function:: wx.BitmapFromBuffer(width, height, dataBuffer, alphaBuffer=None)\n\n   A compatibility wrapper for :meth:`wx.Bitmap.FromBuffer` and :meth:`wx.Bitmap.FromBufferAndAlpha`\n\n\n'
p165
sS'DisplaySizeMM'
p166
V\u000a.. function:: wx.DisplaySizeMM()\u000a\u000a   Returns the display size in millimeters.                  \u000a\u000a   Either of output pointers can be ``None`` if the caller is not interested in the corresponding value. \u000a\u000a\u000a                \u000a\u000a   :rtype: `tuple`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   :returns: \u000a\u000a      ( `width`, `height` ) \u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.GetDisplaySizeMM`, :ref:`wx.Display`  \u000a\u000a\u000a\u000a\u000a\u000a
p167
sS'Bell'
p168
S'\n.. function:: wx.Bell()\n\n   Ring the system bell.                  \n\n\n\n\n\n\n\n\n\n\n   .. note:: \n\n      This function is categorized as a GUI one and so is not thread-safe.  \n\n\n\n\n\n'
p169
sS'GetClientDisplayRect'
p170
V\u000a.. function:: wx.GetClientDisplayRect()\u000a\u000a   Returns the dimensions of the work area on the display.                  \u000a\u000a   On Windows this means the area not covered by the taskbar, etc. Other platforms are currently defaulting to the whole display until a way is found to provide this info for all window managers, etc. \u000a\u000a\u000a                \u000a\u000a   :rtype: :ref:`wx.Rect`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.Display`  \u000a\u000a\u000a\u000a\u000a\u000a
p171
sS'ClientDisplayRect'
p172
V\u000a.. function:: wx.ClientDisplayRect()\u000a\u000a   Returns the dimensions of the work area on the display.                  \u000a\u000a   This is the same as :ref:`wx.GetClientDisplayRect`  but allows retrieving the individual components instead of the entire rectangle. \u000a\u000a   Any of the output pointers can be ``None`` if the corresponding value is not needed by the caller. \u000a\u000a\u000a                \u000a\u000a   :rtype: `tuple`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   :returns: \u000a\u000a      ( `x`, `y`, `width`, `height` ) \u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.Display`  \u000a\u000a\u000a\u000a\u000a\u000a
p173
sS'DirSelector'
p174
V\u000a.. function:: wx.DirSelector(message=DirSelectorPromptStr, default_path=EmptyString, style=0, pos=DefaultPosition, parent=None)\u000a\u000a   Pops up a directory selector dialog.                  \u000a\u000a   The arguments have the same meaning as those of :meth:`DirDialog.__init__` . The message is displayed at the top, and the default_path, if specified, is set as the initial selection. \u000a\u000a   The application must check for an empty return value (if the user pressed Cancel). For example: \u000a\u000a   ::\u000a\u000a           selector = wx.DirSelector("Choose a folder")\u000a           if selector.strip():\u000a               # Do something with the folder name\u000a               print selector\u000a\u000a\u000a\u000a                \u000a\u000a\u000a   :param `message`: \u000a   :type `message`: string\u000a   :param `default_path`: \u000a   :type `default_path`: string\u000a   :param `style`: \u000a   :type `style`: long\u000a   :param `pos`: \u000a   :type `pos`: wx.Point\u000a   :param `parent`: \u000a   :type `parent`: wx.Window\u000a\u000a\u000a\u000a\u000a   :rtype: `string`\u000a\u000a\u000a\u000a\u000a\u000a
p175
sS'LogGeneric'
p176
S'\n.. function:: wx.LogGeneric(level, message)\n\n   Logs a message with the given LogLevel.                  \n\n   E.g. using  ``LOG_Message``   as first argument, this function behaves like  :ref:`wx.LogMessage`. \n\n                \n\n\n   :param `level`: \n   :type `level`: wx.LogLevel\n   :param `message`: \n   :type `message`: :class:`String`\n\n\n\n\n'
p177
sS'Shutdown'
p178
S"\n.. function:: wx.Shutdown(flags=SHUTDOWN_POWEROFF)\n\n   This function shuts down or reboots the computer depending on the value of the `flags`.                  \n\n\n\n\n   :param `flags`: One of  ``SHUTDOWN_POWEROFF`` ,   ``SHUTDOWN_REBOOT``   or   ``SHUTDOWN_LOGOFF``   (currently implemented only for MSW) possibly combined with   ``SHUTDOWN_FORCE``   which forces shutdown under MSW by forcefully terminating all the applications. As doing this can result in a data loss, this flag shouldn't be used unless really necessary.  \n   :type `flags`: int\n\n\n\n\n\n\n   :rtype: `bool`\n\n\n\n\n                  \n\n\n\n   :returns: \n\n      ``True`` on success, ``False`` if an error occurred.  \n\n\n\n\n\n\n\n   .. note:: \n\n      Note that performing the shutdown requires the corresponding access rights (superuser under Unix, ``SE_SHUTDOWN`` privilege under Windows NT) and that this function is only implemented under Unix and MSW.  \n\n\n\n\n\n"
p179
sS'LogMessage'
p180
S'\n.. function:: wx.LogMessage(message)\n\n   For all normal, informational messages.                  \n\n   They also appear in a message box by default (but it can be changed). \n\n                \n\n\n   :param `message`: \n   :type `message`: :class:`String`\n\n\n\n\n'
p181
sS'GetDisplaySizeMM'
p182
V\u000a.. function:: wx.GetDisplaySizeMM()\u000a\u000a   Returns the display size in millimeters.                  \u000a\u000a\u000a                \u000a\u000a   :rtype: :ref:`wx.Size`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.Display`  \u000a\u000a\u000a\u000a\u000a\u000a
p183
sS'Usleep'
p184
S'\n.. function:: wx.Usleep(milliseconds)\n\n\n\n\n\n   Sleeps for the specified number of milliseconds. \n\n                \n\n\n   :param `milliseconds`: \n   :type `milliseconds`: long\n\n\n\n\n\n\n   .. wxdeprecated:: \n      This function is deprecated because its name is misleading: notice that the argument is in milliseconds, not microseconds. Please use either :ref:`wx.MilliSleep`  or :ref:`wx.MicroSleep`  depending on the resolution you need.   \n\n\n\n\n\n'
p185
sS'DisplayDepth'
p186
S'\n.. function:: wx.DisplayDepth()\n\n   Returns the depth of the display (a value of 1 denotes a monochrome display).                  \n\n                \n\n   :rtype: `int`\n\n\n\n\n\n'
p187
sS'GetPowerType'
p188
V\u000a.. function:: wx.GetPowerType()\u000a\u000a   Returns the type of power source as one of  ``POWER_SOCKET`` ,   ``POWER_BATTERY``   or   ``POWER_UNKNOWN`` .                   \u000a\u000a    ``POWER_UNKNOWN``   is also the default on platforms where this feature is not implemented (currently everywhere but MS Windows). \u000a\u000a                \u000a\u000a   :rtype: :ref:`wx.PowerType`\u000a\u000a\u000a\u000a\u000a\u000a
p189
sS'IntersectRect'
p190
S'\n.. function:: wx.IntersectRect(r1, r2)\n\n                           Calculate and return the intersection of r1 and r2.  Returns None if there\n                           is no intersection. \n\n   :rtype: :ref:`PyObject`\n\n\n\n\n\n'
p191
sS'Abort'
p192
S"\n.. function:: wx.Abort()\n\n   Exits the program immediately.                  \n\n   This is a simple wrapper for the standard abort() function which is not available under all platforms (currently only Windows ``CE`` doesn't provide it). \n\n                 \n\n\n\n   .. versionadded:: 2.9.4 \n     \n\n\n\n\n\n"
p193
sS'GetPasswordFromUser'
p194
V\u000a.. function:: wx.GetPasswordFromUser(message, caption=GetPasswordFromUserPromptStr, default_value=EmptyString, parent=None, x=DefaultCoord, y=DefaultCoord, centre=True)\u000a\u000a   Similar to :ref:`wx.GetTextFromUser`  but the text entered in the dialog is not shown on screen but replaced with stars.                  \u000a\u000a   This is intended to be used for entering passwords as the function name implies. \u000a\u000a                \u000a\u000a\u000a   :param `message`: \u000a   :type `message`: string\u000a   :param `caption`: \u000a   :type `caption`: string\u000a   :param `default_value`: \u000a   :type `default_value`: string\u000a   :param `parent`: \u000a   :type `parent`: wx.Window\u000a   :param `x`: \u000a   :type `x`: int\u000a   :param `y`: \u000a   :type `y`: int\u000a   :param `centre`: \u000a   :type `centre`: bool\u000a\u000a\u000a\u000a\u000a   :rtype: `string`\u000a\u000a\u000a\u000a\u000a\u000a
p195
sS'LogWarning'
p196
S"\n.. function:: wx.LogWarning(message)\n\n   For warnings - they are also normally shown to the user, but don't interrupt the program work.                  \n\n                \n\n\n   :param `message`: \n   :type `message`: :class:`String`\n\n\n\n\n"
p197
sS'PostEvent'
p198
S'\n.. function:: wx.PostEvent(dest, event)\n\n   In a GUI application, this function posts `event`  to the specified `dest`  object using :meth:`wx.EvtHandler.AddPendingEvent` .                  \n\n   Otherwise, it dispatches `event`  immediately using :meth:`wx.EvtHandler.ProcessEvent` . See the respective documentation for details (and caveats). Because of limitation of :meth:`wx.EvtHandler.AddPendingEvent`   this function is not thread-safe for event objects having :ref:`String`  fields, use :ref:`wx.QueueEvent`  instead. \n\n                \n\n\n   :param `dest`: \n   :type `dest`: wx.EvtHandler\n   :param `event`: \n   :type `event`: wx.Event\n\n\n\n\n'
p199
sS'IsPlatformLittleEndian'
p200
S'\n.. function:: wx.IsPlatformLittleEndian()\n\n   Returns ``True`` if the current platform is little endian (instead of big endian).                  \n\n   The check is performed at run-time. \n\n\n                \n\n   :rtype: `bool`\n\n\n\n\n\n\n\n   .. seealso:: :ref:`Byte Order Functions and Macros <byte order functions and macros>`  \n\n\n\n\n\n'
p201
sS'EndBusyCursor'
p202
S'\n.. function:: wx.EndBusyCursor()\n\n   Changes the cursor back to the original cursor, for all windows in the application.                  \n\n   Use with :ref:`wx.BeginBusyCursor`. \n\n\n                 \n\n\n\n   .. seealso:: :ref:`wx.IsBusy`, :ref:`wx.BusyCursor`  \n\n\n\n\n\n'
p203
sS'EmptyIcon'
p204
S'\n.. function:: wx.EmptyIcon()\n\n   A compatibility wrapper for the :class:`Icon` constructor\n\n\n'
p205
sS'ImageFromStream'
p206
S'\n.. function:: wx.ImageFromStream(stream, type=BITMAP_TYPE_ANY, index=-1)\n\n   Load an image from a stream (file-like object)\n\n\n'
p207
sS'NewId'
p208
S'\n.. function:: wx.NewId()\n\n\n\n   Generates an integer identifier unique to this run of the program. \n\n                \n\n   :rtype: `int`\n\n\n\n\n\n\n\n   .. wxdeprecated:: \n      IDs generated by this function can possibly conflict with IDs used elsewhere in the application code. It is recommended to instead use the ``wx.ID_ANY`` ``ID`` to assign generated IDs for the controls, menu items and etc. that you create in the application. These IDs are guaranteed to not conflict with the other IDs that are in use in the application. For those cases where you need to create an ``ID`` that can be used more than once then please see :func:`wx.NewIdRef`. \n\n\n\n\n\n'
p209
sS'GetAccelFromString'
p210
S'\n.. function:: wx.GetAccelFromString(label)\n\n\n\n'
p211
sS'BitmapFromImage'
p212
S'\n.. function:: wx.BitmapFromImage(image)\n\n   A compatibility wrapper for the wx.Bitmap(wx.Image) constructor\n\n\n'
p213
sS'FileSelector'
p214
V\u000a.. function:: wx.FileSelector(message, default_path=EmptyString, default_filename=EmptyString, default_extension=EmptyString, wildcard=FileSelectorDefaultWildcardStr, flags=0, parent=None, x=DefaultCoord, y=DefaultCoord)\u000a\u000a   Pops up a file selector box.                  \u000a\u000a   In Windows, this is the common file selector dialog. In X, this is a file selector box with the same functionality. The path and filename are distinct elements of a full file pathname. If path is empty, the current directory will be used. If filename is empty, no default filename will be supplied. The wildcard determines what files are displayed in the file selector, and file extension supplies a type extension for the required filename. Flags may be a combination of ``wx.FD_OPEN``, ``wx.FD_SAVE``, ``wx.FD_OVERWRITE_PROMPT`` or ``wx.FD_FILE_MUST_EXIST``. \u000a\u000a\u000a   Both the Unix and Windows versions implement a wildcard filter. Typing a filename containing wildcards (, ?) in the filename text item, and clicking on Ok, will result in only those files matching the pattern being displayed.  \u000a\u000a   The wildcard may be a specification for multiple types of file with a description for each, such as: \u000a\u000a   ::\u000a\u000a           wildcard = "BMP files (*.bmp)|*.bmp|GIF files (*.gif)|*.gif"\u000a\u000a\u000a\u000a   The application must check for an empty return value (the user pressed Cancel). For example: \u000a\u000a   ::\u000a\u000a           filename = wx.FileSelector("Choose a file to open")\u000a\u000a           if filename.strip():\u000a               # work with the file\u000a               print filename\u000a\u000a           # else: cancelled by user\u000a\u000a\u000a\u000a                \u000a\u000a\u000a   :param `message`: \u000a   :type `message`: string\u000a   :param `default_path`: \u000a   :type `default_path`: string\u000a   :param `default_filename`: \u000a   :type `default_filename`: string\u000a   :param `default_extension`: \u000a   :type `default_extension`: string\u000a   :param `wildcard`: \u000a   :type `wildcard`: string\u000a   :param `flags`: \u000a   :type `flags`: int\u000a   :param `parent`: \u000a   :type `parent`: wx.Window\u000a   :param `x`: \u000a   :type `x`: int\u000a   :param `y`: \u000a   :type `y`: int\u000a\u000a\u000a\u000a\u000a   :rtype: `string`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. note:: \u000a\u000a      ``wx.FD_MULTIPLE`` can only be used with :ref:`wx.FileDialog`  and not here since this function only returns a single file name.  \u000a\u000a\u000a\u000a\u000a\u000a
p215
sS'LogDebug'
p216
S'\n.. function:: wx.LogDebug(message)\n\n   The right functions for debug output.                  \n\n   They only do something in debug mode (when the preprocessor symbol  ``WXDEBUG``  is defined) and expand to nothing in release mode (otherwise). \n\n                \n\n\n   :param `message`: \n   :type `message`: :class:`String`\n\n\n\n\n'
p217
sS'LogError'
p218
S'\n.. function:: wx.LogError(message)\n\n   The functions to use for error messages, i.e.                  \n\n   the messages that must be shown to the user. The default processing is to pop up a message box to inform the user about it. \n\n                \n\n\n   :param `message`: \n   :type `message`: :class:`String`\n\n\n\n\n'
p219
sS'EmptyImage'
p220
S'\n.. function:: wx.EmptyImage(width=0, height=0, clear=True)\n\n   A compatibility wrapper for the wx.Image(width, height) constructor\n\n\n'
p221
sS'DateTimeFromTimeT'
p222
S'\n.. function:: wx.DateTimeFromTimeT(timet)\n\n   Compatibility wrapper for :meth:`DateTime.FromTimeT`\n\n\n'
p223
sS'Trap'
p224
S'\n.. function:: wx.Trap()\n\n   Generate a debugger exception meaning that the control is passed to the debugger if one is attached to the process.                  \n\n   Otherwise the program just terminates abnormally. \n\n   If  ``DEBUG_LEVEL``   is 0 (which is not the default) this function does nothing. \n\n                 \n\n\n'
p225
sS'CallAfter'
p226
S'\n.. function:: wx.CallAfter(callableObj, *args, **kw)\n\n   Call the specified function after the current and pending event\n   handlers have been completed.  This is also good for making GUI\n   method calls from non-GUI threads.  Any extra positional or\n   keyword args are passed on to the callable when it is called.\n\n   :param PyObject callableObj: the callable object\n   :param args: arguments to be passed to the callable object\n   :param kw: keywords to be passed to the callable object\n\n   .. seealso::\n       :ref:`wx.CallLater`\n\n            \n\n\n'
p227
sS'GetHomeDir'
p228
V\u000a.. function:: wx.GetHomeDir()\u000a\u000a   Return the (current) user's home directory.                  \u000a\u000a\u000a                \u000a\u000a   :rtype: `string`\u000a\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.GetUserHome`, :ref:`wx.StandardPaths`  \u000a\u000a\u000a\u000a\u000a\u000a
p229
sS'GetTopLevelWindows'
p230
S"\n.. function:: wx.GetTopLevelWindows()\n\n   Returns a list-like object of the the application's top-level windows, (frames,dialogs, etc.) \n\n   :rtype: :ref:`WindowList`\n\n\n\n\n\n"
p231
sS'LaunchDefaultBrowser'
p232
S'\n.. function:: wx.LaunchDefaultBrowser(url, flags=0)\n\n   Opens the `url`  in user\'s default browser.                  \n\n   If the `flags`  parameter contains  ``BROWSER_NEW_WINDOW``   flag, a new window is opened for the URL (currently this is only supported under Windows). \n\n   And unless the `flags`  parameter contains  ``BROWSER_NOBUSYCURSOR``   flag, a busy cursor is shown while the browser is being launched (using  :ref:`wx.BusyCursor`). \n\n   The parameter `url`  is interpreted as follows:\n\n   - if it has a valid scheme (e.g.  ``"file:"`` ,   ``"http:"``   or   ``"mailto:"`` ) it is passed to the appropriate browser configured in the user system. \n   - if it has no valid scheme (e.g. it\'s a local file path without the  ``"file:"``   prefix), then  :meth:`FileExists`   and :meth:`DirExists`   are used to test if it\'s a local file/directory; if it is, then the browser is called with the `url`  parameter eventually prefixed by  ``"file:"`` . \n   - if it has no valid scheme and it\'s not a local file/directory, then  ``"http:"``   is prepended and the browser is called. \n\n\n\n\n   Returns ``True`` if the application was successfully launched. \n\n\n                \n\n\n   :param `url`: \n   :type `url`: string\n   :param `flags`: \n   :type `flags`: int\n\n\n\n\n   :rtype: `bool`\n\n\n\n\n\n\n\n   .. note:: \n\n      For some configurations of the running user, the application which is launched to open the given URL may be URL-dependent (e.g. a browser may be used for local URLs while another one may be used for remote URLs).  \n\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.LaunchDefaultApplication`, :ref:`wx.Execute`  \n\n\n\n\n\n'
p233
sS'YieldIfNeeded'
p234
S'\n.. function:: wx.YieldIfNeeded()\n\n   Convenience function for wx.GetApp().Yield(True)\n\n\n'
p235
sS'FindWindowAtPointer'
p236
S'\n.. function:: wx.FindWindowAtPointer()\n\n   Find the deepest window at the mouse pointer position, returning the window and current pointer position in screen coordinates.                  \n\n                \n\n   :rtype: `tuple`\n\n\n\n\n\n\n\n   :returns: \n\n      ( :ref:`wx.Window`, `pt` ) \n\n\n\n\n\n'
p237
sS'HandleFatalExceptions'
p238
S'\n.. function:: wx.HandleFatalExceptions(doIt=True)\n\n   If `doIt`  is ``True``, the fatal exceptions (also known as general protection faults under Windows or segmentation violations in the Unix world) will be caught and passed to :meth:`wx.App.OnFatalException` .                  \n\n   By default, i.e. before this function is called, they will be handled in the normal way which usually just means that the application will be terminated. Calling :ref:`wx.HandleFatalExceptions`  with `doIt`  equal to ``False`` will restore this default behaviour. \n\n   Notice that this function is only available if  ``USE_ON_FATAL_EXCEPTION``   is 1 and under Windows platform this requires a compiler with support for ``SEH`` (structured exception handling) which currently means only Microsoft Visual C++ or a recent Borland C++ version. \n\n                \n\n\n   :param `doIt`: \n   :type `doIt`: bool\n\n\n\n\n   :rtype: `bool`\n\n\n\n\n\n'
p239
sS'GetLibraryVersionInfo'
p240
S'\n.. function:: wx.GetLibraryVersionInfo()\n\n   Get wxWidgets version information.                  \n\n\n\n\n\n\n\n\n   :rtype: :ref:`wx.VersionInfo`\n\n\n\n\n\n\n\n   .. versionadded:: 2.9.2 \n    \n\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.VersionInfo`  \n\n\n\n\n\n'
p241
sS'date2pydate'
p242
S'\n.. function:: wx.date2pydate(date)\n\n   Convert a :class:`DateTime` object to a Python datetime.\n\n\n'
p243
sS'Shell'
p244
S'\n.. function:: wx.Shell(command=EmptyString)\n\n   Executes a command in an interactive shell window.                  \n\n   If no command is specified, then just the shell is spawned. \n\n\n                \n\n\n   :param `command`: \n   :type `command`: string\n\n\n\n\n   :rtype: `bool`\n\n\n\n\n\n\n\n   .. seealso:: :ref:`wx.Execute`, :ref:`External Program Execution Sample <external program execution sample>`  \n\n\n\n\n\n'
p245
sS'Sleep'
p246
S'\n.. function:: wx.Sleep(secs)\n\n   Sleeps for the specified number of seconds.                  \n\n                \n\n\n   :param `secs`: \n   :type `secs`: int\n\n\n\n\n'
p247
sS'GetKeyState'
p248
V\u000a.. function:: wx.GetKeyState(key)\u000a\u000a   For normal keys, returns ``True`` if the specified key is currently down.                  \u000a\u000a   For togglable keys (Caps Lock, Num Lock and Scroll Lock), returns ``True`` if the key is toggled such that its ``LED`` indicator is lit. There is currently no way to test whether togglable keys are up or down. \u000a\u000a   Even though there are virtual key codes defined for mouse buttons, they cannot be used with this function currently. \u000a\u000a   In wxGTK, this function can be only used with modifier keys ( ``WXK_ALT`` ,   ``WXK_CONTROL``   and   ``WXK_SHIFT`` ) when not using X11 backend currently. \u000a\u000a                \u000a\u000a\u000a   :param `key`: \u000a   :type `key`: wx.KeyCode\u000a\u000a\u000a\u000a\u000a   :rtype: `bool`\u000a\u000a\u000a\u000a\u000a\u000a
p249
sS'EmptyBitmap'
p250
S'\n.. function:: wx.EmptyBitmap(width, height, depth=BITMAP_SCREEN_DEPTH)\n\n   A compatibility wrapper for the wx.Bitmap(width, height, depth) constructor\n\n\n'
p251
sS'SetCursor'
p252
V\u000a.. function:: wx.SetCursor(cursor)\u000a\u000a   Globally sets the cursor; only has an effect on Windows, Mac and GTK+.                  \u000a\u000a   You should call this function with NullCursor to restore the system cursor. \u000a\u000a\u000a                \u000a\u000a\u000a   :param `cursor`: \u000a   :type `cursor`: wx.Cursor\u000a\u000a\u000a\u000a\u000a\u000a\u000a   .. seealso:: :ref:`wx.Cursor`, :meth:`wx.Window.SetCursor`   \u000a\u000a\u000a\u000a\u000a\u000a
p253
s.