/*
 *========================================================================
 * $Id: xmlsysd_get_stats.c 163 2005-09-14 22:54:20Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */


#include "xmlsysd.h"

xmlChar xmlver[] = "1.0";
xmlChar xmlsysd[] = "xmlsysd";

void get_stats()
{

 int i,j,numfields;
 struct timeval tv;
 xmlNodePtr proc,system,pids;

 /* 
  * Create/allocate new xml document with version 1.0.  This document is 
  * to be freed EACH TIME after it is sent.
  */

 /* 
  * Set the document compression according to the control flag.  Too
  * bad this seems to be ignored in memory dumps.
  */
 if(dctl.compress){
   xmlSetCompressMode(9);	/* experiment with level */
 } else {
   xmlSetCompressMode(0);
 }
 if(dctl.whitespace){
   xmlKeepBlanksDefault(0);	/* Odd. Arguments seem to be backwards. */
 } else {
   xmlKeepBlanksDefault(1);
 }

 doc = xmlNewDoc(xmlver);
 /* Toplevel/root node is xmlsysd */
 docroot = xmlDocSetRootElement(doc,xmlNewDocNode(doc, NULL, xmlsysd , NULL));
 docroot = xmlDocGetRootElement(doc);
 /* toplevel property: Is xmlsysd initialized? */
 sprintf((char*) outbuf,"%1d",initialized);
 xmlSetProp(docroot,(xmlChar*) "init", (xmlChar*) outbuf);


 /* 
  * We now add all sorts of mindless boolean logic.  We generally
  * construct and send a set of tags if and only if its daemon
  * control flags permit it.  These flags can be set so that the
  * daemon for the most part only returns the information we really
  * want just now, while still allowing us to get "anything" later.
  */

 /* systems-derived field groups */
 if(dctl.identity || dctl.time || dctl.users){ 
   /* wrap all systems-call-derived results in system tag */
   system = xmlNewChild(docroot, NULL, (xmlChar*) "system", NULL);
   /*
    * Then call each routine that fills it in, but only if its
    * control flag permits it.
    */
   if(dctl.time) get_system_time(system);	/* returns system time */
   if(dctl.identity) get_system_identity(system);	/* returns system identity */
   if(dctl.users) get_system_users(system);	/* returns system users count */
 }

 /* proc-derived field groups */
 if(dctl.cpuinfo || dctl.loadavg || dctl.meminfo || dctl.net ||
      dctl.stat || dctl.sysvipc || dctl.uptime || dctl.version ) {
   /* wrap all proc-derived results in proc tag */
   proc = xmlNewChild(docroot, NULL, (xmlChar*) "proc", NULL);
   /*
    * Then call each routine that fills it in, but only if its
    * control flag permits it.
    */
   if(dctl.stat) get_proc_stat(proc);		/* /proc/stat */
   if(dctl.meminfo) get_proc_meminfo(proc);	/* /proc/meminfo (notice a trend here?) */
   if(dctl.net) get_proc_net(proc);		/* /proc/net/[dev,??] */
   if(dctl.loadavg) get_proc_loadavg(proc);	/* /proc/loadavg */
   if(dctl.cpuinfo) get_proc_cpuinfo(proc);	/* /proc/cpuinfo */
   if(dctl.sysvipc) get_proc_sysvipc(proc);	/* /proc/sysvipc/[msg,sem,shm] */
   if(dctl.version) get_proc_version(proc);	/* /proc/version */
   if(dctl.uptime) get_proc_uptime(proc);		/* /proc/uptime */
 }
 /* pid-derived results. Note that we don't consider this a <proc> tag. */
 if(dctl.pids){
   /* wrap all proc-derived results in pids tag */
   pids = xmlNewChild(docroot, NULL, (xmlChar*) "pids", NULL);
   gettimeofday(&tv,0);
   sprintf((char*) outbuf,"%d",tv.tv_sec);
   xmlSetProp(pids, (xmlChar*) "tv_sec", (xmlChar*) outbuf);
   sprintf((char*) outbuf,"%d",tv.tv_usec);
   xmlSetProp(pids, (xmlChar*) "tv_usec", (xmlChar*) outbuf);
   /* All the other controls are used INSIDE get_proc_pids() */
   get_proc_pids(pids);		/* /proc/[0-9]* */
 }

 /* xmlSaveFile("dummy.xml",doc); */

}

