/*
 *   Copyright (C) 2003,2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ToneGenerator.h"

#include "common/Exception.h"
#include "common/SoundFile.h"
#include "common/SoundCard.h"
#include "common/NCO.h"

int main(int argc, char *argv[])
{
	if (argc < 4) {
		::fprintf(stderr, "Usage: ToneGenerator <frequency> <amplitude> <length> <outfile>\n");
		return 1;
	}

	double       frequency  = ::atof(argv[1]);
	double       amplitude  = ::atof(argv[2]);
	unsigned int length     = ::atoi(argv[3]);
	wxString     fileName   = wxString(argv[4]);

	try {
		CToneGenerator noise(frequency, amplitude, length, fileName);
		noise.run();
	}
	catch (CException& ex) {
		::fprintf(stderr, "ToneGenerator: error: %s\n", ex.getMessage().c_str());
		return 1;
	}
	catch (...) {
		::fprintf(stderr, "ToneGenerator: an error has occured\n");
		return 1;
	}

	return 0;
}

CToneGenerator::CToneGenerator(double frequency, double amplitude, unsigned int length, const wxString& fileName) :
m_frequency(frequency),
m_amplitude(amplitude),
m_length(length),
m_fileName(fileName)
{
}

CToneGenerator::~CToneGenerator()
{
}

void CToneGenerator::run()
{
	CSoundFile out(m_fileName, 11025, 8);

	out.openWrite();

	int nSamples = 11025 * m_length;

	CNCO nco(11025, m_amplitude);

	double* tones = new double[nSamples];

	nco.generate(m_frequency, tones, nSamples);

	out.write(tones, nSamples);

	out.close();

	delete[] tones;
}
