/*
 *   Copyright (C) 2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "Window.h"

#include <wx/log.h>
#include <wx/debug.h>

#include <cmath>
using namespace std;

CWindow::CWindow(int length) :
m_length(length),
m_window(NULL)
{
	wxASSERT(length > 0);

	m_window = new double[length];
}

CWindow::~CWindow()
{
	delete[] m_window;
}

void CWindow::filter(double* in, double* out) const
{
	wxASSERT(in != NULL);
	wxASSERT(out != NULL);

	for (int i = 0; i < m_length; i++)
		out[i] = in[i] * m_window[i];
}

double* CWindow::filter(double* in) const
{
	wxASSERT(in != NULL);

	for (int i = 0; i < m_length; i++)
		in[i] *= m_window[i];

	return in;
}
