//g++ -o FileBufferTest FileBufferTest.C -DGSM_SUPPORT -I /home/flatmax/work/DAISY/sox-12.17.8/win32  -logg -lvorbis -lvorbisfile -lvorbisenc -lmad  -lm  /usr/lib/libst.a
/* Copyright 2001 Matt Flax <flatmax@ieee.org>
   This file is part of MFFM Time Scale Modification for Audio.

   MFFM Time Scale Modification for Audio is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   MFFM Time Scale Modification for Audio is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You have received a copy of the GNU General Public License
   along with MFFM Time Scale Modification for Audio
 */

#include <fstream>

#include "FileBuffer.H"

int main (int argc, char *argv[]){

  //char fileName[]="/home/flatmax/Short.wav";
  char fileName[]="/home/flatmax/temp.wav";
  int length=1134750;

  int fs=44100;
  int channels=2;
  int windowCnt=1234;

  //open binary output file
  ofstream output("/tmp/test.raw",ios::binary);

  FileBuffer fileBuf(fileName, windowCnt, channels, fs);

  int srcCnt=windowCnt+11*channels, desiredCnt=windowCnt;
  st_sample_t source[srcCnt], desired[desiredCnt];
  int srcLoc=0, desiredLoc=0;

  while (fileBuf.getData(srcLoc, srcCnt, source, desiredLoc, desiredCnt, desired)==0){
    //wroute to output
    int prev=output.tellp();
    output.write((char *)source, srcCnt*sizeof(ATYPE));
    int diff=((int)(output.tellp())-prev);
    cout<<"raw output file moved along "<<diff<<endl;

    srcLoc+=srcCnt;
    desiredLoc=srcLoc+windowCnt/2;
  }

  //close output
  output.close();
  return 0;
}
