/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.StarMathConverter;
import writer2latex.office.OfficeReader;
import writer2latex.util.Config;
import writer2latex.util.Misc;
import writer2latex.xmerge.EmbeddedObject;
import writer2latex.xmerge.EmbeddedXMLObject;

public final class MathmlConverter
extends ConverterHelper {
    private StarMathConverter smc;
    private boolean bContainsFormulas = false;
    private Node theFormula = null;

    public MathmlConverter(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
        this.smc = new StarMathConverter(palette.getI18n(), config);
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bContainsFormulas) {
            if (this.config.useOoomath()) {
                pack.append("\\usepackage{ooomath}").nl();
            } else {
                this.smc.appendDeclarations(pack, decl);
            }
        }
    }

    public String convert(Node settings, Node formula) {
        Element annotation;
        Element semantics = Misc.getChildByTagName(formula, "math:semantics");
        if (semantics != null && (annotation = Misc.getChildByTagName(semantics, "math:annotation")) != null) {
            String sStarMath = "";
            if (annotation.hasChildNodes()) {
                NodeList anl = annotation.getChildNodes();
                int nLen = anl.getLength();
                int i = 0;
                while (i < nLen) {
                    if (anl.item(i).getNodeType() == 3) {
                        sStarMath = sStarMath + anl.item(i).getNodeValue();
                    }
                    ++i;
                }
                this.bContainsFormulas = true;
                return this.smc.convert(sStarMath);
            }
        }
        return "\\text{Warning: No StarMath annotation}";
    }

    public boolean handleDisplayEquation(Node node, LaTeXDocumentPortion ldp) {
        if (this.parseDisplayFormula(node, 0) == 1) {
            ldp.append("\\[").append(this.convert(null, this.theFormula)).append("\\]").nl();
            return true;
        }
        return false;
    }

    private int parseDisplayFormula(Node node, int nParserStatus) {
        Node child = node.getFirstChild();
        while (child != null) {
            Node formula = this.getFormula(child);
            if (formula != null) {
                this.theFormula = formula;
                ++nParserStatus;
            } else if (Misc.isElement(child, "text:span")) {
                nParserStatus = this.parseDisplayFormula(child, nParserStatus);
            } else if (Misc.isElement(child)) {
                if (!Misc.isElement(child, "text:s") && !Misc.isElement(child, "text:tab") && !Misc.isElement(child, "text:tab-stop") && Misc.isElement(child)) {
                    nParserStatus = 2;
                }
            } else if (Misc.isText(child)) {
                if (!OfficeReader.isWhitespace(child.getNodeValue())) {
                    nParserStatus = 2;
                }
            }
            if (nParserStatus >= 2) {
                return 2;
            }
            child = child.getNextSibling();
        }
        return nParserStatus;
    }

    private Node getFormula(Node node) {
        String sHref;
        if (Misc.isElement(node, "draw:frame")) {
            node = Misc.getFirstChildElement(node);
        }
        if ((sHref = Misc.getAttribute(node, "xlink:href")) != null) {
            if (this.ofr.isInPackage(sHref)) {
                EmbeddedObject object;
                if (sHref.startsWith("#")) {
                    sHref = sHref.substring(1);
                }
                if (sHref.startsWith("./")) {
                    sHref = sHref.substring(2);
                }
                if ((object = this.palette.getEmbeddedObject(sHref)) != null && ("application/vnd.sun.xml.math".equals(object.getType()) || "application/vnd.oasis.opendocument.formula".equals(object.getType()))) {
                    try {
                        Document formuladoc = ((EmbeddedXMLObject)object).getContentDOM();
                        return Misc.getChildByTagName(formuladoc, "math:math");
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            return Misc.getChildByTagName(node, "math:math");
        }
        return null;
    }
}

