/* FilterInternal: Debugging information
 *
 * Copyright (C) 2002-2003 William Lachance (william.lachance@sympatico.ca)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * For further information visit http://libwpd.sourceforge.net
 *
 */
#include <stdio.h>
#include <glib.h>
#ifdef DEBUG
#define WRITER_DEBUG_MSG(M) printf M
#else
#define WRITER_DEBUG_MSG(M)
#endif

inline gchar * ucs2ArrayToUTF8String(const GArray *pTextUCS2)
{
	// first convert from ucs2 to ucs4
	gunichar *pTextUCS4 = (gunichar *) g_malloc(sizeof(gunichar)*pTextUCS2->len);
	for (guint i=0; i<pTextUCS2->len; i++) {
		pTextUCS4[i] = ((guint16 *)pTextUCS2->data)[i];
	}

	// then convert from ucs4 to utf8, free our temporary UCS4 buffer, and return it
	gchar *pTextUTF8 = g_ucs4_to_utf8(pTextUCS4, pTextUCS2->len, NULL, NULL, NULL); // TODO: handle errors
	g_free(pTextUCS4);

	return pTextUTF8;
}

inline gchar * utf8_itoa(int i)
{
	GString *string_buf = g_string_new(NULL);
	g_string_printf(string_buf, "%i", i);
	gchar * buf = string_buf->str;
	g_string_free(string_buf, FALSE);
	return buf;
}
