/* FontStyle: Stores (and writes) font-based information that is needed at 
 * the head of an OO document.
 *
 * Copyright (C) 2002-2003 William Lachance (william.lachance@sympatico.ca)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * For further information visit http://libwpd.sourceforge.net
 *
 */

/* "This product is not manufactured, approved, or supported by 
 * Corel Corporation or Corel Corporation Limited."
 */
#include "FontStyle.h"
#include "FontMap.h"
#include "WriterProperties.h"
#include "DocumentElement.h"

FontStyle::FontStyle(const gchar *psName, const gchar *psFontFamily) : Style(psName),
	mpsFontFamily(g_string_new(psFontFamily)),
	mpsFontPitch(g_string_new(IMP_DEFAULT_FONT_PITCH))

{
}

FontStyle::~FontStyle() 
{
	g_string_free(mpsFontFamily, TRUE);
	g_string_free(mpsFontPitch, TRUE);
}

void FontStyle::write(GsfOutput *pOutput) const
{        
	TagOpenElement styleOpen("style:font-decl");
	styleOpen.addAttribute("style:name", mapFont(getName()->str));
	styleOpen.addAttribute("fo:font-family", mapFont(mpsFontFamily->str));
	styleOpen.addAttribute("style:font-pitch", mpsFontPitch->str);
	styleOpen.write(pOutput);
	TagCloseElement styleClose("style:font-decl");
	styleClose.write(pOutput);
}
