/* simddop.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2001-2004,2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "simddop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"
#include "worker_locale.h"

const char *SimDDOp::name="SimDDOp";

SimDDOp::SimDDOp() : FunctionProto()
{
    m_category = FunctionProto::CAT_CURSOR;
}

SimDDOp::~SimDDOp()
{
}

SimDDOp*
SimDDOp::duplicate() const
{
  SimDDOp *ta=new SimDDOp();
  return ta;
}

bool
SimDDOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
SimDDOp::getName()
{
  return name;
}

int
SimDDOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodesimdd( msg );
    }
  }
  return 0;
}

const char *
SimDDOp::getDescription()
{
  return catalog.getLocaleCom(31);
}

int
SimDDOp::normalmodesimdd( ActionMessage *am )
{
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  
  if(startlister==NULL) return 1;
  lm1=startlister->getActiveMode();
  if(lm1==NULL) return 1;
  if(lm1->isType("NormalMode")!=true) return 1;
  nm1=(NormalMode*)lm1;
  
  if((am->mode==am->AM_MODE_ONLYACTIVE)||(am->mode==am->AM_MODE_NORMAL)) {
    nm1->simdd();
  }
  return 0;
}

