/* listermode.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2001-2005,2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "listermode.h"
#include "datei.h"

const char *ListerMode::type="ListerMode";

ListerMode::ListerMode(Lister *parent)
{
  this->parentlister=parent;
  this->parentawindow=parent->getAWindow();
  aguix=parent->getAGUIX();
}

ListerMode::~ListerMode()
{
}

void ListerMode::messageHandler(AGMessage *)
{
}

void ListerMode::on()
{
  parentlister->setActiveMode(this);
}

void ListerMode::off()
{
  parentlister->setActiveMode(NULL);
}

bool ListerMode::isType(const char *str)
{
  if(strcmp(str,type)==0) return true; else return false;
}

const char *ListerMode::getType()
{
  return type;
}

void ListerMode::activate()
{
}

void ListerMode::deactivate()
{
}

int ListerMode::configure()
{
  //TODO
  return 0;
}

void ListerMode::cyclicfunc(cyclicfunc_mode_t mode)
{
}

const char *ListerMode::getLocaleName()
{
  return "";
}

int ListerMode::load()
{
  return 0;
}

int ListerMode::loadBin(Datei *fh)
{
  int chunksize=fh->getInt();
  while(chunksize>0) {
    fh->getUChar();
    chunksize--;
  }
  return 0;
}

bool ListerMode::save(Datei *fh)
{
  return false;
}

void ListerMode::reconfig()
{
}

bool ListerMode::startdnd(DNDMsg *dm)
{
  return false;
}

bool ListerMode::isyours( Widget *elem )
{
  return false;
}

void ListerMode::lvbDoubleClicked()
{
}

void ListerMode::runCommand( const std::string &command )
{
    if ( m_commands.count( command ) > 0 &&
         m_commands[command].getVal() != NULL ) {
        m_commands[command]->callback();
    }
}

void ListerMode::registerCommand( const std::string &command,
                                  const RefCount< GenericCallback< void > > &callback )
{
    m_commands[command] = callback;
}

void ListerMode::runCommand( const std::string &command, const std::list< RefCount< ArgClass > > &args )
{
    if ( m_commands_with_args.count( command ) > 0 &&
         m_commands_with_args[command].getVal() != NULL ) {
        m_commands_with_args[command]->callback( args );
    }
}

void ListerMode::registerCommand( const std::string &command,
                                  const RefCount< GenericCallbackArg< void, const std::list< RefCount< ArgClass > > & > > &callback )
{
    m_commands_with_args[command] = callback;
}
