/* wpucontext.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: wpucontext.h,v 1.16 2005/03/21 20:22:00 ralf Exp $ */

#ifndef WPUCONTEXT_H
#define WPUCONTEXT_H

#include "wdefines.h"
#include <string>
#include <aguix/util.h>
#include "functionproto.h"
#include "normalmode.h"

class Worker;

class WPUStack
{
public:
  WPUStack();
  ~WPUStack();
  WPUStack( const WPUStack &other );
  WPUStack &operator=( const WPUStack &other );

  void push( std::string elem );
  std::string pop();
  std::string top();
  bool isEmpty();
  int size();
protected:
  int s, elems;
  std::string *stack;
  
  void raise();
};

class WPUContext
{
public:
  WPUContext( Worker *, List *coms, ActionMessage *msg = NULL );
  ~WPUContext();
  WPUContext( const WPUContext &other );
  WPUContext &operator=( const WPUContext &other );

  int continueAtLabel( const char *label );
  void push( int nr, std::string elem );
  std::string pop( int nr );
  std::string top( int nr );
  bool isEmpty( int nr );
  int size( int nr );
  int next( ActionMessage *msg );
  int openWin();
  int closeWin();
  char *parse( char *str1, int maxlen, bool quote = true );

  #define IFP_BUFSIZE 1024
  #define IFP_SYMTABLE_MAX 128
  
  enum ifp_t {
    IFP_NONE = -1,
    IFP_NUM = 256,
    IFP_DONE,
    IFP_ISEMPTY,
    IFP_SIZE,
    IFP_LASTERROR,
    IFP_STRING,
    IFP_TRUE,
    IFP_FALSE,
    IFP_P_AND,
    IFP_P_OR,
    IFP_E,
    IFP_NE,
    IFP_LT,
    IFP_LE,
    IFP_GT,
    IFP_GE,
    IFP_FILELISTEMPTY,
    IFP_TONUM,
    IFP_TOSTR,
    IFP_ISLOCAL
  };
  int parse_if( const char *str);
  bool filelistEmpty( bool other );
  int getLastError();
  void resetLastError();
  int getCurrentLine();
  void setRecursive( bool nv );
  bool getRecursive();
  void setWinProgress( int nv );
  void setWinText( const char *str );
  void setTakeDirs( bool nv );
  bool getTakeDirs();
  
  typedef enum { WPU_LASTERROR_STACKEMPTY = 0 } wpu_lasterror_t;
  const char *getBaseDir();

  struct ifp_symentry
  {
    char *str;
    enum ifp_t token;
  };
  
  int filelistSize( bool other );
  int filelistRealSize( bool other );

  const char *getTempName4File( const char *filename );
  void freeTempNameList();
protected:
  WPUStack **stacks;
  ArrayList *acoms;
  int pc;
  int nr_of_stacks;
  void buildStack( int nr );
  
  NMExtList *extlist[2];
  Worker *worker;
  ListerMode *activemode, *nonactivemode;

  struct ifp_symentry ifp_symtable[IFP_SYMTABLE_MAX];
  char ifp_lexbuf[IFP_BUFSIZE];
  int lookahead, tokenval;

#define STRMAX 1024

  char lexemes[STRMAX];
  int lastchar;
  int lastentry;

  struct ifp_erg {
    int numval;
    char *strval;
    int wasstring;
  };

  struct ifp_erg * ifp_expr();
  struct ifp_erg * ifp_factor();
  int ifp_lookup( const char *s );
  int ifp_insert( const char *s, enum ifp_t tok );
  int ifp_lex();
  int ifp_match( int t );
  char *readBrace();
  int ifp_parse();

  const char *scanbuf;
  int scanbuflen;
  int curpos;
  int ignore;
  
  class NM_externorder extorder;
  void buildExtList();
  int lasterror;

  AWindow *userwin;
  Button *cancelb;
  BevelBox *bb1, *bb2;
  SolidButton *prosb;
  Text **texts;
  int nr_of_text;
  int progress;
  
  class temp4filename_t {
  public:
    temp4filename_t()
    {
      filename = NULL;
      tempname = NULL;
    }
    ~temp4filename_t()
    {
      if ( filename != NULL ) _freesafe( filename );
      if ( tempname != NULL ) _freesafe( tempname );
    }
    temp4filename_t( const temp4filename_t &other );
    temp4filename_t &operator=( const temp4filename_t &other );
    char *filename;
    char *tempname;
    time_t modtime;
  };
  std::list<class temp4filename_t*> tempnamelist;
};

#endif
