/* wconfigglb.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: wconfigglb.cc,v 1.5 2005/01/11 23:29:46 ralf Exp $ */

#include "wconfig.h"
#include "worker.h"
#include "filereq.h"
#include "fontreq.h"
#include <string>
#include "pdatei.h"
#include "configheader.h"
#include <aguix/acontainer.h>
#include <aguix/acontainerbb.h>
#include <list>

static struct { WConfig::layoutID_t id;
                int descr; } layoutDescr[] = { { WConfig::LO_STATEBAR, 556 },
					       { WConfig::LO_CLOCKBAR, 557 },
					       { WConfig::LO_BUTTONS, 558 },
					       { WConfig::LO_LISTVIEWS, 559 },
					       { WConfig::LO_BLL, 560 },
					       { WConfig::LO_LBL, 561 },
					       { WConfig::LO_LLB, 562 },
					       { WConfig::LO_BL, 563 },
					       { WConfig::LO_LB, 564 } };
typedef struct { WConfig::layoutID_t id; int group; } layoutIDGrp_t;
layoutIDGrp_t layouts[][5] = { { { WConfig::LO_STATEBAR, 0 },
                                 { WConfig::LO_CLOCKBAR, 1 },
                                 { WConfig::LO_BUTTONS, 2 },
                                 { WConfig::LO_LISTVIEWS, 3 },
                                 { WConfig::LO_DUMMY, -1 }
                               },
                               { { WConfig::LO_STATEBAR, 0 },
                                 { WConfig::LO_CLOCKBAR, 1 },
                                 { WConfig::LO_BUTTONS, 2 },
                                 { WConfig::LO_LISTVIEWS, 3 },
                                 { WConfig::LO_LISTVIEWS, 4 }
                               },
                               { { WConfig::LO_STATEBAR, 0 },
                                 { WConfig::LO_CLOCKBAR, 1 },
				 { WConfig::LO_BLL, 2 },
				 { WConfig::LO_LBL, 2 },
				 { WConfig::LO_LLB, 2 }
			       },
			       { { WConfig::LO_STATEBAR, 0 },
				 { WConfig::LO_CLOCKBAR, 1 },
				 { WConfig::LO_BL, 2 },
				 { WConfig::LO_LB, 2 },
				 { WConfig::LO_DUMMY, -1 }
			       } };

typedef struct {
  Button *button;
  int pos;
  int ind;
} confLayoutEntry_t;

int getNrOfLayoutModes()
{
  return sizeof( layouts ) / sizeof( layouts[0] );
}

int getNrOfLayoutElements()
{
  return sizeof( layouts[0] ) / sizeof( layouts[0][0] );
}

int getLayoutID(  bool buttonV, bool listviewV, int pos, layoutIDGrp_t &return_id )
{
  int mode, i;
  int modes, epmode;

  if ( ( buttonV == false ) && ( listviewV == false ) ) {
    mode = 0;
  } else if ( ( buttonV == false ) && ( listviewV == true ) ) {
    mode = 1;
  } else if ( ( buttonV == true ) && ( listviewV == false ) ) {
    mode = 2;
  } else {
    mode = 3;
  }

  modes = getNrOfLayoutModes();
  if ( ( mode >= 0 ) && ( mode < modes ) ) {
    if ( pos >= 0 ) {
      epmode = getNrOfLayoutElements();
      for ( i = 0; i < epmode; i++ ) {
        if ( layouts[mode][i].id == WConfig::LO_DUMMY ) break;
        if ( i == pos ) {
          return_id.id = layouts[mode][i].id;
          return_id.group = layouts[mode][i].group;
          return 0;
        }
      }
    }
  }
  return_id.id = WConfig::LO_DUMMY;
  return_id.group = -1;
  return 1;
}

int getNrOfUniques( bool bv, bool lvv )
{
  int modes, epmode, i;
  layoutIDGrp_t id;
  int u = -1;

  modes = getNrOfLayoutModes();
  epmode = getNrOfLayoutElements();
  
  for ( i = 0; i < epmode; i++ ) {
    if ( getLayoutID( bv, lvv, i, id ) == 0 ) {
      u = id.group;
    } else break;
  }
  return ( u + 1 );
}

int getSizeOfGroup( bool bv, bool lvv, int group )
{
  int elems = 0;
  int modes, epmode, i;
  layoutIDGrp_t id;

  modes = getNrOfLayoutModes();
  epmode = getNrOfLayoutElements();
  
  for ( i = 0; i < epmode; i++ ) {
    if ( getLayoutID( bv, lvv, i, id ) == 0 ) {
      if ( id.group == group ) elems++;
    } else break;
  }
  return elems;
}

std::string getDescrOfLayoutID( WConfig::layoutID_t id )
{
  int s, i;
  std::string s1;
  
  s = sizeof( layoutDescr ) / sizeof( layoutDescr[0] );
  s1 = "";
  for ( i = 0; i < s; i++ ) {
    if ( layoutDescr[i].id == id ) {
      s1 = catalog.getLocale( layoutDescr[i].descr );
      break;
    }
  }
  return s1;
}

int setupLayoutContainer( AWindow *win,
                          bool bv,
                          bool lvv,
                          std::list<confLayoutEntry_t> &entries,
                          AContainer *ac1,
                          AContainer *&ac2 )
{
  Button *b1;
  int uniques;
  int pos, i, s, ts;
  AContainer *tac;
  layoutIDGrp_t layoutid;
  std::list<confLayoutEntry_t>::iterator it1;
  confLayoutEntry_t entry;

  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;

  if ( win == NULL ) return 1;
  if ( ac1 == NULL ) return 1;
  
  for ( it1 = entries.begin(); it1 != entries.end(); it1++ ) {
    delete (*it1).button;
  }
  entries.clear();

  if ( ac2 != NULL ) delete ac2;
  
  uniques = getNrOfUniques( bv, lvv );
  ac2 = ac1->add( new AContainer( win, 1, uniques ), 0, 3 );
  ac2->setMaxSpace( 5 );
  ac2->setBorderWidth( 5 );

  pos = 0;
  for ( i = 0; i < uniques; i++ ) {
    s = getSizeOfGroup( bv, lvv, i );
    tac = ac2->add( new AContainer( win, 1, s ), 0, i );
    tac->setMaxSpace( 0 );
    tac->setMinSpace( 0 );
    tac->setBorderWidth( 0 );
    for ( ts = 0; ts < s; ts++ ) {
      if ( getLayoutID( bv, lvv, pos, layoutid ) == 0 ) {
        b1 = (Button*)tac->add( new Button( win->getAGUIX(), 
                                                  0,
                                                  0,
                                                  "",
                                                  1,
                                                  0,
                                                  pos ), 0, ts, cincw );
        entry.button = b1;
        entry.pos = pos;
        entry.ind = -1;
        entries.push_back( entry );
      } else break;
      pos++;
    }
  }
  return 0;
}

int updateLayoutButtonText( bool bv,
                            bool lvv,
                            std::list<confLayoutEntry_t> &entries,
                            int history )
{
  std::list<confLayoutEntry_t>::iterator it1;
  layoutIDGrp_t layoutid;
  std::string s1, s2;
  int pos;
  char buf1[ A_BYTESFORNUMBER( int ) ];

  for ( it1 = entries.begin(); it1 != entries.end(); it1++ ) {
    pos = (*it1).pos;
    if ( getLayoutID( bv, lvv, pos, layoutid ) == 0 ) {
      s1 = getDescrOfLayoutID( layoutid.id );
      if ( (*it1).ind >= 0 ) {
        s1 += ": ";
        sprintf( buf1, "%d", (*it1).ind );
        s1 += buf1;
      } else {
        s1 += "   ";
      }
      if ( pos == history ) {
        s2 = "--> ";
        s2 += s1;
        s2 += " <--";
        s1 = s2;
      }
      (*it1).button->setText( 0, s1.c_str() );
    }
  }
  return 0;
}

bool WConfig::configureLayout()
{
  AGUIX *aguix = worker->getAGUIX();
  AWindow *win = new AWindow( aguix );
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  AGMessage *msg;
  int ende;
  bool bv, lvv;
  int history;
  std::list<confLayoutEntry_t>::iterator it1, it2;
  layoutIDGrp_t layoutid, templayoutid;
  int grp, temp, newind;
  int n, i, pos;
  Text **texts;
  std::list<layoutID_t>::iterator it3;
  int ind;
  
  bv = layoutConf.buttonVert;
  lvv = layoutConf.listviewVert;
  win->create( NULL, 10, 10, 100, 100, 0, catalog.getLocale( 569 ) );
  
  // global container 1x3
  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 6 ), true );
  ac1->setMaxSpace( 5 );
  ac1->setBorderWidth( 5 );

  ac1->add( new Text( aguix, 0, 0, catalog.getLocale( 565 ), 1 ), 0, 0, cincwnr );
  // sub container 2x2 for lister config
  AContainer *ac2 = ac1->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac2->setMaxSpace( 5 );
  ac2->setBorderWidth( 0 );
  
  ChooseButton *cb1 = (ChooseButton*)ac2->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( bv == true ) ? 1 : 0,
                                                                   catalog.getLocale( 567 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 0, cincwnr );
  ChooseButton *cb2 = (ChooseButton*)ac2->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( lvv == true ) ? 1 : 0,
                                                                   catalog.getLocale( 568 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 1, 0, cincwnr );

  win->addTextFromString( catalog.getLocale( 566 ), 0, 0, 0, &texts, &n, NULL );
  AContainer *actext = ac1->add( new AContainer( win, 1, n ), 0, 2 );
  actext->setMaxSpace( 5 );
  actext->setBorderWidth( 0 );
  for ( i = 0; i < n; i++ ) {
    actext->add( texts[i], 0, i, cincwnr );
  }
  _freesafe( texts );
  
  // sub container 1x2 for ok/cancel
  AContainer *ac3 = ac1->add( new AContainer( win, 2, 1 ), 0, 5 );
  ac3->setBorderWidth( 0 );
  Button *okb = (Button*)ac3->add( new Button( aguix,
                                               0,
                                               0,
                                               catalog.getLocale( 11 ),
                                               1,
                                               0,
                                               0 ), 0, 0, cincw );
  Button *cancelb = (Button*)ac3->add( new Button( aguix,
                                                   0,
                                                   0,
                                                   catalog.getLocale( 8 ),
                                                   1,
                                                   0,
                                                   0 ), 1, 0, cincw );

  win->setDoTabCycling( true );
  
  std::list<confLayoutEntry_t> entries;
  AContainer *aclayout = NULL;
  setupLayoutContainer( win, bv, lvv, entries, ac1, aclayout );

  ind = 0;
  // for all elements
  for ( it3 = layoutConf.orders.begin(); it3 != layoutConf.orders.end(); it3++ ) {
    // search entry without position (some layouts can be used more than once)
    for ( it1 = entries.begin(); it1 != entries.end(); it1++ ) {
      if ( getLayoutID( bv, lvv, (*it1).pos, layoutid ) == 0 ) {
        if ( ( layoutid.id == (*it3) ) && ( (*it1).ind < 0 ) ) break;
      }
    }
    if ( it1 != entries.end() ) {
      // found candidate
      // now check if there is no entry with a position in the same group
      if ( getLayoutID( bv, lvv, (*it1).pos, layoutid ) == 0 ) {
        grp = layoutid.group;
        for ( it2 = entries.begin(); it2 != entries.end(); it2++ ) {
          if ( getLayoutID( bv, lvv, (*it2).pos, layoutid ) == 0 ) {
            if ( ( layoutid.group == grp ) && ( (*it2).ind >= 0 ) ) break;
          }
        }
        if ( it2 == entries.end() ) {
          // not found
          (*it1).ind = ind++;
        }
      }
    }
  }

  updateLayoutButtonText( bv, lvv, entries, -1 );
  
  win->contMaximize( true );
  win->show();

  while ( ( msg = aguix->GetMessage( NULL ) ) != NULL ) aguix->ReplyMessage( msg );
  ende = 0;
  history = -1;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      if ( msg->type == AG_CLOSEWINDOW ) {
        if ( msg->closewindow.window == win->getWindow() ) ende = -1;
      } else if ( msg->type == AG_BUTTONCLICKED ) {
        if ( msg->button.button == okb ) ende = 1;
        else if ( msg->button.button == cancelb ) ende = -1;
        else {
          for ( it1 = entries.begin(); it1 != entries.end(); it1++ ) {
            if ( (*it1).button == msg->button.button ) {
              // found button
              
              if ( (*it1).ind >= 0 ) {
                // button has already an index
                // goes to history if there was no history
                // otherwise remove index when button was the history
                // and swap with history otherwise
                
                if ( history >= 0 ) {
                  if ( history == (*it1).pos ) {
                    // remove index
                    for ( it2 = entries.begin(); it2 != entries.end(); it2++ ) {
                      if ( (*it2).ind > (*it1).ind ) (*it2).ind--;
                    }
                    (*it1).ind = -1;
                  } else {
                    // search for other entry and swap index
                    for ( it2 = entries.begin(); it2 != entries.end(); it2++ ) {
                      if ( (*it2).pos == history ) {
                        temp = (*it2).ind;
                        (*it2).ind = (*it1).ind;
                        (*it1).ind = temp;
                        break;
                      }
                    }
                  }
                  history = -1;
                } else history = (*it1).pos;
              } else {
                // no index
                // find new value and remove index from other elements from the same
                // group
                if ( getLayoutID( bv, lvv, (*it1).pos, layoutid ) == 0 ) {
                  grp = layoutid.group;
                  for ( it2 = entries.begin(); it2 != entries.end(); it2++ ) {
                    if ( getLayoutID( bv, lvv, (*it2).pos, templayoutid ) == 0 ) {
                      if ( ( templayoutid.group == grp ) &&
                           ( (*it2).ind >= 0 ) ) {
                        break;
                      }
                    }
                  }
                  if ( it2 != entries.end() ) {
                    // found other group member
                    (*it1).ind = (*it2).ind;
                    (*it2).ind = -1;
                  } else {
                    // choose next free index
                    newind = 0;
                    for ( it2 = entries.begin(); it2 != entries.end(); it2++ ) {
                      if ( (*it2).ind >= newind ) newind = (*it2).ind + 1;
                    }
                    (*it1).ind = newind;
                  }
                }
                history = -1;
              }
              updateLayoutButtonText( bv, lvv, entries, history );
              break;
            }
          }
        }
      } else if ( msg->type == AG_CHOOSECLICKED ) {
        history = -1;
        bv = ( cb1->getState() == 1 ) ? true : false;
        lvv = ( cb2->getState() == 1 ) ? true : false;
        setupLayoutContainer( win, bv,
                              lvv, entries, ac1, aclayout );
        updateLayoutButtonText( bv, lvv, entries, -1 );
        win->contMaximize( true );
      }
      aguix->ReplyMessage(msg);
    }
  }
  if ( ende == 1 ) {
    // Werte bernehmen
    layoutConf.orders.clear();
    for ( i = 0; i < getNrOfUniques( bv, lvv ); i++ ) {
      for ( it1 = entries.begin(); it1 != entries.end(); it1++ ) {
        if ( (*it1).ind == i ) {
          pos = (*it1).pos;
          if ( getLayoutID( bv, lvv, pos, layoutid ) == 0 ) {
            layoutConf.orders.push_back( layoutid.id );
          }
        }
      }
    }
    layoutConf.buttonVert = bv;
    layoutConf.listviewVert = lvv;
  }
  win->close();
  delete win;
  return ( ende == -1 ) ? false : true;
}

bool WConfig::changeGlobal()
{
  WConfig *wconfig_bak=duplicate();
  // Aktuelle Daten aendern, bei Cancel Daten aus twconfig wiederherstellen
  AGUIX *aguix=worker->getAGUIX();
  CycleButton *cyb;
  AWindow *glwin=new AWindow(aguix);

  glwin->create(NULL,10,10,10,10,0,catalog.getLocale(1));
  const char *textstr;
  char *buttonstr;
  int erg;
  Requester *req=new Requester(aguix);
  char *tstr;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;

  AContainer *ac1 = glwin->setContainer( new AContainer( glwin, 1, 12 ), true );
  ac1->setMaxSpace( 5 );
  ac1->setBorderWidth( 5 );

  AContainer *ac1_0 = ac1->add( new AContainer( glwin, 2, 1 ), 0, 0 );
  ac1_0->add( new Text( aguix,
                        0,
                        0,
                        catalog.getLocale( 9 ),
                        1 ), 0, 0, /*cincwnr*/ cfix );
  if ( ( strcmp( lang, "builtin" ) == 0 ) ||
       ( strlen( lang ) < 1 ) )
    tstr = dupstring( catalog.getLocale(10) );
  else tstr = dupstring( lang );
  Button *langb = (Button*)ac1_0->add( new Button( aguix,
                                                   0,
                                                   0,
                                                   tstr,
                                                   1,
                                                   0,
                                                   1 ), 1, 0, cincw );
  _freesafe( tstr );
  ac1_0->setMaxSpace( 5 );
  ac1_0->setBorderWidth( 0 );

  AContainerBB *ac1_1 = static_cast<AContainerBB*>( ac1->add( new AContainerBB( glwin,
                                                                                1,
                                                                                2 ),
                                                              0,
                                                              1 ) );
  AContainer *ac1_1_0 = ac1_1->add( new AContainer( glwin, 2, 1 ), 0, 0 );
  ac1_1_0->add( new Text( aguix,
                          0,
                          0,
                          catalog.getLocale( 14 ),
                          1 ), 0, 0, cincwnr );
  tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
  sprintf( tstr, "%d", colors->size() );
  StringGadget *ccsg = (StringGadget*)ac1_1_0->add( new StringGadget( aguix,
								      0,
								      0,
								      5 * aguix->getCharWidth(),
								      tstr,
								      1 ), 1, 0, cincw );
  _freesafe(tstr);
  ac1_1->setMaxSpace( 5 );

  Button *palb = (Button*)ac1_1->add( new Button( aguix,
					          0,
					          0,
					          catalog.getLocale( 15 ),
					          1,
					          0,
					          1 ), 0, 1, cincw );

  Button *fileselb = (Button*)ac1->add( new Button( aguix,
						    0,
						    0,
						    catalog.getLocale( 16 ),
						    1,
						    0,
						    1 ), 0, 2, cincw );
  
  AContainerBB *ac1_3 = static_cast<AContainerBB*>( ac1->add( new AContainerBB( glwin,
                                                                                2,
                                                                                2 ),
                                                              0,
                                                              3 ) );
  ac1_3->add( new Text( aguix,
                        0,
                        0,
                        catalog.getLocale( 17 ),
                        1 ), 0, 0, cfix );
  tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
  sprintf( tstr, "%d", (int)rows );
  StringGadget *rowsg = (StringGadget*)ac1_3->add( new StringGadget( aguix,
								     0,
								     0,
								     5 * aguix->getCharWidth(),
								     tstr,
								     1 ), 1, 0, cincw );
  _freesafe(tstr);
  ac1_3->add( new Text( aguix,
			0,
			0,
			catalog.getLocale( 18 ),
                        1 ), 0, 1, cfix );
  tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
  sprintf( tstr, "%d", (int)columns );
  StringGadget *colsg = (StringGadget*)ac1_3->add( new StringGadget( aguix,
								     0,
                                                                     0,
								     5 * aguix->getCharWidth(),
								     tstr,
								     1 ), 1, 1, cincw );
  _freesafe(tstr);
  ac1_3->setMaxSpace( 5 );
  
  AContainer *ac1_4 = ac1->add( new AContainerBB( glwin,
                                                  2,
                                                  1 ), 0, 4 );
  ac1_4->add( new Text( aguix,
                        0,
                        0,
                        catalog.getLocale( 233 ),
                        1 ), 0, 0, cincwnr );
  tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
  sprintf( tstr, "%d", (int)cachesize );
  StringGadget *cachesg = (StringGadget*)ac1_4->add( new StringGadget( aguix,
                                                                       0,
                                                                       0,
                                                                       7 * aguix->getCharWidth(),
                                                                       tstr,
                                                                       1 ), 1, 0, cincw );
  _freesafe( tstr );

  AContainer *ac1_5 = ac1->add( new AContainer( glwin,
                                                2,
                                                1 ), 0, 5 );
  ac1_5->add( new Text( aguix,
                        0,
                        0,
                        catalog.getLocale( 130 ),
                        1 ), 0, 0, cfix );
  cyb = (CycleButton*)ac1_5->add( new CycleButton( aguix,
                                                   0,
                                                   0,
                                                   100,
                                                   1,
                                                   0,
                                                   0 ), 1, 0, cincw );
  cyb->addOption( catalog.getLocale( 131 ) );
  cyb->addOption( catalog.getLocale( 132 ) );
  cyb->resize( cyb->getMaxSize(), cyb->getHeight() );
  if ( ownerstringtype == 1 ) cyb->setOption( 1 );
  else cyb->setOption( 0 );
  ac1_5->readLimits();
  ac1_5->setMaxSpace( 5 );

  AContainerBB *ac1_6 = static_cast<AContainerBB*>( ac1->add( new AContainerBB( glwin,
                                                                                1,
                                                                                2 ),
                                                              0,
                                                              6 ) );
  ac1_6->add( new Text( aguix,
                        0,
                        0,
                        catalog.getLocale( 134 ),
                        1 ), 0, 0, cincwnr );
  StringGadget *termsg = (StringGadget*)ac1_6->add( new StringGadget( aguix,
								      0,
								      0,
								      30 * aguix->getCharWidth(),
                                                                      terminalbin,
								      1 ), 0, 1, cincw );
  ac1_6->setMaxSpace( 5 );

  ChooseButton *sfds_cb = (ChooseButton*)ac1->add( new ChooseButton( aguix,
                                                                     0,
                                                                     0,
                                                                     ( showStringForDirSize == true ) ? 1 : 0,
                                                                     catalog.getLocale( 386 ),
                                                                     LABEL_LEFT,
                                                                     1,
                                                                     0 ), 0, 7, cincwnr );

  Button *dtb = (Button*)ac1->add( new Button( aguix,
                                               0,
                                               0,
                                               catalog.getLocale( 439 ),
                                               1,
                                               0,
                                               0 ), 0, 8, cincw );

  Button *guib = static_cast<Button*>( ac1->add( new Button( aguix,
                                                             0,
                                                             0,
                                                             catalog.getLocale( 569 ),
                                                             1,
                                                             0,
                                                             0 ), 0, 9, cincw ) );

  AContainer *ac1_9 = ac1->add( new AContainer( glwin,
                                                2,
                                                1 ), 0, 11 );
  Button *okb = (Button*)ac1_9->add( new Button( aguix,
                                                 0,
                                                 0,
                                                 catalog.getLocale( 11 ),
                                                 1,
                                                 0,
                                                 0 ), 0, 0, cincw );
  Button *cancelb = (Button*)ac1_9->add( new Button( aguix,
                                                     0,
                                                     0,
                                                     catalog.getLocale( 8 ),
                                                     1,
                                                     0,
                                                     0 ), 1, 0, cincw );
  ac1_9->setBorderWidth( 0 );
  
  glwin->setDoTabCycling( true );

  glwin->contMaximize( true );
  glwin->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(glwin);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==glwin->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) {
          if(isCorrectTerminalBin(termsg->getText())==false) {
            // show requester
            textstr=catalog.getLocale(195);
            buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(313))+1+
                                        strlen(catalog.getLocale(196))+1);
            sprintf(buttonstr,"%s|%s",catalog.getLocale(313),
                                      catalog.getLocale(196));
            erg=req->request(catalog.getLocale(125),textstr,buttonstr);
            _freesafe(buttonstr);
            if(erg==0) {
              termsg->activate();
            } else {
              termsg->setText(TERMINAL_BIN);
            }
          } else ende=1;
        } else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==langb) {
          glwin->hide();
          if(changeLanguage()==true) {
            if ( ( strcmp( lang, "builtin" ) == 0 ) ||
		 ( strlen( lang ) < 1 ) )
	      langb->setText( 0, catalog.getLocale( 10 ) );
            else langb->setText(0,lang);
          }
          glwin->show();
        } else if(msg->button.button==palb) {
          glwin->hide();
          changePalette();
          glwin->show();
        } else if(msg->button.button==fileselb) {
          glwin->hide();
          changeFileSets();
          glwin->show();
        } else if ( msg->button.button == dtb ) {
          glwin->hide();
          configureDateTime();
          glwin->show();
        } else if ( msg->button.button == guib ) {
          glwin->hide();
          configureLayout();
          glwin->show();
        }
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        if(msg->stringgadget.sg==ccsg) {
          int val=0;
          sscanf(ccsg->getText(),"%d",&val);
          if((val<8)||(val>256)) {
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf(tstr,"%d",colors->size());
            ccsg->setText(tstr);
            _freesafe(tstr);
          } else {
            if(colors->size()<val)
              while(colors->size()!=val) colors->addElement(new WC_Color());
            else if(colors->size()>val)
              while(colors->size()!=val) colors->removeLastElement();
            applyColorList(colors);
          }
        } else if(msg->stringgadget.sg==rowsg) {
          int val=0;
          sscanf(rowsg->getText(),"%d",&val);
          if((val<1)||(val>10)) {
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf( tstr, "%d", (int)rows );
            rowsg->setText(tstr);
            _freesafe(tstr);
          } else setRows(val);
        } else if(msg->stringgadget.sg==colsg) {
          int val=0;
          sscanf(colsg->getText(),"%d",&val);
          if((val<1)||(val>20)) {
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf( tstr, "%d", (int)columns );
            colsg->setText(tstr);
            _freesafe(tstr);
          } else setColumns(val);
        } else if(msg->stringgadget.sg==cachesg) {
          int val=0;
          sscanf(cachesg->getText(),"%d",&val);
          if(val<1) {
            tstr = (char*)_allocsafe( A_BYTESFORNUMBER( int ) );
            sprintf( tstr, "%d", (int)cachesize );
            cachesg->setText(tstr);
            _freesafe(tstr);
          } else setCacheSize(val);
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setLang(wconfig_bak->getLang());
    setTerminalBin(wconfig_bak->getTerminalBin());
    setRows(wconfig_bak->getRows());
    setColumns(wconfig_bak->getColumns());
    setCacheSize(wconfig_bak->getCacheSize());
    setHBarTop(0,wconfig_bak->getHBarTop(0));
    setVBarLeft(0,wconfig_bak->getVBarLeft(0));
    setHBarHeight(0,wconfig_bak->getHBarHeight(0));
    setVBarWidth(0,wconfig_bak->getVBarWidth(0));
    setVisCols( 0, wconfig_bak->getVisCols( 0 ) );
    setHBarTop(1,wconfig_bak->getHBarTop(1));
    setVBarLeft(1,wconfig_bak->getVBarLeft(1));
    setHBarHeight(1,wconfig_bak->getHBarHeight(1));
    setVBarWidth(1,wconfig_bak->getVBarWidth(1));
    setVisCols( 1, wconfig_bak->getVisCols( 1 ) );
    setShowHeader( 0, wconfig_bak->getShowHeader( 0 ) );
    setShowHeader( 1, wconfig_bak->getShowHeader( 1 ) );
    setColors(wconfig_bak->getColors());
    applyColorList(colors);
    setOwnerstringtype(wconfig_bak->getOwnerstringtype());
    setShowStringForDirSize(wconfig_bak->getShowStringForDirSize());
    setDateFormat( wconfig_bak->getDateFormat() );
    setDateFormatString( wconfig_bak->getDateFormatString() );
    setDateSubst( wconfig_bak->getDateSubst() );
    setTimeFormat( wconfig_bak->getTimeFormat() );
    setTimeFormatString( wconfig_bak->getTimeFormatString() );
    setDateBeforeTime( wconfig_bak->getDateBeforeTime() );
    setLayoutOrders( wconfig_bak->getLayoutOrders() );
    setLayoutButtonVert( wconfig_bak->getLayoutButtonVert() );
    setLayoutListviewVert( wconfig_bak->getLayoutListviewVert() );
  } else {
    setOwnerstringtype(cyb->getSelectedOption());
    setTerminalBin(termsg->getText());
    setShowStringForDirSize((sfds_cb->getState()==1)?true:false);
  }
  delete wconfig_bak;
  glwin->close();
  delete glwin;
  delete req;
  return (ende==-1)?false:true;
}

bool WConfig::changeDisplaySets(int side)
{
  bool *sels;
  AGUIX *aguix=worker->getAGUIX();
  AWindow *win=new AWindow(aguix);
  unsigned int j, ui;
  int trow;
  int i1, i2;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  const int cmin = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW;
  
  win->create(NULL,10,10,100,100,0,catalog.getLocale(235));
  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 3 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );
  ac1->setBorderWidth( 5 );
  ac1->add( new Text( aguix, 0, 0, catalog.getLocale( 238 ), 1 ), 0, 0, cincwnr );
  AContainer *ac1_1 = ac1->add( new AContainer( win, 3, 1 ), 0, 1 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );
  ac1_1->setBorderWidth( 0 );
  AContainer *ac1_1_1 = ac1_1->add( new AContainer( win, 1, 2 ), 0, 0 );
  ac1_1_1->setMinSpace( 0 );
  ac1_1_1->setMaxSpace( 0 );
  ac1_1_1->setBorderWidth( 0 );
  FieldListView *lv1 = (FieldListView*)ac1_1_1->add( new FieldListView( aguix,
                                                                        0, 0,
                                                                        100, 50,
                                                                        0 ), 0, 0, cmin );
  AContainer *ac1_1_1_1 = ac1_1_1->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac1_1_1_1->setMinSpace( 0 );
  ac1_1_1_1->setMaxSpace( 0 );
  ac1_1_1_1->setBorderWidth( 0 );
  Button *upb = (Button*)ac1_1_1_1->add( new Button( aguix,
                                                     0, 0,
                                                     catalog.getLocale( 236 ),
                                                     1, 0, 0 ), 0, 0, cincw );
  Button *downb = (Button*)ac1_1_1_1->add( new Button( aguix,
                                                       0, 0,
                                                       catalog.getLocale( 237 ),
                                                       1, 0, 0 ), 1, 0, cincw );
  lv1->setHBarState(2);
  lv1->setVBarState(2);

  AContainer *ac1_1_2 = ac1_1->add( new AContainer( win, 1, 4 ), 1, 0 );
  ac1_1_2->setMinSpace( 5 );
  ac1_1_2->setMaxSpace( -1 );
  ac1_1_2->setBorderWidth( 5 );
  Button *delb = (Button*)ac1_1_2->add( new Button( aguix,
                                                    0, 0,
                                                    catalog.getLocale(239),
                                                    1, 0, 0 ), 0, 1, cincw );
  Button *insb = (Button*)ac1_1_2->add( new Button( aguix,
                                                    0, 0,
                                                    catalog.getLocale(240),
                                                    1, 0, 0 ), 0, 2, cincw );
  FieldListView *lv2 = (FieldListView*)ac1_1->add(new FieldListView( aguix,
                                                                     0, 0,
                                                                     lv1->getWidth(),
                                                                     50,
                                                                     0 ), 2, 0, cmin );
  lv2->setHBarState(2);
  lv2->setVBarState(2);

  AContainer *ac1_2 = ac1->add( new AContainer( win, 2, 1 ), 0, 2 );
  ac1_2->setMinSpace( 5 );
  ac1_2->setMaxSpace( -1 );
  ac1_2->setBorderWidth( 0 );
  Button *okb = (Button*)ac1_2->add( new Button( aguix,
                                                 0, 0,
                                                 catalog.getLocale(11),
                                                 1, 0, 0 ), 0, 0, cfix );
  Button *cancelb = (Button*)ac1_2->add( new Button( aguix,
                                                     0,
                                                     0,
                                                     catalog.getLocale(8),
                                                     1, 0, 0 ), 1, 0, cfix );
  sels = new bool[WorkerTypes::getAvailListColsSize()];
  for ( j = 0; j < WorkerTypes::getAvailListColsSize(); j++ ) {
    sels[j] = false;
  }
  for ( ui = 0; ui < viscols[side].size(); ui++ ) {
    for ( j = 0; j < WorkerTypes::getAvailListColsSize(); j++ ) {
      if ( WorkerTypes::availListCols[j].type == viscols[side][ui] ) break;
    }
    if ( j < WorkerTypes::getAvailListColsSize() ) {
      trow = lv1->addRow();
      lv1->setText( trow, 0, catalog.getLocale( WorkerTypes::availListCols[j].catalogid ) );
      lv1->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
      sels[j]=true;
    }
  }
  for ( j = 0; j < WorkerTypes::getAvailListColsSize(); j++ ) {
    if ( sels[j] == false ) {
      trow = lv2->addRow();
      lv2->setText( trow, 0, catalog.getLocale( WorkerTypes::availListCols[j].catalogid ) );
      lv2->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
    }
  }
  lv1->redraw();
  lv2->redraw();
  lv1->maximizeX();
  lv1->maximizeY();
  lv2->maximizeX();
  lv2->maximizeY();
  if ( lv1->getWidth() < ( 20 * aguix->getCharWidth() ) )
    lv1->resize( ( 20 * aguix->getCharWidth() ), lv1->getHeight() );
  if ( lv2->getWidth() < ( 20 * aguix->getCharWidth() ) )
    lv2->resize( ( 20 * aguix->getCharWidth() ), lv2->getHeight() );
  ac1_1_1->readLimits();
  ac1_1->readLimits();
  win->setDoTabCycling( true );
  win->contMaximize( true );
  win->show();
  AGMessage *msg;
  while((msg=aguix->GetMessage(NULL))!=NULL) aguix->ReplyMessage(msg);
  int ende=0;
  while(ende==0) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==upb) {
          int trow = lv1->getActiveRow();
          if ( lv1->isValidRow( trow ) == true ) {
            if ( trow > 0) {
              lv1->swapRows( trow, trow - 1 );
              lv1->redraw();
              lv1->showActive();
            }
          }
        } else if(msg->button.button==downb) {
          int trow = lv1->getActiveRow();
          if ( lv1->isValidRow( trow ) == true ) {
            if ( trow < ( lv1->getElements() - 1 ) ) {
              lv1->swapRows( trow, trow + 1 );
              lv1->redraw();
              lv1->showActive();
            }
          }
        } else if(msg->button.button==delb) {
          int trow = lv1->getActiveRow(), trow2, trow3;
          if ( lv1->isValidRow( trow ) == true ) {
            // first find entry from availlist
            for ( j = 0, i1 = -1; j < WorkerTypes::getAvailListColsSize(); j++ ) {
              if ( strcmp( catalog.getLocale( WorkerTypes::availListCols[j].catalogid ),
	                   lv1->getText( trow, 0 ).c_str() ) == 0 ) {
                i1 = (int)j;
              }
            }
            // now find insertion position in second LV
            trow2 = 0;
            i2=0;
            int i3;
            while ( lv2->isValidRow( trow2 ) == true ) {
              // for each entry search pos in availlist
              i3 = -1;
              for ( j = 0; j < WorkerTypes::getAvailListColsSize(); j++ ) {
                if ( strcmp( catalog.getLocale( WorkerTypes::availListCols[j].catalogid ),
		             lv2->getText( trow2, 0 ).c_str() ) == 0 ) i3 = (int)j;
              }
              // for each entry with lower position raise the insertion position
              if(i3<i1) i2++;
              trow2++;
            }
            trow3 = lv2->insertRow( i2 );
            lv2->setText( trow3, 0, lv1->getText( trow, 0 ) );
            lv2->setPreColors( trow3, FieldListView::PRECOLOR_ONLYACTIVE );
            lv1->deleteRow( trow );
            lv1->redraw();
            lv2->redraw();
          }
        } else if(msg->button.button==insb) {
          int trow = lv2->getActiveRow(), trow2;
          if ( lv2->isValidRow( trow ) == true ) {
            trow2 = lv1->addRow();
            lv1->setText( trow2, 0, lv2->getText( trow, 0 ) );
            lv1->setPreColors( trow2, FieldListView::PRECOLOR_ONLYACTIVE );
            lv2->deleteRow( trow );
            lv1->redraw();
            lv2->redraw();
          }
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==1) {
    int trow2;
    trow2 = 0;
    viscols[side].clear();
    while ( lv1->isValidRow( trow2 ) == true ) {
      for ( j = 0; j < WorkerTypes::getAvailListColsSize(); j++ ) {
        if ( strcmp( catalog.getLocale( WorkerTypes::availListCols[j].catalogid ),
	             lv1->getText( trow2, 0 ).c_str() ) == 0 ) {
          viscols[side].push_back( WorkerTypes::availListCols[j].type );
        }
      }
      trow2++;
    }
  }
  win->close();
  delete win;
  delete [] sels;
  return (ende==-1)?false:true;
}

bool WConfig::changeFileSets()
{
  WConfig *twconfig = duplicate();
  char tstr[ A_BYTESFORNUMBER( int ) ];
  AGUIX *aguix = worker->getAGUIX();
  AWindow *win = new AWindow( aguix );
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cmwmh = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW;
  AGMessage *msg;
  int ende;
  
  win->create( NULL, 10, 10, 100, 100, 0, catalog.getLocale( 16 ) ); // Groesse wird spaeter angepasst
  
  // global container 1x3
  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 2 ), true );
  ac1->setMaxSpace( 5 );
  ac1->setBorderWidth( 5 );

  // sub container 2x2 for lister config
  AContainer *ac2 = ac1->add( new AContainer( win, 2, 2 ), 0, 0 );
  ac2->setMaxSpace( 5 );
  ac2->setBorderWidth( 0 );
  
  ac2->add( new Text( aguix, 0, 0, catalog.getLocale( 19 ), 1 ), 0, 0, cincwnr );
  ac2->add( new Text( aguix, 0, 0, catalog.getLocale( 20 ), 1 ), 1, 0, cincwnr );

  AContainerBB *ac21 = (AContainerBB*)ac2->add( new AContainerBB( win, 1, 7 ), 0, 1 );
  AContainerBB *ac22 = (AContainerBB*)ac2->add( new AContainerBB( win, 1, 7 ), 1, 1 );
  
  ac21->setMaxSpace( 5 );
  ac22->setMaxSpace( 5 );
  
  FieldListView *lv1 = (FieldListView*)ac21->add( new FieldListView( aguix,
                                                                     0,
                                                                     0,
                                                                     100,
                                                                     80,
                                                                     0 ), 0, 0, cmwmh );
  ac21->add( new Text( aguix, 0, 0, catalog.getLocale( 21 ), 1 ), 0, 1, cincwnr );

  AContainer *ac21a = ac21->add( new AContainer( win, 1, 2 ), 0, 2 );
  ac21a->setMaxSpace( 5 );

  ChooseButton *cb1 = (ChooseButton*)ac21a->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( hbar_top[0] == true ) ? 1 : 0,
                                                                   catalog.getLocale( 22 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 0, cincwnr );
  AContainer *ac211 = ac21a->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac211->add( new Text( aguix, 0, 0, catalog.getLocale( 23 ), 1 ), 0, 0, cfix );
  sprintf( tstr, "%d", (int)hbar_height[0] );
  StringGadget *sg1 = (StringGadget*)ac211->add( new StringGadget( aguix,
                                                                   0,
                                                                   0,
                                                                   50,
                                                                   tstr,
                                                                   0 ), 1, 0, cincw );
  ac211->setBorderWidth( 0 );
  ac211->setMaxSpace( 5 );

  ac21->add( new Text( aguix, 0, 0, catalog.getLocale( 24 ), 1 ), 0, 3, cincwnr );

  AContainer *ac21b = ac21->add( new AContainer( win, 1, 2 ), 0, 4 );
  ac21b->setMaxSpace( 5 );

  ChooseButton *cb2 = (ChooseButton*)ac21b->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( vbar_left[0] == true ) ? 1 : 0,
                                                                   catalog.getLocale( 25 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 0, cincwnr );
  AContainer *ac212 = ac21b->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac212->add( new Text( aguix, 0, 0, catalog.getLocale( 26 ), 1 ), 0, 0, cfix );
  sprintf( tstr, "%d", (int)vbar_width[0] );
  StringGadget *sg2 = (StringGadget*)ac212->add( new StringGadget( aguix,
                                                                   0,
                                                                   0,
                                                                   50,
                                                                   tstr,
                                                                   0 ), 1, 0, cincw );
  ac212->setBorderWidth( 0 );
  ac212->setMaxSpace( 5 );

  ChooseButton *cb13 = (ChooseButton*)ac21->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( showHeader[0] == true ) ? 1 : 0,
                                                                   catalog.getLocale( 554 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 5, cincwnr );
  Button *dis1 = (Button*)ac21->add( new Button( aguix,
                                                 0,
                                                 0,
                                                 catalog.getLocale( 235 ),
                                                 1,
                                                 0,
                                                 0 ), 0, 6, cincw );

  FieldListView *lv2 = (FieldListView*)ac22->add( new FieldListView( aguix,
                                                                     0,
                                                                     0,
                                                                     100,
                                                                     80,
                                                                     0 ), 0, 0, cmwmh );
  ac22->add( new Text( aguix, 0, 0, catalog.getLocale( 21 ), 1 ), 0, 1, cincwnr );

  AContainer *ac22a = ac22->add( new AContainer( win, 1, 2 ), 0, 2 );
  ac22a->setMaxSpace( 5 );

  ChooseButton *cb3 = (ChooseButton*)ac22a->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( hbar_top[1] == true ) ? 1 : 0,
                                                                   catalog.getLocale( 22 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 0, cincwnr );
  AContainer *ac221 = ac22a->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac221->add( new Text( aguix, 0, 0, catalog.getLocale( 23 ), 1 ), 0, 0, cfix );
  sprintf( tstr, "%d", (int)hbar_height[1] );
  StringGadget *sg3 = (StringGadget*)ac221->add( new StringGadget( aguix,
                                                                   0,
                                                                   0,
                                                                   50,
                                                                   tstr,
                                                                   0 ), 1, 0, cincw );
  ac221->setBorderWidth( 0 );
  ac221->setMaxSpace( 5 );

  ac22->add( new Text( aguix, 0, 0, catalog.getLocale( 24 ), 1 ), 0, 3, cincwnr );

  AContainer *ac22b = ac22->add( new AContainer( win, 1, 2 ), 0, 4 );
  ac22b->setMaxSpace( 5 );

  ChooseButton *cb4 = (ChooseButton*)ac22b->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( vbar_left[1] == true ) ? 1 : 0,
                                                                   catalog.getLocale( 25 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 0, cincwnr );
  AContainer *ac222 = ac22b->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac222->add( new Text( aguix, 0, 0, catalog.getLocale( 26 ), 1 ), 0, 0, cfix );
  sprintf( tstr, "%d", (int)vbar_width[1] );
  StringGadget *sg4 = (StringGadget*)ac222->add( new StringGadget( aguix,
                                                                   0,
                                                                   0,
                                                                   50,
                                                                   tstr,
                                                                   0 ), 1, 0, cincw );
  ac222->setBorderWidth( 0 );
  ac222->setMaxSpace( 5 );

  ChooseButton *cb23 = (ChooseButton*)ac22->add( new ChooseButton( aguix,
                                                                   0,
                                                                   0,
                                                                   20,
                                                                   20,
                                                                   ( showHeader[1] == true ) ? 1 : 0,
                                                                   catalog.getLocale( 554 ),
                                                                   LABEL_LEFT,
                                                                   1,
                                                                   0 ), 0, 5, cincwnr );
  Button *dis2 = (Button*)ac22->add( new Button( aguix,
                                                 0,
                                                 0,
                                                 catalog.getLocale( 235 ),
                                                 1,
                                                 0,
                                                 0 ), 0, 6, cincw );

  // sub container 1x2 for ok/cancel
  AContainer *ac3 = ac1->add( new AContainer( win, 2, 1 ), 0, 1 );
  ac3->setBorderWidth( 0 );
  Button *okb = (Button*)ac3->add( new Button( aguix,
                                               0,
                                               0,
                                               catalog.getLocale( 11 ),
                                               1,
                                               0,
                                               0 ), 0, 0, cincw );
  Button *cancelb = (Button*)ac3->add( new Button( aguix,
                                                   0,
                                                   0,
                                                   catalog.getLocale( 8 ),
                                                   1,
                                                   0,
                                                   0 ), 1, 0, cincw );

  lv1->setHBarState( ( hbar_top[0] == true ) ? 1 : 2 );
  lv1->setVBarState( ( vbar_left[0] == true ) ? 1 : 2 );
  lv1->setHBarHeight( hbar_height[0] );
  lv1->setVBarWidth( vbar_width[0] );
  lv1->setShowHeader( showHeader[0] );
  lv1->setFieldText( 0, "Header" );
  lv1->addRow();
  lv1->setText( 0, 0, "                    " );
  lv1->redraw();

  lv2->setHBarState( ( hbar_top[1] == true ) ? 1 : 2 );
  lv2->setVBarState( ( vbar_left[1] == true ) ? 1 : 2 );
  lv2->setHBarHeight( hbar_height[1] );
  lv2->setVBarWidth( vbar_width[1] );
  lv2->setShowHeader( showHeader[1] );
  lv2->setFieldText( 0, "Header" );
  lv2->addRow();
  lv2->setText( 0, 0, "                    " );
  lv2->redraw();

  win->setDoTabCycling( true );
  win->contMaximize( true );
  win->show();

  while ( ( msg = aguix->GetMessage( NULL ) ) != NULL ) aguix->ReplyMessage( msg );
  ende = 0;
  while ( ende == 0 ) {
    msg = aguix->WaitMessage( win );
    if(msg!=NULL) {
      if(msg->type==AG_CLOSEWINDOW) {
        if(msg->closewindow.window==win->getWindow()) ende=-1;
      } else if(msg->type==AG_BUTTONCLICKED) {
        if(msg->button.button==okb) ende=1;
        else if(msg->button.button==cancelb) ende=-1;
        else if(msg->button.button==dis1) {
          win->hide();
          changeDisplaySets(0);
          win->show();
        } else if(msg->button.button==dis2) {
          win->hide();
          changeDisplaySets(1);
          win->show();
        }
      } else if(msg->type==AG_CHOOSECLICKED) {
        if(msg->choose.button==cb1) {
          if(msg->choose.state==true) lv1->setHBarState(1);
          else lv1->setHBarState(2);
        } else if(msg->choose.button==cb2) {
          if(msg->choose.state==true) lv1->setVBarState(1);
          else lv1->setVBarState(2);
        } else if(msg->choose.button==cb3) {
          if(msg->choose.state==true) lv2->setHBarState(1);
          else lv2->setHBarState(2);
        } else if(msg->choose.button==cb4) {
          if(msg->choose.state==true) lv2->setVBarState(1);
          else lv2->setVBarState(2);
        } else if ( msg->choose.button == cb13 ) {
          if ( msg->choose.state == true ) lv1->setShowHeader( true );
          else lv1->setShowHeader( false );
        } else if ( msg->choose.button == cb23 ) {
          if ( msg->choose.state == true ) lv2->setShowHeader( true );
          else lv2->setShowHeader( false );
        }
      } else if(msg->type==AG_STRINGGADGET_DEACTIVATE) {
        int i=0;
        if(msg->stringgadget.sg==sg1) {
          sscanf(sg1->getText(),"%d",&i);
          if(i<5) {
            i=5;
            sprintf(tstr,"%d",i);
            sg1->setText(tstr);
          }
          lv1->setHBarHeight(i);
        } else if(msg->stringgadget.sg==sg2) {
          sscanf(sg2->getText(),"%d",&i);
          if(i<5) {
            i=5;
            sprintf(tstr,"%d",i);
            sg2->setText(tstr);
          }
          lv1->setVBarWidth(i);
        } else if(msg->stringgadget.sg==sg3) {
          sscanf(sg3->getText(),"%d",&i);
          if(i<5) {
            i=5;
            sprintf(tstr,"%d",i);
            sg3->setText(tstr);
          }
          lv2->setHBarHeight(i);
        } else if(msg->stringgadget.sg==sg4) {
          sscanf(sg4->getText(),"%d",&i);
          if(i<5) {
            i=5;
            sprintf(tstr,"%d",i);
            sg4->setText(tstr);
          }
          lv2->setVBarWidth(i);
        }
      }
      aguix->ReplyMessage(msg);
    }
  }
  if(ende==-1) {
    // Wiederherstellen
    setVisCols( 0, twconfig->getVisCols( 0 ) );
    setVisCols( 1, twconfig->getVisCols( 1 ) );
  } else {
    // Werte bernehmen
    setHBarTop(0,cb1->getState());
    setVBarLeft(0,cb2->getState());
    setHBarTop(1,cb3->getState());
    setVBarLeft(1,cb4->getState());
    setShowHeader( 0, cb13->getState() );
    setShowHeader( 1, cb23->getState() );
    int i=0;
    sscanf(sg1->getText(),"%d",&i);
    if(i<5) i=5;
    setHBarHeight(0,i);
    sscanf(sg2->getText(),"%d",&i);
    if(i<5) i=5;
    setVBarWidth(0,i);
    sscanf(sg3->getText(),"%d",&i);
    if(i<5) i=5;
    setHBarHeight(1,i);
    sscanf(sg4->getText(),"%d",&i);
    if(i<5) i=5;
    setVBarWidth(1,i);
  }
  win->close();
  delete win;
  delete twconfig;
  return (ende==-1)?false:true;
}
