/* stringgadget.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: stringgadget.h,v 1.17 2005/03/20 20:44:56 ralf Exp $ */

#ifndef STRINGGADGET_H
#define STRINGGADGET_H

#include "aguixdefs.h"
#include "guielement.h"

class StringGadget:public GUIElement {
public:
  StringGadget(class AGUIX *aguix);
  StringGadget(class AGUIX *aguix,int x,int y,int width,int height,const char *text,int data);
  StringGadget(class AGUIX *aguix,int x,int y,int width,const char *text,int data);
  virtual ~StringGadget();
  StringGadget( const StringGadget &other );
  StringGadget &operator=( const StringGadget &other );
  void resize(int w,int h);
  int getData() const;
  void setData(int);
  virtual void redraw();
  virtual void flush();
  bool isInside(int x,int y) const;
  virtual bool handleMessage(XEvent *E,Message *msg);
  const char *getText() const;
  void setText(const char *new_text);
  void setXOffset(int new_offset);
  int getXOffset() const;
  void activate();
  void deactivate();
  void setCursor(int new_pos);
  int getCursor() const;
  bool isActive() const;
  int setFont(char*);
  virtual const char *getType() const;
  virtual bool isType(const char *type) const;
  virtual bool isParent(Window) const;
  bool isPosChangeForbidden() const;
  void setForbidPosChange(bool nv);
  void setStrongKeyCapture(bool nv);
  virtual void paste(unsigned char*);
  virtual void cancelpaste();
  virtual void cancelcut();
  virtual void takeFocus();
  virtual void leaveFocus();
  void insertAtCursor( const char *str );
  void selectAll();
  void setPasswordMode( bool nv );
protected:
  virtual void doCreateStuff();
  virtual void doDestroyStuff();
private:
  int data;
  char *text;
  int cursorpos;
  int xoffset;
  bool active;
  static const char *type;
  Window twin;
  int tbg;
  bool bgset;
  int maxdisplay;
  int selstart,selend;
  class AGUIXFont *font;
  bool forbidPosChange;
  bool ignoreRelease;
  bool strongkeycapture;
  
  void updateWin();
  void tredraw();
  void bredraw();
  void applySelection();
  void removeSelection();
  void insertSelection();

  bool wantpaste;
  time_t pasterequest;
  bool passwordMode;
};

#endif

