dnl Autoconf macros for libwww
dnl $id$

# This script detects libwww version and defines
# LIBWWW_CFLAGS, LIBWWW_LIBS
# found.

# Stolen from libmcrypt

dnl AM_PATH_LIBWWW([ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]])
dnl Test for libwww, and define LIBWWW_CFLAGS and LIBWWW_LIBS
dnl
AC_DEFUN(AM_PATH_LIBWWW,
[dnl
dnl Get the cflags and libraries from the libwww-config script
dnl
AC_ARG_WITH(libwww-prefix,
          [  --with-libwww-prefix=PFX   Prefix where libwww is installed (optional)],
          libwww_config_prefix="$withval", libwww_config_prefix="")

  if test x$libwww_config_prefix != x ; then
     libwww_config_args="$libwww_config_args --prefix=$libwww_config_prefix"
     if test x${LIBWWW_CONFIG+set} != xset ; then
        LIBWWW_CONFIG=$libwww_config_prefix/bin/libwww-config
     fi
  fi

  AC_PATH_PROG(LIBWWW_CONFIG, libwww-config, no)
  AC_MSG_CHECKING(for libwww)
  no_libwww=""
  if test "$LIBWWW_CONFIG" = "no" ; then
      AC_MSG_WARN(libwww-config was not found)
      no_libwww=yes
  else
dnl libwww-config was found
    LIBWWW_CFLAGS=`$LIBWWW_CONFIG $libwww_config_args --cflags`
    LIBWWW_LIBS=`$LIBWWW_CONFIG $libwww_config_args --libs`
    libwww_config_version=`$LIBWWW_CONFIG $libwww_config_args --version`
  fi

  if test "x$no_libwww" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])
  else
     AC_MSG_RESULT(no)
  fi
  AC_SUBST(LIBWWW_CFLAGS)
  AC_SUBST(LIBWWW_LIBS)
])

dnl *-*wedit:notab*-*  Please keep this as the last line.
