/*
 *  dndtree.c:	        Drag and drop extension for ctree widget
 *
 *  Written by:		Ullrich Hafner
 *  
 *  Copyright (C) 2000 Ullrich Hafner <hafner@bigfoot.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

/*
 *  $Date: 2000/09/24 19:18:50 $
 *  $Author: hafner $
 *  $Revision: 1.1 $
 *  $State: Exp $
 */

#include "config.h"

#include <gtk/gtk.h>

/*****************************************************************************

			   local variables
  
*****************************************************************************/

static void (*old_gtk_drag_end) (GtkWidget *widget,
				 GdkDragContext *context) = NULL;
static void (*old_gtk_drag_begin) (GtkWidget *widget,
				   GdkDragContext *context) = NULL;
#define GTK_WIDGET_CLASS_FW(_widget_) GTK_WIDGET_CLASS (((GtkObject*) (_widget_))->klass)

/*****************************************************************************

			      prototypes
  
*****************************************************************************/

static gint
vertical_timeout (GtkCList *clist);
static void
move_vertical (GtkCList *clist, gint row, gfloat align);
static void
my_drag_begin (GtkWidget *widget, GdkDragContext *context);
static void
my_drag_end (GtkWidget *widget, GdkDragContext *context);

/*****************************************************************************

			     public code
  
*****************************************************************************/

GtkCTree *
gtk_dndtree_new (gint columns, gint tree_column)
{
   GtkCTree *tree = (GtkCTree *) gtk_ctree_new (columns, tree_column);

   if (!old_gtk_drag_begin)
   {
      old_gtk_drag_end = GTK_WIDGET_CLASS_FW (tree)->drag_end;
      GTK_WIDGET_CLASS_FW (tree)->drag_end = my_drag_end;
   
      old_gtk_drag_begin = GTK_WIDGET_CLASS_FW (tree)->drag_begin;
      GTK_WIDGET_CLASS_FW (tree)->drag_begin = my_drag_begin;
   }
   
   gtk_clist_set_reorderable (GTK_CLIST (tree), TRUE);
   gtk_clist_set_use_drag_icons (GTK_CLIST (tree), TRUE);

   return tree;
}

/*****************************************************************************

			     private code
  
*****************************************************************************/

#define ROW_TOP_YPIXEL(clist, row) (((clist)->row_height * (row)) + \
				    (((row) + 1) * CELL_SPACING) + \
				    (clist)->voffset)
#define ROW_FROM_YPIXEL(clist, y)  (((y) - (clist)->voffset) / \
                                    ((clist)->row_height + CELL_SPACING))
#define CELL_SPACING               1
#define COLUMN_INSET               3

static gint
vertical_timeout (GtkCList *clist)
{
   gint row;
   gint x, y;
   
   gtk_widget_get_pointer (GTK_WIDGET (clist), &x, &y);
      
   /* vertical autoscrolling */
   row = ROW_FROM_YPIXEL (clist, y);

   /* don't scroll on last pixel row if it's a cell spacing */
   if (!(y == clist->clist_window_height - 1 &&
	 y == ROW_TOP_YPIXEL (clist, row-1) + clist->row_height))
   {
      if (ROW_TOP_YPIXEL(clist, row) < 0)
	 move_vertical (clist, row, 0);
      else if (ROW_TOP_YPIXEL(clist, row) + clist->row_height >
	       clist->clist_window_height)
	 move_vertical (clist, row, 1);
   }

   return TRUE;
}

static void
move_vertical (GtkCList *clist, gint row, gfloat align)
{
   gfloat value;

   if (!clist->vadjustment)
      return;

   value = (ROW_TOP_YPIXEL (clist, row) - clist->voffset -
	    align * (clist->clist_window_height - clist->row_height) +
	    (2 * align - 1) * CELL_SPACING);

   if (value + clist->vadjustment->page_size > clist->vadjustment->upper)
      value = clist->vadjustment->upper - clist->vadjustment->page_size;

   gtk_adjustment_set_value(clist->vadjustment, value);
}

static void
my_drag_end (GtkWidget *widget, GdkDragContext *context)
{
   GtkCList *clist;

   g_return_if_fail (widget != NULL);
   g_return_if_fail (GTK_IS_CLIST (widget));
   g_return_if_fail (context != NULL);

   old_gtk_drag_end (widget, context);

   clist = GTK_CLIST (widget);
   
   gtk_timeout_remove (clist->vtimer);
   clist->vtimer = 0;
}

static void
my_drag_begin (GtkWidget *widget, GdkDragContext *context)
{
   GtkCList *clist;

   g_return_if_fail (widget != NULL);
   g_return_if_fail (GTK_IS_CTREE (widget));
   g_return_if_fail (context != NULL);

   old_gtk_drag_begin (widget, context);

   clist = GTK_CLIST (widget);

   clist->vtimer = gtk_timeout_add
		   (100, (GtkFunction) vertical_timeout,
		    clist);
}
