classes 
  wrong_code_point '.' '' "+-" " \n" "(*)" letter digit ethioH

let space = [ ' '  '\n' ]
let digit_seq = digit+

let letters = letter | ethioH | ''

rule token eof_string = parse
  | letter+ { "ID:"^(Lexing.lexeme lexbuf) }
  | digit_seq ('.' digit_seq)? { "NB:"^(Lexing.lexeme lexbuf) }
  | '+' { "PLUS" }
  | '-' { "MINUS" } 
  | '' { "E ACUTE" }
  | ethioH { "ETHIOPIAN CONSONANT H" }
  | space { token eof_string engine lexbuf }
  | "(*" { comment engine lexbuf; token eof_string engine lexbuf }
  | '(' letters* ')' { "STRING:"^(Lexing.lexeme lexbuf) }
  | eof { eof_string }

and comment = parse
  | "*)" { () }
  | [^ '.']    { comment engine lexbuf }
