//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSDprDev.h>
#include <WSCdevice.h>
#include <WSDdraw.h>
#include <WSCbase.h>
#include <WSDpsdraw.h>

WSMFclassInit(WSDprDev,WSDdev);

//static WSDpsdraw* _ps_draw = NULL;

WSDprDev::WSDprDev(){
  _type = WS_PR_PS;
  _format = WS_PR_A4;
  _work_width = 512;
  _work_height = 724;
//  if (_ps_draw == NULL){
//    _ps_draw = new WSDpsdraw();
//  }
//  _draw = _ps_draw;
}


long WSDprDev::getValue(long kind,void* data){
  switch(kind){
  }
  return WS_NO_ERR;
}

long WSDprDev::setValue(long kind,void* data){
  long val = *(long*)data;
  switch(kind){
    case WSDEV_PR_TYPE:
      _type = val;
      break;
    case WSDEV_PR_FORMAT:
      _format = val;
      break;
    case WSDEV_WORK_X:
      _work_x = val;
      break;
    case WSDEV_WORK_Y:
      _work_y = val;
      break;
    case WSDEV_WORK_WIDTH:
      _work_width = val;
      break;
    case WSDEV_WORK_HEIGHT:
      _work_height = val;
      break;
    case WSDEV_PR_ORIENTATION:
      _orientation = val;
      break;
  }
  return WS_NO_ERR;
}


WSCbool WSDprDev::getReady(){
#if 0
  long d1 = getDeviceResource();
  long d2 = getWindowResource();
  long d3 = getContextResource();
//printf("WSDprDev::getReady %d %d %d\n",d1,d2,d3);
  if (d1 == -1 || d2 == -1 || d3 == -1){
     return False;
  }
#endif
  return True;
}

long WSDprDev::beginDraw(short x,short y,
                              WSCushort w,WSCushort h,
                              WSCbool absolute,WSCbool scaling){
  if (scaling != False){
    double scale = getScale();
    if ( scale != 1){
      x = (short)((x + getXOffset()) * scale);
      y = (short)((y + getYOffset()) * scale);
      w = (WSCushort)(w * scale);
      h = (WSCushort)(h * scale);
    }else{
      x = x + getXOffset();
      y = y + getYOffset();
    }
  }


  WSDdraw* draw = getDraw();
  if (draw == NULL){
    return WS_ERR;
  }
  _absolute_draw = absolute;

  _x = x; 
  _y = y; 
  _w = w; 
  _h = h; 

  if (getReady() == False){
    return WS_ERR;
  }
  WSDpsdraw* psd = (WSDpsdraw*)draw->cast("WSDpsdraw");
  if (psd != NULL){
    long val = _type;
    psd->setValue(WSDEV_PR_TYPE,val);
    val = _format;
    psd->setValue(WSDEV_PR_FORMAT,val);
    val = _orientation;
    psd->setValue(WSDEV_PR_ORIENTATION,val);
    val = _work_x;
    psd->setValue(WSDEV_WORK_X,val);
    val = _work_y;
    psd->setValue(WSDEV_WORK_Y,val);
    val = _work_width;
    psd->setValue(WSDEV_WORK_WIDTH,val);
    val = _work_height;
    psd->setValue(WSDEV_WORK_HEIGHT,val);
  }
  draw->beginDraw(this,getDeviceResource(),getWindowResource(),getContextResource());

  return WS_NO_ERR;
}

long WSDprDev::endDraw(){
  WSDdraw* draw = getDraw();
  if (draw == NULL){
    _absolute_draw = False;
    return WS_ERR;
  }
  draw->endDraw();

  _absolute_draw = False;
  return WS_NO_ERR;
}

long WSDprDev::initialize(){
  return WS_NO_ERR;
}

long WSDprDev::getExposedArea(short* x,short* y,WSCushort* w,WSCushort* h,WSCbool scaling){
//printf("WSDprDev::getExposedArea  called\n");
  *x = _x;
  *y = _y;
  if (scaling != False){
    double scale = getScale();
    if ( scale != 1){
      *w = (WSCushort)(_w * scale);
      *h = (WSCushort)(_h * scale);
    }else{
      *w = _w;
      *h = _h;
    }
    return WS_NO_ERR;
  }
  *w = _w;
  *h = _h;
//printf("WSDprDev::getExposedArea  0,0,%d,%d\n",_w,_h);
  return WS_NO_ERR;
}
void WSDprDev::setFile(WSDfile* file){
  _file = file;
}
long WSDprDev::getWindowResource(){
  return 0;
}
long WSDprDev::getDeviceResource(){
  return (long)_file;
}
long WSDprDev::getContextResource(){
  return 0;
}
long WSDprDev::getSpecialResource(){
  return 0;
}
WSCbool WSDprDev::isExposed(short,short,WSCushort,WSCushort,WSCbool){
  return True;
}
