//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#include <WScom.h>
#include <WSDmouse.h>
#include <WSCstring.h>

WSMFclassInit(WSDmouse,WSCroot);

static WSDmouse* (*_chandler)() = NULL;
void WSDmouse::setCreateInstanceHandler( WSDmouse* (*hd)()){
  _chandler = hd;
}
static WSDmouse* _the_app_mouse = NULL;
WSDmouse* WSGIappMouse(){
  if (_the_app_mouse == NULL){
    if (_chandler == NULL){
      return NULL;
WSMFtrace("WSGImouse() ERROR. cannot create WSDmouse class instance.\n");
    }
    _the_app_mouse = _chandler();
  }
  return _the_app_mouse;
}

struct WSCmouseData{
  long id;
  long data;
  WSCstring str;
};


WSDmouse::WSDmouse(){
  _status = 0;
  _target_btn = 0 ;
  _fclient = NULL;
}
void WSDmouse::initialize(){}

void WSDmouse::setStatus(WSCulong status){
  _status = status;
}
WSCulong WSDmouse::getStatus(){
  return _status;
}
void WSDmouse::setTargetBtn(WSCulong no){
  _target_btn = no;
}
WSCulong WSDmouse::getTargetBtn(){
  return _target_btn;
}
void WSDmouse::delMouseCursor(long pos){
  if (pos < 0){
    return;
  }
  long num = _mlist.getNum();
  if (pos < num){
    WSCmouseData* mouse = (WSCmouseData*)_mlist[pos];
    _mlist.del((void*)mouse);
  }
}
void WSDmouse::setMouseCursor(long){}
void WSDmouse::setupMouseCursor(char*){}
void WSDmouse::addMouseCursor(long id,long data,char* str){
  WSCmouseData* mouse = NULL;
  long i;
  long num = _mlist.getNum();
  for(i=0; i<num; i++){
    WSCmouseData* mouse1 = (WSCmouseData*)_mlist[i];
    if (mouse1->id == id){
      mouse1->data = data;
      mouse1->str.setString(str);
      _mlist.del((void*)mouse1);
      mouse = mouse1;
      break;
    }
  }
  if (mouse == NULL){
    mouse = new WSCmouseData;
    mouse->data = data;
    mouse->id = id;
    mouse->str.setString(str);
  }
  num = _mlist.getNum();
  for(i=0; i<num; i++){
    WSCmouseData* mouse1 = (WSCmouseData*)_mlist[i];
    if (mouse1->id < id){
      continue;
    }
    _mlist.add((void*)mouse,i);
    return;
  } 
  _mlist.add((void*)mouse);
}

long WSDmouse::getMouseCursorId(long pos){
  long num = _mlist.getNum();
  if (pos < 0){
    return -1;
  }

  if (pos < num){
    WSCmouseData* mouse = (WSCmouseData*)_mlist[pos];
    return mouse->id;
  }
  return -1;
}

char* WSDmouse::getMouseCursorName(long id){
  long num = _mlist.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCmouseData* mouse = (WSCmouseData*)_mlist[i];
    if (mouse->id == id){
      return mouse->str.getString();
    }
  }
  return NULL;
}

long WSDmouse::getMouseCursor(long id){
  long num = _mlist.getNum();
  long i;
  for(i=0; i<num; i++){
    WSCmouseData* mouse = (WSCmouseData*)_mlist[i];
    if (mouse->id == id){
      return mouse->data;
    }
  }
  id = 0;
  for(i=0; i<num; i++){
    WSCmouseData* mouse = (WSCmouseData*)_mlist[i];
    if (mouse->id == id){
      return mouse->data;
    }
  }
  if (num > 0){
    WSCmouseData* mouse = (WSCmouseData*)_mlist[0];
    return mouse->data;
  }
  return 0;
}

WSCbool WSDmouse::getMousePosition(short*,short*){
  return False;
}

WSCbool WSDmouse::getMousePosition(short*,short*,WSCbase*){
  return False;
}

void WSDmouse::setMousePosition(short x,short y){}
void WSDmouse::resetMouseCursors(){}
void WSDmouse::setMouseFocusClient(WSCbase* cl){
  _fclient = cl;
}
WSCbase* WSDmouse::getMouseFocusClient(){
  return _fclient;
}

